<?php
namespace Frontend\Common;
use Base\Db\DataTable as DataTable;
use Frontend\Base\AbstractModule;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;


class Common extends AbstractModule 
{
   function __construct()
   {
		/*default countries, currencies start*/	
		$CountryName = $this->getSession()->getVar("CountryName");
		if($CountryName == "")
			$this->getSession()->setVar("CountryName",d("DEFAULT_COUNTRY"));
		
		$SessPriceDisplay = $this->getSession()->getVar("SessPriceDisplay");
		
		if($SessPriceDisplay == ""){
				//$this->getSession()->setVar("SessPriceDisplay","EXC");
			//if(d("PRICE_DISPLAY_INC_VAT")=="1")
				$this->getSession()->setVar("SessPriceDisplay","INC");
		}
		
		
		$this->getFrontCurrency();
		/*default countries, currencies end*/	
		$this->reCheckPaidOrder();
		if(d("WHOSONLINE_STAT")=="1"){
			$this->WhosOnline();
		}
		
		if(isset($_REQUEST['Target']) && $_REQUEST['Target']=="FrontCurrencyUpdate"){
			if(@$_REQUEST['SelCurrencyID'] > 0){
				$this->getSession()->setVar("currentCurrencyID",$_REQUEST['SelCurrencyID']);
				MyRedirect($this->getClass("Cms\Pages\Common")->SKAddRemoveParmsFromURL(DEFINE_CURRENT_PAGE_URL,array("Target","SelCurrencyID")));
				exit;
			}
		}
		
		if(isset($_REQUEST['Target']) && $_REQUEST['Target']=="FrontPriceDisplayUpdate"){
			if(isset($_REQUEST['PriceDisplay']) && $_REQUEST['PriceDisplay'] == "EXC"){
				$this->getSession()->setVar("SessPriceDisplay","EXC");
				MyRedirect($this->getClass("Cms\Pages\Common")->SKAddRemoveParmsFromURL(DEFINE_CURRENT_PAGE_URL,array("Target","PriceDisplay")));
				exit;
			}
			if(isset($_REQUEST['PriceDisplay']) && $_REQUEST['PriceDisplay'] == "INC"){
				$this->getSession()->setVar("SessPriceDisplay","INC");
				MyRedirect($this->getClass("Cms\Pages\Common")->SKAddRemoveParmsFromURL(DEFINE_CURRENT_PAGE_URL,array("Target","PriceDisplay")));
				exit;
			}
		}
		
   }
	
  
   
	function getFrontCurrency()
	{
		/* Default Currency start here */
		$currentCurrencyID = $this->getSession()->getVar("currentCurrencyID");
		if($currentCurrencyID != ""){
			$dir = FileHandle::CheckPrivateLogDirectory("cache");
			$filename=$dir."cache.currency_".$currentCurrencyID.".txt";
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
				$CurrentObj =unserialize(file_get_contents($filename));
			}
			else{
				$Obj = new DataTable(TABLE_CURRENCIES);
				$Obj->where[] = array('=',array('CurrencyID' => $currentCurrencyID));
				$CurrentObj = (object)$Obj->tableSelectOne(array("*"));
				if(d("CACHE_IMPLEMENT")=="1"){
					$fp2 = fopen($filename, "w");
					fputs($fp2,serialize($CurrentObj));	
					fclose($fp2);
				}
			
			}
			
		}
		else{
			$CurrentObj = $this->getDefaultCurrency();
			$this->getSession()->setVar("currentCurrencyID",$CurrentObj->CurrencyID);
		}
		return $CurrentObj;
		/* Default Currency start end */
	}
	
	function getDefaultCurrency()
	{
		/* Default Currency start here */
		$Obj = new DataTable(TABLE_CURRENCIES);
		$Obj->where[] = array('=',array('DefaultValue' => 1));
		$Obj->where[] = array('=',array('Active' => 1));
		return (object)$Obj->tableSelectOne(array("*"));
		/* Default Currency start end */
	}
	
	function initCall()
	{
		$this->getClass('Sale\Cart\Common')->RestoreCartByCookie();
	}
	
	function reCheckPaidOrder()
	{
		$OrderID = $this->getSession()->getVar("OrderID");
		if($OrderID != "")
		{
			$Obj = new DataTable(TABLE_ORDERS);
			$Obj->where[] = array('=',array('OrderID' => $OrderID));
			$CurrentObj = (object)$Obj->tableSelectOne(array("PaymentStatus"));
			
			if(isset($CurrentObj->PaymentStatus) && $CurrentObj->PaymentStatus =="Paid")
				$this->getSession()->deleteVar("OrderID");
					
		}
	}
	
   function WhosOnline()
   {
    
		$WhosOnlineObj = new DataTable(TABLE_WHOS_ONLINE);
		if(defined("DEFINE_REMOVEIP_WHOSONLINE") && trim(@constant("DEFINE_REMOVEIP_WHOSONLINE")) !="" && strstr(trim(@constant("DEFINE_REMOVEIP_WHOSONLINE")),@$_SERVER['REMOTE_ADDR']) ==true)
		{
			/* No tracking please*/
		}
		else 
		{
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
			$WhosDataArray = array();
			$WhosDataArray['UserID'] =  isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
			$WhosDataArray['UserName'] =  isset($IsCurrentUser->UserName)?$IsCurrentUser->UserName:"";
			$WhosDataArray['EmailAddress'] =  isset($IsCurrentUser->Email)?$IsCurrentUser->Email:"";
			$WhosDataArray['FullName'] =  isset($IsCurrentUser->FirstName)?$IsCurrentUser->FirstName." ".$IsCurrentUser->LastName:"Guest";
			$WhosDataArray['LastClick'] =  date('Y-m-d H:i:s');
			$WhosDataArray['LastURL'] =  d("DEFINE_CURRENT_PAGE_URL");
			$WhosOnlineObj->where ="SessionID ='".session_id()."'";
			$CurrentWhosOnline = (object)$WhosOnlineObj->tableSelectOne();
			if(isset($CurrentWhosOnline->SessionID) && $CurrentWhosOnline->SessionID !="")
			{
				$WhosOnlineObj->tableUpdate($WhosDataArray);
			}
			else 
			{
				$WhosDataArray['EntryDate'] =  date('Y-m-d H:i:s');
				$WhosDataArray['IPAddress'] =  isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
				$WhosDataArray['SessionID'] = session_id();
				$WhosOnlineObj->tableInsert($WhosDataArray);
			}
		}
		$WhosOnlineObj->where =" LastClick < '".date('Y-m-d H:i:s',mktime(date('H'),date('i')-20,date('s'),date('m'),date('d'),date('Y')))."'";
		$WhosOnlineObj->tableDelete();	
   }
   
   
   function getUniqueCacheKey()
   {
	   $CacheKeyArray = array();
	   $CacheKeyArray['WebsiteKey'] = d("DEFINE_WEBSITE_KEY");
	   $CacheKeyArray['IsMobile'] = d("DEFINE_DETECT_IS_MOBILE");
	   $CacheKeyArray['IsTablet'] = d("DEFINE_DETECT_IS_TABLET");
	   $CacheKeyArray['IsBotLighthouse'] = d("DEFINE_DETECT_IS_BOT_LIGHTHOUSE");
	   $CacheKeyArray['IsHome'] = d("DEFINE_IS_HOMEPAGE_CHECK");
	   $CacheKeyArray['CurrencyID'] = $this->getSession()->getVar("currentCurrencyID");
	   $CacheKeyArray['CountryName'] = $this->getSession()->getVar("CountryName");
	   $CacheKeyArray['TaxCountry'] = $this->getSession()->getVar("TaxCountry");
	   $CacheKeyArray['SessPriceDisplay'] = $this->getSession()->getVar("SessPriceDisplay");
	   
	   $IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
	   if(isset($IsCurrentUser->UserTypeID) && $IsCurrentUser->UserTypeID != ""){
		  $CacheKeyArray['UserTypeID'] = isset($IsCurrentUser->UserTypeID)?$IsCurrentUser->UserTypeID:"";
		  $CacheKeyArray['VATExempt'] = isset($IsCurrentUser->VATExempt)?$IsCurrentUser->VATExempt:"";
	   }
	   
	   $CacheKey = md5(serialize($CacheKeyArray));
	   
	   return $CacheKey;
   }   
   
   function getModuleCodeByURL($URL)
   {
	   if(substr($URL,-1)=="/")
	     $URL = substr($URL,0,-1);
	   
		$PageObj = new DataTable(TABLE_SEO);
		$PageObj->where[] = array('=',array('URLName' => $URL));
		$CurrentObj = (object)$PageObj->tableSelectOne(array("URLID","MCode","MView","RedirectEnabled","RedirectURL","ReferenceID"));
		return $CurrentObj;
   }
   
   function getModuleKeyAndView($arr)
   {
	  $ReturnArray = $arr;
	  
	  $CacheKey = md5(serialize($arr));
	  $SeourlDir = FileHandle::CheckPrivateLogDirectory("cache_keyurl");
	  $filename=$SeourlDir .$CacheKey.".txt";
		
	  if(d("CACHE_IMPLEMENT")=="1")
		{
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
				return  unserialize(file_get_contents($filename));
		
			/* check define value and return from here*/
			
		} 	
	  
	  if(isset($arr['MCode']) && isset($arr['MView'])) 
	  {
		$Obj = new DataTable(TABLE_MODULE_KEY);
		//$Obj->displayQuery = true;
		
		$where = new Where();
		$where->NEST//start braket
				->equalTo('MCode',$arr['MCode'])
				->OR
				->equalTo('SCode',$arr['MCode'])
				->UNNEST;
		
		$where->NEST//start braket
				->equalTo('MView',$arr['MView'])
				->OR
				->equalTo('SView',$arr['MView'])
				->UNNEST;
		
		$Obj->where = $where;
		$record = (object)$Obj->tableSelectOne();
		if(isset($record->ModuleKeyID))
		{
			$ReturnArray['MCode'] = $record->MCode;
			$ReturnArray['MView'] = $record->MView;
			$ReturnArray['code'] = $record->MCode;
			$ReturnArray['view'] = $record->MView;
			$ReturnArray['IsCache'] = $record->IsCache;
			$ReturnArray['obj'] = $record;
		}
		else
		{
			$ReturnArray['MCode'] = $arr['MCode'];
			$ReturnArray['MView'] = $arr['MView'];
			$ReturnArray['code'] = $arr['MCode'];
			$ReturnArray['view'] = $arr['MView'];
		}
	  }
	  
	  if(d("CACHE_IMPLEMENT")=="1"){
			$fp2 = fopen($filename, "w");
			fputs($fp2,serialize($ReturnArray));	
			fclose($fp2);
		}
	  return $ReturnArray;
   }
   
   function getModuleKeyAndView_22june2020($arr)
   {
	  $ReturnArray = $arr;
	  if(isset($arr['MCode']) && isset($arr['MView'])) 
	  {
		$Obj = new DataTable(TABLE_MODULE_KEY);
		//$Obj->displayQuery = true;
		
		$where = new Where();
		$where->NEST//start braket
				->equalTo('MCode',$arr['MCode'])
				->OR
				->equalTo('SCode',$arr['MCode'])
				->UNNEST;
		
		$where->NEST//start braket
				->equalTo('MView',$arr['MView'])
				->OR
				->equalTo('SView',$arr['MView'])
				->UNNEST;
		
		$Obj->where = $where;
		$record = (object)$Obj->tableSelectOne();
		if(isset($record->ModuleKeyID))
		{
			$ReturnArray['MCode'] = $record->MCode;
			$ReturnArray['MView'] = $record->MView;
			$ReturnArray['code'] = $record->MCode;
			$ReturnArray['view'] = $record->MView;
			$ReturnArray['IsCache'] = $record->IsCache;
			$ReturnArray['obj'] = $record;
		}
		else
		{
			$ReturnArray['MCode'] = $arr['MCode'];
			$ReturnArray['MView'] = $arr['MView'];
			$ReturnArray['code'] = $arr['MCode'];
			$ReturnArray['view'] = $arr['MView'];
		}
	  }
	  return $ReturnArray;
   }
    
};
