<?php
namespace Frontend\Base;

#[AllowDynamicProperties]
abstract class AbstractTheme extends \stdClass implements FrontThemeInterface
{
    protected $obj; 
    protected $themeFile; 
    public $isAjax = false; 
    public $isIframe = false; 
    protected $module; 
   
	function __construct()
	{
		$this->themeFile = "default";
		if(isset($_GET['ajax']))
			$this->isAjax = true;
		if(isset($_GET['iframe']))
			$this->isIframe = true;
			
	}
	
	public function setTheme($class)
    {
		$obj = new $class;
		$this->obj = $obj;
		$this->obj->master = $this;
		return $this;
    }
	 public function __call($method,$arguments) {
	 
       if(method_exists($this, $method)) {
            return call_user_func_array(array($this,$method),$arguments);
	   }
	   else if(method_exists($this->obj, $method)) {
		    return call_user_func_array(array($this->obj,$method),$arguments);
	   }
       else{
		   // method not found 
	   }
	   
    }
	
    public function renderTheme($moduleObj)
	{
		$this->setModule($moduleObj);
		
		if($moduleObj->getThemeFile() != "")
			 $this->setThemeFile($moduleObj->getThemeFile());
		 
		$path = $this->getThemePath();
		$includeFile = $path.$this->themeFile.".php";
		
		if($this->isAjax===true && file_exists($path."ajax.php"))
			$includeFile = $path."ajax.php";
		
		if($this->isIframe===true && file_exists($path."iframe.php"))
			$includeFile = $path."iframe.php";
		
		if(file_exists($includeFile))
			include($includeFile);
	}
	
	public function getMeta()
	{
		if(isset($this->module) && is_object($this->module))
			echo $this->module->getBeforeMeta();
	
		$this->obj->getMeta();
		
		if(isset($this->module) && is_object($this->module))
			echo $this->module->getAfterMeta();
		
	}
	
	 public function getClass($class)
	 {
		 if(class_exists($class))
			 return new $class;
		 
	 }
	 
	public function getThemeFile()
	{
		return $this->themeFile;	
	}
	public function setThemeFile($themeFile)
	{
		$this->themeFile = $themeFile;
	}
	 public function getSession()
	 {
		global $sessionObj;
		return $sessionObj;
	 }
	 
	 public function getModule()
	 {
		return $this->module;
	 }
	 
	 public function getFooterJs()
	 {
		 $this->obj->getFooterJs();
		 if(isset($this->module) && is_object($this->module))
		 	 $this->module->getFooterJs();
		 
		 
	 }
	 
	 public function getFooterCss()
	 {
		
		 $this->obj->getFooterCss();
		 if(isset($this->module) && is_object($this->module))
		 	 $this->module->getFooterCss();
		 
		 
	 }
	
	 public function getHeaderCss()
	 {
		 $this->obj->getHeaderCss();
		 if(isset($this->module) && is_object($this->module))
		 	 $this->module->getHeaderCss();
		 
	 }
	 
	 public function setModule($moduleObj)
	 {
		$this->module = $moduleObj;
	 }
	public function getThemePath()
	{
		return $this->obj->getThemePath();
	}
	
	
	public function getMetaTitle()
	{
		return $this->master->getModule()->getMetaTitle();
	}	
	
	public function getMetaKeywords()
	{
		return $this->master->getModule()->getMetaKeywords();
	}	
	
	public function getMetaDescription()
	{
		return $this->master->getModule()->getMetaDescription();
	}	
	
	
	
};
