<?php
namespace Frontend\Base;

#[AllowDynamicProperties]
abstract class AbstractModule extends \stdClass implements AbstractModuleInterface
{
    protected $module; 
    protected $moduleObj; 
    protected $moduleArr; 
    protected $moduleParam; 
    protected $view; 
    protected $theme; 
    protected $session; 
    protected $metaTitle; 
    protected $metaKeywords; 
    protected $metaDescription; 
    
	function __construct()
	{
		$this->view = "Default";
		if(isset($_GET['view']) && $_GET['view'] != "")
		$this->view = $_GET['view'];
		
		if(count($_GET) > 0)
		{
			foreach($_GET as $k=>$v)
			  $this->{$k} = $v;
		}
		
		
			
	}
	public function setModule($module)
    {
		$this->module = $module;
		$this->initModule();
		return $this;
    }
	
	public function getModule()
    {
		return $this->module;
    }
	 
	 public function getSession()
	 {
		global $sessionObj;
		return $sessionObj;
	 }
	public function __get($name)
	{
		if(isset($this->moduleObj->{$name}))
			return $this->moduleObj->{$name};
		
	}
	
	public function __call($method,$arguments) {
		if(method_exists($this, $method)) {
            return call_user_func_array(array($this,$method),$arguments);
	   }
       else if(isset($this->moduleObj) && method_exists($this->moduleObj, $method)) {
		    return call_user_func_array(array($this->moduleObj,$method),$arguments);
	   }
       else{
		   /* method not found */
	   }
    }
	
	 public function getClass($class)
	 {
		 if(class_exists($class))
			 return new $class;
		 
	 }
	 public function initModule()
	 {
		 $this->module = str_replace("/","\\",$this->module);
		 $moduleString ="";
		 if($this->module != "")
		 {
			 $arr = explode("\\",$this->module);
			 $this->moduleArr = $arr;
			 $class = "\\".(isset($arr[0])?$arr[0]:"")."\\".(isset($arr[1])?$arr[1]:"")."\\Front\\Controller\\".(isset($arr[2])?$arr[2]:"Index")."Controller";
			 //$this->moduleObj = new \Catalog\Category\Front\Controller\IndexController;
			 
			 if(class_exists($class))
			 {
				 $this->moduleObj = new $class;
				 $this->moduleObj->origin = $this;
				 $this->moduleObj->module = $this->module;
				 $this->moduleObj->moduleArr = $this->moduleArr;
				 $this->moduleObj->theme = $this->theme;
				 $this->moduleObj->view = $this->view;
				 $this->moduleObj->moduleParam = $this->moduleParam;
				 
				 if(method_exists($this->moduleObj, "settings"))
					$this->moduleObj->settings();
			 }
			
			 
		 }
	 }
	 
    public function getController($arguments =array())
	{
		if(isset($_GET['action']) && $_GET['action'] != "")
			call_user_func_array(array($this->moduleObj,$_GET['action']."Action"),$arguments);
		
			$this->getClass("Cms\Pages\Common")->CheckRedirectURL();
			/* check 404 start*/
			if($this->getDisplayFile()==false)
			{
				$this->getClass("Cms\Pages\Common")->Before404();
				/* 404*/
				if(ob_get_length())
					@ob_clean();
				
				header("HTTP/1.1 404 Not Found");
				header("Status: 404 Not Found");
				define("DEFINE_FRONT_SIDE_404",true);
				$this->setView("404");
				
			}
			/* check 404 end*/
		
	}
	
	public function showMeta()
	{
		if(isset($this->moduleObj) && method_exists($this->moduleObj, "showMeta")) {
		    return call_user_func_array(array($this->moduleObj,"showMeta"),array());
	   }
	   else
		   return true;
	}
	
	public function getView()
	{
		return $this->view;	
	}
	public function setView($view)
	{
		$this->view = $view;
	}
	public function getModuleParam()
	{
		return $this->moduleParam;	
	}
	public function setModuleParam($arr)
	{
		if(isset($arr['view']))
			$this->setView($arr['view']);	
		
		$this->moduleParam = $arr;
	}
	
	public function getTheme()
	{
		return $this->theme;	
	}
	public function setTheme($theme)
	{
		$this->theme = $theme;
	}
	
	public function getThemeUrl($file="")
	{
		if($file != "")
			return FRONT_THEME_URL.$file;
		else
			return FRONT_THEME_URL;
	}
	
	public function displayView()
	{
		$moduleObj = $this;
		$themeObj = $this->getTheme();
		
		if(file_exists(DIR_FS_SITE."includes/alert.php"))
			include_once(DIR_FS_SITE."includes/alert.php");
		
		if($this->getDisplayFile()){
			
			if(isset($this->moduleParam['IsCache']) && $this->moduleParam['IsCache']=="1" && count($_POST)==0 && d("CACHE_IMPLEMENT")=="1"){
				
				
				$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
				$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache/files");
				
				$CacheKey = $this->getClass("Frontend\Common\Common")->getUniqueCacheKey();
				$filename=$dir.md5(DEFINE_CURRENT_PAGE_URL.$CacheKey).".txt";
				if(file_exists($filename)){
					echo "<!--SKCAIMCONTENT START-->";
					echo file_get_contents($filename);
					echo "<!--SKCAIMCONTENT END-->";
				}
				else{
					@ob_start();
					include($this->getDisplayFile());
					$Content = ob_get_contents();
					$fp2 = fopen($filename, "w");
					fputs($fp2,$Content);	
					fclose($fp2);
				}
			}
			else{
				include($this->getDisplayFile());
			}
			
		}
		else{
			"coming soon.";
		}
		
	}	
	
	function bodyClass()
	{
		$className = array();
		if(isset($this->moduleArr[0]) && isset($this->moduleArr[1]))
			$className[trim(strtolower($this->moduleArr[0]."_".$this->moduleArr[1]))] = trim(strtolower($this->moduleArr[0]."_".$this->moduleArr[1]));
			
		if(isset($this->moduleObj) && method_exists($this->moduleObj, "bodyClass")){
			$childClass = trim(strtolower($this->moduleObj->bodyClass()));
			if($childClass != "")
			$className[$childClass] = $childClass;
		}
		
		if(is_array($className) && count($className) > 0){
			return " ".implode(" ",array_values($className));
		}
		return "";
	}
	public function getDisplayFile()
	{
		if(isset($this->moduleArr[0]) && isset($this->moduleArr[1]))
			$displayFile = ($this->moduleArr[0])."/".($this->moduleArr[1])."/Front/View/".$this->view.".php";
		
		if(isset($displayFile) && $displayFile != "" && file_exists(FRONT_THEME_PATH."modules/".$displayFile))
			return (FRONT_THEME_PATH."modules/".$displayFile);
		else if(isset($displayFile) && $displayFile != "" && file_exists(DIR_FS_SITE."modules/".$displayFile))
			return (DIR_FS_SITE."modules/".$displayFile);
		else
			return false;
		
	}
	
	public function getMetaTitle()
	{
		if($this->metaTitle != "")
			return $this->metaTitle;
		else
			return d('SITE_NAME');
	}	
	public function setMetaTitle($val)
	{
		$this->metaTitle = $val;
	}

	public function getMetaKeywords()
	{
			return $this->metaKeywords;
	}	
	public function setMetaKeywords($val)
	{
		$this->metaKeywords = $val;
	}

	public function getMetaDescription()
	{
			return $this->metaDescription;
	}	
	public function setMetaDescription($val)
	{
		$this->metaDescription = $val;
	}	
};
