<?php 
namespace Customer\Report\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function EmailCustomersAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Customer Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Report created at ".date("Y-m-d h:i");
			
			$rows = $this->getAllReportList(false);
			$data = $this->PrepareAllReportList($rows,true);
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."customer_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $UserID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	public function PrintCustomersAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $UserID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	public function DownloadCustomersAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."customer_reports-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $UserID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	public function PrepareAllReportList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['UserID']=array("title"=>"ID","display"=>true);
		$ReturnData['header']['CreatedDate']=array("title"=>"CreatedDate","display"=>true);
		$ReturnData['header']['UserName']=array("title"=>"UserName","display"=>true);
		$ReturnData['header']['Email']=array("title"=>"Email","display"=>true);
		$ReturnData['header']['Name']=array("title"=>"Name","display"=>true);
		$ReturnData['header']['Address']=array("title"=>"Address","display"=>true);
		//$ReturnData['header']['RewardPoints']=array("title"=>"Loyalty Points","display"=>true);
		$ReturnData['header']['LastLogin']=array("title"=>"Last Login","display"=>true);
		$ReturnData['header']['IPAddress']=array("title"=>"IP Address","display"=>true);
		if($csv===false){
			$ReturnData['header']['Detail']=array("title"=>"Detail","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$LoyalityPointArr = $this->getClass('Customer\Login\Common')->GetLoyalityPoint($CurrentRecord->UserID);
				$ReturnData['data'][$CurrentRecord->UserID]['UserID'] = isset($CurrentRecord->UserID)?$CurrentRecord->UserID:"";
				$ReturnData['data'][$CurrentRecord->UserID]['UserName'] = isset($CurrentRecord->UserName)?$CurrentRecord->UserName:"";
				$ReturnData['data'][$CurrentRecord->UserID]['CreatedDate'] = isset($CurrentRecord->CreatedDate)?ConvertDateFromDb($CurrentRecord->CreatedDate):"";
				$ReturnData['data'][$CurrentRecord->UserID]['Name'] = (isset($CurrentRecord->FirstName)?$CurrentRecord->FirstName:"")." ".(isset($CurrentRecord->LastName)?$CurrentRecord->LastName:"");
				$ReturnData['data'][$CurrentRecord->UserID]['Email'] = (isset($CurrentRecord->Email)?$CurrentRecord->Email:"");
				$ReturnData['data'][$CurrentRecord->UserID]['Address'] = $CurrentRecord->Address1." ".$CurrentRecord->Address2." ".$CurrentRecord->City." ".$CurrentRecord->State." ".SKGetCountryByCodeFull($CurrentRecord->Country)." ".$CurrentRecord->ZipCode." ";
				//$ReturnData['data'][$CurrentRecord->UserID]['RewardPoints'] = isset($LoyalityPointArr['LeftPoint'])?$LoyalityPointArr['LeftPoint']:0;
				$ReturnData['data'][$CurrentRecord->UserID]['LastLogin'] = isset($CurrentRecord->LastLogin)?ConvertDateFromDb($CurrentRecord->LastLogin):"";
				$ReturnData['data'][$CurrentRecord->UserID]['IPAddress'] = isset($CurrentRecord->IPAddress)?$CurrentRecord->IPAddress:"";
				if($csv===false){
					$ReturnData['data'][$CurrentRecord->UserID]['Detail'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Customer\MyAccount\Index&UserID='.$CurrentRecord->UserID.'&view=AddEditUser" class="btn btn-xs btn-primary">Detail</a>';
				}
			}
		}
		return $ReturnData;
	}
	public function getAllReportList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
		$UserType = (isset($_REQUEST['utst']) && $_REQUEST['utst'] != "")?$_REQUEST['utst']:"";
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ReportObj = new DataTable(TABLE_USERS);
		//$where->notEqualTo('u.UserName','');
		
		if($UserType =="Wholesaler")
			$where->equalTo('Wholesaler',"1");
		
		if($UserType =="VIPStatus")
			$where->equalTo('VIPStatus',"1");
		
		if($UserType =="ClientStatus")
			$where->equalTo('ClientStatus',"1");
		
		if($StartDate != "")
			$where->greaterThanOrEqualTo('CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('CreatedDate', $EndDate);
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$ReportObj->where = $where;
		
		//$ReportObj->displayQuery = true;
		$ReportObj->AllowPaging =$paging;
		$ReportObj->PageSize=$PageSize;
		$ReportObj->PageTotalDisplay = 15; 
		$ReportObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ReportObj;
		//$ReportObj->columnExpression=true;
		return $ReportObj->tableSelectAll(array("*"),array($OrderBy));
	
	}
	
	public function getSortByArray()
	{
		return  array(
					"11"=>array("display"=>"Name (A - Z)","column"=>"FirstName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"FirstName DESC"),
					"21"=>array("display"=>"Email (A - Z)","column"=>"Email ASC"),
					"22"=>array("display"=>"Email (Z - A)","column"=>"Email DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"CreatedDate ASC"),
					);
	}
	
	public function pageTitle()
	{
		return "Customers Reports";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
				</div>		
			   ';
	}
	
	
}	