<?php 
namespace Customer\MyAccount\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Customer\Login\Common as LoginCommon;
use Customer\MyAccount\Common as MyAccount;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	function __construct()
	{
		
		$this->getClass('Customer\Login\Common')->CheckUserLogin(constant("DEFINE_CURRENT_PAGE_URL"));
		
	}
	
	public function getLoginCommon()
	{
		$obj = new LoginCommon();
		return $obj;
	}
	
	public function getMyAccountCommon()
	{
		$obj = new MyAccountCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			if($arr['ID']=="1001")
				$arr['ID'] ="108";
			
			$obj = $this->getClass('Cms\Pages\Common')->getPageByPageID($arr['ID']);
			if(isset($obj->PageID))
			{
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
		}
		
		
	}
	
		public function AddShareWishlistAction()
		{
			if(count($_POST)>0)
			{
				
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$this->getSession()->setArrVar("alert",array("success","You have successfully sent email to your friend."));
					$this->AllDone = "1";
					
					$Mail_Subject = "Please check list of products at ".d('SITE_NAME')."";
					$Mail_ToEmail = isset($_POST['FEmail'])?$_POST['FEmail']:"";
					
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody =isset($_POST['MessageBody'])?$_POST['MessageBody']:"";
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
			
	public function StatusWListCategoryAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
		$UserID = $this->getSession()->getVar("UserID");
		$WCategoryID = isset($_GET['WCatID'])?$_GET['WCatID']:"";	
		if($WCategoryID > 0){
			
			$Obj = new DataTable(TABLE_USERS_WCATEGORY);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			$Obj->where[] = array('=',array('WCategoryID' => $WCategoryID));
			$CurrentList = (object)$Obj->tableSelectOne(array("*"));
			if(isset($CurrentList->WCategoryID) && $CurrentList->WCategoryID != ""){
				 
				 $Obj = new DataTable(TABLE_USERS_WCATEGORY);
				 $Obj->where[] = array('=',array('UserID' => $UserID));
				 $Obj->where[] = array('=',array('WCategoryID' => $WCategoryID));
				 $DataArray = array();
				 $DataArray['ListType'] = ($CurrentList->ListType=="Public")?"Private":"Public";
				 $Obj->tableUpdate($DataArray);
				 $this->getSession()->setArrVar("alert",array("success","Status updated of your wishlist."));
				  
			}
		}
		 MyRedirect(SKSEOURL('account','MyWishlist'));
		  exit;	
			
		}
	}
	public function RemoveWListCategoryAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
		$UserID = $this->getSession()->getVar("UserID");
		$WCategoryID = isset($_GET['WCatID'])?$_GET['WCatID']:"";	
		if($WCategoryID > 0){
			
			$Obj = new DataTable(TABLE_USERS_WCATEGORY);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			$Obj->where[] = array('=',array('WCategoryID' => $WCategoryID));
			$CurrentList = (object)$Obj->tableSelectOne(array("*"));
			if(isset($CurrentList->WCategoryID) && $CurrentList->WCategoryID != ""){
				 
				 $Obj = new DataTable(TABLE_USERS_WCATEGORY);
				 $Obj->where[] = array('=',array('UserID' => $UserID));
				 $Obj->where[] = array('=',array('WCategoryID' => $WCategoryID));
				 $Obj->tableDelete();
				 $this->getSession()->setArrVar("alert",array("success","Wishlist deleted successfully."));
				  
			}
		}
		 MyRedirect(SKSEOURL('account','MyWishlist'));
		  exit;	
			
		}
	}
	public function RemoveWListItemAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$WID = isset($_GET['WID'])?$_GET['WID']:"";	
			if($WID > 0){
				$UWObj = new DataTable(TABLE_USERS_WISHLIST);
				$UWObj->where[] = array('=',array('UserID' => $UserID));
				$UWObj->where[] = array('=',array('WishListID' => $WID));
				$CurrentWProduct = (object)$UWObj->tableSelectOne(array("*"));
				if(isset($CurrentWProduct->WishListID) && $CurrentWProduct->WishListID != ""){
					 
					 $UWObj = new DataTable(TABLE_USERS_WISHLIST);
					 $UWObj->where[] = array('=',array('UserID' => $UserID));
					 $UWObj->where[] = array('=',array('WishListID' => $WID));
					 $UWObj->tableDelete();	
					 $this->getSession()->setArrVar("alert",array("success","item deleted in your wishlist."));
					  
				}
			}
			 MyRedirect(SKSEOURL('account','MyWishlist'));
			  exit;	
			
		}
	}
	public function AddInListAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$ProductID = isset($_POST['ProductID'])?$_POST['ProductID']:"";
			if($ProductID > 0){
				$wishlistCatRows = $this->getClass('Customer\Login\Common')->GetWishListCategory($UserID,"All");
				$ListID = isset($_POST['ListID'])?$_POST['ListID']:"";
				$ListName = isset($_POST['ListName'])?$_POST['ListName']:"";
				$ListType = isset($_POST['ListType'])?$_POST['ListType']:"Public";
				/* add list name start*/
				if($ListName != ""){
					
					$Obj = new DataTable(TABLE_USERS_WCATEGORY);
					$Obj->where[] = array('=',array('UserID' => $UserID));
					$Obj->where[] = array('=',array('CategoryName' => $ListName));
					$CurrentList = (object)$Obj->tableSelectOne(array("*"));
					if(isset($CurrentList->WCategoryID) && $CurrentList->WCategoryID != ""){
						$ListID = $CurrentList->WCategoryID;
					}
					else{
						$Obj = new DataTable(TABLE_USERS_WCATEGORY);
						$DataArray = array();
						$DataArray['CategoryName']	= $ListName;
						$DataArray['UserID']	= $UserID;
						$DataArray['ListType']	= $ListType;
						$DataArray['CreatedDate']	= date('Y-m-d H:i:s');
						$ListID = $Obj->tableInsert($DataArray);
					}
					
				}
				/* add list name end*/
				
				if($ListID > 0){
					$Obj = new DataTable(TABLE_USERS_WCATEGORY);
					$Obj->where[] = array('=',array('UserID' => $UserID));
					$Obj->where[] = array('=',array('WCategoryID' => $ListID));
					$CurrentList = (object)$Obj->tableSelectOne(array("*"));
					if(isset($CurrentList->WCategoryID) && $CurrentList->WCategoryID != ""){
						
						$UWObj = new DataTable(TABLE_USERS_WISHLIST);
						$UWObj->where[] = array('=',array('UserID' => $UserID));
						$UWObj->where[] = array('=',array('WCategoryID' => $ListID));
						$UWObj->where[] = array('=',array('ProductID' => $ProductID));
						$CurrentWProduct = (object)$UWObj->tableSelectOne(array("*"));
						if(!isset($CurrentWProduct->WishListID)){
							$DataArray = array();
							$DataArray['WCategoryID']	= $ListID;
							$DataArray['UserID']	= $UserID;
							$DataArray['ProductID']	= $ProductID;
							$DataArray['CreatedDate']	= date('Y-m-d H:i:s');
							$UWObj->tableInsert($DataArray);
						}
					
					}
					
				}
				
			  $this->getSession()->setArrVar("alert",array("success","product added in your wishlist."));
			  MyRedirect(SKSEOURL('catalog_product','Detail',$ProductID));
			  exit;	
			}
		}
	}
	
	public function ViewClientInvoiceAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$InvoiceID = isset($_GET['IvID'])?$_GET['IvID']:"";
			if($InvoiceID != ""){
				
				$Obj = new DataTable(TABLE_CLIENT_INVOICES);
				$Obj->where[] = array('=',array('InvoiceID' => $InvoiceID));
				$Obj->where[] = array('=',array('UserID' => $UserID));
				$Obj->where[] = array('=',array('Display' => "1"));
				$CurrentInvoice = (object)$Obj->tableSelectOne(array("*"),array("InvoiceID DESC"));									
				if(isset($CurrentInvoice->InvoiceID) && $CurrentInvoice->InvoiceID != ""){
					$MessageBody = $this->getClass('Sale\Order\Common')->getClientInvoice($InvoiceID);
					echo $MessageBody;
					exit;
				}
			
			}
		}
	}
	
	public function ViewOrderAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$OrderID = isset($_GET['OID'])?$_GET['OID']:"";
			if($OrderID != ""){
				
				$Obj = new DataTable(TABLE_ORDERS);
				$Obj->where[] = array('=',array('OrderID' => $OrderID));
				$Obj->where[] = array('=',array('UserID' => $UserID));
				$CurrentOrder = (object)$Obj->tableSelectOne(array("*"),array("OrderID DESC"));									
				if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ""){
					$MessageBody = $this->getClass('Sale\Cart\ShoppingCalculation')->getInvoice($OrderID);
					echo $MessageBody;
					exit;
				}
			
			}
		}
	}
	public function RegisterProductAction()
	{
		if(count($_POST)>0){
			
			$CurrentUserObj  = $this->getLogedinUser();
			$Code = isset($_POST['RegistrationCode'])?$_POST['RegistrationCode']:""; 
			if(trim($Code)=="")
				$this->getSession()->setArrVar("alert",array("danger","Product registration code cannot be left empty."));
			
			$where = new Where();
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where->notEqualTo('p.ProductType','Child');
			$where->equalTo('p.Active',"1");
			$where->equalTo('pr.Active',"1");
			$where->equalTo('pr.ProductCode',$Code);
			$ProductObj->where = $where;
		
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_CODES),
										  'on'=>"(pr.ProductID=p.ProductID AND pr.Active='1')",
										  'columns'=>array("ProductCode"),
										  'type'=>''
										  );
			
			//$ProductObj->displayQuery = true;
			$rows = (object)$ProductObj->tableSelectAll(array("*"));						  
			
			if(count($rows)==0)
				$this->getSession()->setArrVar("alert",array("danger","Sorry! product registration code do not exist."));
			
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0){
			
				foreach($rows as $CurrentProduct){
					if(isset($CurrentProduct->ProductID) && $CurrentProduct->ProductID != ""){	
						 $UserID = $this->getSession()->getVar("UserID");
						 $ProductRegObj = new DataTable(TABLE_PRODUCT_REG_CODE);
						 $ProductRegObj->where[] = array('=',array('UserID' => $UserID));
						 $ProductRegObj->where[] = array('=',array('ProductID' => $CurrentProduct->ProductID));
						 $ProductRegObj->where[] = array('=',array('ProductRegID' => $Code));
						 $CurrentCode = (object)$ProductRegObj->tableSelectOne(array("*"));	
						 if(isset($CurrentCode->ProductRegID)){
							/* product already in the list*/
						 }
						 else{
							 
							 $ProductRegObj = new DataTable(TABLE_PRODUCT_REG_CODE);
							 $DataArray = array();
							 $DataArray['UserID'] = $UserID;
							 $DataArray['ProductID'] = $CurrentProduct->ProductID;
							 $DataArray['ProductRegID'] = $Code;
							 $DataArray['CreatedDate'] = date('Y-m-d H:i:s');
							 $ProductRegObj->tableInsert($DataArray);
			   
						 }
					}
					
				}
				
			   $this->getSession()->setArrVar("alert",array("success","You have successfully added product registration code."));
			   MyRedirect(SKSEOURL('account','ResourceCentre'));
			   exit;
			}
			
		}
	}
	public function VDownloadAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$VID = isset($_GET['VID'])?$_GET['VID']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($VID != "" && $EKEY != "" && $Key==$EKEY){
				$DownloadStatus = false;
				if($this->origin->v=="ResourceCentre" || $this->origin->v=="ViewRegisteredProducts"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getRegisterProductIDsByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="OnlineAcademy"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getOnlineAcademyProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="AftershowLive"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getAftershowLiveProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="MyStreamingVideos"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getMyStreamingVideosProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($DownloadStatus===true){
					$this->getClass('Plugin\Vimeo\VimeoVideo')->DownloadFile($VID,@$_GET['Dindex']);
				}
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v));
			exit;
			
		}
			
	}
	
	public function MMDownloadAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$Part = isset($_GET['Part'])?$_GET['Part']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($Part != "" && $EKEY != "" && $Key==$EKEY){
				$DownloadStatus = false;
				if($this->origin->v=="ResourceCentre" || $this->origin->v=="ViewRegisteredProducts"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getRegisterProductIDsByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="OnlineAcademy"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getOnlineAcademyProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="AftershowLive"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getAftershowLiveProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="MyStreamingVideos"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getMyStreamingVideosProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($DownloadStatus===true)
				{
					$CurrentProduct = $ReturnArray['products'][$PID];
					$params = array();
					$params["DownloadID"] = isset($CurrentProduct->FeedID)?$CurrentProduct->FeedID:"";
					$params["ProductID"] = isset($CurrentProduct->FeedID)?$CurrentProduct->FeedID:"";
					if(isset($_GET['LecID']) && $_GET['LecID'] != "")
						$params["ProductID"] = $_GET['LecID'];
	
					$params["email"] = isset($CurrentProduct->CustomerData->Email)?$CurrentProduct->CustomerData->Email:"";
					$params["Part"] = $Part;
					$FileObj =  $this->getClass('Plugin\MurphysMagic\MurphysMagic')->FetchMurphyRecord("GetDownloadLink",http_build_query($params));
					if(isset($FileObj['Status']) && $FileObj['Status']=="ready"){
						MyRedirect($FileObj['DownloadLink']);
						exit;
					}
					else if(isset($FileObj['Status']) && $FileObj['Status'] != "ready"){
						echo "<h3>Your request for download has been received and has been queued. <br>This shall be available for download after 1-2 hours (approximately) from now. Please try then.</h3>";
						exit;
		
					}
					else{
						
						if(isset($CurrentProduct->OrderID) && $CurrentProduct->OrderID != ""){
							$this->getClass('Plugin\MurphysMagic\MurphysMagic')->processPayment($CurrentProduct->OrderID);
							echo "<h1>Please try again.</h1>";		
							exit;	
						}
					}
					
				}
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v));
			exit;
			
		}
			
	}
	
	public function LDownloadAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$UserID = $this->getSession()->getVar("UserID");
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$DID = isset($_GET['DID'])?$_GET['DID']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($DID != "" && $EKEY != "" && $Key==$EKEY){
				
				$DownloadStatus = false;
				if($this->origin->v=="ResourceCentre" || $this->origin->v=="ViewRegisteredProducts"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getRegisterProductIDsByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="OnlineAcademy"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getOnlineAcademyProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="AftershowLive"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getAftershowLiveProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($this->origin->v=="MyStreamingVideos"){
					$ReturnArray = $this->getClass("Customer\Login\Common")->getMyStreamingVideosProductByUserID($UserID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				}
				
				if($DownloadStatus===true){
					$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
					$where = new Where();
					$where->equalTo('DownloadID',$DID);
					$Obj->where = $where;
					$CurrentDownload = (object)$Obj->tableSelectOne(array("*"),array("DownloadID ASC"));
					if(file_exists(DIR_FS_SITE_SECURE_DOWNLOAD.$CurrentDownload->DownloadFile) && $CurrentDownload->DownloadFile != ""){
						FileHandle::DownloadFile(DIR_FS_SITE_SECURE_DOWNLOAD.$CurrentDownload->DownloadFile);
					}
					
				}
				
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v));
			exit;
			
		}
			
	}
	public function ChangePasswordAction()
	{
		if(count($_POST)>0){
		
			$CurrentUserObj  = $this->getLogedinUser();
			
			if(empty($_POST['Password']))
				$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
			
			//$specialChars = preg_match('#[^\w]#', $password);
			if(strlen($_POST['Password']) < 8 || !preg_match("#[0-9]+#",$_POST['Password']) || !preg_match("#[A-Z]+#",$_POST['Password']) || !preg_match("#[a-z]+#",$_POST['Password'])) 
				$this->getSession()->setArrVar("alert",array("danger","Password must be at least 8 characters in length and must contain at least one number, one upper case letter, one lower case letter."));
			
			if($_POST['Password'] != $_POST['RPassword'])
				$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
			

			$TmpPwd = explode(":",$CurrentUserObj->Password);
			$EncyptPassword = NeoCryptedPassword($_POST['OldPassword'],$TmpPwd[1]).":".$TmpPwd[1];
			
			if($EncyptPassword != $CurrentUserObj->Password)
				$this->getSession()->setArrVar("alert",array("danger","Please enter correct old password."));
		
		
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				$DataArray = array();
				$DataArray['Password'] = $_POST['Password'];
				$PassSalt = md5(uniqid(rand(),true));
				$DataArray['Password'] = NeoCryptedPassword($DataArray['Password'],$PassSalt).":".$PassSalt;
	
				$UserID = $this->getSession()->getVar("UserID");
				$UserObj = new DataTable(TABLE_USERS);
				$UserObj->where[] = array('=',array('UserID' => $UserID));
				$UserObj->where[] = array('=',array('Active' => "1"));
				$UserObj->tableUpdate($DataArray);
			
				$this->getSession()->setArrVar("alert",array("success","You have successfully changed your password."));
				MyRedirect(SKSEOURL('account','Default'));
				exit;
			}
				
			
		}
	}
	
	public function ChangeProfileAction()
	{
		if(count($_POST)>0){
			
			$DataArray = array();
			$DataArray['FirstName']	= isset($_POST['FirstName'])?$_POST['FirstName']:"";
			$DataArray['LastName'] 	= isset($_POST['LastName'])?$_POST['LastName']:"";
			$DataArray['Address1']	= isset($_POST['Address1'])?$_POST['Address1']:"";
			$DataArray['Address2']	= isset($_POST['Address2'])?$_POST['Address2']:"";
			$DataArray['City']		= isset($_POST['City'])?$_POST['City']:"";
			$DataArray['State']		= isset($_POST['State'])?$_POST['State']:"";
			$DataArray['Country']	= isset($_POST['Country'])?$_POST['Country']:"";
			$DataArray['Area']		= isset($_POST['Area'])?$_POST['Area']:"";
			$DataArray['ZipCode']	= isset($_POST['ZipCode'])?$_POST['ZipCode']:"";
			$DataArray['Phone'] 	= isset($_POST['Phone'])?$_POST['Phone']:"";
			$DataArray['VATNumber'] 	= isset($_POST['VATNumber'])?$_POST['VATNumber']:"";
			
			if(empty($DataArray['FirstName']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter first name"));
			
			if(empty($DataArray['Address1']))
				$this->getSession()->setArrVar("alert",array("danger","Please select Address1"));
			if(empty($DataArray['City']))
				$this->getSession()->setArrVar("alert",array("danger","Please select City"));
			
			if(empty($DataArray['State']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter State"));
			
			if(empty($DataArray['ZipCode']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Post Code/Zip Code"));
			
			
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
				{
					$UserID = $this->getSession()->getVar("UserID");
					$UserObj = new DataTable(TABLE_USERS);
					$UserObj->where[] = array('=',array('UserID' => $UserID));
					$UserObj->where[] = array('=',array('Active' => "1"));
					$UserObj->tableUpdate($DataArray);
				}
		
				$this->getSession()->setArrVar("alert",array("success",d("ACCOUNT_INFO_UPDATED_MSG")));
				MyRedirect(SKSEOURL('account','Default'));
				exit;
			}
		}
	}
	
	public function VouchertoPointAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$VCode = isset($_GET['VCode'])?$_GET['VCode']:"";
			
			$CouponObj = new DataTable(array('c'=>TABLE_COUPONS));
			$CouponObj->joinExpression = true;
			$CouponObj->joinArray[] = array('name'=>array('gt'=>TABLE_GV_TRACK),
										  'on'=>"(gt.CouponID = c.CouponID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );
			$where = new Where();
			$where->equalTo('c.Active','1');
			$where->equalTo('c.GvEnabled','1');
			$where->equalTo('gt.UserID',$UserID);
			$where->equalTo('c.CouponCode',$VCode);
			$where->NEST//start braket
					->expression('(? BETWEEN StartDate AND EndDate)',date('Y-m-d'))
					//->OR
					//->expression("(StartDate =? OR EndDate =?)",array('0000-00-00','0000-00-00'))
					->OR
						->NEST//start braket
						->ISNULL('StartDate')
						->AND
						->ISNULL('EndDate')
						->UNNEST
				  ->UNNEST;
			$CouponObj->where = $where;
			$CurrentVoucher = (object)$CouponObj->tableSelectOne();
			if(isset($CurrentVoucher->CouponCode) && $CurrentVoucher->CouponCode != "" && $CurrentVoucher->CouponCode == $VCode){
				$VoucherPoints = $CurrentVoucher->CouponValue*d("PRODUCT_POINT_INCURRENCY");
				$CouponObj = new DataTable(TABLE_COUPONS);
				$DataArray = array();
				$DataArray['Active'] = "0";
				$DataArray['GvRedeem'] = "1";
				$DataArray['RedeemDate'] = date('Y-m-d H:i:s');
				$DataArray['OrderID'] = "0";
				$CouponObj->where[] = array('=',array('CouponID' => $CurrentVoucher->CouponID));
				$CouponObj->tableUpdate($DataArray);
				
				if($VoucherPoints > 0)
				{
					$UserPointObj = new DataTable(TABLE_USERS_POINT);
					$DataArray = array();
					$DataArray['UserID'] =$UserID;
					$DataArray['OrderID'] =0;
					$DataArray['CouponID'] = $CurrentVoucher->CouponID;
					$DataArray['Points'] = $VoucherPoints;
					$DataArray['OrderStatus'] = "Paid";
					$DataArray['PointStatus'] = "Get";
					$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
					$UserPointObj->tableInsert($DataArray);
				}
				
				$this->getSession()->setArrVar("alert",array("success","Congratulation Voucher Code has successfully converted into loyality points."));
				MyRedirect(SKSEOURL('account','Default'));
				exit;
			}
			
		}
	}
	public function DeleteAddressAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$AddressID = isset($_GET['ID'])?$_GET['ID']:"";
			$UserAddressObj = new DataTable(TABLE_USERS_ADDRESS);
			$UserAddressObj->where[] = array('=',array('UserID' => $UserID));
			$UserAddressObj->where[] = array('=',array('AddressID' => $AddressID));
			$UserAddressObj->tableDelete();
			$this->getSession()->setArrVar("alert",array("success","You have updated your address book."));
			MyRedirect(SKSEOURL('account','MyAddressBook'));
			exit;
			
		}
		
	}
	public function AddEditAddressAction()
	{
		if(count($_POST)>0){
			
			$DataArray = array();
			$DataArray['FirstName']	= isset($_POST['FirstName'])?$_POST['FirstName']:"";
			$DataArray['LastName'] 	= isset($_POST['LastName'])?$_POST['LastName']:"";
			$DataArray['Address1']	= isset($_POST['Address1'])?$_POST['Address1']:"";
			$DataArray['Address2']	= isset($_POST['Address2'])?$_POST['Address2']:"";
			$DataArray['City']		= isset($_POST['City'])?$_POST['City']:"";
			$DataArray['State']		= isset($_POST['State'])?$_POST['State']:"";
			$DataArray['Country']	= isset($_POST['Country'])?$_POST['Country']:"";
			$DataArray['Area']		= isset($_POST['Area'])?$_POST['Area']:"";
			$DataArray['ZipCode']	= isset($_POST['ZipCode'])?$_POST['ZipCode']:"";
			$DataArray['Phone'] 	= isset($_POST['Phone'])?$_POST['Phone']:"";
			
			if(empty($DataArray['FirstName']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter first name"));
			
			if(empty($DataArray['Address1']))
				$this->getSession()->setArrVar("alert",array("danger","Please select Address1"));
			if(empty($DataArray['City']))
				$this->getSession()->setArrVar("alert",array("danger","Please select City"));
			
			if(empty($DataArray['State']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter State"));
			
			if(empty($DataArray['ZipCode']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Post Code/Zip Code"));
			
			
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
				{
					$UserID = $this->getSession()->getVar("UserID");
					$ID = isset($_GET['ID'])?$_GET['ID']:"";
					
					if($ID > 0){
						$UserAddressObj = new DataTable(TABLE_USERS_ADDRESS);
						$UserAddressObj->where[] = array('=',array('UserID' => $UserID));
						$UserAddressObj->where[] = array('=',array('AddressID' => $ID));
						$UserAddressObj->tableUpdate($DataArray);
						$this->AllDone = "1";
						$this->getSession()->setArrVar("alert",array("success","You have updated your address book."));
					}
					else{
						
						$UserAddressObj = new DataTable(TABLE_USERS_ADDRESS);
						$DataArray['UserID'] 	= $UserID;
						$DataArray['AddressType'] 	= "Billing";
						$DataArray['CreatedDate'] 	= date('Y-m-d H:i:s');
						$UserAddressObj->tableInsert($DataArray);
						$this->AllDone = "1";
						$this->getSession()->setArrVar("alert",array("success","You have updated your address book."));
					}
					
				}
		
				
			}
		}
	}
	
	public function DeleteUserMessageAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$CurrentUser = $this->getLogedinUser();
			$MessageID = isset($_GET['MID'])?(int)$_GET['MID']:"";
			$CurrentMessage = $this->getClass('Customer\Login\Common')->GetMessageByMID($CurrentUser->UserID,$MessageID,false);
			if($MessageID > 0 && isset($CurrentMessage->MessageID)){
			
				$ObjR = new DataTable(TABLE_MESSAGES_TO);
				$where = new Where();
				$where->equalTo('UserID',$CurrentUser->UserID);
				$where->equalTo('MessageID',$MessageID);
				$where->notEqualTo('DefaultFolder','sent');
				
				$ObjR->where = $where;
				$DataArray = array();
				$DataArray['MessageRead'] = "1";
				$DataArray['MessageDelete'] = "1";
				$ObjR->tableUpdate($DataArray);
					
			}
			
		}
		$this->getSession()->setArrVar("alert",array("success","Message deleted successfully."));
		MyRedirect(SKSEOURL($this->origin->m,$this->origin->v));
		exit;
	}
	public function DownloadMessageFileAction()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != ""){
			$CurrentUser = $this->getLogedinUser();
			$MessageID = isset($_GET['MID'])?(int)$_GET['MID']:"";
			$CurrentMessage = $this->getClass('Customer\Login\Common')->GetMessageByMID($CurrentUser->UserID,$MessageID,false);
			if($MessageID > 0 && isset($CurrentMessage->MessageID)){
			
				if(isset($CurrentMessage->AttachmentFile) && $CurrentMessage->AttachmentFile != "" && file_exists(DIR_FS_SITE_PRIVATE."attachments/".$CurrentMessage->AttachmentFile)){
					FileHandle::DownloadFile(DIR_FS_SITE_PRIVATE."attachments/".$CurrentMessage->AttachmentFile);
				}
					
			}
			
		}
		$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
		MyRedirect(SKSEOURL($this->origin->m,"Default"));
		exit;
	}
	public function AddNewMessageAction()
		{
			if(count($_POST)>0 && $this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
			{
				$CurrentUser = $this->getLogedinUser();
				$ParentID = isset($_GET['MID'])?(int)$_GET['MID']:"0";;
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true && $CurrentUser->UserID != "")
				{
					
					$this->getSession()->setArrVar("alert",array("success","You have successfully sent message."));
					$this->AllDone = "1";
					if(isset($CurrentUser->UserID)){
					$MessageObj = new DataTable(TABLE_MESSAGES);
					$DataArray = array();
					$DataArray['ParentID'] = $ParentID;
					$DataArray['MessageTo'] = "Admin";
					//$DataArray['MessageCC'] = isset($_POST['MessageCC'])?$_POST['MessageCC']:"";
					//$DataArray['MessageBCC'] = isset($_POST['MessageBCC'])?$_POST['MessageBCC']:"";
					$DataArray['MessageFrom'] = $CurrentUser->FirstName." ".$CurrentUser->LastName."<".$CurrentUser->Email.">";
					
					$DataArray['Subject'] = isset($_POST['Subject'])?$_POST['Subject']:"";
					$DataArray['Message'] = isset($_POST['MessageBody'])?$_POST['MessageBody']:"";
					$DataArray['SenderID'] = $CurrentUser->UserID;
					
					/* attachment Start*/
					if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !=""){
						
						$ArrayType = explode(".",$_FILES['Upload']['name']);
						$Type=$ArrayType[count($ArrayType)-1];
						if(in_array(strtoupper($Type),$this->getClass('Customer\Login\Common')->getAttachmentTypesArray())){
							$dir = FileHandle::CheckPrivateLogDirectory("attachments");
							$FileName=uniqid("Att-".date('Y-m-d')."-").".".$Type;
							copy($_FILES['Upload']['tmp_name'],$dir.$FileName);
							$DataArray['AttachmentName'] = isset($_FILES['Upload']['name'])?$_FILES['Upload']['name']:"";
							$DataArray['AttachmentFile'] = $FileName;
						}
				
					}
					/* attachment End*/
					
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');			
					$MessageID = $MessageObj->tableInsert($DataArray);	
					if($MessageID > 0){
						$SubDataArray = array();
						$SubDataArray['MessageID'] = $MessageID;
						$SubDataArray['UserID'] = "Admin";
						$SubDataArray['MessageRead'] = "0";
						$SubDataArray['MessageDelete'] = "0";
						$SubDataArray['DefaultFolder'] = "inbox";
						$SubDataArray['MessageFolderID'] = "0";
						$MessageToObj = new DataTable(TABLE_MESSAGES_TO);
						$MessageToObj->tableInsert($SubDataArray);	
						
						$SubDataArray = array();
						$SubDataArray['MessageID'] = $MessageID;
						$SubDataArray['UserID'] = $CurrentUser->UserID;
						$SubDataArray['MessageRead'] = "1";
						$SubDataArray['MessageDelete'] = "0";
						$SubDataArray['DefaultFolder'] = "sent";
						$SubDataArray['MessageFolderID'] = "0";
						$MessageToObj = new DataTable(TABLE_MESSAGES_TO);
						$MessageToObj->tableInsert($SubDataArray);	
					}
					
					$Mail_Subject = isset($_POST['Subject'])?$_POST['Subject']:"";
					$Mail_ToEmail = d('ADMIN_EMAIL');
					
					$Mail_FromEmail =$CurrentUser->Email;
					$Mail_FromName = $CurrentUser->FirstName." ".$CurrentUser->LastName;
					$MessageBody =isset($_POST['MessageBody'])?nl2br($_POST['MessageBody']):"";
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
					
				}	
					
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
		
	public function getUserMessages()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"25";
			$type = (isset($_REQUEST['type']) && $_REQUEST['type'] != "")?$_REQUEST['type']:"D";
			$folder = (isset($_REQUEST['folder']) && $_REQUEST['folder'] != "")?$_REQUEST['folder']:"inbox";

			$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
			$KeywordArr =  explode(" ",$Keyword);
			$OrderBy = array("m.CreatedDate DESC");
			
			$where = new Where();
			$MessageObj = new DataTable(array('m'=>TABLE_MESSAGES));
			
			$where->NEST//start braket
				->equalTo('mt.MessageDelete','')
				->OR
				->equalTo('mt.MessageDelete','0')
				->OR
				->isNull('mt.MessageDelete')
			  ->UNNEST;			
			$where->equalTo('mt.UserID',$UserID);
			
			if($type=="F")
				$where->equalTo('mt.MessageFolderID',$folder);
			else
				$where->equalTo('mt.DefaultFolder',$folder);

			
			if(count($KeywordArr) > 0 && $Keyword != "")
			{
				foreach ($KeywordArr as $Key=>$Value)
				{
					$where->NEST//start braket
							->like('m.MessageTo','%'.$Value.'%')->OR
							->like('m.Subject','%'.$Value.'%')->OR
							->like('m.Message','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			$MessageObj->where = $where;
		
			$MessageObj->joinExpression = true;
			$MessageObj->joinArray[] = array('name'=>array('mt'=>TABLE_MESSAGES_TO),
										  'on'=>"(m.MessageID=mt.MessageID)",
										  'columns'=>array("MessageRead","ReadDate","DefaultFolder"),
										  'type'=>''
										  );
			//$MessageObj->displayQuery =true;
			$MessageObj->AllowPaging =true;
			if(isset($_GET['ps']) && $_GET['ps']=="ALL")
				$MessageObj->AllowPaging =false;
				
			$MessageObj->PageSize=$ps;
			$MessageObj->PagingPrefix="";
			$MessageObj->PageTotalDisplay = 10; 
			$MessageObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
			$this->paging = $MessageObj;
			$MessageObj->groupBy = array("m.MessageID");
			return $MessageObj->tableSelectAll(array("*"),$OrderBy);
		}
			 
	}
	
	
	
	public function LogoutAction()
	{
		$this->getClass('Customer\Login\Common')->LogoutUser();
		$this->getSession()->setArrVar("alert",array("success",d("LOGOUT_MSG")));
		MyRedirect(SKSEOURL('customer','Login'));
		exit;
		
	}
	
	public function getWholeSalerProductlist()
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"16";
		$sb = isset($_GET['sb'])?$_GET['sb']:"00";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderBy = array("p.CreatedDate DESC");
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('p.WholeSaler',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
			}
		}
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID AND (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		//$ProductObj->displayQuery =true;
		$ProductObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$ProductObj->AllowPaging =false;
			
		$ProductObj->PageSize=$ps;
		$ProductObj->PagingPrefix="";
		$ProductObj->PageTotalDisplay = 10; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	public function getVIPProductlist()
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"16";
		$sb = isset($_GET['sb'])?$_GET['sb']:"00";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderBy = array("p.CreatedDate DESC");
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('p.VIPStatus',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
			}
		}
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		//$ProductObj->displayQuery =true;
		$ProductObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$ProductObj->AllowPaging =false;
			
		$ProductObj->PageSize=$ps;
		$ProductObj->PagingPrefix="";
		$ProductObj->PageTotalDisplay = 10; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	
	public function getSortByArray()
	{
		return  array(
					"00"=>array("display"=>"Default","column"=>array("p.Position ASC","p.CreatedDate DESC")),
					"11"=>array("display"=>"Name (A - Z)","column"=>array("p.ProductName ASC")),
					"12"=>array("display"=>"Name (Z - A)","column"=>array("p.ProductName DESC")),
					"21"=>array("display"=>"Price (Low &gt; High)",array("column"=>"PriceSort ASC")),
					"22"=>array("display"=>"Price (High &gt; Low)",array("column"=>"PriceSort DESC")),
					"31"=>array("display"=>"Date (Latest)","column"=>array("p.CreatedDate DESC")),
					"32"=>array("display"=>"Date (Oldest)","column"=>array("p.CreatedDate ASC")),
					);
	}
	
	public function getUserAddressByID($AddressID)
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$UserAddressObj = new DataTable(TABLE_USERS_ADDRESS);
			$UserAddressObj->where[] = array('=',array('UserID' => $UserID));
			$UserAddressObj->where[] = array('=',array('AddressID' => $AddressID));
			return (object)$UserAddressObj->tableSelectOne();
		}
		return false;
	}
	
	
	
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"";
	}
	
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	function getLogedinUser()
	{
		return $this->getClass('Customer\Login\Common')->IsUserLogin();
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
}	