<?php 
namespace Customer\MyAccount\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Customer\MyAccount\Common as MyAccountCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class MessageController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewMessages");
	}
	
	public function getMyAccountCommon()
	{
		$obj = new MyAccountCommon();
		return $obj;
	}
	
	public function DownloadFileAction()
	{
		$MessageID = (isset($_GET['MessageID']) && $_GET['MessageID'] > 0)?$_GET['MessageID']:0;
		$CurrentMessage = $this->getMessageDetail($MessageID);
		if($MessageID > 0 && isset($CurrentMessage->MessageID)){
			if(isset($CurrentMessage->AttachmentFile) && $CurrentMessage->AttachmentFile != "" && file_exists(DIR_FS_SITE_PRIVATE."attachments/".$CurrentMessage->AttachmentFile)){
				FileHandle::DownloadFile(DIR_FS_SITE_PRIVATE."attachments/".$CurrentMessage->AttachmentFile);
			}
				
		}
		
	}
	
	
	public function DeleteMessageAction()
	{
		$MessageID = (isset($_GET['MessageID']) && $_GET['MessageID'] > 0)?$_GET['MessageID']:0;
		$CurrentMessage = $this->getMessageDetail($MessageID);
		if($MessageID > 0 && isset($CurrentMessage->MessageID)){
			
			$Admin = "Admin";
			$ObjR = new DataTable(TABLE_MESSAGES_TO);
			$where = new Where();
			$where->equalTo('UserID',$Admin);
			$where->equalTo('MessageID',$MessageID);
			$where->notEqualTo('DefaultFolder','sent');
			
			$ObjR->where = $where;
			$DataArray = array();
			$DataArray['MessageRead'] = "1";
			$DataArray['MessageDelete'] = "1";
			$ObjR->tableUpdate($DataArray);
				
		}
		
		$this->getSession()->setArrVar("alert",array("success","Message deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."");
		exit;
		
	}
	public function AddEditMessageAction()
	{
		if(count($_POST)>0)
		{
			$UID = isset($_GET['UID'])?$_GET['UID']:0;
			$ParentID = (isset($_GET['MessageID']) && $_GET['MessageID'] > 0)?$_GET['MessageID']:0;
					
			foreach($_POST['UserID'] as $k=>$UserID){
				
				$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($UserID);
				if(isset($CurrentUser->UserID)){
					$MessageObj = new DataTable(TABLE_MESSAGES);
					$DataArray = array();
					$DataArray['ParentID'] = $ParentID;
					$DataArray['MessageTo'] = $CurrentUser->FirstName." ".$CurrentUser->LastName."<".$CurrentUser->Email.">";
					$DataArray['MessageCC'] = isset($_POST['MessageCC'])?$_POST['MessageCC']:"";
					$DataArray['MessageBCC'] = isset($_POST['MessageBCC'])?$_POST['MessageBCC']:"";
					$DataArray['MessageFrom'] = isset($_POST['MessageFrom'])?$_POST['MessageFrom']:"Admin";
					
					$DataArray['Subject'] = isset($_POST['Subject'])?$_POST['Subject']:"";
					$DataArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
					$DataArray['SenderID'] = isset($_POST['SenderID'])?$_POST['SenderID']:"Admin";
					
					/* attachment Start*/
					if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
					{
						$ArrayType = explode(".",$_FILES['Upload']['name']);
						$Type=$ArrayType[count($ArrayType)-1];
						
						$dir = FileHandle::CheckPrivateLogDirectory("attachments");
						$FileName=uniqid("Att-".date('Y-m-d')."-").".".$Type;
						copy($_FILES['Upload']['tmp_name'],$dir.$FileName);
					
						$DataArray['AttachmentName'] = isset($_FILES['Upload']['name'])?$_FILES['Upload']['name']:"";
						$DataArray['AttachmentFile'] = $FileName;
				
					}
					/* attachment End*/
					
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');			
					$MessageID = $MessageObj->tableInsert($DataArray);	
					if($MessageID > 0){
						$SubDataArray = array();
						$SubDataArray['MessageID'] = $MessageID;
						$SubDataArray['UserID'] = $CurrentUser->UserID;
						$SubDataArray['MessageRead'] = "0";
						$SubDataArray['MessageDelete'] = "0";
						$SubDataArray['DefaultFolder'] = "inbox";
						$SubDataArray['MessageFolderID'] = "0";
						$MessageToObj = new DataTable(TABLE_MESSAGES_TO);
						$MessageToObj->tableInsert($SubDataArray);	
						
						$SubDataArray = array();
						$SubDataArray['MessageID'] = $MessageID;
						$SubDataArray['UserID'] = "Admin";
						$SubDataArray['MessageRead'] = "1";
						$SubDataArray['MessageDelete'] = "0";
						$SubDataArray['DefaultFolder'] = "sent";
						$SubDataArray['MessageFolderID'] = "0";
						$MessageToObj = new DataTable(TABLE_MESSAGES_TO);
						$MessageToObj->tableInsert($SubDataArray);	
						
						$Mail_Subject = isset($_POST['Subject'])?$_POST['Subject']:"";;
						$Mail_ToEmail = $CurrentUser->Email;
						$Mail_FromEmail =d('ADMIN_EMAIL');
						$Mail_FromName = d('SITE_NAME');
						$MessageBody =isset($_POST['Message'])?nl2br($_POST['Message']):"";
						$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
					}
				}		
			}
			
			$this->getSession()->setArrVar("alert",array("success","Message added successfully."));
				
			if($UID > 0)
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=Customer\MyAccount\Index&view=AddEditUser&UserID=".$UID."&tab=messages");
			else
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."");
			
			exit;
		}
		
	}
	
	
	
	public function getAllMessageList()
	{
			$Admin = "Admin";
			$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"25";
			$type = (isset($_REQUEST['type']) && $_REQUEST['type'] != "")?$_REQUEST['type']:"D";
			$folder = (isset($_REQUEST['folder']) && $_REQUEST['folder'] != "")?$_REQUEST['folder']:"inbox";

			$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
			$KeywordArr =  explode(" ",$Keyword);
			$OrderBy = array("m.CreatedDate DESC");
			
			$where = new Where();
			$MessageObj = new DataTable(array('m'=>TABLE_MESSAGES));
			
			$where->NEST//start braket
				->equalTo('mt.MessageDelete','')
				->OR
				->equalTo('mt.MessageDelete','0')
				->OR
				->isNull('mt.MessageDelete')
			  ->UNNEST;			
			$where->equalTo('mt.UserID',$Admin);
			
			if($type=="F")
				$where->equalTo('mt.MessageFolderID',$folder);
			else
				$where->equalTo('mt.DefaultFolder',$folder);

			
			if(count($KeywordArr) > 0 && $Keyword != "")
			{
				foreach ($KeywordArr as $Key=>$Value)
				{
					$where->NEST//start braket
							->like('m.MessageTo','%'.$Value.'%')->OR
							->like('m.Subject','%'.$Value.'%')->OR
							->like('m.Message','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			$MessageObj->where = $where;
		
			$MessageObj->joinExpression = true;
			$MessageObj->joinArray[] = array('name'=>array('mt'=>TABLE_MESSAGES_TO),
										  'on'=>"(m.MessageID=mt.MessageID)",
										  'columns'=>array("MessageRead","ReadDate","DefaultFolder"),
										  'type'=>''
										  );
			//$MessageObj->displayQuery =true;
			$MessageObj->AllowPaging =true;
			if(isset($_GET['ps']) && $_GET['ps']=="ALL")
				$MessageObj->AllowPaging =false;
				
			$MessageObj->PageSize=$ps;
			$MessageObj->PagingPrefix="";
			$MessageObj->PageTotalDisplay = 10; 
			$MessageObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
			$this->paging = $MessageObj;
			$MessageObj->groupBy = array("m.MessageID");
			return $MessageObj->tableSelectAll(array("*"),$OrderBy);
		
	
	}
	
	public function getUserIDsByMessageID($UserIDs = "",$MessageID="")
	{
		$UserIDArray = array();
		if($MessageID > 0){
			
			$Obj = new DataTable(TABLE_MESSAGES_TO);
			$where = new Where();
			$where->equalTo('MessageID',$MessageID);
			$where->notEqualTo('UserID','Admin');
			$Obj->where = $where;
			$TObj = (object)$Obj->tableSelectOne(array("UserID"));
			if(isset($TObj->UserID) && $TObj->UserID != "")
			array_push($UserIDArray,$TObj->UserID);
		}
		
		if(isset($UserIDs) && is_array($UserIDs) && count($UserIDs) > 0){
			foreach($UserIDs as $val)
				$UserIDArray[$val] = $val;
				
			//array_push($UserIDArray,array_values($UserIDs));
		}
		else if(isset($UserIDs) && $UserIDs != ""){
			array_push($UserIDArray,$UserIDs);
		}
		
		//var_dump($UserIDArray);exit;
		if(isset($UserIDArray) && count($UserIDArray) > 0){
			$Obj2 = new DataTable(TABLE_USERS);
			$where = new Where();
			$where->in('UserID',$UserIDArray);
			$Obj2->where = $where;
			$Obj2->columnExpression=true;
			$rows = $Obj2->tableSelectAll(array("UserID as id","CONCAT(UserName,' (', Email, ' ', FirstName, ' ',LastName,')') as text"),array("UserName ASC"),100);
			return $rows;
			
		}
		
		return array();
		
	}
	public function getMessageDetail($MessageID)
	{
		$Obj2 = new DataTable(TABLE_MESSAGES);
		$Obj2->where[] = array('=',array('MessageID' => $MessageID));
		return (object)$Obj2->tableSelectOne("");
		
	}
	public function pageTitle()
	{
		return "Messages";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditMessage">Add Message</a>
					</div>
              </div>		
			   ';
	}
	
	
}	