<?php 
namespace Customer\MyAccount\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class JsonController extends AbstractModule
{
	function __construct()
	{
		header('Content-Type: application/json');
	}
	
	
	public function listAction()
	{
		$Keyword = isset($_REQUEST['q'])?$_REQUEST['q']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$where->notEqualTo('u.UserName','');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$UserObj->where = $where;
		$UserObj->columnExpression=true;
		$UserObj->rowType="array";
		$jsonArray = $UserObj->tableSelectAll(array("UserID as id","CONCAT(UserName,' (', Email, ' ', FirstName, ' ',LastName,')') as text"),array("UserName ASC"),100);
		echo json_encode($jsonArray);
		exit;
	}	
	
}	