<?php 
namespace Customer\MyAccount\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Customer\MyAccount\Common as MyAccountCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getMyAccountCommon()
	{
		$obj = new MyAccountCommon();
		return $obj;
	}
	
	
	public function AddEditUserAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		if(count($_POST)>0){
			
			$DataArray = array();
			$DataArray['FirstName']	= isset($_POST['FirstName'])?$_POST['FirstName']:"";
			$DataArray['LastName'] 	= isset($_POST['LastName'])?$_POST['LastName']:"";
			$DataArray['BusinessNature'] 	= isset($_POST['BusinessNature'])?$_POST['BusinessNature']:"";
			$DataArray['BusinessName'] 	= isset($_POST['BusinessName'])?$_POST['BusinessName']:"";
			$DataArray['Gender'] 	= isset($_POST['Gender'])?$_POST['Gender']:"";
			$DataArray['Goal'] 	= isset($_POST['Goal'])?$_POST['Goal']:"";
			$DataArray['Address1']	= isset($_POST['Address1'])?$_POST['Address1']:"";
			$DataArray['Address2']	= isset($_POST['Address2'])?$_POST['Address2']:"";
			$DataArray['City']		= isset($_POST['City'])?$_POST['City']:"";
			$DataArray['State']		= isset($_POST['State'])?$_POST['State']:"";
			$DataArray['Area']	= isset($_POST['Area'])?$_POST['Area']:"";
			$DataArray['Country']	= isset($_POST['Country'])?$_POST['Country']:"";
			$DataArray['ZipCode']		= isset($_POST['ZipCode'])?$_POST['ZipCode']:"";
			$DataArray['VATNumber'] 	= isset($_POST['VATNumber'])?$_POST['VATNumber']:"";
			$DataArray['Phone'] 	= isset($_POST['Phone'])?$_POST['Phone']:"";
			$DataArray['VATExempt'] = isset($_POST['VATExempt'])?$_POST['VATExempt']:0;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
			$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
			$DataArray['PaidPercent'] = (isset($_POST['PaidPercent']) && $_POST['PaidPercent'] !="")?$_POST['PaidPercent']:"0";
			$DataArray['ClientStatus'] = isset($_POST['ClientStatus'])?$_POST['ClientStatus']:0;
			$DataArray['DiscountPercent'] = (isset($_POST['DiscountPercent']) && $_POST['DiscountPercent'] !="")?$_POST['DiscountPercent']:"0";
			$DataArray['LoyaltyDiscountActive'] = isset($_POST['LoyaltyDiscountActive'])?$_POST['LoyaltyDiscountActive']:0;
			
			if($UserID != "")
			{
				/* update users*/
				
				 if(isset($_POST['UpdateUserName']) && $_POST['UpdateUserName']=="1")
				 {
					$DataArray['UserName']	= isset($_POST['UserName'])?$_POST['UserName']:"";
					$UserObj = new DataTable(TABLE_USERS);
					$UserObj->where[] = array('=',array('UserName' => $DataArray['UserName']));
					$UserObj->columnExpression=true;
					$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
					if($Obj['Total'] > 0)
						$this->getSession()->setArrVar("alert",array("danger",d("USERNAME_ALREADY_EXIST_MSG")));
					
				 }
				 
				  if(isset($_POST['UpdateEmail']) && $_POST['UpdateEmail']=="1")
				 {
					$DataArray['Email']	= isset($_POST['Email'])?$_POST['Email']:"";
					$UserObj = new DataTable(TABLE_USERS);
					$UserObj->where[] = array('=',array('Email' => $DataArray['Email']));
					$UserObj->columnExpression=true;
					$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
					if($Obj['Total'] > 0)
						$this->getSession()->setArrVar("alert",array("danger","This Email already exists. Please try again."));
					
				 }
				 
				 
				 
				 $arr = $this->getSession()->getVar("alert");
				 if($arr==NULL || count($arr)==0)	{
					 
					 $UserObj = new DataTable(TABLE_USERS);
					 $UserObj->where[] = array('=',array('UserID' => $UserID));
					 $UserObj->tableUpdate($DataArray);
				
					 $this->getClass('Customer\Login\Common')->UserTypeSync($UserID);
					 $this->getSession()->setArrVar("alert",array("success","User updated successfully."));
					 
					 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=general");
					 exit;
				 }
			}
			else
			{
				/* add user with checks*/
				
				$DataArray['UserName']	= isset($_POST['UserName'])?$_POST['UserName']:"";
				$DataArray['Email']		= isset($_POST['Email'])?$_POST['Email']:$DataArray['UserName'];
				$DataArray['Password']	= isset($_POST['Password'])?$_POST['Password']:"";
				
				if(empty($DataArray['UserName']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter username"));
		
		
			if(empty($DataArray['Password']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter password"));
			
			if(strlen($_POST['Password']) < 8 || !preg_match("#[0-9]+#",$_POST['Password']) || !preg_match("#[A-Z]+#",$_POST['Password']) || !preg_match("#[a-z]+#",$_POST['Password'])) 
					$this->getSession()->setArrVar("alert",array("danger","Password must be at least 8 characters in length and must contain at least one number, one upper case letter, one lower case letter."));
			
			if(@$_POST['Password'] != @$_POST['CPassword'])
				$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
			
			if(!$this->getClass('Customer\Login\Common')->ValidateEmail($DataArray['Email']))
				$this->getSession()->setArrVar("alert",array("danger","Invalid Email Address ! Please try user@domain.com"));
			
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserName' => $DataArray['UserName']));
			$UserObj->columnExpression=true;
			$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger",d("USERNAME_ALREADY_EXIST_MSG")));
			
			/* Check email address too start */
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('Email' => $DataArray['Email']));
			$UserObj->columnExpression=true;
			$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger","This Email already exists. Please try again."));
			/* Check email address too end */
			
			 $arr = $this->getSession()->getVar("alert");
			 if($arr==NULL || count($arr)==0)	{
				 
				 $UserID  = SKRemoveSpecialChars(substr($DataArray['UserName'],0,5))."_".md5(uniqid(rand(), true));
				 $DataArray['UserID']  = $UserID;
				 $DataArray['LastLogin']  = date('Y-m-d H:i:s');
				 $DataArray['PrevLastLogin']  = date('Y-m-d H:i:s');
				 $DataArray['CreatedDate']  = date('Y-m-d H:i:s');
				 
				 $UserObj->tableInsert($DataArray);
				 
				 /* UserTypeRelObj addition start */
					$DataSubArray = array();
					$DataSubArray['UserID'] = $DataArray['UserID'];
					$DataSubArray['UserTypeID'] = (int)(isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1");
					$DataSubArray['Discount'] = "0";
					$DataSubArray['CreatedDate'] = $DataArray['CreatedDate'];
					
					$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
					$UserTypeRelObj->tableInsert($DataSubArray);
				 /* UserTypeRelObj addition end */
				 
				 $this->getClass('Customer\Login\Common')->UserTypeSync($UserID);
				 $this->getSession()->setArrVar("alert",array("success","You have successfully added new user."));
				 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=general");
				 exit;
			 }
			
			}
			
			
		}
	}
	public function UpdateBulkUserAction()
	{
		/* BulkSubmit start*/
			if(isset($_POST['BulkSubmit'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$UserID){
					if($UserID != ""){
						
						$DataArray = array();		
						if(isset($_POST['ClientStatus']) && $_POST['ClientStatus'] != ""){
							$DataArray['ClientStatus'] = isset($_POST['ClientStatus'])?$_POST['ClientStatus']:0;
							$DataArray['PaidPercent'] = isset($_POST['PaidPercent'])?$_POST['PaidPercent']:0;
						}
						if(isset($_POST['VATExempt']) && $_POST['VATExempt'] != "")
							$DataArray['VATExempt'] = isset($_POST['VATExempt'])?$_POST['VATExempt']:0;
						if(isset($_POST['WholeSaler']) && $_POST['WholeSaler'] != "")
							$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
						if(isset($_POST['VIPStatus']) && $_POST['VIPStatus'] != "")
							$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
						if(isset($_POST['Active']) && $_POST['Active'] != "")
							$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						if(count($DataArray) > 0){
							$UserObj = new DataTable(TABLE_USERS);
							$UserObj->where="UserID ='".$UserID."'";
							$UserObj->tableUpdate($DataArray);
							$this->getClass('Customer\Login\Common')->UserTypeSync($UserID);
						}
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Customers updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&orderBy=".$this->origin->orderBy."&k=".$this->origin->k."&WS=".$this->origin->WS."&AT=".$this->origin->AT."&VS=".$this->origin->VS."&CL=".$this->origin->CL);
			    exit;
			}
			/* BulkSubmit end*/
	}
	
	
	public function VouchertoPointAction()
	{
		$VCode = isset($_GET['VCode'])?$_GET['VCode']:"";
			
		if($VCode != "")
		{
			$this->getClass('Customer\Login\Common')->ConvertVouchertoPoint($VCode);
			$this->getSession()->setArrVar("alert",array("success","Congratulation Voucher Code has successfully converted into loyality points."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&UserID=".$this->origin->UserID."&tab=vouchers");
			exit;
			
		}
	}
	
	public function GenerateOTPAction()
	{
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:0;
			$DataArray = array();
			$DataArray['OnePassword'] = uniqid();
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserID' => $UserID));
			$UserObj->where[] = array('=',array('Active' => "1"));
			$UserObj->tableUpdate($DataArray);
			echo $DataArray['OnePassword'];exit;
			
	}
	public function RemoveOTPAction()
	{
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:0;
			$DataArray = array();
			$DataArray['OnePassword'] = "";
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserID' => $UserID));
			$UserObj->where[] = array('=',array('Active' => "1"));
			$UserObj->tableUpdate($DataArray);
			echo "1";exit;
			
	}
	
	public function UnBlockUserAction()
	{
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:0;
			$DataArray = array();
			$DataArray['FailureNum'] = "0";
			$DataArray['FailureDate'] = NULL;
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserID' => $UserID));
			$UserObj->where[] = array('=',array('Active' => "1"));
			$UserObj->tableUpdate($DataArray);
			echo "1";exit;
			
	}
	
	public function UpdatePasswordAction()
	{
		if(count($_POST)>0){
		
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:0;
			
			if(empty($_POST['Password']))
				$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
			
			if(strlen($_POST['Password']) < 8 || !preg_match("#[0-9]+#",$_POST['Password']) || !preg_match("#[A-Z]+#",$_POST['Password']) || !preg_match("#[a-z]+#",$_POST['Password'])) 
					$this->getSession()->setArrVar("alert",array("danger","Password must be at least 8 characters in length and must contain at least one number, one upper case letter, one lower case letter."));
			
			if($_POST['Password'] != $_POST['RPassword'])
				$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
			

			
		
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				$DataArray = array();
				$DataArray['Password'] = $_POST['Password'];
				$PassSalt = md5(uniqid(rand(),true));
				$DataArray['Password'] = NeoCryptedPassword($DataArray['Password'],$PassSalt).":".$PassSalt;
	
				$UserObj = new DataTable(TABLE_USERS);
				$UserObj->where[] = array('=',array('UserID' => $UserID));
				$UserObj->where[] = array('=',array('Active' => "1"));
				$UserObj->tableUpdate($DataArray);
			
				$this->getSession()->setArrVar("alert",array("success","You have successfully changed the password."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=password");
				exit;
			}
				
			
		}
	}
	
	public function AddClientInvoiceAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		if(count($_POST) > 0){
			
			$ClientInvoiceObj = new DataTable(TABLE_CLIENT_INVOICES);
			$DataArray = array();
			$DataArray['InvoiceName'] = isset($_POST['InvoiceName'])?$_POST['InvoiceName']:"";
			$DataArray['InvoiceNo'] = "CL".date('ymd').(10000 + $ClientInvoiceObj->getMax("InvoiceID") + 1);
			$DataArray['FirstName'] = isset($_POST['FirstName'])?$_POST['FirstName']:"";
			$DataArray['LastName'] = isset($_POST['LastName'])?$_POST['LastName']:"";
			$DataArray['FromDate'] = isset($_POST['StartDate'])?$_POST['StartDate']:date("Y-m-d");
			$DataArray['ToDate'] = isset($_POST['EndDate'])?$_POST['EndDate']:date("Y-m-d");
			$DataArray['UserID'] = $UserID;
			$DataArray['SalePrice'] = isset($_POST['SalePrice'])?$_POST['SalePrice']:"";
			$DataArray['InvoiceCommission'] = isset($_POST['InvoiceCommission'])?$_POST['InvoiceCommission']:"";
			$DataArray['InvoiceAmount'] = isset($_POST['InvoiceAmount'])?$_POST['InvoiceAmount']:"";
			$DataArray['InvoiceStatus'] = isset($_POST['InvoiceStatus'])?$_POST['InvoiceStatus']:"";
			$DataArray['Display'] = isset($_POST['Display'])?$_POST['Display']:"0";
			$DataArray['CreatedDate']= date('Y-m-d H:i:s');
			
			$ClientInvoiceObj = new DataTable(TABLE_CLIENT_INVOICES);
			$InvoiceID = $ClientInvoiceObj->tableInsert($DataArray);

			$DumpPostArray = (isset($_POST['DumpPostData']) && $_POST['DumpPostData'] != "")?unserialize(base64_decode($_POST['DumpPostData'])):"";
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				if(isset($DumpPostArray[$i]['OrderID']) && $DumpPostArray[$i]['OrderID'] != "")
				{
					$DataPrdArray = array();
					$DataPrdArray['InvoiceID'] = $InvoiceID;	
					$DataPrdArray['OrderID'] = isset($DumpPostArray[$i]['OrderID'])?$DumpPostArray[$i]['OrderID']:"";	
					$DataPrdArray['ReferenceID'] = isset($DumpPostArray[$i]['ReferenceID'])?$DumpPostArray[$i]['ReferenceID']:"";	
					$DataPrdArray['ReferenceType'] = isset($DumpPostArray[$i]['ReferenceType'])?$DumpPostArray[$i]['ReferenceType']:"";	
					$DataPrdArray['OrderDetailID'] = isset($DumpPostArray[$i]['OrderDetailID'])?$DumpPostArray[$i]['OrderDetailID']:"";	
					$DataPrdArray['ItemName'] = isset($DumpPostArray[$i]['ItemName'])?$DumpPostArray[$i]['ItemName']:"";	
					$DataPrdArray['ItemPriceInclVat'] = isset($DumpPostArray[$i]['ItemPriceInclVat'])?$DumpPostArray[$i]['ItemPriceInclVat']:"";	
					$DataPrdArray['ItemPriceExclVat'] = isset($DumpPostArray[$i]['ItemPriceExclVat'])?$DumpPostArray[$i]['ItemPriceExclVat']:"";	
					$DataPrdArray['ItemPrice'] = isset($DumpPostArray[$i]['ItemPrice'])?$DumpPostArray[$i]['ItemPrice']:"";
					$DataPrdArray['CommissionPrice'] = isset($DumpPostArray[$i]['CommissionPrice'])?$DumpPostArray[$i]['CommissionPrice']:"";
					$ClientInvoiceProductObj = new DataTable(TABLE_CLIENT_INVOICES_PRODUCT);
					$ClientInvoiceProductObj->tableInsert($DataPrdArray);	
				}
				
				
			}
			
			$this->getSession()->setArrVar("alert",array("success","Invoice added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clinvoices");
			exit;
		}
		
	}
	
	public function DeleteClientInvoiceAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$InvoiceID = isset($_GET['InvoiceID'])?$_GET['InvoiceID']:"";
		
		$CurrentInvoice = $this->getClass('Sale\Order\Common')->getClientInvoiceDetailByInvoiceID($InvoiceID);
		$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($CurrentInvoice->UserID);
			
		if(isset($CurrentInvoice->InvoiceID) && $CurrentInvoice->InvoiceID != ""){	
			
			$ClientInvoiceObj = new DataTable(TABLE_CLIENT_INVOICES);
			$ClientInvoiceObj->where[] = array('=',array('UserID' => $UserID));
			$ClientInvoiceObj->where[] = array('=',array('InvoiceID' => $InvoiceID));
			$ClientInvoiceObj->tableDelete();
			
		}
			$this->getSession()->setArrVar("alert",array("success","Invoice deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clinvoices");
			exit;		
		exit;
	}
	
	public function UpdateInvoiceAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		if(count($_POST) > 0){
			
			for ($i=1;$i <$_POST['Count'];$i++){
				$InvoiceID = isset($_POST['InvoiceID_'.$i])?$_POST['InvoiceID_'.$i]:"";	
			
				$Obj = new DataTable(TABLE_CLIENT_INVOICES);
				$Obj->where[] = array('=',array('UserID' => $UserID));
				$Obj->where[] = array('=',array('InvoiceID' => $InvoiceID));
				$DataArray = array();
				$DataArray['Display'] = isset($_POST['Display_'.$i])?$_POST['Display_'.$i]:0;						
				$DataArray['InvoiceStatus'] = isset($_POST['InvoiceStatus_'.$i])?$_POST['InvoiceStatus_'.$i]:"";						
				$Obj->tableUpdate($DataArray);	
			
			}
			$this->getSession()->setArrVar("alert",array("success","Invoices updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clinvoices");
			exit;
		}
		
	}
	public function ClientInvoiceSendAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$InvoiceID = isset($_GET['InvoiceID'])?$_GET['InvoiceID']:"";
		
		$CurrentInvoice = $this->getClass('Sale\Order\Common')->getClientInvoiceDetailByInvoiceID($InvoiceID);
		$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($CurrentInvoice->UserID);
			
		if(isset($CurrentInvoice->InvoiceID) && $CurrentInvoice->InvoiceID != ""){	
			$MessageBody = $this->getClass('Sale\Order\Common')->getClientInvoice($InvoiceID);
			
			$Mail_Subject = "Your Invoice Details at ".d('SITE_NAME')." Invoice No. ".$CurrentInvoice->InvoiceNo;
			$Mail_ToEmail = $CurrentUser->Email;
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody,d('BCC_EMAIL'));
			
			
		}
			$this->getSession()->setArrVar("alert",array("success","Email has been sent successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clinvoices");
			exit;		
		exit;
	}
	public function ClientInvoiceDisplayAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$InvoiceID = isset($_GET['InvoiceID'])?$_GET['InvoiceID']:"";
		$MessageBody = $this->getClass('Sale\Order\Common')->getClientInvoice($InvoiceID);
		echo $MessageBody;
		exit;
	}
	public function AddProductClientAction()
	{
		if(count($_POST)>0)
		{
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		
			$productRelatedArray = $_POST["RelatedID"];
			if (count($productRelatedArray) >0)
			{
				foreach ($productRelatedArray as $value) {
					if(trim($value) != "")
					{
						$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
						$DataArray = array();
						$DataArray['ProductID'] = $value;
						$DataArray['RelationID'] = $UserID;
						$DataArray['RelationType'] = "product_client";
						$DataArray['SortOrder'] = $this->getClass("Catalog\Product\Common")->SKMaxGetRelatedSortOrder($UserID,"product_client") + 1;
						$ProductRelatedObj->tableInsert($DataArray);
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Client product(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clproducts");
			exit;
		}
	}
	
	public function DeleteProductClientAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$RelationID = isset($_GET['DeleteRelated'])?$_GET['DeleteRelated']:0;
		if($RelationID > 0)
		{
			$ProductRelateObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelateObj->where[] = array('=',array('RelationID' => $UserID));
			$ProductRelateObj->where[] = array('=',array('ProductID' => $RelationID));
			$ProductRelateObj->where[] = array('=',array('RelationType' => 'product_client'));
			$ProductRelateObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Record deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=clproducts");
			exit;
		}
	}
	
	
	public function AddUserPointAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		if(count($_POST) > 0){
				$UserPointObj = new DataTable(TABLE_USERS_POINT);
				$DataArray = array();
				$DataArray['UserID'] =$UserID;
				$DataArray['OrderID'] =0;
				$DataArray['Points'] =(isset($_POST['Points']) && $_POST['Points'] > 0)?$_POST['Points']:"0";
				$DataArray['OrderStatus'] ='Paid';
				$DataArray['PointStatus'] =$_POST['PointStatus'];
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$UserPointObj->tableInsert($DataArray);
				$this->getSession()->setArrVar("alert",array("success","You have successfully updated the user points."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditUser&UserID=$UserID&tab=points");
				exit;
		}
	}
	
	public function getGiftVouchersListByUserID($UserID)
	{
		if($UserID != ""){
			$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"gt.CreatedDate DESC";
			$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
			$KeywordArr =  explode(" ",$Keyword);
			
			
			$CouponObj = new DataTable(array('c'=>TABLE_COUPONS));
			$CouponObj->joinExpression = true;
			$CouponObj->joinArray[] = array('name'=>array('gt'=>TABLE_GV_TRACK),
										  'on'=>"(gt.CouponID = c.CouponID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );
			$where = new Where();
			$where->equalTo('c.GvEnabled','1');
			$where->equalTo('gt.UserID',$UserID);
			if(count($KeywordArr) > 0 && $Keyword != "")
			{
				foreach ($KeywordArr as $Key=>$Value)
				{
					if($Value != "")
					{
						$where->NEST//start braket
								->like('c.CouponCode','%'.$Value.'%')->OR
								->like('c.PurchasedOrderID','%'.$Value.'%')->OR
								->like('c.OrderID','%'.$Value.'%')->OR
								->UNNEST;
					}
				}
				
			}
			
			$CouponObj->where = $where;
			
			$CouponObj->orderExpression = true;
			//$CouponObj->AllowPaging =true;
			//$CouponObj->PageSize=50;
			//$CouponObj->PageTotalDisplay = 15; 
			//$CouponObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
			//$CouponObj->displayQuery = true;
			//$this->paging = $CouponObj;
			return $CouponObj->tableSelectAll(array("*"),"gt.CreatedDate DESC");
		}
	
	}
	
	public function getPointDataByUserID($UserID)
	{
		if($UserID != ""){
			$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
			$Obj = new DataTable(TABLE_USERS_POINT);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			$Obj->where[] = array('=',array('OrderStatus' => 'Paid'));
			return $Obj->tableSelectAll(array("*"),array($OrderBy));		
		}
	}
	public function getAllOrderByUserID($UserID)
	{
		if($UserID != ""){
			$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
			$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
			$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
			$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
			$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
			$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
			$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"50";
			$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
			
			$KeywordArr =  explode(" ",$Keyword);
			
			$where = new Where();
			$OrderObj = new DataTable(TABLE_ORDERS);
			$where->equalTo('UserID',$UserID);
			
			if($PaymentStatus !="")
				$where->equalTo('PaymentStatus',$PaymentStatus);
			if($OrderStatus !="")
				$where->equalTo('OrderStatus',$OrderStatus);
			if($PaymentMethod !="")
				$where->equalTo('PaymentMethod',$PaymentMethod);
			if($CreatedBy !="")
				$where->equalTo('CreatedBy',$CreatedBy);
			if($Download =="1")
				$where->notEqualTo('DownloadID','');
			
			if(count($KeywordArr) > 0 && $Keyword != "")
			{
				foreach ($KeywordArr as $Key=>$Value)
				{
					if($Value != "")
					{
						$where->NEST//start braket
								->like('OrderNo','%'.$Value.'%')->OR
								->like('BillingFirstName','%'.$Value.'%')->OR
								->like('BillingLastName','%'.$Value.'%')->OR
								->like('BillingAddress1','%'.$Value.'%')->OR
								->like('BillingAddress2','%'.$Value.'%')->OR
								->like('BillingCity','%'.$Value.'%')->OR
								->like('BillingState','%'.$Value.'%')->OR
								->like('BillingCountry','%'.$Value.'%')->OR
								->like('BillingZipCode','%'.$Value.'%')->OR
								->like('BillingPhone','%'.$Value.'%')->OR
								->like('BillingFax','%'.$Value.'%')->OR
								->like('ShippingFirstName','%'.$Value.'%')->OR
								->like('ShippingLastName','%'.$Value.'%')->OR
								->like('ShippingAddress1','%'.$Value.'%')->OR
								->like('ShippingAddress2','%'.$Value.'%')->OR
								->like('ShippingCity','%'.$Value.'%')->OR
								->like('ShippingState','%'.$Value.'%')->OR
								->like('ShippingCountry','%'.$Value.'%')->OR
								->like('ShippingZipCode','%'.$Value.'%')->OR
								->like('ShippingPhone','%'.$Value.'%')->OR
								->like('ShippingFax','%'.$Value.'%')->OR
								->like('Email','%'.$Value.'%')->OR
								->like('ShippingText','%'.$Value.'%')->OR
								->like('ShippingCode','%'.$Value.'%')->OR
								->like('VoucherText','%'.$Value.'%')->OR
								->like('VoucherCode','%'.$Value.'%')->OR
								->like('TransactionID','%'.$Value.'%')->OR
								->like('TrackingCode','%'.$Value.'%')->OR
								->UNNEST;
					}
				}
				
			}
			$OrderObj->where = $where;
			
			//$OrderObj->displayQuery = true;
			$OrderObj->AllowPaging =true;
			$OrderObj->PageSize=$PageSize;
			$OrderObj->PageTotalDisplay = 15; 
			$OrderObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
			$this->paging = $OrderObj;
			//$OrderObj->columnExpression=true;
			return $OrderObj->tableSelectAll(array("*"),array($OrderBy));
		}
	
	}
	
	public function getClientInvoicesByUserID($UserID)
	{
		if($UserID != "")
		{
			$Obj = new DataTable(TABLE_CLIENT_INVOICES);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			return $Obj->tableSelectAll(array("*"),array("InvoiceID DESC"));									
			
		}
		return ;
	}
	
	public function getClientProductByUserID($UserID)
	{
		if($UserID != "")
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='product_client')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.RelationID' => $UserID));
			
			return $Obj->tableSelectAll(array("ProductName","ProductID"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	
	public function getClientProductBySpecificTime($UserID,$StartDate,$EndDate)
	{
		if($UserID != "")
		{
			$Obj = new DataTable(array('o'=>TABLE_ORDERS));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(od.OrderID=o.OrderID)",
										  'columns'=>array("OrderDetailID","ReferenceID","ItemType","ItemName","Qty","ItemTotal"=>"Total","ItemVoucherAmount"=>"VoucherAmount","ItemTaxPrice"=>"TaxPrice","ItemTaxPercent"=>"TaxPercent"),
										  'type'=>''
										  );
										  
            $Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.ProductID=od.ReferenceID and ptc.RelationType='product_client')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );										  
			
			$where = new Where();
			$where->equalTo('o.PaymentStatus','Paid');
			$where->notEqualTo('o.OrderStatus','Cancelled');
			$where->greaterThan('o.CreatedDate',$StartDate);
			$where->lessThan('o.CreatedDate',$EndDate);
			
			$where->equalTo('od.ItemType','Product');
			$where->equalTo('ptc.RelationID',$UserID);
			
			$Obj->where = $where;
			//$Obj->displayQuery = true;
			$Obj->groupBy = array("od.OrderDetailID");
			return $Obj->tableSelectAll(array("OrderID","OrderNo","PaymentStatus","SubTotal","TaxAmount","ShippingAmount","OrderTotal"=>"Total","VoucherAmount","GrandTotal","PointAmount","CreatedDate"),array("o.CreatedDate ASC"));									
			
		}
		return;
	}
	
	public function RemoveDiscountByClientPrice($Price,$Obj)
	{
		$Discount = 0;
		$Total = isset($Obj->GrandTotal)?$Obj->GrandTotal:"0";
		if(isset($Obj->VoucherAmount) && $Obj->VoucherAmount > 0)
			$Discount = $Discount + $Obj->VoucherAmount;
		
		if(isset($Obj->PointAmount) && $Obj->PointAmount > 0)
			$Discount = $Discount + $Obj->PointAmount;
		if($Discount > 0 && $Total > 0){
				
				$DiscountPercent = ($Discount*100/$Total);
				$DiscountPrice = ($Price*($DiscountPercent/100));
				if($Price > $DiscountPrice)
					return $DiscountPrice;
		}			
		return 0;
	}
	
	/* Client Creator function from old DB start*/

function  FromOldDbSkCalExcVatItemPrice($ItemPrice,$SubTotal,$TaxAmount)
{
	if($ItemPrice > 0 && $SubTotal > 0)
		return ($ItemPrice - (($ItemPrice * $TaxAmount)/$SubTotal));
	else 
		return 0;
}

function  FromOldDbSkCalDisItemPrice($ItemPrice,$SubTotal,$TaxAmount,$PointAmount,$VoucherAmount)
{
	$Discount = $PointAmount + $VoucherAmount;
	if($Discount > 0 && $ItemPrice > 0 && $SubTotal > 0)
	{
		return (($ItemPrice * $Discount)/$SubTotal);
	}
	else 
	{
		return 0;
	}
}
/* Client Creator function from old DB end*/

	
	public function getDetail($UserID)
	{
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		
		$UserObj->joinExpression = true;
		$UserObj->joinArray[] = array('name'=>array('r'=>TABLE_USER_TYPE_RELATION),
									  'on'=>"(r.UserID=u.UserID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$UserObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
									  'on'=>"(ut.UserTypeID=r.UserTypeID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$UserObj->where[] = array('=',array('u.UserID' => $UserID));
		//$UserObj->where[] = array('=',array('u.Active' => "1"));
		//$UserObj->displayQuery = true;
		$obj =  (object)$UserObj->tableSelectOne(array("*"),array("ut.SortOrder DESC"));
		return $obj;
		return false;
	}
	public function getAllList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"CreatedDate DESC";
		$psz = (isset($_REQUEST['psz'])&& $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"50";
		$AT = isset($_REQUEST['AT'])?$_REQUEST['AT']:"";
		$WS = isset($_REQUEST['WS'])?$_REQUEST['WS']:"";
		$VS = isset($_REQUEST['VS'])?$_REQUEST['VS']:"";
		$CL = isset($_REQUEST['CL'])?$_REQUEST['CL']:"";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$where->notEqualTo('u.UserName','');
		
		if($AT=="1")
			$where->equalTo('u.Active','1');
		
		if($WS=="1")
			$where->equalTo('u.WholeSaler','1');
		
		if($VS=="1")
			$where->equalTo('u.VIPStatus','1');
		
		if($CL=="1")
			$where->equalTo('u.ClientStatus','1');
		
			
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$UserObj->where = $where;
		
		//$UserObj->displayQuery = true;
		$UserObj->AllowPaging =true;
		$UserObj->PageSize=$psz;
		$UserObj->PageTotalDisplay = 15; 
		$UserObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $UserObj;
		$UserObj->columnExpression=true;
		return $UserObj->tableSelectAll(array("*,DATE_FORMAT(LastLogin,'%b %d, %Y') as MyLastLogin"),array($orderBy));
	
	}
	
	public function getWholeSalerList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"CreatedDate DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$where->notEqualTo('u.UserName','');
		$where->equalTo('WholeSaler','1');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$UserObj->where = $where;
		
		//$UserObj->displayQuery = true;
		$UserObj->AllowPaging =true;
		$UserObj->PageSize=25;
		$UserObj->PageTotalDisplay = 15; 
		$UserObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $UserObj;
		$UserObj->columnExpression=true;
		return $UserObj->tableSelectAll(array("*,DATE_FORMAT(LastLogin,'%b %d, %Y') as MyLastLogin"),array($orderBy));
	
	}
	
	public function getVIPCustomersList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"CreatedDate DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$where->notEqualTo('u.UserName','');
		$where->equalTo('VIPStatus','1');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$UserObj->where = $where;
		
		//$UserObj->displayQuery = true;
		$UserObj->AllowPaging =true;
		$UserObj->PageSize=25;
		$UserObj->PageTotalDisplay = 15; 
		$UserObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $UserObj;
		$UserObj->columnExpression=true;
		return $UserObj->tableSelectAll(array("*,DATE_FORMAT(LastLogin,'%b %d, %Y') as MyLastLogin"),array($orderBy));
	
	}
	
	public function getAllClientList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"CreatedDate DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$where->notEqualTo('u.UserName','');
		$where->equalTo('ClientStatus','1');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Address1','%'.$Value.'%')->OR
							->like('Address2','%'.$Value.'%')->OR
							->like('City','%'.$Value.'%')->OR
							->like('State','%'.$Value.'%')->OR
							->like('Country','%'.$Value.'%')->OR
							->like('ZipCode','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$UserObj->where = $where;
		
		//$UserObj->displayQuery = true;
		$UserObj->AllowPaging =true;
		$UserObj->PageSize=25;
		$UserObj->PageTotalDisplay = 15; 
		$UserObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $UserObj;
		$UserObj->columnExpression=true;
		return $UserObj->tableSelectAll(array("*,DATE_FORMAT(LastLogin,'%b %d, %Y') as MyLastLogin"),array($orderBy));
	
	}
	
	public function pageTitle()
	{
		return "Customers";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditUser">Add Customer</a>
					</div>
              </div>		
			   ';
	}
	
	
}	