<?php $obj = $this->getCurrentObj();?>
<section id="CMSDetail" class="pb-xl-5 pb-4 mt-3" >
	<div class="container">
		<h1 class="text-start mb-4"><?php echo MyStripSlashes($obj->LeftTitle1)??""?></h1>
		<?php echo isset($obj->LeftDescription1)?MyStripSlashes($obj->LeftDescription1):""?>
		<div class="row Login">
			<div class="col-md-6">
				<div class="block-info block-account mr-1 h-100">
					<h4 class="p-2">New User</h4>
					<div class="info p-2">
						<p class="">By creating an account with <?php echo d("SITE_NAME")?>  you will be able to shop faster, be up to date on an order's status, change your login password and keep track of the orders you have previously made.</p>
						<div class="block-info-bottom p-3 text-end">
							<a href="<?php echo SKSEOURL('customer','Register')?>" class="btn btn-dark">Register Now</a>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="block-info block-login ml-1 h-100">
					<h4 class="p-2">Existing User</h4>
					<div class="info p-2">
						<form role="form" action="<?php echo SKSEOURL('customer','Login','','action=Login')?>" method="POST" id="LoginForm" name="LoginForm" class="my-5">
							<div class="form-group">
								<label for="Login" class="sr-only">Login</label>
								<input type="text" class="form-control"  name="UserName" id="UserName_R" value="<?php echo  $this->getSession()->getVar("UserName")?>"  placeholder="e.g. username or user@domain.com" title="Invalid email ! Please try user@domain.com" required/>
							</div>
							<div class="form-group">
								<label for="exampleInputEmail1" class="sr-only">Password</label>
								<input type="password" class="form-control" name="Password" id="Password_R" title="<?php echo d("BLANK_PASSWORD_MSG")?>" placeholder="Enter password" required/>
							</div>
							<div>
								<?php echo $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationDisplay(d("GOOGLE_CAPTCHA_VERFICATION_KEY"),array("field"=>"g-recaptcha-response","button"=>"frmLoginSubmit"));?>
							</div>
							<div>
							Forgotten your password? <a href="<?php echo SKSEOURL('customer','ForgetPassword')?>" class="sk_modal" data-type="ajax" data-title="">Click Here</a>
							</div>
							<div class="block-info-bottom p-3 text-end">
								<button type="submit" id="frmLoginSubmit" class="btn btn-dark">Submit</button>
							</div>	
						</form>
					</div>
				</div>
			</div>
		</div>
		 <?php if(d("SOCIAL_LOGIN_STATUS")=="1"):?>
		 <div class="mt-5">
			<div class="block-info block-social-login h-100">
				<div class="info p-2">
					<a href="<?php echo SKSEOURL('customer','Login','','action=SocialLogin&Provider=Facebook')?>" class="btn btn-dark d-block">Login with Facebook</a>
					<hr>
					<a href="<?php echo SKSEOURL('customer','Login','','action=SocialLogin&Provider=Google')?>" class="btn btn-dark d-block">Login with Google</a>
				</div>
			</div>
		</div>	
		 <?php endif;?> 
		 <?php if(d("CHECKOUT_WITHOUT_LOGIN")=="1" && $this->getSession()->getVar("redirect_url")==SKSEOURL('checkout','Checkout')):?>
		 <div class="mt-5">
			<div class="block-info block-checkout h-100">
				<h4 class="p-2">Skip Login and Checkout as Guest</h4>
				<div class="info p-2">
					<p>Would you like to checkout without creating a customer account? Please note that all of our services will not be available to customers that do not wish to create an account. Also, you cannot view the order status of your order, and each time you have to shop with us you will have to re-enter all of your data.<br /><br />Creating an account is free. If you still wish to continue to checkout without creating an account, please click the button to your right.</p><br /><br />
					 <?php /*?><a href="<?php echo SKSEOURL('catalog_product','LastChance')?>" data-type="ajax" data-title="" class="sk_modal btn btn-default d-block float-none float-md-right">Skip Login and Checkout</a><?php */?>
					 <div class="block-info-bottom p-3 text-end">
						<a href="<?php echo SKSEOURL('checkout','Checkout')?>" class="btn btn-dark">Skip Login and Checkout</a>
					</div>
				</div>
			</div>	
		</div>
		 <?php endif;?>
	</div>
</section>