<?php 
namespace Customer\Login\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Customer\Login\Common as LoginCommon;
use Plugin\ConstantContact\ConstantContact as ConstantContact;

use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	function __construct()
	{
		
		if(isset($_GET['backto']) && $_GET['backto'] != ""){
			$this->getSession()->setVar("redirect_url",$_GET['backto']);
		}
	}
	
	public function getLoginCommon()
	{
		$obj = new LoginCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$obj = $this->getClass('Cms\Pages\Common')->getPageByPageID($arr['ID']);
			if(isset($obj->PageID))
			{
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
		}
		
		
		if(isset($arr['MView']) && in_array(strtolower($arr['MView']),array("thankyou","wishlist"))==false)
		{
			$this->getLoginCommon()->RedirectIfLogin(false);
		}
		if(isset($arr['MView']) && strtolower($arr['MView']) == "thankyou"){
			if(isset($_GET['PaymentEnd']) && $_GET['PaymentEnd'] == "1"){
				$this->getClass("Sale\Checkout\Common")->clearCart();
				if(isset($_GET['OrderID']) && $_GET['OrderID'] != ""){
					$LastOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($_GET['OrderID']);
					if(isset($LastOrder->UserID) && $LastOrder->UserID != ""){
						$this->getLoginCommon()->DirectLoginByUserID($LastOrder->UserID);						
					}
				}
			}
		}		
	}
	
	public function SocialLoginAction()
	{
		$Provider = isset($_GET['Provider'])?$_GET['Provider']:"";
		if($Provider != ""){
			$this->getClass('Plugin\SocialLogin\Common')->Init($Provider);
		}
		
	}
	public function SocialLoginRedirectAction()
	{
		$Provider = isset($_GET['Provider'])?$_GET['Provider']:"";
		if($Provider != ""){
			$this->getClass('Plugin\SocialLogin\Common')->AfterLogin($Provider);
		}
		
	}
	
	public function LoginAction()
	{
		if(count($_POST)>0){
			if(isset($_POST['UserName']) and $_POST['UserName']!='')
			{
				
				$this->getSession()->setVar("UserName",$_POST['UserName']);
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true){
					$this->getLoginCommon()->AuthenticateUser($_POST['UserName'],$_POST['Password']);
					$this->getSession()->setArrVar("alert",array("danger",d("USER_LOGIN_INVALID_MSG")));
					MyRedirect(SKSEOURL('customer','Login'));
					exit;
				}
				else{
				  $this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				  MyRedirect(SKSEOURL('customer','Login'));
				  exit;
				}
			}
		}
	}
	public function ResetPasswordAction()
	{
		if(count($_POST)>0){
			$code = isset($_GET['code'])?$_GET['code']:"";
			$CurrentUserObj = $this->getLoginCommon()->getResetPasswordUser($code);
			if(isset($CurrentUserObj->UserName) && $CurrentUserObj->UserName !="" && $code !=""){
				
				if(empty($_POST['Password']))
				$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
			
				if(strlen($_POST['Password']) < 8 || !preg_match("#[0-9]+#",$_POST['Password']) || !preg_match("#[A-Z]+#",$_POST['Password']) || !preg_match("#[a-z]+#",$_POST['Password'])) 
					$this->getSession()->setArrVar("alert",array("danger","Password must be at least 8 characters in length and must contain at least one number, one upper case letter, one lower case letter."));
			
				if($_POST['Password'] != $_POST['RPassword'])
					$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
			
			
				$arr = $this->getSession()->getVar("alert");
				if($arr==NULL || count($arr)==0){
					
					$DataArray = array();
					$DataArray['ForgetCode'] 	= md5(uniqid(rand(),true));	
					$DataArray['Password'] = $_POST['Password'];
					$PassSalt = md5(uniqid(rand(),true));
					$DataArray['Password'] = NeoCryptedPassword($DataArray['Password'],$PassSalt).":".$PassSalt;
					
					$UserObj = new DataTable(TABLE_USERS);
					$UserObj->where[] = array('=',array('UserName' => $CurrentUserObj->UserName));
					$UserObj->where[] = array('=',array('Active' => "1"));
					$UserObj->tableUpdate($DataArray);
				
					$this->getSession()->setArrVar("alert",array("success","You have successfully changed your password."));
					MyRedirect(SKSEOURL('customer','Login'));
					exit;
				}
			}
				
		}
	}
	public function SentPasswordAction()
	{
		if(count($_POST)>0){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			if($Email != ""){
				$UserObj = new DataTable(TABLE_USERS);
				$UserObj->where[] = array('=',array('Email' => $Email));
				$UserObj->where[] = array('=',array('Active' => "1"));
				$UserObj->columnExpression=true;
				$CurrentUserObj = (object)$UserObj->tableSelectOne(array("UserID","Email","UserName","Password","FirstName","LastName"));
				if($UserObj->getNumRows() == 1)
				{
					$DataArray = array();
					$DataArray['ForgetCode'] 	= md5(uniqid(rand(),true));	
					$UserObj->tableUpdate($DataArray);
					
					$DataArray['FirstName'] = $CurrentUserObj->FirstName;
					$DataArray['LastName'] = $CurrentUserObj->LastName;
					$DataArray['Email']    = $CurrentUserObj->Email;
					$DataArray['UserName'] = $CurrentUserObj->UserName;
					
					$DataArray['Mail_Subject'] =d('EMAIL_SUBJECT_USER_FORGET_PASSWORD');
					$DataArray['Mail_ToEmail'] = $Email;
					$this->getClass('Cms\Pages\Common')->SendMailByUsingTemplate("forgot_password.php",$DataArray);
					
					$this->getSession()->setArrVar("alert",array("success","We have sent your login details in your email address."));
					MyRedirect(SKSEOURL('customer','Login'));
					exit;
				}
				else 
				{
					$this->getSession()->setArrVar("alert",array("danger",d("USERNAME_NOT_FOUND_MSG")));
					MyRedirect(SKSEOURL('customer','Login'));
					exit;
					
				}
				
		
			}
		
		}
	}
	public function SignUpAction()
	{
		if(count($_POST)>0)
		{
			$DataArray = array();
			$DataArray['UserName']	= isset($_POST['UserName'])?$_POST['UserName']:"";
			$DataArray['Email']		= isset($_POST['Email'])?$_POST['Email']:$DataArray['UserName'];
			$DataArray['Password']	= isset($_POST['Password'])?$_POST['Password']:"";
			$DataArray['FirstName']	= isset($_POST['FirstName'])?$_POST['FirstName']:"";
			$DataArray['LastName'] 	= isset($_POST['LastName'])?$_POST['LastName']:"";
			$DataArray['Gender'] 	= isset($_POST['Gender'])?$_POST['Gender']:"";
			$DataArray['Goal'] 	= isset($_POST['Goal'])?$_POST['Goal']:"";
			$DataArray['Address1']	= isset($_POST['Address1'])?$_POST['Address1']:"";
			$DataArray['Address2']	= isset($_POST['Address2'])?$_POST['Address2']:"";
			$DataArray['City']		= isset($_POST['City'])?$_POST['City']:"";
			$DataArray['State']		= isset($_POST['State'])?$_POST['State']:"";
			$DataArray['Area']	= isset($_POST['Area'])?$_POST['Area']:"";
			$DataArray['Country']	= isset($_POST['Country'])?$_POST['Country']:"";
			$DataArray['ZipCode']		= isset($_POST['ZipCode'])?$_POST['ZipCode']:"";
			$DataArray['Phone'] 	= isset($_POST['Phone'])?$_POST['Phone']:"";
			$DataArray['VATNumber'] 	= isset($_POST['VATNumber'])?$_POST['VATNumber']:"";
			$DataArray['IPAddress'] 	= isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
			
			$NewsLetter 	= isset($_POST['NewsLetter'])?$_POST['NewsLetter']:"";
			
			$DataArray['AccountCode'] 	= $this->getLoginCommon()->SkGetUniqueUserNo();
			$PassSalt = md5(uniqid(rand(),true));
			$DataArray['Password'] = NeoCryptedPassword($DataArray['Password'],$PassSalt).":".$PassSalt;
			$DataArray['ActivationCode'] 	= md5(uniqid(rand(),true));
			$DataArray['LastLogin'] 	= date("YmdHis");
			$DataArray['PrevLastLogin'] 	= date("YmdHis");
			$DataArray['CreatedDate'] 	= date("YmdHis");
			if(d("ACTIVATE_BY_EMAIL")=="1")
			{
				$DataArray['Active'] =0;
			}
			else 
			{
				$DataArray['Active'] =1;
				$DataArray['ActiveOnce'] ="1";
			}	

			if(empty($DataArray['UserName']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter username"));
		
		
			if(empty($DataArray['Password']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter password"));
			
			//$specialChars = preg_match('#[^\w]#', $password);
			if(strlen($_POST['Password']) < 8 || !preg_match("#[0-9]+#",$_POST['Password']) || !preg_match("#[A-Z]+#",$_POST['Password']) || !preg_match("#[a-z]+#",$_POST['Password'])) 
					$this->getSession()->setArrVar("alert",array("danger","Password must be at least 8 characters in length and must contain at least one number, one upper case letter, one lower case letter."));
			
			if(@$_POST['Password'] != @$_POST['CPassword'])
				$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
			
			if(!$this->getLoginCommon()->ValidateEmail($DataArray['Email']))
				$this->getSession()->setArrVar("alert",array("danger","Invalid Email Address ! Please try user@domain.com"));
			
			if(empty($DataArray['FirstName']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter first name"));
			
			//if(empty($DataArray['LastName']))
				//$this->getSession()->setArrVar("alert",array("danger","Please enter last name"));
			
			if(empty($DataArray['Address1']))
				$this->getSession()->setArrVar("alert",array("danger","Please select Address1"));
			if(empty($DataArray['City']))
				$this->getSession()->setArrVar("alert",array("danger","Please select City"));
			if(empty($DataArray['State']))
				$this->getSession()->setArrVar("alert",array("danger","Please select State"));
			if(empty($DataArray['ZipCode']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Post Code/Zip Code"));
		
			
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserName' => $DataArray['UserName']));
			$UserObj->columnExpression=true;
			$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger",d("USERNAME_ALREADY_EXIST_MSG")));
			
			/* Check email address too start */
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('Email' => $DataArray['UserName']));
			$UserObj->columnExpression=true;
			$Obj = $UserObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger",d("USERNAME_ALREADY_EXIST_MSG")));
			
			/* Check email address too end */	
		
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					/* add here  and redirect here*/
					
					$DataArray['UserID']  = SKRemoveSpecialChars(substr($DataArray['UserName'],0,5))."_".md5(uniqid(rand(), true));
					$UserObj->tableInsert($DataArray);

					/* News letter addition start */
					if($NewsLetter=="1")
					{
						$DataSubArray = array();
						$DataSubArray['UserID'] = $DataArray['UserID'];
						$DataSubArray['DisplayName'] = $DataArray['FirstName']." ".$DataArray['LastName'];
						$DataSubArray['Email'] = $DataArray['Email'];
						$DataSubArray['CreatedDate'] = $DataArray['CreatedDate'];
						
						$NewsletterUserObj = new DataTable(TABLE_USERS_NEWSLETTER);
						$NewsletterUserObj->where[] = array('=',array('Email' => $DataSubArray['Email']));
						$CurrentNewsLetterObj = (object)$NewsletterUserObj->tableSelectOne();
						if(isset($CurrentNewsLetterObj->Email) && $CurrentNewsLetterObj->Email !="")
							$NewsletterUserObj->tableUpdate($DataSubArray);
						else 
							$NewsletterUserObj->tableInsert($DataSubArray);
						
						
					
					}
					/* News letter addition end */
					
					/* UserTypeRelObj addition start */
					$DataSubArray = array();
					$DataSubArray['UserID'] = $DataArray['UserID'];
					$DataSubArray['UserTypeID'] = (int)(isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1");
					$DataSubArray['Discount'] = "0";
					$DataSubArray['CreatedDate'] = $DataArray['CreatedDate'];
					
					$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
					$UserTypeRelObj->tableInsert($DataSubArray);
					/* UserTypeRelObj addition end */
					
					/* Email sent start*/
					
					if($DataArray['Active'] =="0")
					{
						
						$DataArray['Mail_Subject'] =d('EMAIL_SUBJECT_USER_SIGNUP');
						$DataArray['Mail_ToEmail'] =$DataArray['Email'];
						$this->getClass('Cms\Pages\Common')->SendMailByUsingTemplate("activate_user.php",$DataArray);
						MyRedirect(SKSEOURL('customer','Thankyou','','Status=Activate'));						
						exit;
					}
					
					$DataArray['Mail_Subject'] =d('EMAIL_SUBJECT_USER_SIGNUP');
					$DataArray['Mail_ToEmail'] =$DataArray['Email'];
					$DataArray['Password']	= isset($_POST['Password'])?$_POST['Password']:"";
					$this->getClass('Cms\Pages\Common')->SendMailByUsingTemplate("sign_up.php",$DataArray);
					$this->getSession()->setVar("UserID",$DataArray['UserID']);
					
					$UserData = md5($DataArray['UserID'].$DataArray['UserName'].$DataArray['Password'].$DataArray['IPAddress']);
					$this->getSession()->setVar("UserKey",$UserData);
					
					/* Email sent end*/
				
					if($this->getSession()->getVar("redirect_url") != "")
					{
						$redirect_url = $this->getSession()->getVar("redirect_url");
						$this->getSession()->deleteVar("redirect_url");
						MyRedirect($redirect_url);
						exit;
					}
					MyRedirect(SKSEOURL('customer','Thankyou','','Status=Registered'));
					exit;
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"";
	}
	
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
}	