<?php 
namespace Customer\Login\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Customer\Login\Common as LoginCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class DownloadController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	function __construct()
	{
		
	}
	
	public function getLoginCommon()
	{
		$obj = new LoginCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$obj = $this->getClass('Cms\Pages\Common')->getPageByPageID($arr['ID']);
			if(isset($obj->PageID))
			{
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
		}
		$DownloadID = isset($_GET['DownloadID'])?$_GET['DownloadID']:"";
		if($DownloadID != ""){
			
			$return = $this->getClass("Customer\Login\Common")->getDownoadlistByDownloadID($DownloadID);
			if($return===false){
				$this->getSession()->setArrVar("alert",array("danger","Invalid Download ID or your Download Id has been expired."));
			}
		}
		
		
	}
	
	public function MMDownloadAction()
	{
		$DownloadID = isset($_GET['DownloadID'])?$_GET['DownloadID']:"";
		if($DownloadID != ""){
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$Part = isset($_GET['Part'])?$_GET['Part']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$DownloadID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($Part != "" && $EKEY != "" && $Key==$EKEY){
				$DownloadStatus = false;
				
				$ReturnArray = $this->getClass("Customer\Login\Common")->getDownoadlistByDownloadID($DownloadID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
					
				if($DownloadStatus===true)
				{
					$CurrentProduct = $ReturnArray['products'][$PID];
					$params = array();
					$params["DownloadID"] = isset($CurrentProduct->FeedID)?$CurrentProduct->FeedID:"";
					$params["ProductID"] = isset($CurrentProduct->FeedID)?$CurrentProduct->FeedID:"";
					if(isset($_GET['LecID']) && $_GET['LecID'] != "")
						$params["ProductID"] = $_GET['LecID'];
	
					$params["email"] = isset($CurrentProduct->CustomerData->Email)?$CurrentProduct->CustomerData->Email:"";
					$params["Part"] = $Part;
					$FileObj =  $this->getClass('Plugin\MurphysMagic\MurphysMagic')->FetchMurphyRecord("GetDownloadLink",http_build_query($params));
					if(isset($FileObj['Status']) && $FileObj['Status']=="ready"){
						MyRedirect($FileObj['DownloadLink']);
						exit;
					}
					else if(isset($FileObj['Status']) && $FileObj['Status'] != "ready"){
						echo "<h3>Your request for download has been received and has been queued. <br>This shall be available for download after 1-2 hours (approximately) from now. Please try then.</h3>";
						exit;
		
					}
					else{
						
						if(isset($CurrentProduct->OrderID) && $CurrentProduct->OrderID != ""){
							$this->getClass('Plugin\MurphysMagic\MurphysMagic')->processPayment($OrderID);
							echo "<h1>Please try again.</h1>";		
							exit;	
						}
					}
					
				}
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v,'','DownloadID='.$DownloadID));
			exit;
			
		}
			
	}
	
	public function LDownloadAction()
	{
			$DownloadID = isset($_GET['DownloadID'])?$_GET['DownloadID']:"";
			if($DownloadID != ""){
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$DID = isset($_GET['DID'])?$_GET['DID']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$DownloadID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($DID != "" && $EKEY != "" && $Key==$EKEY){
				
				$DownloadStatus = false;
				
				$ReturnArray = $this->getClass("Customer\Login\Common")->getDownoadlistByDownloadID($DownloadID);
					if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
						$DownloadStatus = true;	
				
				if($DownloadStatus===true){
					$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
					$where = new Where();
					$where->equalTo('DownloadID',$DID);
					$Obj->where = $where;
					$CurrentDownload = (object)$Obj->tableSelectOne(array("*"),array("DownloadID ASC"));
					if(file_exists(DIR_FS_SITE_SECURE_DOWNLOAD.$CurrentDownload->DownloadFile) && $CurrentDownload->DownloadFile != ""){
						FileHandle::DownloadFile(DIR_FS_SITE_SECURE_DOWNLOAD.$CurrentDownload->DownloadFile);
					}
					
				}
				
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v,'','DownloadID='.$DownloadID));
			exit;
			
		}
			
	}
	
	public function VDownloadAction()
	{
			$DownloadID = isset($_GET['DownloadID'])?$_GET['DownloadID']:"";
			if($DownloadID != ""){
			$SessionID = $this->getSession()->getCurrentSID();
			$PID = isset($_GET['PID'])?$_GET['PID']:"";
			$VID = isset($_GET['VID'])?$_GET['VID']:"";
			$EKEY = isset($_GET['EKEY'])?$_GET['EKEY']:"";
			$data = $SessionID."&&&".$DownloadID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			if($VID != "" && $EKEY != "" && $Key==$EKEY){
				$DownloadStatus = false;
				
			$ReturnArray = $this->getClass("Customer\Login\Common")->getDownoadlistByDownloadID($DownloadID);
				if(isset($ReturnArray['products'][$PID]) && $ReturnArray['products'][$PID] != "")
					$DownloadStatus = true;	
					
				if($DownloadStatus===true){
					$this->getClass('Plugin\Vimeo\VimeoVideo')->DownloadFile($VID,@$_GET['Dindex']);
				}
			}
			$this->getSession()->setArrVar("alert",array("danger","Invalid Request Please try again."));
			MyRedirect(SKSEOURL($this->origin->m,$this->origin->v,'','DownloadID='.$DownloadID));
			exit;
			
		}
			
	}
	
	function SentEmailAction()
	{
		if(count($_POST)>0){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			if($Email != ""){
				
				
				$OrderObj = new DataTable(TABLE_ORDERS);
				$where = new Where();
				$where->equalTo('Email',$Email);
				$where->equalTo('PaymentStatus','Paid');
				$where->notEqualTo('DownloadID','');
				$where->expression('(DATEDIFF(NOW(),CreatedDate) <= ?)','180');
				$OrderObj->where = $where;
				$CurrentOrder = (object)$OrderObj->tableSelectOne(array("OrderID","DownloadID","OrderNo","UserID","Email","BillingFirstName","BillingLastName"),array("CreatedDate DESC"));
				if(isset($CurrentOrder->OrderID)){
					
					$Mail_Subject = "Your Instant Download ID at ".d("SITE_NAME");
					$Mail_ToEmail = isset($CurrentOrder->Email)?$CurrentOrder->Email:"";
					$Mail_FromEmail = d("ADMIN_EMAIL");
					$Mail_FromName = d("SITE_NAME");
					$MessageBody = "Dear ".MyStripSlashes($CurrentOrder->BillingFirstName)." ".MyStripSlashes($CurrentOrder->BillingLastName)."<br><br>";
					
					$MessageBody .="Below are the details of your Instant download order <br>Order Number: ".$CurrentOrder->OrderNo." <br>Download ID : ".$CurrentOrder->DownloadID;								 
					$MessageBody .= "<br><br>Thank you, if you have any queries please contact us at: <a href='".d("SALES_EMAIL")."'>".d("SALES_EMAIL")."</a>.<br><br>".d("SITE_NAME");
					
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					$this->getSession()->setArrVar("alert",array("success","We have successfully sent your Download ID on your email address."));
					MyRedirect(SKSEOURL('customer','DownloadManager'));
					exit;
				}
				else 
				{
					$this->getSession()->setArrVar("alert",array("danger","We are sorry but we did not find any Download ID associated with your email address. For further assistance please contact us."));
					
				}
		
			}
		
		}
	}
	
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"Download Area";
	}
	
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
}	