<?php 
namespace Customer\Login;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function SocialLoginRegister($DataArray,$ExtraParam=array())
	{
		$UserFirstObj = new DataTable(TABLE_USERS);
		$NumRows = 0;
		$UserFirstObj->where[] = array('=',array('UserName' => $DataArray['UserName']));
		$FirstObj = (object)$UserFirstObj->tableSelectOne(array("UserID","UserName","Active"));
		if(isset($FirstObj->UserID) && $FirstObj->UserID != ""){
			
			if($FirstObj->Active=="1"){
				$this->DirectLoginByUserID($FirstObj->UserID);
				if($this->getSession()->getVar("redirect_url") != ""){
					$redirect_url = $this->getSession()->getVar("redirect_url");
					$this->getSession()->deleteVar("redirect_url");
					MyRedirect($redirect_url);
					exit;
				}
				else {
					MyRedirect(SKSEOURL('account','Default'));				
					exit;
				}
			}
			else{
				$this->getSession()->setArrVar("alert",array("danger","Your account is not activated."));
				MyRedirect(SKSEOURL('customer','Login'));
				exit;
				
			}
			
		}
		else{
			
			$UserObj = new DataTable(TABLE_USERS);
			$DataArray['Active'] =1;
			$DataArray['ActiveOnce'] ="1";
			$DataArray['UserID']  = SKRemoveSpecialChars(substr($DataArray['UserName'],0,5))."_".md5(uniqid(rand(), true));
			$UserObj->tableInsert($DataArray);
			
			/* UserTypeRelObj addition start */
			$DataSubArray = array();
			$DataSubArray['UserID'] = $DataArray['UserID'];
			$DataSubArray['UserTypeID'] = "1";
			$DataSubArray['Discount'] = "0";
			$DataSubArray['CreatedDate'] = date("YmdHis");
			
			$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
			$UserTypeRelObj->tableInsert($DataSubArray);
			/* UserTypeRelObj addition end */
			$this->DirectLoginByUserID($DataArray['UserID']);
			if($this->getSession()->getVar("redirect_url") != ""){
				$redirect_url = $this->getSession()->getVar("redirect_url");
				$this->getSession()->deleteVar("redirect_url");
				MyRedirect($redirect_url);
				exit;
			}
			else {
				MyRedirect(SKSEOURL('account','Default'));				
				exit;
			}
			
		}
		
		
	}
	function DirectLoginByUserID($UserID)
	{
		
		$UserObj = new DataTable(TABLE_USERS);
		$UserObj->where = array(array('=',array('UserID' => $UserID)),
									  array('=',array('Active' => "1"))											  
									  );

		$CurrentUserObj = $UserObj->tableSelectOne();
		$NumRows = $UserObj->getNumRows();
		if(isset($NumRows) && $NumRows == 1)
		{
			$UserObj->tableUpdate(   array("LastLogin"=>date("YmdHis"),
										      "IPAddress"=>isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"",
										      "PrevLastLogin"=>((isset($CurrentUserObj['LastLogin']) && $CurrentUserObj['LastLogin'] != "" && $CurrentUserObj['LastLogin'] != "0000-00-00 00:00:00")?$CurrentUserObj['LastLogin']:date("YmdHis"))
										      )
										);
			
			$UserData = md5($CurrentUserObj['UserID'].$CurrentUserObj['UserName'].$CurrentUserObj['Password'].$CurrentUserObj['IPAddress']);
			$this->getSession()->setVar("UserID",$CurrentUserObj['UserID']);
			$this->getSession()->setVar("UserKey",$UserData);
		}
		return false;
	}
	
	function AuthenticateUser($UserName, $Password,$Encrypted=false)
	{
		$UserFirstObj = new DataTable(TABLE_USERS);
		$UserObj = new DataTable(TABLE_USERS);
		$NumRows = 0;
		
		$UserFirstObj->where[] = array('=',array('UserName' => $UserName));
		$UserFirstObj->where[] = array('=',array('Active' => "1"));
		$FirstObj = (object)$UserFirstObj->tableSelectOne(array("Password","FailureNum","FailureDate"));
		
		/* temporary blocked start*/
		if(isset($FirstObj->FailureNum) && $FirstObj->FailureNum > 5){
			$hourdiff = round((strtotime(date("YmdHis")) - strtotime($FirstObj->FailureDate))/3600, 1);
			if($hourdiff > 48){
				$UserFirstObj->tableUpdate(array("FailureDate"=>NULL,
										   "FailureNum"=>0,
										   )
										);
			}
			else{
				$this->getSession()->setArrVar("alert",array("danger","Your account has been temporary blocked, please try after 48 hours."));
				MyRedirect(SKSEOURL('customer','Login'));
				exit;
			}
		}
		/* temporary blocked end*/
		
		/* check for email address too start*/
		if(!isset($FirstObj->Password))
		{
			$UserFirstObj = new DataTable(TABLE_USERS);
			$UserFirstObj->where[] = array('=',array('Email' => $UserName));
			$UserFirstObj->where[] = array('=',array('Active' => "1"));
			$FirstObj = (object)$UserFirstObj->tableSelectOne(array("Password","UserName"));
			
			if(isset($FirstObj->UserName) && $FirstObj->UserName !="")
				$UserName = $FirstObj->UserName;
		}
		/* check for email address too end*/
		
		if(isset($FirstObj->Password) && $FirstObj->Password !="")
		{
			$TmpPwd = explode(":",$FirstObj->Password);
			$EncyptPassword = NeoCryptedPassword($Password,$TmpPwd[1]).":".$TmpPwd[1];
			if($EncyptPassword == $FirstObj->Password)
			{
				$UserObj->where = array(array('=',array('UserName' => $UserName)),
											  array('=',array('Password' => $EncyptPassword)),
											  array('=',array('Active' => "1"))											  
											  );
											  
				$CurrentUserObj = $UserObj->tableSelectOne();
				$NumRows = $UserObj->getNumRows();
			}
			
			/*Check tmporary password start*/
			
			if($NumRows==0 && $Password != ""){
				
				$UserObj->where = array(array('=',array('UserName' => $UserName)),
									  array('=',array('OnePassword' => $Password)),
									  array('=',array('Active' => "1"))											  
									  );

									  
				$CurrentUserObj = $UserObj->tableSelectOne();
				$NumRows = $UserObj->getNumRows();
				if(isset($NumRows) && $NumRows == 1){
					$UserObj->tableUpdate(   array("OnePassword"=>"")
										 );
				}
				
			}
			/*Check tmporary password end*/
			
		}
		if($Encrypted===true)
		{
			$UserObj->where = array(array('=',array('UserName' => $UserName)),
									  array('=',array('Password' => $Password)),
									  array('=',array('Active' => "1"))											  
									  );

									  
			$CurrentUserObj = $UserObj->tableSelectOne();
			$NumRows = $UserObj->getNumRows();
		}
		if(isset($NumRows) && $NumRows == 1)
		{
			$UserObj->tableUpdate(   array("LastLogin"=>date("YmdHis"),
										   "FailureNum"=>"0",
										   "IPAddress"=>isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"",
										   "PrevLastLogin"=>((isset($CurrentUserObj['LastLogin']) && $CurrentUserObj['LastLogin'] != "" && $CurrentUserObj['LastLogin'] != "0000-00-00 00:00:00")?$CurrentUserObj['LastLogin']:date("YmdHis"))
										      )
										);
			
			$UserData = md5($CurrentUserObj['UserID'].$CurrentUserObj['UserName'].$CurrentUserObj['Password'].$CurrentUserObj['IPAddress']);
			
			$this->getSession()->setVar("UserID",$CurrentUserObj['UserID']);
			$this->getSession()->setVar("UserKey",$UserData);
			
			if($CurrentUserObj['Country'] != "")
				$this->getSession()->setVar("TaxCountry",SKGetCountryCodeByCountry($CurrentUserObj['Country'],2));
			
			
			$this->getClass('Sale\Cart\ShoppingCalculation')->ResetCart();
			
			if($this->getSession()->getVar("redirect_url") != "")
			{
				$redirect_url = $this->getSession()->getVar("redirect_url");
				$this->getSession()->deleteVar("redirect_url");
				MyRedirect($redirect_url);
				exit;
			}
			else 
			{
				MyRedirect(SKSEOURL('account','Default'));				
				exit;
			}
		}
		else{
			
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserName' => $UserName));
			$UserObj->where[] = array('=',array('Active' => "1"));
			$FirstObj = (object)$UserFirstObj->tableSelectOne(array("UserName","FailureNum","FailureDate"));
			if(isset($FirstObj->UserName))
			$UserObj->tableUpdate(   array("FailureDate"=>date("YmdHis"),
										   "FailureNum"=>$FirstObj->FailureNum + 1,
										   )
										);
		}
		return false;
	}
	
	function RedirectIfLogin($ReturnURL="")
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$UserObj = new DataTable(TABLE_USERS);
			$UserObj->where[] = array('=',array('UserID' => $UserID));
			$UserObj->where[] = array('=',array('Active' => "1"));
		
			$UserObj->tableSelectOne(array("UserName"));
			if($UserObj->getNumRows() == 1)
			{
				MyRedirect(SKSEOURL('account','Default'));		
				exit;
			}
		}
	}
	
	function IsUserLogin()
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$UserObj = new DataTable(array('u'=>TABLE_USERS));
			
			$UserObj->joinExpression = true;
			$UserObj->joinArray[] = array('name'=>array('r'=>TABLE_USER_TYPE_RELATION),
										  'on'=>"(r.UserID=u.UserID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID=r.UserTypeID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->where[] = array('=',array('u.UserID' => $UserID));
			$UserObj->where[] = array('=',array('u.Active' => "1"));
			$obj =  (object)$UserObj->tableSelectOne(array("*"),array("ut.SortOrder DESC"));
			
			return $obj;
		}
		
		if(isset($GLOBALS['UserIDByAdmin']) && $GLOBALS['UserIDByAdmin'] != ""){
			$UserID = $GLOBALS['UserIDByAdmin'];
			
			$UserObj = new DataTable(array('u'=>TABLE_USERS));
			
			$UserObj->joinExpression = true;
			$UserObj->joinArray[] = array('name'=>array('r'=>TABLE_USER_TYPE_RELATION),
										  'on'=>"(r.UserID=u.UserID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID=r.UserTypeID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->where[] = array('=',array('u.UserID' => $UserID));
			$UserObj->where[] = array('=',array('u.Active' => "1"));
			$obj =  (object)$UserObj->tableSelectOne(array("*"),array("ut.SortOrder DESC"));
			
			return $obj;
			
		}
		
		return false;
	}
	
	function CheckUserLogin($ReturnURL="",$LoginMessage="")
	{
		if($this->getSession()->getVar("UserID") != "" && $this->getSession()->getVar("UserKey") != "")
		{
			$UserID = $this->getSession()->getVar("UserID");
			$UserObj = new DataTable(array('u'=>TABLE_USERS));
			
			$UserObj->joinExpression = true;
			$UserObj->joinArray[] = array('name'=>array('r'=>TABLE_USER_TYPE_RELATION),
										  'on'=>"(r.UserID=u.UserID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID=r.UserTypeID)",
										  'columns'=>array("*"),
										  'type'=>'left'
										  );
			
			$UserObj->where[] = array('=',array('u.UserID' => $UserID));
			$UserObj->where[] = array('=',array('u.Active' => "1"));
			$CurrentUserObj =  (object)$UserObj->tableSelectOne(array("*"),array("ut.SortOrder DESC"));
			
			if($UserObj->getNumRows() == 1)
			{
				$UserObj = new DataTable(TABLE_USERS);
				$UserObj->where[] = array('=',array('UserID' => $UserID));
				$UserObj->where[] = array('=',array('Active' => "1"));
				$UserObj->tableUpdate(   array("LastLogin"=>date("YmdHis"),
												  "IPAddress"=>isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:""
										      )
										);
				return $CurrentUserObj;
			}
			else 
			{
				if(!empty($ReturnURL))
					$this->getSession()->setVar("redirect_url",$ReturnURL);
			
			MyRedirect(SKSEOURL('customer','Login'));
				exit;
			}
		}
		else 
		{
			if(!empty($ReturnURL))
				$this->getSession()->setVar("redirect_url",$ReturnURL);
			
			MyRedirect(SKSEOURL('customer','Login'));
			exit;
		}
	}
	
	function LogoutUser()
	{
		$this->getSession()->deleteVar("UserName");
		$this->getSession()->deleteVar("UserID");
		$this->getSession()->deleteVar("UserKey");
		return true;
	}
	
	function getResetPasswordUser($code)
	{
		$UserObj = new DataTable(TABLE_USERS);
		$UserObj->where[] = array('=',array('ForgetCode' => $code));
		$UserObj->where[] = array('=',array('Active' => "1"));
		$CurrentUserObj = (object)$UserObj->tableSelectOne();
		
		return $CurrentUserObj;
		
	}
	
	function GetLoyalityPoint($UserID)
	{
		$PaymentStatusArray = $this->getClass('Sale\Order\Common')->getPaymentStatuses();
		$PointStatusArray = $this->getClass('Sale\Order\Common')->getPointStatuses();
		
		$UserPointObj = new DataTable(TABLE_USERS_POINT);
		$UserPointObj->where[] = array('=',array('UserID' => $UserID));
		$UserPointObj->where[] = array('=',array('OrderStatus' => $PaymentStatusArray['Paid']));
		$UserPointObj->where[] = array('=',array('PointStatus' => $PointStatusArray['Get']));
		$UserPointObj->columnExpression = true;
		$GetPointObj = (object)$UserPointObj->tableSelectOne(array("SUM(Points) as GetPoint"));
		
		$UserPointObj = new DataTable(TABLE_USERS_POINT);
		$UserPointObj->where[] = array('=',array('UserID' => $UserID));
		$UserPointObj->where[] = array('=',array('OrderStatus' => $PaymentStatusArray['Paid']));
		$UserPointObj->where[] = array('=',array('PointStatus' => $PointStatusArray['Access']));
		$UserPointObj->columnExpression = true;
		$AccessPointObj = (object)$UserPointObj->tableSelectOne(array("SUM(Points) as AccessPoint"));
		
		$Total = (isset($GetPointObj->GetPoint) && $GetPointObj->GetPoint >0)?$GetPointObj->GetPoint:0;
		$AccessPoint = (isset($AccessPointObj->AccessPoint) && $AccessPointObj->AccessPoint >0)?$AccessPointObj->AccessPoint:0;
		
		return array("Total"=>$Total,
						"AccessPoint"=>$AccessPoint,
						"LeftPoint"=>$Total-$AccessPoint,
					   );
			
	}
	
	function GetOrderHistory($UserID)
	{
		if($UserID != ''){
			
			$Obj = new DataTable(array('o'=>TABLE_ORDERS));
			$where = new Where();
			//$where->equalTo('o.PaymentStatus','Paid');
			$where->equalTo('o.UserID',$UserID);
			//$where->expression('(DATEDIFF(NOW(),o.CreatedDate) <= ?)','180');
			$Obj->where = $where;
			//$Obj->displayQuery = true;
			return $Obj->tableSelectAll(array("*"),array("o.CreatedDate DESC"),100);
			
		}
	}
	
	
	function ConvertVouchertoPoint($VCode)
	{
		$CouponObj = new DataTable(array('c'=>TABLE_COUPONS));
		$CouponObj->joinExpression = true;
		$CouponObj->joinArray[] = array('name'=>array('gt'=>TABLE_GV_TRACK),
									  'on'=>"(gt.CouponID = c.CouponID)",
									  'columns'=>array("*"),
									  'type'=>''
									  );
		$where = new Where();
		$where->equalTo('c.Active','1');
		$where->equalTo('c.GvEnabled','1');
		//$where->equalTo('gt.UserID',$UserID);
		$where->equalTo('c.CouponCode',$VCode);
		$where->NEST//start braket
				->expression('(? BETWEEN StartDate AND EndDate)',date('Y-m-d'))
				//->OR
				//->expression("(StartDate =? OR EndDate =?)",array('0000-00-00','0000-00-00'))
				->OR
					->NEST//start braket
					->ISNULL('StartDate')
					->AND
					->ISNULL('EndDate')
					->UNNEST
			  ->UNNEST;
		$CouponObj->where = $where;
		$CurrentVoucher = (object)$CouponObj->tableSelectOne();
		if(isset($CurrentVoucher->CouponCode) && $CurrentVoucher->CouponCode != "" && $CurrentVoucher->CouponCode == $VCode){
				$VoucherPoints = $CurrentVoucher->CouponValue*d("PRODUCT_POINT_INCURRENCY");
				$CouponObj = new DataTable(TABLE_COUPONS);
				$DataArray = array();
				$DataArray['Active'] = "0";
				$DataArray['GvRedeem'] = "1";
				$DataArray['RedeemDate'] = date('Y-m-d H:i:s');
				$DataArray['OrderID'] = "0";
				$CouponObj->where[] = array('=',array('CouponID' => $CurrentVoucher->CouponID));
				$CouponObj->tableUpdate($DataArray);
				
				if($VoucherPoints > 0)
				{
					$UserPointObj = new DataTable(TABLE_USERS_POINT);
					$DataArray = array();
					$DataArray['UserID'] =$CurrentVoucher->UserID;
					$DataArray['OrderID'] =0;
					$DataArray['CouponID'] = $CurrentVoucher->CouponID;
					$DataArray['Points'] = $VoucherPoints;
					$DataArray['OrderStatus'] = "Paid";
					$DataArray['PointStatus'] = "Get";
					$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
					$UserPointObj->tableInsert($DataArray);
				}
				
			}
		
	}
	
	
	function GetUserVouchers($UserID)
	{
		if($UserID != ""){
			$CouponObj = new DataTable(array('c'=>TABLE_COUPONS));
			$CouponObj->joinExpression = true;
			$CouponObj->joinArray[] = array('name'=>array('gt'=>TABLE_GV_TRACK),
										  'on'=>"(gt.CouponID = c.CouponID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );
			$where = new Where();
			$where->equalTo('c.Active','1');
			$where->equalTo('c.GvEnabled','1');
			$where->equalTo('gt.UserID',$UserID);
			$where->NEST//start braket
					->expression('(? BETWEEN StartDate AND EndDate)',date('Y-m-d'))
					//->OR
					//->expression("(StartDate =? OR EndDate =?)",array('0000-00-00','0000-00-00'))
					->OR
						->NEST//start braket
						->ISNULL('StartDate')
						->AND
						->ISNULL('EndDate')
						->UNNEST
				  ->UNNEST;
			$CouponObj->where = $where;
			
			$CouponObj->orderExpression = true;
			return $CouponObj->tableSelectAll(array("*"),"gt.CreatedDate DESC");
		}
	}
	function getRegisterProductlistByUserID($UserID)
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('pr.Active',"1");
		$where->equalTo('prc.UserID',$UserID);
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_CODES),
									  'on'=>"(pr.ProductID=p.ProductID AND pr.Active='1')",
									  'columns'=>array("ProductCode"),
									  'type'=>''
									  );
		$ProductObj->joinArray[] = array('name'=>array('prc'=>TABLE_PRODUCT_REG_CODE),
									  'on'=>"(prc.ProductID=p.ProductID)",
									  'columns'=>array("ProductRegID"),
									  'type'=>''
									  );
		//$ProductObj->displayQuery = true;
		$ProductObj->groupBy = array("p.ProductID");
		return $ProductObj->tableSelectAll(array("*"), array("prc.CreatedDate DESC"));
	}
	
	function getRegisterProductIDsByUserID($UserID)
	{
		$CurrentUser = $this->getUserByUserID($UserID);
		$rows = $this->getRegisterProductlistByUserID($UserID);
		if(count($rows) > 0){
			$SessionID = $this->getSession()->getCurrentSID();
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			//$data = MyDecryptData($Key, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			$ReturnArray['key'] = $Key;
			$ReturnArray['count'] = count($rows);
			$ReturnArray['products'] = array();
			foreach($rows as $CurrentProduct){
				if(isset($CurrentUser->UserID))
					$CurrentProduct->CustomerData = $CurrentUser;
				
				$ReturnArray['products'][$CurrentProduct->ProductID] = $CurrentProduct;
			}
			return $ReturnArray;
		}
		return false;
		
	}
	
	function getDownloadlistByUserID($UserID)
	{
		$CurrentUser = $this->getUserByUserID($UserID);
		
		if(isset($CurrentUser->UserID) && $CurrentUser->UserID != ''){
			
			$Obj = new DataTable(array('o'=>TABLE_ORDERS));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(od.OrderID=o.OrderID)",
										  'columns'=>array("OrderDetailID","ReferenceID"),
										  'type'=>''
										  );
			
			$Obj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
										  'on'=>"(p.ProductID=od.ReferenceID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );		
			$where = new Where();
			$where->equalTo('o.PaymentStatus','Paid');
			$where->notEqualTo('o.DownloadID','');
			//$where->notEqualTo('o.OrderStatus','Cancelled');
			
			$where->equalTo('od.ItemType','Product');
			
			$where->notEqualTo('p.ProductType','Child');
			$where->NEST//start braket
					->equalTo('o.UserID',$CurrentUser->UserID)
					->OR
					->equalTo('o.Email',$CurrentUser->Email)
				  ->UNNEST;
			
			$Obj->where = $where;
			//$Obj->displayQuery = true;
			//$Obj->groupBy = array("p.ProductID");
			return $Obj->tableSelectAll(array("OrderID","OrderNo","DownloadID"),array("o.CreatedDate DESC"));
			
		}
	}
	
	function getOnlineAcademylistByUserID($UserID)
	{
		return $this->getDownloadlistByUserID($UserID);
	}
	function getAftershowLivelistByUserID($UserID)
	{
		return $this->getDownloadlistByUserID($UserID);
	}
	function getOnlineAcademyProductByUserID($UserID)
	{
		$CurrentUser = $this->getUserByUserID($UserID);
		$rows = $this->getOnlineAcademylistByUserID($UserID);
		if(count($rows) > 0){
			$SessionID = $this->getSession()->getCurrentSID();
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			$ReturnArray['key'] = $Key;
			$ReturnArray['count'] = count($rows);
			$ReturnArray['products'] = array();
			foreach($rows as $CurrentProduct){
				if(isset($CurrentUser->UserID))
					$CurrentProduct->CustomerData = $CurrentUser;
			
				$ReturnArray['products'][$CurrentProduct->ProductID] = $CurrentProduct;
			}
			return $ReturnArray;
		}
		return false;
		
	}
	function getAftershowLiveProductByUserID($UserID)
	{
		$CurrentUser = $this->getUserByUserID($UserID);
		$rows = $this->getAftershowLivelistByUserID($UserID);
		if(count($rows) > 0){
			$SessionID = $this->getSession()->getCurrentSID();
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			$ReturnArray['key'] = $Key;
			$ReturnArray['count'] = count($rows);
			$ReturnArray['products'] = array();
			foreach($rows as $CurrentProduct){
				if(isset($CurrentUser->UserID))
					$CurrentProduct->CustomerData = $CurrentUser;
			
				$ReturnArray['products'][$CurrentProduct->ProductID] = $CurrentProduct;
			}
			return $ReturnArray;
		}
		return false;
		
	}
	
	function getMyStreamingVideosProductByUserID($UserID)
	{
		$CurrentUser = $this->getUserByUserID($UserID);
		$rows = $this->getDownloadlistByUserID($UserID);
		if(count($rows) > 0){
			$SessionID = $this->getSession()->getCurrentSID();
			$data = $SessionID."&&&".$UserID;
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			$ReturnArray['key'] = $Key;
			$ReturnArray['count'] = count($rows);
			$ReturnArray['products'] = array();
			foreach($rows as $CurrentProduct){
				if(isset($CurrentUser->UserID))
					$CurrentProduct->CustomerData = $CurrentUser;
				
				$ReturnArray['products'][$CurrentProduct->ProductID] = $CurrentProduct;
			}
			return $ReturnArray;
		}
		return false;
		
	}
	
	function getDownoadlistByDownloadID($DownloadID)
	{
		if($DownloadID != ""){
			$Obj = new DataTable(array('o'=>TABLE_ORDERS));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(od.OrderID=o.OrderID)",
										  'columns'=>array("OrderDetailID","ReferenceID"),
										  'type'=>''
										  );
			
			$Obj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
										  'on'=>"(p.ProductID=od.ReferenceID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );		
			$where = new Where();
			$where->equalTo('o.PaymentStatus','Paid');
			$where->equalTo('o.DownloadID',$DownloadID);
			//$where->notEqualTo('o.DownloadID','');
			$where->expression('(DATEDIFF(NOW(),o.CreatedDate) <= ?)','180');
			$where->notEqualTo('o.OrderStatus','Cancelled');
			
			$where->equalTo('od.ItemType','Product');
			
			$where->notEqualTo('p.ProductType','Child');
			$Obj->where = $where;
			//$Obj->displayQuery = true;
			$Obj->groupBy = array("p.ProductID");
			$rows = $Obj->tableSelectAll(array("OrderID","OrderNo","DownloadID","Email"),array("o.CreatedDate DESC"));
			if(count($rows) > 0){
				$SessionID = $this->getSession()->getCurrentSID();
				$data = $SessionID."&&&".$DownloadID;
				$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
				$ReturnArray['key'] = $Key;
				$ReturnArray['count'] = count($rows);
				$ReturnArray['products'] = array();
				foreach($rows as $CurrentProduct){
					
					if(isset($CurrentProduct->Email))
						$CurrentProduct->CustomerData = $CurrentProduct;
					
					$ReturnArray['products'][$CurrentProduct->ProductID] = $CurrentProduct;
				}
				return $ReturnArray;
			}
		}
		return false;
		
	}
	
	function GetUserAddresses($UserID)
	{
		$UserAddressObj = new DataTable(TABLE_USERS_ADDRESS);
		$UserAddressObj->where[] = array('=',array('UserID' => $UserID));
		//$UserAddressObj->displayQuery = true;
		return $UserAddressObj->tableSelectAll("",array("CreatedDate DESC"));
	}
	
	function GetWishListProduct($UserID,$WCategoryID)
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('uw.WCategoryID',$WCategoryID);
		$where->equalTo('uw.UserID',$UserID);
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('uw'=>TABLE_USERS_WISHLIST),
									  'on'=>"(uw.ProductID=p.ProductID)",
									  'columns'=>array("WishListID"),
									  'type'=>''
									  );
		//$ProductObj->displayQuery = true;
		//$ProductObj->groupBy = array("p.ProductID");
		return $ProductObj->tableSelectAll(array("*"), array("uw.CreatedDate DESC"));
	}
	function GetPublicWishListByEmail($Email)
	{
		$UserObj = new DataTable(TABLE_USERS);
		$where = new Where();
		$where->NEST//start braket
				->equalTo('UserName',$Email)
				->OR
				->equalTo('Email',$Email)
			  ->UNNEST;			
			$UserObj->where = $where;
		$Obj =  (object)$UserObj->tableSelectOne(array("UserID"));
		if(isset($Obj->UserID))
			return $this->GetWishListCategory($Obj->UserID,"Public");
		
		return false;
	}
	
	function GetPublicWishListCategory($WCategoryID)
	{
		$Obj = new DataTable(TABLE_USERS_WCATEGORY);
		$Obj->where[] = array('=',array('WCategoryID' => $WCategoryID));
		$Obj->where[] = array('=',array('ListType' => "Public"));
		return $Obj->tableSelectAll("",array("CreatedDate ASC"));
	}
	function GetWishListCategory($UserID,$ListType="Public")
	{
		$Obj = new DataTable(TABLE_USERS_WCATEGORY);
		$Obj->where[] = array('=',array('UserID' => $UserID));
		If($ListType != "All")
			$Obj->where[] = array('=',array('ListType' => $ListType));
			
		return $Obj->tableSelectAll("",array("CreatedDate ASC"));
	}
	
	function GetUnReadMessage($UserID,$Count=true)
	{
		 $Obj = new DataTable(array('mt'=>TABLE_MESSAGES_TO));
	
		$where = new Where();
		$where->equalTo('mt.UserID',$UserID);
		$where->equalTo('mt.DefaultFolder','inbox');
		$where->notEqualTo('mt.MessageRead','1');
		
		$where->NEST//start braket
				->equalTo('mt.MessageDelete','')
				->OR
				->equalTo('mt.MessageDelete','0')
				->OR
				->isNull('mt.MessageDelete')
			  ->UNNEST;		
		
		$Obj->where = $where;
		//$Obj->displayQuery = true;
		if($Count===true){
			$Obj->columnExpression = true;
			$TObj = (object)$Obj->tableSelectOne(array("COUNT(*) as Total"));
			return isset($TObj->Total)?$TObj->Total:"0";
			
		}
		else{
			
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('m'=>TABLE_MESSAGES),
										  'on'=>"(m.MessageID=mt.MessageID)",
										  'columns'=>array("*"),
										  'type'=>''
										  );
										  
			$Obj->groupBy = array("m.MessageID");
			return $Obj->tableSelectAll(array("*"),array("m.CreatedDate DESC"));
		}
		 
	}
	
	function GetMessageByMID($UserID,$MID,$Read=true)
	{
			$Obj = new DataTable(TABLE_MESSAGES_TO);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			$Obj->where[] = array('=',array('MessageID' => $MID));
			$CurrentObj = (object)$Obj->tableSelectOne("");
			if(isset($CurrentObj->MessageID) && $CurrentObj->MessageID > 0){
				
				if($Read==true){
					
					$ObjR = new DataTable(TABLE_MESSAGES_TO);
					$ObjR->where[] = array('=',array('UserID' => $UserID));
					$ObjR->where[] = array('=',array('MessageID' => $MID));
					$DataArray = array();
					$DataArray['MessageRead'] = "1";
					$DataArray['ReadDate'] = date('Y-m-d H:i:s');
					$ObjR->tableUpdate($DataArray);
					
				}
				
				$Obj2 = new DataTable(TABLE_MESSAGES);
				$Obj2->where[] = array('=',array('MessageID' => $CurrentObj->MessageID));
				return (object)$Obj2->tableSelectOne("");
				
				
					
			}
			return;
			
	}

	function GetMessageFolders($UserID)
	{
		$Obj = new DataTable(TABLE_MESSAGES_FOLDERS);
		$Obj->where[] = array('=',array('UserID' => $UserID));
		return $Obj->tableSelectAll("",array("CreatedDate ASC"));
	}
	
	
	function SkGetUniqueUserNo()
	{

		$UserObj = new DataTable(TABLE_USERS);
		/*
		$UserObj->Where ="1";
		$UserNo = $UserObj->getMax("AccountCode")+1;

		if($UserNo <10000)
			$UserNo = 10001;
		*/
		while (1)
		{

			$UserNo= chr(rand(65,76)).chr(rand(65,76)).chr(rand(65,76)).rand(1111111,9999999);
			$UserObj->where = "AccountCode = '".$UserNo."'";
			$CurrentUserObj = (object)$UserObj->tableSelectOne(array("AccountCode"));
			if(isset($UserObj->AccountCode) && $UserObj->AccountCode !="")
				continue;
			else 
				break;
		}		
		return $UserNo;

	}
	
	function UserTypeSync($UserID)
	{
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		$UserObj->where[] = array('=',array('u.UserID' => $UserID));
		$obj =  (object)$UserObj->tableSelectOne(array("*"));
		if(isset($obj->UserID) && $obj->UserID != "")
		{
			/* check default UserTypeID=1 in TABLE_USER_TYPE_RELATION START*/
			$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
			$UserTypeRelObj->where[] = array('=',array('UserID' => $UserID));
			$UserTypeRelObj->where[] = array('=',array('UserTypeID' => "1"));
			$TmpObj =  (object)$UserTypeRelObj->tableSelectOne(array("*"));
			if(!isset($TmpObj->UserID))
			{
				$DataSubArray = array();
				$DataSubArray['UserID'] = $UserID;
				$DataSubArray['UserTypeID'] = "1";
				$DataSubArray['Discount'] = "0";
				$DataSubArray['CreatedDate'] = date('Y-m-d H:i:s');
				$UserTypeRelObj->tableInsert($DataSubArray);
			}
			/* check default UserTypeID=1 in TABLE_USER_TYPE_RELATION END*/
			
			/* check WholeSaler UserTypeID=2 in TABLE_USER_TYPE_RELATION START*/
			if(isset($obj->WholeSaler) && $obj->WholeSaler == "1")
			{
				$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
				$UserTypeRelObj->where[] = array('=',array('UserID' => $UserID));
				$UserTypeRelObj->where[] = array('=',array('UserTypeID' => "2"));
				$TmpObj =  (object)$UserTypeRelObj->tableSelectOne(array("*"));
				if(!isset($TmpObj->UserID))
				{
					$DataSubArray = array();
					$DataSubArray['UserID'] = $UserID;
					$DataSubArray['UserTypeID'] = "2";
					$DataSubArray['Discount'] = "0";
					$DataSubArray['CreatedDate'] = date('Y-m-d H:i:s');
					$UserTypeRelObj->tableInsert($DataSubArray);
				}
			}
			else
			{
				$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
				$UserTypeRelObj->where[] = array('=',array('UserID' => $UserID));
				$UserTypeRelObj->where[] = array('=',array('UserTypeID' => "2"));
				$UserTypeRelObj->tableDelete();
			}
			/* check WholeSaler UserTypeID=2 in TABLE_USER_TYPE_RELATION END*/
			
			/* check VIPStatus UserTypeID=3 in TABLE_USER_TYPE_RELATION START*/
			if(isset($obj->VIPStatus) && $obj->VIPStatus == "1")
			{
				$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
				$UserTypeRelObj->where[] = array('=',array('UserID' => $UserID));
				$UserTypeRelObj->where[] = array('=',array('UserTypeID' => "3"));
				$TmpObj =  (object)$UserTypeRelObj->tableSelectOne(array("*"));
				if(!isset($TmpObj->UserID))
				{
					$DataSubArray = array();
					$DataSubArray['UserID'] = $UserID;
					$DataSubArray['UserTypeID'] = "3";
					$DataSubArray['Discount'] = "0";
					$DataSubArray['CreatedDate'] = date('Y-m-d H:i:s');
					$UserTypeRelObj->tableInsert($DataSubArray);
				}
			}
			else
			{
				$UserTypeRelObj = new DataTable(TABLE_USER_TYPE_RELATION);
				$UserTypeRelObj->where[] = array('=',array('UserID' => $UserID));
				$UserTypeRelObj->where[] = array('=',array('UserTypeID' => "3"));
				$UserTypeRelObj->tableDelete();
			}
			/* check VIPStatus UserTypeID=3 in TABLE_USER_TYPE_RELATION END*/
		}
		
		
	}
	
	public function getUserByUserID($UserID)
	{
		$UserObj = new DataTable(array('u'=>TABLE_USERS));
		
		$UserObj->joinExpression = true;
		$UserObj->joinArray[] = array('name'=>array('r'=>TABLE_USER_TYPE_RELATION),
									  'on'=>"(r.UserID=u.UserID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$UserObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
									  'on'=>"(ut.UserTypeID=r.UserTypeID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$UserObj->where[] = array('=',array('u.UserID' => $UserID));
		//$UserObj->where[] = array('=',array('u.Active' => "1"));
		//$UserObj->displayQuery = true;
		$obj =  (object)$UserObj->tableSelectOne(array("*"),array("ut.SortOrder DESC"));
		return $obj;
		return false;
	}
	
	public function getActiveClientInvoices($UserID)
	{
		if($UserID != "")
		{
			$Obj = new DataTable(TABLE_CLIENT_INVOICES);
			$Obj->where[] = array('=',array('UserID' => $UserID));
			$Obj->where[] = array('=',array('Display' => "1"));
			return $Obj->tableSelectAll(array("*"),array("InvoiceID DESC"));									
			
		}
		return ;
	}
	
	function getInvoiceStatuses()
	{
		$rows = array("Pending"=>"Pending",
					  "Paid"=>"Paid",
					  "Cancel"=>"Cancel",
				  );
		
		return $rows;
	}
	
	function getUserByUserIDs($IDs,$Active="1",$AllColumns=false)
	{
		if(isset($IDs) && is_array($IDs) && count($IDs) > 0)
			$IDs = implode(",",$IDs);
		
		if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where = new Where();
			$UObj = new DataTable(array('u'=>TABLE_USERS));
			$where->notEqualTo('u.UserName','');
			if($Active=="1")
				$where->equalTo('u.Active',"1");
			
			$where->in('u.UserID',$IDArray);
			$UObj->where = $where;
			//$UObj->displayQuery = true;
			
			$ColumnArray = array("UserID as id","CONCAT(UserName,' (', Email, ' ', FirstName, ' ',LastName,')') as text");
			if($AllColumns==true)
				$ColumnArray = array("*");
			
			$UObj->columnExpression=true;
			$rows = $UObj->tableSelectAll($ColumnArray,array("CreatedDate DESC"));
			return $rows;
			//return $rows->toArray();
		}
		else{
			return array();
		}
		
	}
	
	function getAttachmentTypesArray()
	{
		$rows = array("JPG","JPEG","PNG","GIF","PDF","DOC","DOCX","PPT","PPTX","ODT","AVI","OGG","M4A","MOV","MP3","MP4","MPG","WAV","WMV");
		return $rows;
	}
	function getBusinessNatures()
	{
		$rows = array();
		$rows["Refrigeration Manufacturing"] ="Refrigeration Manufacturing";
		$rows["Refrigeration Engineer"] ="Refrigeration Engineer";
		$rows["Catering Equipment Suppliers"] ="Catering Equipment Suppliers";
		return $rows;
	}
	
	
	
	function ValidateEmail($email)
	{
	    return filter_var($email, FILTER_VALIDATE_EMAIL);
	}
	
}	