<?php 
namespace Cms\Testimonials;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;


class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	public function getTestimonialDetail($TestimonialID)
	{
		if($TestimonialID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PLUGIN_TESTIMONIALS));
			$Obj->where[] = array('=',array('p.TestimonialID' => $TestimonialID));
				
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.TestimonialID AND s.MCode='testimonial_main')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	public function getTestimonialHomeList($limit=6)
	{
		$OrderBy = "RAND()";
		$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
		$where = new Where();
		$where->equalTo('Active','1');
		$where->equalTo('Homepage','1');
		$Obj->where = $where;	
		$Obj->orderExpression = true;
		return $Obj->tableSelectAll(array("*"),$OrderBy,$limit);
	
	}
	
	function StarRating($r=0)
	{
		if($r > 0)
		{
			$ReturnString ='<div class="star-rating">';
			for ($i=1;$i<=5;$i++)
			{
				if($r >=$i)
					$ReturnString .='<span class="fa fa-star"></span>';
				else 
					$ReturnString .='<span class="far fa-star"></span>';
			}
			$ReturnString .=' '.$r.' stars</div>';
			
			return $ReturnString;
		}
		return '<div class="no-rating"></div>';
	}
	
	
	public function getBranchTestimonialMenu($BranchID,$limit=12)
	{
		$OrderBy = "RAND()";
		$where = new Where();
		$Obj = new DataTable(array('m'=>TABLE_PLUGIN_TESTIMONIALS));
		$where->equalTo('mtb.BranchID',$BranchID);
		$where->equalTo('m.Active',"1");
		
		$Obj->joinExpression = true;
		$Obj->joinArray[] = array('name'=>array('mtb'=>TABLE_BRANCH_RELATION),
									  'on'=>"(mtb.RelationID=m.TestimonialID and mtb.RelationType='branch_testimonial')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		
		$Obj->where = $where;	
		$Obj->AllowPaging =true;
		$Obj->PageSize=$limit;
		$Obj->PageTotalDisplay = 12; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		//$Obj->displayQuery =true;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","TestimonialID ASC"));
	
	}
	
	public function getTestimonialList($limit=12)
	{
		$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
		$where = new Where();
		$where->equalTo('Active','1');
		$Obj->where = $where;	
		$Obj->AllowPaging =true;
		$Obj->PageSize=$limit;
		$Obj->PageTotalDisplay = 12; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","TestimonialID ASC"));
	
	}
	
}	