<?php 
namespace Cms\Pages;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

#[AllowDynamicProperties]
class Image extends AbstractModule 
{
	function __construct()
	{
		
	}
	public function GetImage($Img,$Parms="")
	{
		$ImArr = explode("_",pathinfo($Img, PATHINFO_FILENAME));
		$ext = pathinfo($Img, PATHINFO_EXTENSION);
		if(strtolower($ext) == "webp")
			$Parms['Format'] = "webp";
		if(isset($ImArr[1]) && $ImArr[1] != ""){
			$SizeArr = explode("x",$ImArr[1]);
			if(isset($SizeArr[0]) && $SizeArr[0] > 0)
				$Parms['w'] = $SizeArr[0];
			if(isset($SizeArr[1]) && $SizeArr[1] > 0)
				$Parms['h'] = $SizeArr[1];
		}
		if(isset($ImArr[2]) && $ImArr[2] != ""){
			$Parms['ThumbnailMode'] = $ImArr[2];
		}
		
		if(d("CACHE_IMPLEMENT")=="1")
		{
			$CacheKey = $Img.serialize($Parms);
			$SeourlDir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache_seoimage");
			$filename=$SeourlDir .md5($CacheKey).".txt";
		}
		if(isset($filename) && file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$Path = file_get_contents($filename);
		}
		else{
			
			$Path = DIR_FS_SITE_UPLOADS."no-image.jpg";
			if(isset($ImArr[0]) && $ImArr[0] != ""){
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where[] = array('=',array('URLName' => $ImArr[0]));
				$CurrentImage = (object)$SeoObj->tableSelectOne(array("ImageID","DirPath"));
				if(isset($CurrentImage->ImageID) && $CurrentImage->ImageID !="" && file_exists(DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID))
					$Path = DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID;
				else if(file_exists(DIR_FS_SITE_UPLOADS.$ImArr[0].".jpg"))
					$Path = DIR_FS_SITE_UPLOADS.$ImArr[0].".jpg";
			}
			if(isset($filename) && $filename != "" && d("CACHE_IMPLEMENT")=="1"){
				$fp2 = fopen($filename, "w");
				fputs($fp2,$Path);	
				fclose($fp2);
			}		
		}
		
		if(isset($Parms['w']) && $Parms['w'] > 0){
			
			require_once(DIR_FS_SITE."includes/classes/class.thumbnail.php");
			$ThumbnailObj = new \Thumbnail();
			$ThumbnailObj->OriginalFileName = $Path;	
			$ThumbnailObj->ThumbnailWidth = $Parms['w'];
			$ThumbnailObj->DirectSavePath = DIR_FS_SITE."img";
			$ThumbnailObj->DirectSaveFile = $Img;
			
			if(isset($Parms['h']) && $Parms['h'] > 0)
				$ThumbnailObj->ThumbnailHeight = $Parms['h'];
		
			foreach($Parms as $k=>$v)
				$ThumbnailObj->{$k} = $Parms[$k];
		
			$ThumbnailObj->Display =true;				
			
			if(DIR_FS_SITE_UPLOADS."no-image.jpg"==$Path){
				header("HTTP/1.1 404 Not Found");
				header("Status: 404 Not Found");
			}
			$ThumbnailObj->CreateThumbnail();
		
		}
		else{
			if(DIR_FS_SITE_UPLOADS."no-image.jpg"==$Path){
				header("HTTP/1.1 404 Not Found");
				header("Status: 404 Not Found");
			}
			$this->ReadFile($Path);
		}
		
			 
	}
	
	public function GetImage_old_5july2022($Img,$Parms="")
	{
		$ImArr = explode("_",pathinfo($Img, PATHINFO_FILENAME));
		if(isset($ImArr[1]) && $ImArr[1] != ""){
			$SizeArr = explode("x",$ImArr[1]);
			if(isset($SizeArr[0]) && $SizeArr[0] > 0)
				$Parms['w'] = $SizeArr[0];
			if(isset($SizeArr[1]) && $SizeArr[1] > 0)
				$Parms['h'] = $SizeArr[1];
		}
		if(isset($ImArr[2]) && $ImArr[2] != ""){
			$Parms['ThumbnailMode'] = $ImArr[2];
		}
		
		if(d("CACHE_IMPLEMENT")=="1")
		{
			$CacheKey = $Img.serialize($Parms);
			$SeourlDir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache_seoimage");
			$filename=$SeourlDir .md5($CacheKey).".txt";
		}
		if(isset($filename) && file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$Path = file_get_contents($filename);
		}
		else{
			
			$Path = DIR_FS_SITE_UPLOADS."no-image.jpg";
			if(isset($ImArr[0]) && $ImArr[0] != ""){
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where[] = array('=',array('URLName' => $ImArr[0]));
				$CurrentImage = (object)$SeoObj->tableSelectOne(array("ImageID","DirPath"));
				if(isset($CurrentImage->ImageID) && $CurrentImage->ImageID !="" && file_exists(DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID))
					$Path = DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID;
			}
			if(isset($filename) && $filename != "" && d("CACHE_IMPLEMENT")=="1"){
				$fp2 = fopen($filename, "w");
				fputs($fp2,$Path);	
				fclose($fp2);
			}
			
			
		
		}
		//var_dump($Path);
		//var_dump($Parms);
		//var_dump($ImArr);
		//exit;
		
		if(isset($Parms['w']) && $Parms['w'] > 0){
			
			require_once(DIR_FS_SITE."includes/classes/class.thumbnail.php");
			$ThumbnailObj = new \Thumbnail();
			$ThumbnailObj->OriginalFileName = $Path;	
			$ThumbnailObj->ThumbnailWidth = $Parms['w'];
			
			if(isset($Parms['h']) && $Parms['h'] > 0)
				$ThumbnailObj->ThumbnailHeight = $Parms['h'];
		
			foreach($Parms as $k=>$v)
				$ThumbnailObj->{$k} = $Parms[$k];
		
			$ThumbnailObj->Display =true;				
			
			if(DIR_FS_SITE_UPLOADS."no-image.jpg"==$Path){
				header("HTTP/1.1 404 Not Found");
				header("Status: 404 Not Found");
			}
			$ThumbnailObj->CreateThumbnail();
		
		}
		else{
			if(DIR_FS_SITE_UPLOADS."no-image.jpg"==$Path){
				header("HTTP/1.1 404 Not Found");
				header("Status: 404 Not Found");
			}
			$this->ReadFile($Path);
		}
		
			 
	}
	
	function ReadFile($file)
	{
		$len = filesize($file);
		$filename = basename($file);
		$file_extension = strtolower(substr(strrchr($filename,"."),1));
		switch( $file_extension )
		{
			case "gif": $ctype="image/gif"; break;
			case "png": $ctype="image/png"; break;
			case "webp": $ctype="image/webp"; break;
			case "jpeg":
			case "jpg": $ctype="image/jpg"; break;
			default: $ctype="application/force-download";
		}
		//ob_clean();
		header("Content-Type: $ctype");
		header("Pragma: public");
		header("Expires: 0");
		readfile($file);
		exit;
	}
	

	function InputFile($FileName,$ImageID="")
	{
		$Return = '';
		if($ImageID != ""){
			$Return .= '<table>';
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where[] = array('=',array('ImageID' => $ImageID));
			$CurrentImage = (object)$SeoObj->tableSelectOne(array("*"));
			if(isset($CurrentImage->ImageID) && $CurrentImage->ImageID !="" && file_exists(DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID)){
				$Path = DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID;
				$Return .= '</tr>
						<td>
							'.SKSeoImage($CurrentImage->ImageID,"200",array("class"=>"img-responsive")).'
						<br>
						<a href="'.DIR_WS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID.'" target="_blank">[view]</a>
						</td>
						<td>
							 <input type="hidden" name="ImageID_'.$FileName.'" value="'.$ImageID.'">
							 <label>
								<input type="checkbox" class="ChkDeleteImage" name="ChkImage_'.$FileName.'" value="'.$ImageID.'" onclick=""> Delete Image
								<input type="hidden" class="InpDeleteImage" name="DeleteImage_'.$FileName.'" value="" >
							 </label>
						</td><tr>
				   ';
			}
			$Return .= '</tr>
							<td><input type="file" name="'.$FileName.'"></td>
							<td> Alt Text: <input type="text" name="AltText_'.$FileName.'" value="'.$CurrentImage->AltText.'"></td>
						<tr>
				   ';
		    $Return .= '</table>';
		}
		else{
		$Return = '<table>
						</tr>
						<td><input type="file" name="'.$FileName.'"></td>
						<td> Alt Text: <input type="text" name="AltText_'.$FileName.'"></td><tr>
				   </table>';
		}
		
		return $Return;
	}
	
	function AddEditFile($FileName,$SourcePath,$DirPath,$Name = "")
	{
		$AltText = isset($_POST['AltText_'.$FileName])?$_POST['AltText_'.$FileName]:$Name;
		$ImageID = isset($_POST['ImageID_'.$FileName])?$_POST['ImageID_'.$FileName]:"";
		$DeleteImage = isset($_POST['DeleteImage_'.$FileName])?$_POST['DeleteImage_'.$FileName]:"";
		
		$URL = 	SkURLCreate(str_replace(array("_"),array("-"),$AltText));
		if($URL=="")
			$URL = uniqid();
		
		$URLName = $this->GetUniqueImage($URL,$SourcePath,$DirPath,$ImageID);
		
		
		if($ImageID != ""){
		
			$DataArray = array();
			$DataArray['URLName'] = $URLName;
			$DataArray['AltText'] = $AltText;
			$DataArray['SourcePath'] = $SourcePath;
			$DataArray['DirPath'] = $DirPath;
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where = "ImageID = '".$ImageID."'";
			$SeoObj->tableUpdate($DataArray);
		}
		if(strpos($FileName, "[") >0){
			
			
			$Var = substr($FileName,0,strpos($FileName, "["));
			$index = str_replace(array("[","]"),array("",""),substr($FileName,strpos($FileName, "[")));
			
			$AltText = isset($_POST['AltText_'.$Var][$index])?$_POST['AltText_'.$Var][$index]:$Name;
			$ImageID = isset($_POST['ImageID_'.$Var][$index])?$_POST['ImageID_'.$Var][$index]:"";
			$DeleteImage = isset($_POST['DeleteImage_'.$Var][$index])?$_POST['DeleteImage_'.$Var][$index]:"";
			
			$URL = 	SkURLCreate(str_replace(array("_"),array("-"),$AltText));
			if($URL=="")
				$URL = uniqid();
			
			$URLName = $this->GetUniqueImage($URL,$SourcePath,$DirPath,$ImageID);
			
			//var_dump($ImageID,$AltText,$_POST['ImageUpload'][$index]);exit;
			if($ImageID != ""){
			
				$DataArray = array();
				$DataArray['URLName'] = $URLName;
				$DataArray['AltText'] = $AltText;
				$DataArray['SourcePath'] = $SourcePath;
				$DataArray['DirPath'] = $DirPath;
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where = "ImageID = '".$ImageID."'";
				$SeoObj->tableUpdate($DataArray);
			}
			
		
			
			if(isset($_FILES[$Var]['name'][$index]) && $_FILES[$Var]['name'][$index] !=""){
				if($ImageID != ""){
					$this->DeleteImage($ImageID);
				}
				$ArrayType = explode(".",$_FILES[$Var]['name'][$index]);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageID = uniqid().".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS.$DirPath."/".$ImageID;
				copy($_FILES[$Var]['tmp_name'][$index],$OriginalImage);
				$DataArray = array();
				$DataArray['ImageID'] = $ImageID;
				$DataArray['URLName'] = $URLName;
				$DataArray['AltText'] = $AltText;
				$DataArray['SourcePath'] = $SourcePath;
				$DataArray['DirPath'] = $DirPath;
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->tableInsert($DataArray);
				return $ImageID;
				
			}
			elseif($ImageID != "" && $DeleteImage != "" && $DeleteImage==$ImageID){
				$this->DeleteImage($ImageID);
				return "";
			}
			else{
				if($ImageID != "")
					return $ImageID;
			}
			
		}
		elseif(isset($_FILES[$FileName]) && $_FILES[$FileName]['name'] !="")
		{
			if($ImageID != ""){
				$this->DeleteImage($ImageID);
			}
			$ArrayType = explode(".",$_FILES[$FileName]['name']);
			$Type=$ArrayType[count($ArrayType)-1];
			
			$ImageID = uniqid().".".$Type;				
			$OriginalImage =DIR_FS_SITE_UPLOADS.$DirPath."/".$ImageID;
			copy($_FILES[$FileName]['tmp_name'],$OriginalImage);
			$DataArray = array();
			$DataArray['ImageID'] = $ImageID;
			$DataArray['URLName'] = $URLName;
			$DataArray['AltText'] = $AltText;
			$DataArray['SourcePath'] = $SourcePath;
			$DataArray['DirPath'] = $DirPath;
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->tableInsert($DataArray);
			return $ImageID;
		}
		elseif($ImageID != "" && $DeleteImage != "" && $DeleteImage==$ImageID){
			$this->DeleteImage($ImageID);
			return "";
		}
		else{
			if($ImageID != "")
				return $ImageID;
		}
		
		return "";
	}
	
	function AddEditImportFile($FileName,$SourcePath,$DirPath,$Name = "")
	{
		$AltText = $Name;
		$ImageID = $FileName;
		$SeoObj = new DataTable(TABLE_SEO_IMAGES);
		$SeoObj->where = "ImageID = '".$ImageID."' AND SourcePath='".$SourcePath."' AND DirPath='".$DirPath."'";
		//$SeoObj->displayQuery =true;
		$CurrentSEO = (object)$SeoObj->tableSelectOne();
		if(isset($CurrentSEO->ImageID) && $CurrentSEO->ImageID != ""){
			
			if($AltText != $CurrentSEO->AltText){
				$DataArray = array();
				$DataArray['AltText'] = $AltText;
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where = "ImageID = '".$ImageID."' AND SourcePath='".$SourcePath."' AND DirPath='".$DirPath."'";
				$SeoObj->tableUpdate($DataArray);
			}
			
				
			return $CurrentSEO->ImageID;
		}
		else{
			if($ImageID != "" && file_exists(DIR_FS_SITE_UPLOADS.$DirPath."/".$ImageID) && filesize(DIR_FS_SITE_UPLOADS.$DirPath."/".$ImageID) > 0){
				
				/* check image in another directory START*/
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where = "ImageID = '".$ImageID."'";
				//$SeoObj->displayQuery =true;
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ImageID"));
				if(isset($CurrentSEO->ImageID) && $CurrentSEO->ImageID != ""){
					$ReImageID = str_replace(".",uniqid("-").".",$ImageID);
					rename (DIR_FS_SITE_UPLOADS.$DirPath."/".$ImageID, DIR_FS_SITE_UPLOADS.$DirPath."/".$ReImageID);
					$ImageID=$ReImageID;
				}
				/* check image in another directory END*/
				
				$URL = 	SkURLCreate(str_replace(array("_"),array("-"),$AltText));
				if($URL=="")
					$URL = uniqid();
				$URLName = $this->GetUniqueImage($URL,$SourcePath,$DirPath,$ImageID);
				
				$SeoObj = new DataTable(TABLE_SEO_IMAGES);
				$SeoObj->where = "ImageID = '".$ImageID."'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ImageID"));
				if(!isset($CurrentSEO->ImageID)){
					$DataArray = array();
					$DataArray['ImageID'] = $ImageID;
					$DataArray['URLName'] = $URLName;
					$DataArray['AltText'] = $AltText;
					$DataArray['SourcePath'] = $SourcePath;
					$DataArray['DirPath'] = $DirPath;
					$SeoObj = new DataTable(TABLE_SEO_IMAGES);
					$SeoObj->tableInsert($DataArray);
				}
				return $ImageID;
			}
			else{
				/* image is not in the directory*/
			}
		}
		return "";
	}
	
	function GetUniqueImage($URLName,$SourcePath,$DirPath,$ImageID,$i=1)
	{
		$SeoObj = new DataTable(TABLE_SEO_IMAGES);
		$SeoObj->where = "URLName = '".$URLName."'";
		//$SeoObj->displayQuery =true;
		$CurrentSEO = $SeoObj->tableSelectOne();
		if(isset($CurrentSEO['ImageID'])){
			
			if($CurrentSEO['ImageID']==$ImageID && $CurrentSEO['DirPath']==$DirPath && $CurrentSEO['SourcePath']==$SourcePath){
				return $URLName;
			}
			else{
				if($i <= 500){
					$URLName .= '-'.rand();
					return $this->GetUniqueImage($URLName,$SourcePath,$DirPath,$ImageID,$i++);
				}
				return $URLName;
			}
		}
		else{
			return $URLName;
		}
			
	}
	
	function DeleteImage($ImageID,$ForceRemove=true)
	{
		if(isset($ImageID) && $ImageID !="" && $ForceRemove==true) /* false if not want to remove image*/
		{
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where = "ImageID = '".$ImageID."'";
			$CurrentSEO = $SeoObj->tableSelectOne();
			if(isset($CurrentSEO['ImageID'])){
				if(file_exists(DIR_FS_SITE_UPLOADS.$CurrentSEO['DirPath']."/".$CurrentSEO['ImageID']))
					unlink(DIR_FS_SITE_UPLOADS.$CurrentSEO['DirPath']."/".$CurrentSEO['ImageID']);
			}
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where[] = array('=',array('ImageID' => $ImageID));
			$SeoObj->tableDelete();	
		}
		
		return false;
	}	
	
}		