<?php 
namespace Cms\Pages\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Base\File\FileHandle as FileHandle;


class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = true; 
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->origin->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$PageObj = new DataTable(array('p'=>TABLE_CMS_PAGES));
			$PageObj->where[] = array('=',array('p.PageID' => $arr['ID']));
			$PageObj->joinExpression = true;
			$PageObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.PageID AND s.MCode='cms_pages')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$PageObj->tableSelectOne();
			if(isset($obj->PageID))
			{
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
						$this->onlyFile = true;
					}	
					
					if($obj->Template=="Comingsoon"){
						$this->origin->getTheme()->isIframe = true;
					}
					
					
					if($obj->Template=="Home"){
						$this->origin->moduleParam['IsCache'] = false;
						$this->setThemeFile("home"); 
						define("DEFINE_IS_HOMEPAGE_CHECK","1");
					}
						
					if(isset($_GET['PageNo']) && $_GET['PageNo']> 1)
						$obj->MetaTitle = $obj->MetaTitle ." - Page ".$_GET['PageNo'];
				
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
					
					$PathArr = $this->getClass("Cms\Pages\Common")->GetPageHerarcyArray($obj->PageID);
					if(isset($PathArr) && is_array($PathArr) && count($PathArr)> 0){
						$TopParentID = isset($PathArr[count($PathArr)-1])?$PathArr[count($PathArr)-1]:"0";
						if($TopParentID=="1074"){
							$this->origin->setView("Subpages");
						}
						if($TopParentID > 0){
							$this->leftSideInc = false;		
							$this->leftSideFile = "left-pages";		
							$this->LeftSideArr = array("TopParentID"=>$TopParentID);		
						}
					}
			}
			
		}
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	public function getThemeFile()
	{
		return $this->themeFile;
	}
	
	public function setThemeFile($themeFile)
	{
		$this->themeFile =$themeFile;
	}
	
	function getCategories()
	{
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where[] = array('=',array('ParentID' => 0));
		$CategoryObj->where[] = array('=',array('Active' => "1"));
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	}
	
	public function BLinkAction()
	{
		$BannerID = isset($_GET['BID'])?(int)$_GET['BID']:"0";
		if($BannerID > 0)
		{
			$Obj = new DataTable(TABLE_BANNERS);
			$Obj->where[] = array('=',array('BannerID' => (int)$BannerID));
			$CurrentBanner = (object)$Obj->tableSelectOne();
			if(isset($CurrentBanner->BannerID) && $CurrentBanner->Link != ""){
			
				$BannerObj = new DataTable(TABLE_BANNERS);
				$DataArray = array();
				$DataArray['Clicks'] = isset($CurrentBanner->Clicks)?$CurrentBanner->Clicks+1:1;
				$BannerObj->where[] = array('=',array('BannerID' => $CurrentBanner->BannerID));
				$BannerObj->tableUpdate($DataArray);	
				//MyRedirect(MyStripSlashes($CurrentBanner->Link));
				header( "HTTP/1.1 301 Moved Permanently" );
				header( "Location: ".MyStripSlashes($CurrentBanner->Link));
				exit;	
			}
		
		}
		header( "HTTP/1.1 301 Moved Permanently" );
		header( "Location: ".SKSEOURL('cms_pages','Detail',d('DEFAULT_PAGEID')));
		exit;
	}
	
	public function HomeSubscribeAction()
	{
		if(count($_POST)>0){
			if(!$this->getClass("Customer\Login\Common")->ValidateEmail($_POST['Email']))
				$this->getSession()->setArrVar("alert",array("danger","Invalid Email Address ! Please try user@domain.com"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0){
				
				$DataSubArray = array();
				
				if(isset($_POST['DisplayName']))
					$DataSubArray['DisplayName'] = isset($_POST['DisplayName'])?$_POST['DisplayName']:"";;
					
				$DataSubArray['Email'] = isset($_POST['Email'])?$_POST['Email']:"";
				
				$NewsletterUserObj = new DataTable(TABLE_USERS_NEWSLETTER);
				$NewsletterUserObj->where[] = array('=',array('Email' => $DataSubArray['Email']));
				$CurrentNewsLetterObj = (object)$NewsletterUserObj->tableSelectOne();
				if(isset($CurrentNewsLetterObj->Email) && $CurrentNewsLetterObj->Email !=""){
					$NewsletterUserObj->tableUpdate($DataSubArray);
				}
				else {
					$DataSubArray['CreatedDate'] = date("YmdHis");
					$NewsletterUserObj->tableInsert($DataSubArray);
				}
				$this->getSession()->setArrVar("alert",array("success","You have successfully been added to our Newsletter Subscription. We shall get in touch with you soon."));
					
				
			}
			else{
				
			}
			
		}
		
	}
	public function HomeSubmitAction()
	{
		if(count($_POST)>0){
			if(empty($_POST['Name']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Name"));
			
			if(!$this->getClass("Customer\Login\Common")->ValidateEmail($_POST['Email']))
				$this->getSession()->setArrVar("alert",array("danger","Invalid Email Address ! Please try user@domain.com"));
			
			//if(empty($_POST['Phone']))
			//	$this->getSession()->setArrVar("alert",array("danger","Please enter Phone"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0){
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true){
				//if(true){
					$DataArray = array();
					$DataArray['Mail_Subject'] ="Contact us: User message on ".d("SITE_NAME");
					$DataArray['Mail_ToEmail'] =d("ADMIN_EMAIL");
					$DataArray['Mail_Header'] ='User submitted message at '.d("SITE_NAME").'<br><br>';
					$DataArray['Mail_Footer'] ='Thank you <br><br>'.d("SITE_NAME").'.';
					$DataArray['Name'] = isset($_POST['Name'])?$_POST['Name']:"";
					$DataArray['Email Address'] = isset($_POST['Email'])?$_POST['Email']:"";
					//$DataArray['Phone'] = isset($_POST['Phone'])?$_POST['Phone']:"";
					$DataArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
					
					$this->getSession()->setArrVar("alert",array("success","Your enquiry has been successfully sent. We shall get in touch with you soon."));
					$this->getClass('Cms\Pages\Common')->SendMailByUsingTemplate("enquiry.php",$DataArray);
					MyRedirect(SKSEOURL('cms_pages','Detail',$this->currentObj->PageID));
					exit;
				}
				else{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
			
		}
		
	}
	
	public function ContactSubmitAction()
	{
		if(count($_POST)>0){
			if(empty($_POST['Name']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Name"));
			
			if(!$this->getClass("Customer\Login\Common")->ValidateEmail($_POST['Email']))
				$this->getSession()->setArrVar("alert",array("danger","Invalid Email Address ! Please try user@domain.com"));
			
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0){
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true){
					$DataArray = array();
					$DataArray['Mail_Subject'] ="Contact us: User message on ".d("SITE_NAME");
					$DataArray['Mail_ToEmail'] =d("ADMIN_EMAIL");
					$DataArray['Mail_Header'] ='User submitted message at '.d("SITE_NAME").'<br><br>';
					$DataArray['Mail_Footer'] ='Thank you <br><br>'.d("SITE_NAME").'.';
					$DataArray['Name'] = isset($_POST['Name'])?$_POST['Name']:"";
					$DataArray['Email Address'] = isset($_POST['Email'])?$_POST['Email']:"";
					$DataArray['Company'] = isset($_POST['Company'])?$_POST['Company']:"";
					//$DataArray['Phone'] = isset($_POST['Phone'])?$_POST['Phone']:"";
					$DataArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
					$DataArray['Mail_BCC'] = d("BCC_EMAIL");
					
					/* DB insert start*/
					$DataSubArray = array();
					$DataSubArray['FirstName'] = isset($_POST['FirstName'])?$_POST['FirstName']:"";
					if($DataSubArray['FirstName']=="")
						$DataSubArray['FirstName'] = isset($_POST['Name'])?$_POST['Name']:"";
						
					$DataSubArray['LastName'] = isset($_POST['LastName'])?$_POST['LastName']:"";
					$DataSubArray['Email'] = isset($_POST['Email'])?$_POST['Email']:"";
					$DataSubArray['Phone'] = isset($_POST['Phone'])?$_POST['Phone']:"";
					$DataSubArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
					$DumpData = array();
					$DumpData['Company'] = isset($_POST['Company'])?$_POST['Company']:"";
					$DumpData['Measurement'] = isset($_POST['Measurement'])?$_POST['Measurement']:"";
					
					if(isset($_FILES['Upload_Image1']) && $_FILES['Upload_Image1']['name'] !="" && $this->getClass('Cms\Pages\Common')->CheckImageFromFront($_FILES['Upload_Image1']['name']) === true)
					{
						$ArrayType = explode(".",$_FILES['Upload_Image1']['name']);
						$Type=$ArrayType[count($ArrayType)-1];
						
						$dir = FileHandle::CheckPrivateLogDirectory("contact_upload");
						$ImageName = uniqid("enq_").".".$Type;		
						$OriginalImage=$dir.$ImageName;		
						copy($_FILES['Upload_Image1']['tmp_name'],$OriginalImage);
						$DumpData['Upload_Image1'] = array("Name"=>$_FILES['Upload_Image1']['name'],
														   "Label"=>"Image 1",
														   "Type"=>"Image",
														   "FileName"=>$ImageName,
														   "FullPath"=>$OriginalImage,
														   );
					
					}
					if(isset($_FILES['Upload_Image2']) && $_FILES['Upload_Image2']['name'] !="" && $this->getClass('Cms\Pages\Common')->CheckImageFromFront($_FILES['Upload_Image2']['name']) === true)
					{
						$ArrayType = explode(".",$_FILES['Upload_Image2']['name']);
						$Type=$ArrayType[count($ArrayType)-1];
						
						$dir = FileHandle::CheckPrivateLogDirectory("contact_upload");
						$ImageName = uniqid("enq_").".".$Type;		
						$OriginalImage=$dir.$ImageName;		
						copy($_FILES['Upload_Image2']['tmp_name'],$OriginalImage);
						$DumpData['Upload_Image2'] = array("Name"=>$_FILES['Upload_Image2']['name'],
														   "Label"=>"Image 2",
														   "Type"=>"Image",
														   "FileName"=>$ImageName,
														   "FullPath"=>$OriginalImage,
														   );
					
					}		
					if(count($DumpData) > 0)			
						$DataSubArray['DumpData'] = serialize($DumpData);
					
					$DataSubArray['CreatedDate'] = date("YmdHis");
					$DBObj = new DataTable(TABLE_EMAIL_ENQUIRIES);
					$DBObj->tableInsert($DataSubArray);
					/* DB insert end*/
					
					$this->getSession()->setArrVar("alert",array("success","Your enquiry has been successfully sent. We shall get in touch with you soon."));
					$this->getClass('Cms\Pages\Common')->SendMailByUsingTemplate("enquiry.php",$DataArray);
					MyRedirect(SKSEOURL('cms_pages','Detail',$this->currentObj->PageID));
					exit;
				}
				else{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
			
		}
		
	}
	
	function getBeforeMeta()
	{
		
	}
	function getAfterMeta()
	{
		if(is_object($this->currentObj)){
			$CurrentRecord = $this->currentObj;
			
			$ogImage = SKSeoImage($CurrentRecord->Image,"500");
			if($ogImage=="")
				$ogImage = d("DIR_WS_SITE")."templates/front/logo.jpg";
			
			$return ='<link rel="canonical" href="'.SKSEOURL('cms_pages','Detail',$CurrentRecord->PageID).'" />';
			$return .='<meta property="og:site_name" content="'.d("SITE_NAME").'"/>
						<meta property="og:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'" />
						<meta property="og:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'" />
						<meta property="og:type" content="website" />
						<meta property="og:url" content="'.SKSEOURL('cms_pages','Detail',$CurrentRecord->PageID).'" />
						<meta property="og:image" content="'.$ogImage.'" />
						<meta property="og:locale" content="en_GB"/>
						<meta property="fb:app_id" content="'.d("FACEBOOK_APP_ID").'"/>
						<meta name="twitter:card" content="summary"/>
						<meta name="twitter:site" content="'.d("TWITTER_SITE_ID").'"/>
						<meta name="twitter:creator" content="'.d("TWITTER_SITE_CREATOR").'"/>
						<meta name="twitter:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'"/>
						<meta name="twitter:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'"/>
						<meta name="twitter:image" content="'.$ogImage.'"/>
			
			';
		}
		return $return;		 
	}
	
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function directFile()
	{
		return $this->onlyFile;
	}
		
		
}	