<?php 
namespace Cms\Pages\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;


class GalleryController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = true; 
	function __construct()
	{
		
	}
	
	
	function settings()
	{
		$arr = $this->origin->moduleParam;
		$this->origin->setView("GalleryImage");
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$CategoryObj = new DataTable(array('p'=>TABLE_GALLERY_CATEGORY));
			$CategoryObj->where[] = array('=',array('p.CategoryID' => $arr['ID']));
			$CategoryObj->joinExpression = true;
			$CategoryObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.CategoryID AND s.MCode='cms_gallery')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$CategoryObj->tableSelectOne();
			if(isset($obj->CategoryID))
			{
						
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
					
			}
			
		
			
		}
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	public function getThemeFile()
	{
		return $this->themeFile;
	}
	
	public function setThemeFile($themeFile)
	{
		$this->themeFile =$themeFile;
	}
	
	
	function pageTitle()
	{
		return isset($this->currentObj->CategoryName)?MyStripSlashes($this->currentObj->CategoryName):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function directFile()
	{
		return $this->onlyFile;
	}
		
		
}	