<?php 
namespace Cms\Pages;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class CronController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	
	public function GeneralCronAction($ScriptTimeLimit,$Obj)
	{
		
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/generalcron");
		$filename=$dir."general_".date('Y-m-d').".txt";
		$UniqueID = uniqid("general_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"GeneralCron Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		
	
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/		
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			$this->getClass("Cms\Pages\Common")->ClearCacheFiles();
			
			fputs($fp2,"GeneralCron ClearCacheFiles ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d H:i:s',strtotime("+2 hours"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			//var_dump($DataArray);
			$sk_timeend = explode(' ', microtime() );
			$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
			if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
				return ;	
		}
		else{
			if(isset($Obj->CronID) && strtotime(date('Y-m-d H:i:s')) > strtotime($Obj->CronDate)){
			
				fputs($fp2,"GeneralCron PastCronUpdated ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d H:i:s');
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$CronObj->tableUpdate($DataArray);
			}
		}
		/* script end here*/		
	
		
		
		
		fputs($fp2,"GeneralCron End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
		
	}
}	