<?php 
namespace Cms\Pages;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;
use Base\File\FileHandle as FileHandle;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	public function getPageByPageID($PageID)
	{
		if($PageID > 0)
		{
			$PageObj = new DataTable(array('p'=>TABLE_CMS_PAGES));
			$PageObj->where[] = array('=',array('p.PageID' => $PageID));
			$PageObj->joinExpression = true;
										  
			$obj  = $PageObj->tableSelectOne();
			
			if($obj['ModuleKey'] > 0)
			{
				$MObj = new DataTable(TABLE_MODULE_KEY);
				$MObj->where="ModuleKeyID ='".(int)$obj['ModuleKey']."'";
				$TmpObj  = (object)$MObj->tableSelectOne();
				
				
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$PageID." AND MCode ='".$TmpObj->SCode."' AND MView ='".$TmpObj->SView."'";
			$CurrentSEO = $SeoObj->tableSelectOne();
			
				if(isset($CurrentSEO['ReferenceID']) && $CurrentSEO['ReferenceID'] > 0)
				$obj = array_merge($obj,$CurrentSEO);
			}
			
			return (object)$obj;
		
		}
		return ;
	
	}
	
	
	function GetUniqueURL($URLName,$MCode,$MView,$ReferenceID,$i=1)
	{
		$SeoObj = new DataTable(TABLE_SEO);
		$SeoObj->where = "URLName = '".$URLName."'";
		//$SeoObj->where = "ReferenceID = ".$ReferenceID." AND MCode ='".$MCode."' AND MView ='".$MView."'";
		$CurrentSEO = $SeoObj->tableSelectOne();
		if(isset($CurrentSEO['URLID'])){
			
			if($CurrentSEO['ReferenceID']==$ReferenceID && $CurrentSEO['MView']==$MView && $CurrentSEO['MCode']==$MCode){
				return $URLName;
			}
			else{
				if($i <= 500){
					$URLName .= '-'.rand(1,5000);
					return $this->GetUniqueURL($URLName,$MCode,$MView,$ReferenceID,$i++);
				}
				return $URLName;
			}
		}
		else{
			return $URLName;
		}
			
	}
	
	function Before404()
	{
		if(d("DEFINE_CURRENT_PAGE_URL") != ""){
			$Str = basename(d("DEFINE_CURRENT_PAGE_URL"));
			
			preg_match_all("/(.*)-c-(.*).html/Uis", $Str, $matches);
			if (is_array($matches) && count($matches) >0) {
				for ($m = 0; $m < count($matches); $m++){
					if(isset($matches[2][$m]) && $matches[2][$m]  != ""){
						header( "HTTP/1.1 301 Moved Permanently" );
						header( "Location: ".SKSEOURL('catalog_category','Detail',$matches[2][$m]));
						exit;
					}
				}
			}
			
			preg_match_all("/(.*)-p-(.*).html/Uis", $Str, $matches);
			if (is_array($matches) && count($matches) >0) {
				for ($m = 0; $m < count($matches); $m++){
					if(isset($matches[2][$m]) && $matches[2][$m]  != ""){
						header( "HTTP/1.1 301 Moved Permanently" );
						header( "Location: ".SKSEOURL('catalog_product','Detail',$matches[2][$m]));
						exit;
					}
				}
			}
			
			preg_match_all("/product-video.php\?productId\=(.*)/i", $Str, $matches);
			if (is_array($matches) && count($matches) >0) {
				for ($m = 0; $m < count($matches); $m++){
					if(isset($matches[1][$m]) && $matches[1][$m]  != ""){
						header( "HTTP/1.1 301 Moved Permanently" );
						header( "Location: ".SKSEOURL('catalog_product','Detail',$matches[1][$m]));
						//header( "Location: ".SKSEOURL('catalog_product','Detail',$matches[1][$m],"#VideoDisplay"));
						exit;
					}
				}
			}
			
			preg_match_all("/case-studies-cms-17.html\?caseid\=(.*)/i", $Str, $matches);
			if (is_array($matches) && count($matches) >0) {
				for ($m = 0; $m < count($matches); $m++){
					if(isset($matches[1][$m]) && $matches[1][$m]  > 0){
						header( "HTTP/1.1 301 Moved Permanently" );
						header( "Location: ".SKSEOURL('cms_pages','Detail',1200+$matches[1][$m]));
						//header( "Location: ".SKSEOURL('catalog_product','Detail',$matches[1][$m],"#VideoDisplay"));
						exit;
					}
				}
			}
			
		}
		
	}
	
	function CheckRedirectURL()
	{
		if(isset($_SERVER['HTTPS']))
			$URL = "https://".$_SERVER['HTTP_HOST'].d("DEFINE_CURRENT_PAGE_URL");
		else 
			$URL = "http://".$_SERVER['HTTP_HOST'].d("DEFINE_CURRENT_PAGE_URL");
			
		$SourceURL = str_replace(d("DIR_WS_SITE"),'',$URL);	
		if($SourceURL != ""){
			$RObj = new DataTable(TABLE_REDIRECT);
			$RObj->where[] = array('=',array('SourceURL' => $SourceURL));
			$where = new Where();
			$where->equalTo('SourceURL',$SourceURL);
			$where->notEqualTo('DestinationURL',$SourceURL);
			$RObj->where = $where;
			$Obj = (object)$RObj->tableSelectOne();
			if(isset($Obj->DestinationURL) && $Obj->DestinationURL != ""){
				$DestinationURL = $this->GetFinalRedirection($Obj->DestinationURL);
				header( "HTTP/1.1 301 Moved Permanently" );
				header( "Location: ".d("DIR_WS_SITE").$Obj->DestinationURL );
				exit;

			}
			
		}
		
		$this->CheckNoIndexURL();
		
	}
	
	
	function CheckNoIndexURL()
	{
		if(isset($_SERVER['HTTPS']))
			$URL = "https://".$_SERVER['HTTP_HOST'].d("DEFINE_CURRENT_PAGE_URL");
		else 
			$URL = "http://".$_SERVER['HTTP_HOST'].d("DEFINE_CURRENT_PAGE_URL");
			
		$SourceURL = str_replace(d("DIR_WS_SITE"),'',$URL);	
		if($SourceURL != ""){
			$RObj = new DataTable(TABLE_NOINDEX);
			$RObj->where[] = array('=',array('SourceURL' => $SourceURL));
			$where = new Where();
			$where->equalTo('SourceURL',$SourceURL);
			$RObj->where = $where;
			$Obj = (object)$RObj->tableSelectOne();
			if(isset($Obj->SourceURL) && $Obj->SourceURL != "" && defined("DEFINE_CURRENT_NOINDEX_URL") == false){
					define("DEFINE_CURRENT_NOINDEX_URL","1");
			}
			
		}
		
	}
	function GetFinalRedirection($DestinationURL,$i=1)
	{
		$RObj = new DataTable(TABLE_REDIRECT);
		$where = new Where();
		$where->equalTo('SourceURL',$DestinationURL);
		$where->notEqualTo('DestinationURL',$DestinationURL);
		$RObj->where = $where;
		$Obj = (object)$RObj->tableSelectOne();
		if(isset($Obj->DestinationURL)){
			if($i <= 50){
				$i++;
				//echo "<hr>".$i."--".$Obj->DestinationURL."--".$Obj->RedirectID;
				return $this->GetFinalRedirection($Obj->DestinationURL,$i);
			}
			else{
				return DIR_WS_SITE;
			}
		}
		else{
			return $DestinationURL;
		}
			
	}
	
	function EmailAndNotificationPush($TemplateKey,$VarArray=array(),$NotifyData=array(),$EmailData=array())
	{
		$VarArray['{SITE_NAME}'] =d("SITE_NAME");
		foreach($VarArray as $kk=>$vv)
			$VarArray[$kk] = nl2br($vv);
		
		$Obj = new DataTable(TABLE_EMAIL_TEMPLATES);
		$Obj->where[] = array('=',array('TemplateKey' => $TemplateKey));
		$CurrentTemplate =  (object)$Obj->tableSelectOne();
		if(isset($CurrentTemplate->TemplateID)){
			
			if(isset($CurrentTemplate->NotificationStatus) && $CurrentTemplate->NotificationStatus=="1"){
					$DataArray = array();
					$DataArray['NotificationTo'] = isset($NotifyData['NotificationTo'])?$NotifyData['NotificationTo']:"";
					$DataArray['Notification'] = str_replace(array_keys($VarArray),array_values($VarArray),$CurrentTemplate->Notification);
					$DataArray['RedirectLink'] = isset($NotifyData['RedirectLink'])?$NotifyData['RedirectLink']:"";
					$DataArray['RedirectVar'] = isset($NotifyData['RedirectVar'])?$NotifyData['RedirectVar']:"";
					$DataArray['ReadStatus'] = "0";
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
					$NotifyObj = new DataTable(TABLE_EMAIL_NOTIFICATIONS);
					$NotifyObj->tableInsert($DataArray);
					//var_dump($DataArray);
			}
			
			if(isset($CurrentTemplate->EmailStatus) && $CurrentTemplate->EmailStatus=="1"){
				$MessageBody = str_replace(array_keys($VarArray),array_values($VarArray),MyStripSlashes($CurrentTemplate->Message));;
				
				$Subject = str_replace(array_keys($VarArray),array_values($VarArray),$CurrentTemplate->Subject);;
				
				$FileAttachment = isset($EmailData['FileAttachment'])?$EmailData['FileAttachment']:false;
				$AttachmentFileName = isset($EmailData['AttachmentFileName'])?$EmailData['AttachmentFileName']:"";
				$ToEmail = isset($EmailData['ToEmail'])?$EmailData['ToEmail']:"";
				$FromEmail = ($CurrentTemplate->FromEmail != "")?$CurrentTemplate->FromEmail:d("ADMIN_EMAIL");
				$FromName = ($CurrentTemplate->FromName != "")?$CurrentTemplate->FromName:d("SITE_NAME");
				$CC = ($CurrentTemplate->EmailCC != "")?$CurrentTemplate->EmailCC:"";
				$BCC = ($CurrentTemplate->EmailBCC != "")?$CurrentTemplate->EmailBCC:"";
				$this->SendEmail($Subject,$ToEmail,$FromEmail,$FromName,$MessageBody,$BCC,d("EMAIL_FORMAT"),$FileAttachment,$AttachmentFileName);
				//echo $MessageBody;var_dump($ToEmail,$MessageBody,$Subject,$FromEmail,$FromName);exit;
			}
			
		}
		
		//var_dump($CurrentTemplate);
	}
	
	function SendMailByUsingTemplate($TemplateName,$arr=array())
	{
		$arr['neo_sid'] = $this->getSession()->getCurrentSID();
		@ob_start();
		if(file_exists(DIR_FS_SITE."templates/emails/".$TemplateName))
			require(DIR_FS_SITE."templates/emails/".$TemplateName);
		
		$MessageBody = ob_get_contents();
		@ob_clean();
		//echo $MessageBody;exit;
		
		$Mail_FileAttachment = isset($arr['Mail_FileAttachment'])?$arr['Mail_FileAttachment']:false;
		$Mail_AttachmentFileName = isset($arr['Mail_AttachmentFileName'])?$arr['Mail_FAttachmentFileName']:"";
		$Mail_Subject = isset($arr['Mail_Subject'])?$arr['Mail_Subject']:d("SITE_NAME");
		$Mail_ToEmail = isset($arr['Mail_ToEmail'])?$arr['Mail_ToEmail']:"";
		$Mail_FromEmail = isset($arr['Mail_FromEmail'])?$arr['Mail_FromEmail']:d("ADMIN_EMAIL");
		$Mail_FromName = isset($arr['Mail_FromName'])?$arr['Mail_FromName']:d("SITE_NAME");
		$Mail_BCC = isset($arr['Mail_BCC'])?$arr['Mail_BCC']:"";
		$Mail_Subject = str_replace("sitename.com",d("SITE_NAME"),$Mail_Subject);
		$this->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,$Mail_BCC,d("EMAIL_FORMAT"),$Mail_FileAttachment,$Mail_AttachmentFileName);
	}
	
	function SendEmail($Subject, $ToEmail, $FromEmail, $FromName, $Message, $Bcc="",$Format=DEFINE_EMAIL_FORMAT,$FileAttachment=false,$AttachmentFileName="",$IS_SMTP=DEFINE_SMTP_MAIL_STATUS)
	{
		$mail = new PHPMailer;
		if($IS_SMTP=="1")
		{
			//$mail->SMTPDebug = 2;
			//$mail->Debugoutput = 'html';
			
			$mail->isSMTP();                                   // send via SMTP
			$mail->Host     = d("SMTP_HOSTNAME"); // SMTP servers
			$mail->SMTPAuth = true;     // turn on SMTP authentication	
			$mail->Username = d("SMTP_USERNAME");  // SMTP username
			$mail->Password = d("SMTP_PASSWORD"); // SMTP password	
			 //$mail->Port = (d("SMTP_PORT") == "")?"25":d("SMTP_PORT");	
			 
			if(d("SMTP_SECURE") != "")
				$mail->SMTPSecure = d("SMTP_SECURE");	
			
			//$mail->Port="587";
			//$mail->SMTPSecure ="ssl";
			$mail->SMTPOptions = array(
					'ssl' => array(
						'verify_peer' => false,
						'verify_peer_name' => false,
						'allow_self_signed' => true
					)
				);
			
			if(d("SMTP_FORCE_EMAIL") != "")
				$FromEmail = d("SMTP_FORCE_EMAIL");	
		}
		
		$mail->setFrom($FromEmail, str_replace('’',"'",$FromName));
		
		$mail->addAddress(trim($ToEmail),trim($ToEmail)); 
		$MyBccArray = explode(",",$Bcc);
		foreach($MyBccArray as $Key=>$Value)
		{
			if(trim($Value) !="")
				$mail->addBCC($Value); 
			
		}
		
		if(d("SMTP_EMAIL_BCC_ALL") != ""){
			$mail->addBCC(d("SMTP_EMAIL_BCC_ALL")); 
		}
		
		if($Format=="html")
		{
			$mail->msgHTML(str_replace('’',"'",$Message));                               // send as HTML
		}
		else 
		{
			$mail->AltBody = str_replace('’',"'",$Message);
		}
		
		$mail->Subject  =  str_replace('’',"'",$Subject);
		//$mail->Subject  =  utf8_encode($Subject);
		//$mail->AltBody  =  $Message;
		if($FileAttachment)
		{
			if(is_array($AttachmentFileName))
			{
				foreach ($AttachmentFileName as $k=>$v)
					$mail->addAttachment($v,basename($v));
				
			}
			else 
				$mail->addAttachment($AttachmentFileName,basename($AttachmentFileName));
			
		}
		
		try {
			
			if (ob_get_length())
				ob_clean();
			
			$mail->Send();
			//var_dump("<pre><hr>",$mail->ErrorInfo,"<hr>",$mail);exit;
			
		}
		catch(phpmailerException $e)
		{
			$LogObj = new DataTable(TABLE_LOG_ERROR_EMAIL);
			$DataArray = array();
			$DataArray['ErrorMsg'] =$e->getMessage();
			$DataArray['PostObj'] =serialize($_POST);
			$DataArray['ServerObj'] =serialize($_SERVER);
			$DataArray['MsgObj'] =serialize($mail);
			//$DataArray['Exception'] =serialize($e);
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
			$LogObj->tableInsert($DataArray);
			echo 'Message: ' .$e->getMessage();
		}
		catch(Exception $e)
		{
			$LogObj = new DataTable(TABLE_LOG_ERROR_EMAIL);
			$DataArray = array();
			$DataArray['ErrorMsg'] =$e->getMessage();
			$DataArray['PostObj'] =serialize($_POST);
			$DataArray['ServerObj'] =serialize($_SERVER);
			$DataArray['MsgObj'] =serialize($mail);
			//$DataArray['Exception'] =serialize($e);
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
			$LogObj->tableInsert($DataArray);
			echo 'Message: ' .$e->getMessage();
		}
		
		
		return true;
	
	}
	
	public function getAddOnByID($AddOnID,$IncludeDiv=false)
	{
		$CurrentText = "";
		if($AddOnID > 0)
		{
			$dir = FileHandle::CheckPrivateLogDirectory("cache");
			$filename=$dir."cache.addon_".md5(serialize(array($AddOnID,$IncludeDiv))).".txt";
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
				$CurrentText =unserialize(file_get_contents($filename));
			}
			else{
				$Obj = new DataTable(TABLE_ADD_ON);
				$Obj->where[] = array('=',array('AddOnID' => $AddOnID));
				$Current = (object)$Obj->tableSelectOne(array("Description1"));
				if($IncludeDiv==true)
					$CurrentText = isset($Current->Description1)?'<div class="addon-content">'.MyStripSlashes($Current->Description1).'</div>':"";
				else
					$CurrentText = isset($Current->Description1)?MyStripSlashes($Current->Description1):"";
				
				if(d("CACHE_IMPLEMENT")=="1"){
					$fp2 = fopen($filename, "w");
					fputs($fp2,serialize($CurrentText));	
					fclose($fp2);
				}
			}
			
			
			
		
		}
		return $CurrentText;
	
	}
	
	public function getAddOnByID1($AddOnID,$IncludeDiv=false)
	{
		return $this->getAddOnByID($AddOnID,$IncludeDiv);
	}
	public function getAddOnByID2($AddOnID,$IncludeDiv=false)
	{
		if($AddOnID > 0)
		{
			$Obj = new DataTable(TABLE_ADD_ON);
			$Obj->where[] = array('=',array('AddOnID' => $AddOnID));
			$Current = (object)$Obj->tableSelectOne(array("Description2"));
			if($IncludeDiv==true)
				return isset($Current->Description2)?'<div class="addon-content">'.MyStripSlashes($Current->Description2).'</div>':"";
			else
				return isset($Current->Description2)?MyStripSlashes($Current->Description2):"";
		
		}
		return ;
	
	}
	
	public function getSubpages($ParentID=0,$ps=10,$PageNo=1)
	{
		$ObjObj = new DataTable(TABLE_CMS_PAGES);
		$ObjObj->where ="ParentID='".(int)$ParentID."' and Active ='1'";
		$ObjObj->AllowPaging =true;
		$ObjObj->PageSize=$ps;
		$ObjObj->PagingPrefix="";
		$ObjObj->PageTotalDisplay = 10; 
		$ObjObj->PageNo =$PageNo;	
		$this->paging = $ObjObj;
		return $ObjObj->tableSelectAll(array("PageID","LinkTitle","LeftDescription2","Image"),"Position ASC");
	
	}
	
	public function getFeaturedSubpages($ParentID=0,$limit=5)
	{
		$ObjObj = new DataTable(TABLE_CMS_PAGES);
		$ObjObj->where ="ParentID='".(int)$ParentID."' and Active ='1' and Featured ='1'";
		return $ObjObj->tableSelectAll(array("PageID","LinkTitle","LeftDescription2","Image"),"Position ASC",$limit);
	
	}
	
	public function GetPageHerarcyArray($PageID,$PathArr=NULL,$i=1) 
	{

		$ObjObj2 = new DataTable(TABLE_CMS_PAGES);
		$Obj = new DataTable(TABLE_CMS_PAGES);
		$Obj->where[] = array('=',array('PageID' => $PageID));
		$Current = (object)$Obj->tableSelectOne(array("ParentID"));
		$ParentID = isset($Current->ParentID)?$Current->ParentID:"";
		if($ParentID =="0"){
			if($PathArr==NULL){
				$ObjObj2->where ="ParentID='".(int)$PageID."' and Active ='1' ";
				$SubRecord = $ObjObj2->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
				if(count($SubRecord) > 0){
					return array($PageID);
				}
					
			}
			return $PathArr;
		}
		else 
		{
			if($i <= 50){
				$PathArr[] = $ParentID;
				return $this->GetPageHerarcyArray($ParentID,$PathArr,$i++);
			}
		}
	}
	
	public function getAdsByCategoryID($moduleObj,$CategoryID)
	{
		if($CategoryID > 0){
			//var_dump($moduleObj);
			
			$Obj = new DataTable(TABLE_ADS);
			$where = new Where();
			$where->equalTo('CategoryID',(int)$CategoryID);
			$where->equalTo('Active',"1");
			$where->equalTo('PageType',"ALL");
			$Obj->where = $where;
			$rows = $Obj->tableSelectAll(array("*"),array("Position ASC","AdID ASC"));
			$this->displayAdData($rows);
			
			/* homepage check start here*/
			if( 
				isset($moduleObj->moduleParam['obj']->SCode) && $moduleObj->moduleParam['obj']->SCode=="cms_pages"
				 && isset($moduleObj->moduleParam['obj']->SView) && $moduleObj->moduleParam['obj']->SView=="Detail"
				&& isset($moduleObj->moduleParam['ID']) && $moduleObj->moduleParam['ID']=="1001"
			  ){
				  
				  $Obj = new DataTable(TABLE_ADS);
				$where = new Where();
				$where->equalTo('CategoryID',(int)$CategoryID);
				$where->equalTo('Active',"1");
				$where->equalTo('PageType',"Home");
				$Obj->where = $where;
				$rows = $Obj->tableSelectAll(array("*"),array("Position ASC","AdID ASC"));
				$this->displayAdData($rows);
			
			  }
			/* homepage check start end*/
			/* productpage check start here*/
			if( 
				isset($moduleObj->moduleParam['obj']->SCode) && $moduleObj->moduleParam['obj']->SCode=="catalog_product"
				 && isset($moduleObj->moduleParam['obj']->SView) && $moduleObj->moduleParam['obj']->SView=="Detail"
			  ){
				  
				  $Obj = new DataTable(TABLE_ADS);
				$where = new Where();
				$where->equalTo('CategoryID',(int)$CategoryID);
				$where->equalTo('Active',"1");
				$where->equalTo('PageType',"Product");
				$where->NEST//start braket
					->equalTo('ProductIDs',"0")
					->OR
					->equalTo('ProductIDs',"")
					->OR
					->ISNULL('ProductIDs')
					->UNNEST;
	
				$Obj->where = $where;
				$rows = $Obj->tableSelectAll(array("*"),array("Position ASC","AdID ASC"));
				$this->displayAdData($rows);
			
			  }
			/* productpage check start end*/
			/* Specific product check start here*/
			if( 
				isset($moduleObj->moduleParam['obj']->SCode) && $moduleObj->moduleParam['obj']->SCode=="catalog_product"
				 && isset($moduleObj->moduleParam['obj']->SView) && $moduleObj->moduleParam['obj']->SView=="Detail"
				 && isset($moduleObj->moduleParam['ID']) && $moduleObj->moduleParam['ID'] > "0"
			  ){
				
				$ID = $moduleObj->moduleParam['ID'];	
				$Obj = new DataTable(TABLE_ADS);
				$where = new Where();
				$where->equalTo('CategoryID',(int)$CategoryID);
				$where->equalTo('Active',"1");
				$where->equalTo('PageType',"Product");
				$where->expression("FIND_IN_SET(?,ProductIDs)",(int)$ID);
				//$Obj->displayQuery = true;
				$Obj->where = $where;
				$rows = $Obj->tableSelectAll(array("*"),array("Position ASC","AdID ASC"));
				$this->displayAdData($rows);
			
			  }
			/* Specific product check end*/
			
			
			
			
		}
	}
	function displayAdData($adRows)
	{
		if(isset($adRows) && count($adRows) > 0){
			if(file_exists(dirname(__FILE__)."/Front/View/templates/ads.php")){
				include(dirname(__FILE__)."/Front/View/templates/ads.php");
			}
		}
	}
	
	
	public function getCMSUpperBanner1($BannerIDs)
	{
		if($BannerIDs != ""){
			$Obj = new DataTable(TABLE_BANNERS);
			$Obj->noCache = true;
			$where = new Where();
			$where->in('BannerID',explode(",",$BannerIDs));
			$where->equalTo('Active',"1");
			$Obj->where = $where;
			$rowBanners = $Obj->tableSelectAll(array("*"),array("Position ASC","BannerID ASC"));
			if(count($rowBanners) > 0):?>
<!-- Banner -->
<section id="Banners">
<div id="carouselExampleControls" class="carousel slide" data-ride="carousel" data-interval="8000" data-wrap="true">
  <div class="carousel-inner">
	<?php $Init = 1;?>
	<?php foreach($rowBanners as $CurrentBanner):?>
		<div class="carousel-item<?php echo $Init==1?" active":""?>"><?php $this->getClass("Cms\Pages\Common")->getBannerData($CurrentBanner,"cms_banners");?></div>
	<?php $Init++;endforeach;?>  
	
  <!--<a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
    <span class="sr-only">Previous</span>
  </a>
  <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
    <span class="carousel-control-next-icon" aria-hidden="true"></span>
    <span class="sr-only">Next</span>
  </a>-->
	
  </div>  
</div>
</section>
<style>
.carousel-item-left{display:none;}
.carousel-item-next{display:none;}
</style>
<!-- eof Banner -->
<?php endif;
			
			
		}
	}
	
	public function getGalleryCategoryList()
	{
		$CategoryObj = new DataTable(TABLE_GALLERY_CATEGORY);
		$where = new Where();
		$where->equalTo('Active',"1");
		$CategoryObj->where = $where;
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	
	}
	
	public function getBannerByCategoryID($CategoryID,$Limit=0)
	{
		if($CategoryID > 0){
			
			$Obj = new DataTable(TABLE_BANNERS);
			$Obj->noCache = true;
			$where = new Where();
			$where->equalTo('CategoryID',(int)$CategoryID);
			$where->equalTo('Active',"1");
			$where->NEST//start braket
					->expression('(? BETWEEN StartDate AND EndDate)',date('Y-m-d H:i:s'))
					//->OR
					//->expression("(StartDate =? OR EndDate =?)",array('0000-00-00 00:00:00','0000-00-00 00:00:00'))
					->OR
						->NEST//start braket
						->ISNULL('StartDate')
						->AND
						->ISNULL('EndDate')
						->UNNEST
					->UNNEST;
	
			//$Obj->displayQuery = true;
			$Obj->where = $where;
			if($Limit > 0)
				return $Obj->tableSelectAll(array("*"),array("Position ASC","BannerID ASC"),$Limit);
			else
				return $Obj->tableSelectAll(array("*"),array("Position ASC","BannerID ASC"));
			
		}
		return false;
	}
	
	function displayConfigField($CurrentConfig)
	{
		if(isset($CurrentConfig->DefineID)){
			
			if(file_exists(dirname(__FILE__)."/Admin/View/fields/".basename(strtolower($CurrentConfig->DefineType)).".php"))
				include(dirname(__FILE__)."/Admin/View/fields/".basename(strtolower($CurrentConfig->DefineType)).".php");
			else
				include(dirname(__FILE__)."/Admin/View/fields/text.php");
			
		}
	}
	function getNotes($ReferenceID,$ReferenceType,$NoteSection,$AddForm="1",$FrontDisplay="0")
	{
		if($ReferenceID != "" && file_exists(dirname(__FILE__)."/Admin/View/Notes.php")){
				include(dirname(__FILE__)."/Admin/View/Notes.php");
		}
			
		
	}
	function getInnerTempate($file,$HomeObj)
	{
		if(count($_POST)==0 && d("CACHE_IMPLEMENT")=="1"){
			$HomeFile = dirname(__FILE__)."/Front/View/templates/".basename($file).".php";
			$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
			$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache/files");
			$CacheKey = $this->getClass("Frontend\Common\Common")->getUniqueCacheKey();
			$filename=$dir.md5($HomeFile.$CacheKey).".txt";
			
			if(file_exists($filename)){
				echo "<!--SKCAIMCONTENT START-->";
				echo file_get_contents($filename);
				echo "<!--SKCAIMCONTENT END-->";
			}
			else{
				if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php")){
					@ob_start();
					include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
					$Content = ob_get_contents();
					$fp2 = fopen($filename, "w");
					fputs($fp2,$Content);	
					fclose($fp2);
				}
			}
		}
		else{
			if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php")){
				include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
			}
		}
		
		
			
	}
	function getBannerData($CurrentBanner,$file="default")
	{
		if(isset($CurrentBanner->BannerID))
		{
			$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
			$CacheKey = $this->getClass("Frontend\Common\Common")->getUniqueCacheKey();
			$filename=$dir.md5("cache.banner_".$CurrentBanner->BannerID.$CacheKey).".txt";
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
				include($filename);
			}
			else{
				@ob_start();
				if(file_exists(dirname(__FILE__)."/Front/View/banner/".basename($file).".php"))
					include(dirname(__FILE__)."/Front/View/banner/".basename($file).".php");
				else
					include(dirname(__FILE__)."/Front/View/banner/default.php");
				
				$Content = ob_get_contents();
				$fp2 = fopen($filename, "w");
				fputs($fp2,$Content);	
				fclose($fp2);
				
			}
			
			if(d("BANNERS_STAT_TRACK")=="1"){
				$BannerObj = new DataTable(TABLE_BANNERS);
				$DataArray = array();
				$DataArray['Impressions'] = isset($CurrentBanner->Impressions)?$CurrentBanner->Impressions+1:1;
				$BannerObj->where[] = array('=',array('BannerID' => $CurrentBanner->BannerID));
				$BannerObj->tableUpdate($DataArray);
			}			
		}
			
	}
	
	public function GetJsonData($url,$param="")
	{
		if($param != "")
		$url = $url."?".$param;
	
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache_json.".md5($url).".txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			return $ReturnArray;
		}
		else
		{
			$data = file_get_contents($url);
			if($data=="" || $data == false){
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, $url);
				//curl_setopt($verify, CURLOPT_POST, true);
				//curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($curl, CURLOPT_TIMEOUT, 15);
				$data = curl_exec($curl);
				curl_close($curl);
			}
			if($data != ""){
				$ReturnArray = json_decode($data);
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				return $ReturnArray;
			}
		
		}
		return false;
	}
	
	public function getTestimonialList($limit=12)
	{
		$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
		$where = new Where();
		$where->equalTo('Active','1');
		$Obj->where = $where;	
		$Obj->AllowPaging =true;
		$Obj->PageSize=$limit;
		$Obj->PageTotalDisplay = 12; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","TestimonialID ASC"));
	
	}
	
	public function getTestimonialHomeList($limit=6)
	{
		$OrderBy = "RAND()";
		$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
		$where = new Where();
		$where->equalTo('Active','1');
		$where->equalTo('Featured','1');
		$Obj->where = $where;	
		$Obj->orderExpression = true;
		return $Obj->tableSelectAll(array("*"),$OrderBy,$limit);
	
	}
	
	function SKAddRemoveParmsFromURL($PageURL,$ExcludeParam= array(),$AddParam=array())
	{
			$url = parse_url($PageURL);
			$path = $url['path'];
			$query = isset($url['query'])?$url['query']:"";
			$FiterArray = array();
			if($query !="")
			{
				parse_str($query,$FiterArray);
			}
			
			foreach ($FiterArray as $k=>$v)
			{
				if(in_array($k,$ExcludeParam))
					unset($FiterArray[$k]);
			}
			$FiterArray = array_merge($FiterArray,$AddParam);
			return  $path."?".urldecode(http_build_query($FiterArray));
		
	}
	
	public function GenerateHTMLSitemapPageList($ParentID=0,$ClassName="sitemap-link")
	{
		$Text="";
		$PageObj = new DataTable(TABLE_CMS_PAGES);
		//$PageObj->where="Active='1' AND PageID >1000 AND ParentID ='".(int)$ParentID."'";
		$PageObj->where="PageID >1000 AND ParentID ='".(int)$ParentID."'";
		$rows = $PageObj->tableSelectAll(array("PageID","PageName","LinkTitle"),"Position ASC");
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<div class="'.$ClassName.'">
							<a href="'.SKSEOURL('cms_pages','Detail',$CurrentRecord->PageID).'">'.MyStripSlashes($CurrentRecord->LinkTitle).'</a>
						</div>';
			$Text .= $this->GenerateHTMLSitemapPageList($CurrentRecord->PageID,$ClassName);  		
			
		 }
		 return (string)$Text;
	
	}
	
	function GetDocumentByUser($UserID,$Active=false)
	{
		$DocumentObj = new DataTable(TABLE_DOCUMENTS);
		$where = new Where();
		//$where->equalTo('DocumentType',"User");
		$where->equalTo('UserID',$UserID);
		if($Active==true)
		$where->equalTo('Active','1');
		
		$DocumentObj->where = $where;
		return $DocumentObj->tableSelectAll("",array("Position ASC","DocumentID DESC"));
	}
	
	function GetAllDocumentofUserWithCategories($UserID)
	{
		$DoumentArray =array();
		
		$DocumentObj = new DataTable(TABLE_DOCUMENTS);
		$where = new Where();
		$where->equalTo('UserID',$UserID);
		$where->equalTo('Active','1');
		
		$DocumentObj->where = $where;
		$rows = $DocumentObj->tableSelectAll("",array("Position ASC","DocumentID DESC"));
		
		if(count($rows) > 0){
			$DoumentArray['Private'] =array("category"=>"My Documents","rows"=>$rows);			
		}
		
		
		$Obj = new DataTable(TABLE_DOCUMENT_CATEGORY);
		$Obj->where="1";
		$where = new Where();
		$where->notEqualTo('CategoryID','1');
		$where->equalTo('Active','1');
		$Obj->where = $where;
		
		$categoryRows = $Obj->tableSelectAll(array("*"),"Position ASC");
		foreach( $categoryRows as $CurrentCategory){
		
			$DocumentObj = new DataTable(TABLE_DOCUMENTS);
			$where = new Where();
			$where->equalTo('CategoryID',$CurrentCategory->CategoryID);
			$where->equalTo('Active','1');
			
			$DocumentObj->where = $where;
			$rows = $DocumentObj->tableSelectAll("",array("Position ASC","DocumentID DESC"));
			
			if(count($rows) > 0){
				$DoumentArray[$CurrentCategory->CategoryID] =array("category"=>$CurrentCategory->CategoryName,"rows"=>$rows);			
			}
			
		}
		
		return $DoumentArray;
	
	}
	
	
	function GetAllDefaultDocuments($Active=false)
	{
		$DoumentArray =array();		
		
		$Obj = new DataTable(TABLE_DOCUMENT_CATEGORY);
		$Obj->where="1";
		$where = new Where();
		$where->notEqualTo('CategoryID','1');
		if($Active==true)
			$where->equalTo('Active','1');
		
		$Obj->where = $where;
		
		$categoryRows = $Obj->tableSelectAll(array("*"),"Position ASC");
		foreach( $categoryRows as $CurrentCategory){
		
			$DocumentObj = new DataTable(TABLE_DOCUMENTS);
			$where = new Where();
			$where->equalTo('CategoryID',$CurrentCategory->CategoryID);
			if($Active==true)
			$where->equalTo('Active','1');	
			
			$DocumentObj->where = $where;
			$rows = $DocumentObj->tableSelectAll("",array("Position ASC","DocumentID DESC"));
			
			if(count($rows) > 0){
				$DoumentArray[$CurrentCategory->CategoryID] =array("category"=>$CurrentCategory->CategoryName,"rows"=>$rows);			
			}
			
		}
		
		return $DoumentArray;
	
	}
	
	public function UploadImageURL($Image,$dir)
	{
		if($Image !="" && file_exists(DIR_FS_SITE_UPLOADS.$dir."/".$Image))
			return DIR_WS_SITE_UPLOADS.$dir."/".$Image;
		
		return false;
	}
	public function getGalleryListByCategory($CategoryID)
	{
		$returnString="";
		$Obj = new DataTable(TABLE_GALLERY_IMAGES);
		$where = new Where();
		$where->equalTo('CategoryID',$CategoryID);
		$where->equalTo('Active','1');	
		
		$Obj->where = $where;
		$rows = $Obj->tableSelectAll("",array("Position ASC","ImageID DESC"));
		$uniqid = uniqid("g_".$CategoryID);
		if(count($rows) > 0){
			$returnString  = '<div class="text-center document-child-grid"><div class="row gutter-lg pt-lg-4">';				
			foreach($rows as $CurrentRecord){
				$returnString .= '
					<div class="col-lg-3 col-sm-6 mb-4">
					  <div class="document-list bg-white border ProBox font-montserrat">
						<div class="document-image">
							<a data-lightbox="'.$uniqid.'" data-title="'.(isset($CurrentRecord->ImageName)?MyStripSlashes($CurrentRecord->ImageName):"").'" href="'.SKSeoImage($CurrentRecord->Image,"600",false).'" target="_blank">'.SKSeoImage($CurrentRecord->Image,"300",array("class"=>"img-fluid d-block mx-auto")).'</a>
						</div>
						<div class="Head font-weight-semi">
							<a href="'.SKSeoImage($CurrentRecord->Image,"600",false).'" target="_blank">'. (isset($CurrentRecord->ImageName)?MyStripSlashes($CurrentRecord->ImageName):"").'</a>
						</div>
					  </div>
					</div>
				';		
			}
			$returnString .= '</div></div>';				
		}
		
		return $returnString;
	}
	
	public function getDocumentListByCategory($CategoryID,$view="grid")
	{
		$returnString="";
		$DocumentObj = new DataTable(TABLE_DOCUMENTS);
		$where = new Where();
		$where->equalTo('CategoryID',$CategoryID);
		$where->equalTo('Active','1');	
		
		$DocumentObj->where = $where;
		$rows = $DocumentObj->tableSelectAll("",array("Position ASC","DocumentID DESC"));
		if(count($rows) > 0){
			
			if($view=="list"){
				
				$returnString  = '<div class="text-center document-child-list"><div class="row gutter-lg pt-lg-4">';				
				foreach($rows as $CurrentRecord){
					$returnString .= '
						<div class="col-lg-3 col-sm-6 mb-4">
						  <div class="document-list bg-white border ProBox font-montserrat p-3">
							<div class="Head font-weight-semi text-start">
								<h3>'. (isset($CurrentRecord->DocumentName)?MyStripSlashes($CurrentRecord->DocumentName):"").'</h3>
								<a href="'.$this->UploadImageURL($CurrentRecord->Upload,"document").'" target="_blank">Download PDF</a>
							</div>
						  </div>
						</div>
					';		
				}
				$returnString .= '</div></div>';	
				
			}
			if($view=="grid"){
				$returnString  = '<div class="text-center document-child-grid"><div class="row gutter-lg pt-lg-4">';				
				foreach($rows as $CurrentRecord){
					$returnString .= '
						<div class="col-lg-3 col-sm-6 mb-4">
						  <div class="document-list bg-white border ProBox font-montserrat">
							<div class="document-image"><a href="'.$this->UploadImageURL($CurrentRecord->Upload,"document").'" target="_blank"><img src="'.SKImgDisplay(DIR_FS_SITE_UPLOADS."document/".$CurrentRecord->Image,"250,250,true").'" alt="'. (isset($CurrentRecord->DocumentName)?MyStripSlashes($CurrentRecord->DocumentName):"").'" class="img-fluid d-block mx-auto" /></a></div>
							<div class="Head font-weight-semi">
								<a href="'.$this->UploadImageURL($CurrentRecord->Upload,"document").'" target="_blank">'. (isset($CurrentRecord->DocumentName)?MyStripSlashes($CurrentRecord->DocumentName):"").'</a>
							</div>
						  </div>
						</div>
					';		
				}
				$returnString .= '</div></div>';	
			}	
		}
		
		return $returnString;
	}
	
	
	public function SKEditorTags($tag,$TagString,$TagID)
	{
		$returnString = "";
		if(strtolower($TagString)=="documentcategory" && $TagID > 0){
			$returnString = $this->getDocumentListByCategory($TagID,"list");
		}
		
		if(strtolower($TagString)=="gallerycategory" && $TagID > 0){
			$returnString = $this->getGalleryListByCategory($TagID);
		}
		if(strtolower($TagString)=="faqs" && $TagID != ""){
			$returnString = $this->getClass("Cms\Faqs\Common")->getContentFaqs($TagID);
		}
		
		return $returnString;
	}
	function ClearCacheFiles()
	{
		$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
		$this->getClass("Base\File\FileHandle")->SKClearPrivateSecondaryCache();
	}
	
	function ClearCacheThumbnailImages()
	{
		$this->getClass("Base\File\FileHandle")->SKClearImageCache();
	}
	function GetImageTypeArray()
	{
		return array("Jpg","Jpeg","Gif","Bmp","Png");
	}
	function CheckImageFromFront($src)
	{	
			if($src == "")
				return false;
			
			if(strpos($src,"?"))		   {
			   $arr = explode("?",$src);
			   $src = $arr[0];
		   } 
			return in_array(ucfirst(strtolower(pathinfo($src, PATHINFO_EXTENSION))),$this->GetImageTypeArray());

	}
	
	
}	