<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Frontend\Base\FrontTheme as FrontTheme;

class ThirdpartyController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Thirdparty");
	}
	
	
	public function generateAction()
	{
		$themeConfig = include(DIR_FS_SITE."/templates/front/".d("FRONT_THEME")."/settings.php");	
		define('FRONT_THEME_URL',$themeConfig['theme']['theme_url']);
		define('FRONT_THEME_PATH',$themeConfig['theme']['theme_path']);
		if(isset($themeConfig['theme']['includes']) && is_array($themeConfig['theme']['includes'])){
			foreach($themeConfig['theme']['includes'] as $k=>$file){
				if($file != "" && file_exists($file))
					include_once ($file);
			}
		}
		$themeObj = new FrontTheme();
		$themeObj->setTheme($themeConfig['theme']['class_key']);
		
		@ob_start();
		$themeObj->getHeaderCss();
		$themeObj->getHeaderJs();
		$ContentMeta = ob_get_clean();
		if($ContentMeta != ""){
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/thirdparty");
			$filename=$dir."meta.txt";
			$fp2 = fopen($filename, "w");
			fputs($fp2,$ContentMeta);	
			fclose($fp2);
		}
		
		@ob_start();
		$themeObj->getHeader();
		$ContentHeader= ob_get_clean();
		if($ContentHeader != ""){
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/thirdparty");
			$filename=$dir."header.txt";
			$fp2 = fopen($filename, "w");
			fputs($fp2,$ContentHeader);	
			fclose($fp2);
		}
		
		@ob_start();
		$themeObj->getFooter();
		$themeObj->getFooterJs();
		$this->getClass("Cms\Pages\Common")->getAdsByCategoryID($themeObj,1);
		$ContentFooter= ob_get_clean();
		if($ContentFooter != ""){
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/thirdparty");
			$filename=$dir."footer.txt";
			$fp2 = fopen($filename, "w");
			fputs($fp2,$ContentFooter);	
			fclose($fp2);
		}
		var_dump("Done");exit;	
			
	}
	
	public function phpBB3ForumAdminAction()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$admin = $this->getSession()->getVar("admin");
		if(isset($admin['UserName'])){
			unset($admin['Password']);
		
			$data = $SessionID."&&&".serialize($admin);
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			
			$FormString = '<html>
							<head>
							<title></title>
							<script type="text/javascript">
							function FormSubmission()
							{
								FormObj = document.getElementById(\'FormRt\');
								FormObj.submit();
								return true;
							}
							</script>
							</head>
							<body onload="return FormSubmission();">
							<form name="FormRt" target="_top"  id="FormRt" action="'.DIR_WS_SITE.'forum/index.php" method="POST">';
							$FormString .= '<input type="hidden" name="sk_token" value="'. $Key .'" />';
							$FormString .= '<input type="hidden" name="sk_party" value="PHPBB3" />';
				
		$FormString .= '<br>If this page appears for more than five seconds <button type="submit" onclick="return FormSubmission();">click here to reload.</button>
						  </form>
							</body>
						</html>';
		
			echo $FormString;exit;
		}
		
	}
	
	public function WordpressAdminAction()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$admin = $this->getSession()->getVar("admin");
		if(isset($admin['UserName'])){
			unset($admin['Password']);
			
			require_once DIR_FS_SITE . '/blog/wp-load.php';
			global $wpdb;
			$row = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."users ORDER BY ID ASC");
			if(is_object($row)){
				$user_id= $row->ID;
				$user = get_userdata( $user_id );
				wp_set_current_user($user_id); // set the current wp user
				wp_set_auth_cookie($user_id);
				do_action( 'wp_login', $row->user_login );
				
			}
			MyRedirect(DIR_WS_SITE."blog/wp-admin/");
     		exit;
			
			
			/*$data = date('YmdHis')."&&&".$SessionID."&&&".serialize($admin);
			$Key = MyEncryptData($data, d("ENCRYPTION_PRIVATE_KEY"),d("ENCRYPTION_PRIVATE_IV"));
			
			$FormString = '<html>
							<head>
							<title></title>
							<script type="text/javascript">
							function FormSubmission()
							{
								FormObj = document.getElementById(\'FormRt\');
								FormObj.submit();
								return true;
							}
							</script>
							</head>
							<body onload="return FormSubmission();">
							<form name="FormRt" target="_top"  id="FormRt" action="'.DIR_WS_SITE.'blog/index.php" method="POST">';
							$FormString .= '<input type="hidden" name="sk_token" value="'. $Key .'" />';
							$FormString .= '<input type="hidden" name="sk_party" value="WORDPRESS" />';
				
							$FormString .= '<br>If this page appears for more than five seconds <button type="submit" onclick="return FormSubmission();">click here to reload.</button>
						  </form>
							</body>
						</html>';
		
			echo $FormString;exit;
			*/
		}
		
	}
	
	
	public function pageTitle()
	{
		return "Thirdparty";
	}
	
	public function pageRight()
	{
		
	}
	
	
	
	
}	