<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class TestimonialController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewTestimonials");
	}
	
	
	public function AddEditTestimonialAction()
	{
		if(count($_POST)>0)
		{
			$TestimonialObj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
			$TestimonialID = isset($_GET['TestimonialID'])?$_GET['TestimonialID']:0;
			

			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
			
			$DataArray['ClientName'] = isset($_POST['ClientName'])?$_POST['ClientName']:"";
			$DataArray['ClientEmail'] = isset($_POST['ClientEmail'])?$_POST['ClientEmail']:"";
			$DataArray['ClientPhone'] = isset($_POST['ClientPhone'])?$_POST['ClientPhone']:"";
			$DataArray['ClientLocation'] = isset($_POST['ClientLocation'])?$_POST['ClientLocation']:"";			
			$DataArray['ClientCountry'] = isset($_POST['ClientCountry'])?$_POST['ClientCountry']:"";			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
				
			/* other image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_other",'other',"");
			/* other image end*/
			
			
			if($TestimonialID > 0)
			{
				
				$TestimonialObj->where[] = array('=',array('TestimonialID' => $TestimonialID));
				$TestimonialObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Testimonial updated successfully."));
				
			}
			else 
			{
				$TestimonialObj->where ="1";
				$Position = $TestimonialObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$TestimonialObj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
				$TestimonialID = $TestimonialObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Testimonial added successfully."));
				
			}
					
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewTestimonials&TestimonialID=$TestimonialID");
			exit;
		}
		
	}
	
	public function UpdateTestimonialAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$TestimonialObj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
				$TestimonialID =$_POST['TestimonialID_'.$i];
				$DataArray = array();
				$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$TestimonialObj->where[] = array('=',array('TestimonialID' => $TestimonialID));
				$TestimonialObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Testimonial updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewTestimonials");
			 exit;
		}
	}
	
	public function DeleteTestimonialAction()
	{
		$TestimonialID = isset($_GET['TestimonialID'])?$_GET['TestimonialID']:0;
		$Obj = $this->getTestimonialDetail($TestimonialID);
		
		if($TestimonialID > 0)
		{
			$TestimonialObj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
			$TestimonialObj->where[] = array('=',array('TestimonialID' => $TestimonialID));
			$TestimonialObj->tableDelete();		
			if(isset($Obj->Image) && $Obj->Image !="")
				$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
			
		}			
		$this->getSession()->setArrVar("alert",array("success","Testimonial deleted successfully."));
		
		 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewTestimonials");
		 exit;
	}
	
	public function getTestimonialDetail($TestimonialID)
	{
		if($TestimonialID > 0)
		{
			$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
			$Obj->where[] = array('=',array('TestimonialID' => $TestimonialID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
		
	public function getTestimonialList()
	{
		$Obj = new DataTable(TABLE_PLUGIN_TESTIMONIALS);
		$Obj->AllowPaging =true;
		$Obj->PageSize=50;
		$Obj->PageTotalDisplay = 15; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","TestimonialID ASC"));
	}
	
	
		
	public function ImageTestimonialURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."other/".$Image))
			return DIR_WS_SITE_UPLOADS."other/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Testimonial Manager";
	}
	
	public function pageRight()
	{
		if($this->origin->getView()=="ViewTestimonials"){
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditTestimonial">Add Testimonial</a>
					</div>
              </div>		
			   ';
		}
	}
	
	
	
	
}	