<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class SitemapController extends AbstractModule
{
	function __construct()
	{
		$this->tab = isset($_GET['tab'])?$_GET['tab']:"2";
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Sitemap");
	}
	
	function GzSitemapCreate($filename)
	{
		$string = file_get_contents($filename);
		$gz = gzopen($filename.'.gz','w9');
		gzwrite($gz, $string);
		gzclose($gz);
	}
	
	function AddEditRobotsAction()
	{
		if(count($_POST) > 0){
			$filename=DIR_FS_SITE."robots.txt";
			$Content = isset($_POST['Content'])?$_POST['Content']:"";
			$fp2 = fopen($filename, "w");
			fputs($fp2,$Content);	
				fclose($fp2);
			
			$this->getSession()->setArrVar("alert",array("success","Updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		    exit;
			
		}
	}
	
	function AddEditManualSitemapAction()
	{
		if(count($_POST) > 0){
			$filename=DIR_FS_SITE."sitemap.xml";
			$Content = isset($_POST['Content'])?$_POST['Content']:"";
			$fp2 = fopen($filename, "w");
			fputs($fp2,$Content);	
				fclose($fp2);
			
			$this->GzSitemapCreate($filename);
			$this->getSession()->setArrVar("alert",array("success","Updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		    exit;
			
		}
	}
	function AddEditSitemapAction()
	{
		if(count($_POST) > 0){
			
			$SitemapFile = "sitemap.xml";
			$ContentSite = "";
			$ContentSite .= $this->GeneratePageList(0);
			$ContentSite .= $this->GenerateCategoryList(0);
			$ContentSite .= $this->GenerateProductList();
			if($ContentSite != ""){
				$filename=DIR_FS_SITE.$SitemapFile;
				$fp2 = fopen($filename, "w");
				$SitemapContent='<?xml version="1.0" encoding="UTF-8"?>
	<urlset xmlns="http://www.google.com/schemas/sitemap/0.84"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.google.com/schemas/sitemap/0.84
                      http://www.google.com/schemas/sitemap/0.84/sitemap.xsd">'.$ContentSite."</urlset>";
					  
				
				fputs($fp2,$SitemapContent);	
				fclose($fp2);
				$this->GzSitemapCreate($filename);
			}
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		    exit;
		}
	}
	
	public function GeneratePageList($ParentID)
	{
		$Text="";
		$PageObj = new DataTable(TABLE_CMS_PAGES);
		//$PageObj->where="Active='1' AND PageID >1000 AND ParentID ='".(int)$ParentID."'";
		$PageObj->where="PageID >1000 AND ParentID ='".(int)$ParentID."'";
		$rows = $PageObj->tableSelectAll(array("PageID"),"Position ASC");
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<url>
						<loc>'.str_replace("&","&amp;",SKSEOURL('cms_pages','Detail',$CurrentRecord->PageID)).'</loc>
						<lastmod>'.date('Y-m-d').'</lastmod>
						<changefreq>daily</changefreq>
						<priority>'.($ParentID==0?'1.0':'0.5').'</priority>
					</url>';
			$Text .= $this->GeneratePageList($CurrentRecord->PageID);  		
			
		 }
		 return (string)$Text;
	
	}
	
	public function GenerateCategoryList($ParentID)
	{
		$Text="";
		$TmpObj = new DataTable(TABLE_CATEGORY);
		$TmpObj->where="Active='1' AND ParentID ='".(int)$ParentID."'";
		$rows = $TmpObj->tableSelectAll(array("CategoryID"),"Position ASC");
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<url>
						<loc>'.str_replace("&","&amp;",SKSEOURL('catalog_category','Detail',$CurrentRecord->CategoryID)).'</loc>
						<lastmod>'.date('Y-m-d').'</lastmod>
						<changefreq>daily</changefreq>
						<priority>'.($ParentID==0?'1.0':'0.5').'</priority>
					</url>';
			$Text .= $this->GenerateCategoryList($CurrentRecord->CategoryID);  		
			
		 }
		 return (string)$Text;
	
	}
	
	public function GenerateProductList()
	{
		$Text="";
		$where = new Where();
		$TmpObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->in('p.ProductType',array('Simple','Attribute'));
		$where->equalTo('p.Active','1');
		$TmpObj->where = $where;
		$rows = $TmpObj->tableSelectAll(array("ProductID"),array("ProductName ASC"));
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<url>
						<loc>'.str_replace("&","&amp;",SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID)).'</loc>
						<lastmod>'.date('Y-m-d').'</lastmod>
						<changefreq>daily</changefreq>
						<priority>1.0</priority>
					</url>';
		 }
		 return (string)$Text;
	
	}
	public function pageTitle()
	{
		return "Sitemap";
	}
	
	public function pageRight()
	{
		
	}
	
	
	
	
}	