<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;

class SettingController extends AbstractModule
{
	function __construct()
	{
		$this->tab = isset($_GET['tab'])?$_GET['tab']:"2";
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Setting");
	}
	
	public function EditConfigAction()
	{
		if(count($_POST) > 0){
			
			$tab = isset($_GET['tab'])?$_GET['tab']:"";
			$DM = isset($_GET['DM'])?$_GET['DM']:"0";
			foreach($_POST['Config'] as $key=>$value){
				$Obj = new DataTable(TABLE_CONF_GROUP_DEFINE);
				$DataArray = array();
				$DataArray['DefineValue'] = $value;
				$Obj->where[] = array('=',array('DefineKey' => $key));
				$Obj->tableUpdate($DataArray);
			}
		
			$dir = FileHandle::CheckPrivateLogDirectory("cache");
			$filename=$dir."cache.define.txt";
			if(file_exists($filename))
				unlink($filename);
			
			$this->getSession()->setArrVar("alert",array("success","Settings updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&tab=$tab&DM=$DM");
			 exit;
			
		}
	}
	public function getConfigList($GroupID)
	{
		$DevelopmerMode = isset($_GET['DM'])?$_GET['DM']:"0";
		$Obj = new DataTable(TABLE_CONF_GROUP_DEFINE);
		$Obj->where[] = array('=',array('GroupID' => $GroupID));
		if($DevelopmerMode != "1")
			$Obj->where[] = array('=',array('AdminDisplay' => "1"));
			
		return $Obj->tableSelectAll(array("*"),array("SortOrder ASC","DefineID ASC"));
	}
	
	public function getConfigGroup()
	{
		$DevelopmerMode = isset($_GET['DM'])?$_GET['DM']:"0";
		$Obj = new DataTable(TABLE_CONF_GROUP);
		if($DevelopmerMode != "1")
			$Obj->where[] = array('=',array('AdminDisplay' => "1"));
			
		return $Obj->tableSelectAll(array("*"),array("SortOrder ASC","GroupID ASC"));
	}
	
	public function ClearCacheAction()
	{
		$this->getClass("Cms\Pages\Common")->ClearCacheFiles();
		echo "Done";exit;
	}
	
	public function ClearCronLogAction()
	{
		$this->getClass("Base\File\FileHandle")->SKClearCronLog();
		echo "Done";exit;
	}
	
	public function ClearErrorLogAction()
	{
		$this->getClass("Base\File\FileHandle")->SKClearErrorLog();
		echo "Done";exit;
	}
	
	public function ClearThumbnailImagesAction()
	{
		$this->getClass("Cms\Pages\Common")->ClearCacheThumbnailImages();
		echo "Done";exit;
	}
	
	public function pageTitle()
	{
		return "Settings";
	}
	
	public function pageRight()
	{
		
	}
	
	
	
	
}	