<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class RedirectController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewRedirect");
	}
	
	public function AddEditRedirectAction()
	{
		if(count($_POST)>0)
		{
			$RedirectObj = new DataTable(TABLE_REDIRECT);
			$RedirectID = isset($_GET['RedirectID'])?$_GET['RedirectID']:0;

			$DataArray = array();
			$DataArray['SourceURL'] = isset($_POST['SourceURL'])?$_POST['SourceURL']:"";
			$DataArray['DestinationURL'] = isset($_POST['DestinationURL'])?$_POST['DestinationURL']:"";
			
			if($DataArray['SourceURL'] == $DataArray['DestinationURL']){
				$this->getSession()->setArrVar("alert",array("danger","Source URL and destination URL not same."));
			}	
			
			$RObj = new DataTable(TABLE_REDIRECT);
			$RObj->where[] = array('=',array('SourceURL' => $DataArray['DestinationURL']));
			$RObj->columnExpression=true;
			$Obj = $RObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger","DestinationURL is invalid."));
					
			$RObj = new DataTable(TABLE_REDIRECT);
			$RObj->where[] = array('=',array('SourceURL' => $DataArray['SourceURL']));
			$RObj->columnExpression=true;
			$Obj = $RObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger","SourceURL is invalid."));
			
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)	{ 
				if($RedirectID > 0)
				{
					
					$RedirectObj->where[] = array('=',array('RedirectID' => $RedirectID));
					$RedirectObj->tableUpdate($DataArray);
					$this->getSession()->setArrVar("alert",array("success","Redirect updated successfully."));
					
				}
				else 
				{
								
					$RedirectID = $RedirectObj->tableInsert($DataArray);		
					$this->getSession()->setArrVar("alert",array("success","Redirect added successfully."));
					
				}
				
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewRedirect&RedirectID=$RedirectID");
				exit;
			 }
			
		}
		
	}
	
	public function DeleteRedirectAction()
	{
		$RedirectID = isset($_GET['RedirectID'])?$_GET['RedirectID']:0;
		$obj = $this->getDetail($RedirectID);
		
		if($RedirectID > 0 && $obj->DefaultValue != "1")
		{
			$RedirectObj = new DataTable(TABLE_REDIRECT);
			$RedirectObj->where[] = array('=',array('RedirectID' => $RedirectID));
			$RedirectObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Redirect deleted successfully."));
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewRedirect");
		 exit;
	}
	public function getList()
	{
		
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$where = new Where();
		
		
		$RedirectObj = new DataTable(TABLE_REDIRECT);
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('SourceURL','%'.$Value.'%')->OR
							->like('DestinationURL','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$RedirectObj->where = $where;
		
		$RedirectObj->orderExpression = true;
		$RedirectObj->AllowPaging =true;
		$RedirectObj->PageSize=100;
		$RedirectObj->PageTotalDisplay = 15; 
		$RedirectObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $RedirectObj;
		return $RedirectObj->tableSelectAll(array("*"),"SourceURL ASC");
	
	}
	
	
	public function getDetail($RedirectID)
	{
		if($RedirectID > 0)
		{
			$RedirectObj = new DataTable(array('m'=>TABLE_REDIRECT));
			$RedirectObj->where[] = array('=',array('m.RedirectID' => $RedirectID));
			return (object)$RedirectObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Redirect";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-success" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'">View Redirect</a>
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditRedirect">Add Redirect</a>
					</div>
              </div>		
			   ';
	}
	
	
}	