<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class NoteController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
	
	}
	
	
	public function AddEditBannerAction()
	{
		if(count($_POST)>0)
		{
			$BannerObj = new DataTable(TABLE_BANNERS);
			$BannerID = isset($_GET['BannerID'])?$_GET['BannerID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['BannerName'] = isset($_POST['BannerName'])?$_POST['BannerName']:"";
			$DataArray['BannerTitle'] = isset($_POST['BannerTitle'])?$_POST['BannerTitle']:"";
			$DataArray['BannerType'] = isset($_POST['BannerType'])?$_POST['BannerType']:"Image";
			
			$DataArray['Content'] = isset($_POST['Content'])?$_POST['Content']:"";
			$DataArray['EmbedCode'] = isset($_POST['EmbedCode'])?$_POST['EmbedCode']:"";
			$DataArray['LinkType'] = isset($_POST['LinkType'])?$_POST['LinkType']:"";
			$DataArray['Link'] = isset($_POST['Link'])?$_POST['Link']:"";
			
			$DataArray['StartDate'] = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			$DataArray['EndDate'] = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']:NULL;
			$DataArray['CounterDate'] = (isset($_POST['CounterDate']) && $_POST['CounterDate'] != "")?$_POST['CounterDate']:NULL;
			$DataArray['CounterStatus'] = isset($_POST['CounterStatus'])?(int)$_POST['CounterStatus']:"0";
			
			/* banner image added*/
			if(isset($_POST['BannerImage']) && $_POST['BannerImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."banner/".$_POST['BannerImage']))
			{
				if(isset($_POST['BannerImageDelete']) && $_POST['BannerImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."banner/".$_POST['BannerImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid("Banner_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."banner/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['BannerImage']) && $_POST['BannerImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."banner/".$_POST['BannerImage']))
					@unlink(DIR_FS_SITE_UPLOADS."banner/".$_POST['BannerImage']);
			}
			/* banner image added end*/
			
			if($BannerID > 0)
			{
				
				$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
				$BannerObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Banner updated successfully."));
				
			}
			else 
			{
				$BannerObj->where ="CategoryID='".$CategoryID."'";
				$Position = $BannerObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CategoryID'] = $CategoryID;
				
				$DataArray['Clicks'] = "0";
				$DataArray['Impressions'] = "0";
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$BannerObj = new DataTable(TABLE_BANNERS);
				$BannerID = $BannerObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Banner added successfully."));
				
			}
					
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID&BannerID=$BannerID");
			exit;
		}
		
	}
	
	public function UpdateBannerAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$BannerObj = new DataTable(TABLE_BANNERS);
				$BannerID =$_POST['BannerID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
				$BannerObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Banner updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID");
			 exit;
		}
	}
	
	public function DeleteBannerAction()
	{
		$BannerID = isset($_GET['BannerID'])?$_GET['BannerID']:0;
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$Obj = $this->getBannerDetail($BannerID);
		
		if($BannerID > 0)
		{
			$BannerObj = new DataTable(TABLE_BANNERS);
			$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
			$BannerObj->tableDelete();		
			if(isset($Obj->Image) && $Obj->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."banner/".$Obj->Image))
					@unlink(DIR_FS_SITE_UPLOADS."banner/".$Obj->Image);	
			
		}			
		$this->getSession()->setArrVar("alert",array("success","Banner deleted successfully."));
		
		 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID");
		 exit;
	}
	
	public function getBannerDetail($BannerID)
	{
		if($BannerID > 0)
		{
			$Obj = new DataTable(TABLE_BANNERS);
			$Obj->where[] = array('=',array('BannerID' => $BannerID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	public function BannerCount($CategoryID)
	{
		$Obj = new DataTable(TABLE_BANNERS);
		
		$Obj->columnExpression=true;
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj = $Obj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function AddNoteAction()
	{
		if(count($_POST)>0){
			$NoteObj = new DataTable(TABLE_NOTES);
			$DataArray = array();
			$DataArray['ReferenceID'] = isset($_POST['ReferenceID'])?$_POST['ReferenceID']:"";
			$DataArray['ReferenceType'] = isset($_POST['ReferenceType'])?$_POST['ReferenceType']:"";
			$DataArray['NoteSection'] = isset($_POST['NoteSection'])?$_POST['NoteSection']:"";
			$DataArray['NoteMessage'] = isset($_POST['NoteMessage'])?$_POST['NoteMessage']:"";
			$DataArray['FrontDisplay'] = isset($_POST['FrontDisplay'])?$_POST['FrontDisplay']:"0";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			$NoteObj->TableInsert($DataArray);
		}
		
		@ob_clean();
		echo "Note added successfully.";
		exit;
	}
	public function DeleteNoteAction()
	{
		if(count($_POST)>0){
			$ReferenceID = isset($_POST['ReferenceID'])?$_POST['ReferenceID']:"";
			$ReferenceType = isset($_POST['ReferenceType'])?$_POST['ReferenceType']:"";
			$NoteSection = isset($_POST['NoteSection'])?$_POST['NoteSection']:"";
			$FrontDisplay = isset($_POST['FrontDisplay'])?$_POST['FrontDisplay']:"0";
			$NoteID = isset($_POST['NoteID'])?$_POST['NoteID']:"";
			if($ReferenceID != "" && $ReferenceType != "" && $NoteID > 0){
			
				$Obj = new DataTable(TABLE_NOTES);
				$Obj->where[] = array('=',array('NoteID' => $NoteID));
				$Obj->where[] = array('=',array('ReferenceID' => $ReferenceID));
				$Obj->where[] = array('=',array('ReferenceType' => $ReferenceType));
					
				if($NoteSection != "")
					$Obj->where[] = array('=',array('NoteSection' => $NoteSection));
				
				$Obj->tableDelete();		
				echo "Note Deleted successfully.";
				exit;
			}
			echo "Invalid Request. Try Again.";
			exit;
		
		}		
	}
	
	public function DisplayNoteAction()
	{
		if(count($_POST)>0){
			$ReferenceID = isset($_POST['ReferenceID'])?$_POST['ReferenceID']:"";
			$ReferenceType = isset($_POST['ReferenceType'])?$_POST['ReferenceType']:"";
			$NoteSection = isset($_POST['NoteSection'])?$_POST['NoteSection']:"";
			$FrontDisplay = isset($_POST['FrontDisplay'])?$_POST['FrontDisplay']:"0";
			
			if($ReferenceID != "" && $ReferenceType != ""){
				$Obj = new DataTable(TABLE_NOTES);
				$Obj->where[] = array('=',array('ReferenceID' => $ReferenceID));
				$Obj->where[] = array('=',array('ReferenceType' => $ReferenceType));
				if($NoteSection != "")
					$Obj->where[] = array('=',array('NoteSection' => $NoteSection));
				
				$rows = $Obj->tableSelectAll(array("*"),array("NoteID DESC"));
				
				if(count($rows) > 0)
				{
					$Content = '<h3>NOTES</h3><table border="0" cellpadding="3" cellspacing="1" width="100%" class="table table-striped jambo_table">';
					$Content .= '<thead><tr class="InsideLeftTd"><th align="left" width="200"><b>Date</b></th><th align="left"><b>Note</b></th><th align="center"><b>Delete</b></th></tr></thead>';
					foreach($rows as $CurrentNote){
						$Content .= '<tr><td>'.ConvertDateFromDb($CurrentNote->CreatedDate,true).'</td><td align="left">'.MyStripSlashes(nl2br($CurrentNote->NoteMessage)).'</td><td align="center"><a href="javascript:;" rel="'.$CurrentNote->NoteID.'" class="NoteDelete btn btn-danger btn-xs"><i class="fa fa-trash-o"></i> Delete</a></b></td></tr>';
					}
					
					$Content .= '</table>';
					
					echo $Content;
					exit;				
				}
				else
				{
					echo "No Notes.";
					exit;
				}	
				
				
			}
		}
		exit;
	}
	
	
	public function pageTitle()
	{
		return "Notes";
	}
	
	public function pageRight()
	{
		
	}
	
	
	
	
}	