<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class NoindexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewNoindex");
	}
	
	public function AddEditNoindexAction()
	{
		if(count($_POST)>0)
		{
			$NoindexObj = new DataTable(TABLE_NOINDEX);
			$NoindexID = isset($_GET['NoindexID'])?$_GET['NoindexID']:0;

			$DataArray = array();
			$DataArray['SourceURL'] = isset($_POST['SourceURL'])?$_POST['SourceURL']:"";
			
			$RObj = new DataTable(TABLE_NOINDEX);
			$RObj->where[] = array('=',array('SourceURL' => $DataArray['SourceURL']));
			$RObj->columnExpression=true;
			$Obj = $RObj->tableSelectOne(array('Total'=>'Count(*)'));
			if($Obj['Total'] > 0)
				$this->getSession()->setArrVar("alert",array("danger","URL already exist."));
					
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)	{ 
				if($NoindexID > 0)
				{
					
					$NoindexObj->where[] = array('=',array('NoindexID' => $NoindexID));
					$NoindexObj->tableUpdate($DataArray);
					$this->getSession()->setArrVar("alert",array("success","Noindex updated successfully."));
					
				}
				else 
				{
								
					$NoindexID = $NoindexObj->tableInsert($DataArray);		
					$this->getSession()->setArrVar("alert",array("success","Noindex added successfully."));
					
				}
				
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewNoindex&NoindexID=$NoindexID");
				exit;
			 }
			
		}
		
	}
	
	public function DeleteNoindexAction()
	{
		$NoindexID = isset($_GET['NoindexID'])?$_GET['NoindexID']:0;
		
		if($NoindexID > 0)
		{
			$NoindexObj = new DataTable(TABLE_NOINDEX);
			$NoindexObj->where[] = array('=',array('NoindexID' => $NoindexID));
			$NoindexObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Noindex deleted successfully."));
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewNoindex");
		 exit;
	}
	public function getList()
	{
		$NoindexObj = new DataTable(TABLE_NOINDEX);
		$NoindexObj->where = "1";
		
		$NoindexObj->orderExpression = true;
		$NoindexObj->AllowPaging =true;
		$NoindexObj->PageSize=100;
		$NoindexObj->PageTotalDisplay = 15; 
		$NoindexObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $NoindexObj;
		return $NoindexObj->tableSelectAll(array("*"),"SourceURL ASC");
	
	}
	
	
	public function getDetail($NoindexID)
	{
		if($NoindexID > 0)
		{
			$NoindexObj = new DataTable(array('m'=>TABLE_NOINDEX));
			$NoindexObj->where[] = array('=',array('m.NoindexID' => $NoindexID));
			return (object)$NoindexObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Noindex";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-success" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'">View No Index</a>
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditNoindex">Add No Index</a>
					</div>
              </div>		
			   ';
	}
	
	
}	