<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Cms\Pages\Common as PagesCommon;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getPagesCommon()
	{
		$obj = new PagesCommon();
		return $obj;
	}
	
	public function AddPageAction()
	{
		if(count($_POST)>0)
		{
			$PageObj = new DataTable(TABLE_CMS_PAGES);
			$SeoObj = new DataTable(TABLE_SEO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PageID = isset($_GET['PageID'])?$_GET['PageID']:0;


			$DataArray = array();
			$DataArray['ParentID'] =$ParentID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['PageName'] = isset($_POST['PageName'])?$_POST['PageName']:"";
			$DataArray['LinkTitle'] = isset($_POST['LinkTitle'])?$_POST['LinkTitle']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['LeftTitle1'] = isset($_POST['LeftTitle1'])?$_POST['LeftTitle1']:"";
			$DataArray['LeftDescription1'] = isset($_POST['LeftDescription1'])?$_POST['LeftDescription1']:"";
			$DataArray['LeftDescription2'] = isset($_POST['LeftDescription2'])?$_POST['LeftDescription2']:"";
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			$DataArray['PluginID'] = (isset($_POST['PluginID']) && $_POST['PluginID'] > 0)?$_POST['PluginID']:0;
			
			/* other image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_other",'other',"");
			/* other image end*/
			
			if($PageID > 0)
			{
				$PageObj->where[] = array('=',array('PageID' => $PageID));
				$PageObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Page updated successfully."));
				
			}
			else 
			{
							
				$PageObj->where ="ParentID='".$ParentID."'";
				$Position = $PageObj->getMax("Position") + 1;
				
				$DataArray['ModuleKey'] = "1";
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$PageID = $PageObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Page added successfully."));
				
			}
			
			
			
			$CurrentSEO = $this->getPageDetail($PageID);
			
			$DataArray = array();
			$URL = 	SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['PageName']);
			$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'cms_pages','Detail',$PageID);
			$DataArray['URLName'] = $URL;
			
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->URLID) && $CurrentSEO->URLID !="")
			{
				$SeoObj->where = "URLID = ".$CurrentSEO->URLID."";
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "cms_pages";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $PageID;
				$SeoObj->tableInsert($DataArray);
			}
					

			if(isset($_POST['SaveThis']) && $_POST['SaveThis']=="1")
			{
				$DataTableObj= new DataTable(TABLE_BACKUP);
				$DataArray = array();
				$DataArray['ReferenceID'] = $PageID;
				$DataArray['Page'] = "cms_pages";
				$DataArray['Dumps'] = base64_encode(serialize($_POST));
				$DataArray['CreatedDate'] = date('YmdHis');
			
				$DataTableObj->tableInsert($DataArray);
			}	
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
		    exit;
		}
		
	}
	public function UpdatePageAction()
	{
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		if(count($_POST)>0)
		{
			$PageObj = new DataTable(TABLE_CMS_PAGES);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$PageID =$_POST['PageID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				if($PageID > 1000)
				{
					$PageObj->where="PageID ='".(int)$PageID."'";
					$PageObj->tableUpdate($DataArray);
				}
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Page updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
			 exit;
		}
	}
	
	public function DeletePageAction()
	{
		$PageID = isset($_GET['PageID'])?$_GET['PageID']:0;
		if($PageID > 0)
		{
			$PageObj = new DataTable(TABLE_CMS_PAGES);
			$PageObj->where[] = array('=',array('PageID' => $PageID));
			$PageObj->tableDelete();								
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$PageID." AND MCode ='cms_pages' ";
			$SeoObj->tableDelete();		
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Page deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$PageObj = new DataTable(TABLE_CMS_PAGES);
		$PageObj->orderExpression = true;
		$PageObj->where="ParentID ='".(int)$ParentID."'";
		return $PageObj->tableSelectAll(array("*"),"PageID >1000 DESC,Position ASC");
	
	}
	
	public function subPagesCount($ParentID)
	{
		$CategoryObj = new DataTable(TABLE_CMS_PAGES);
		$CategoryObj->where="ParentID ='".(int)$ParentID."'";
		$CategoryObj->columnExpression=true;
		$Obj = $CategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getPageDetail($PageID)
	{
		return $this->getPagesCommon()->getPageByPageID($PageID);
	}
	
	public function pageTitle()
	{
		$ParentPage = $this->getPageDetail($this->origin->ParentID);
		return ($ParentPage->PageName.""??"")." Pages";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&view=AddPage">Add Page</a>
					</div>
              </div>		
			   ';
	}
	
	
}	