<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class GalleryController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewGallery");
	}
	
	public function AddEditGalleryCategoryAction()
	{
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_GALLERY_CATEGORY);
			$SeoObj = new DataTable(TABLE_SEO);
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['CategoryName'] = isset($_POST['CategoryName'])?$_POST['CategoryName']:"";
			/* category image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_gallery",'gallery',$DataArray['CategoryName']);
			/* category image end*/
			
			
			if($CategoryID > 0)
			{
				$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$CategoryObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Category updated successfully."));
				
			}
			else 
			{
							
				$CategoryObj->where ="1";
				$Position = $CategoryObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$CategoryID = $CategoryObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Category added successfully."));
				
			}
			
			
			
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='cms_gallery' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$URL = 	SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['CategoryName']);
			$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'cms_gallery','Detail',$CategoryID);
			$DataArray['URLName'] = $URL;
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "cms_gallery";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $CategoryID;
				$SeoObj->tableInsert($DataArray);
			}
					
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&CategoryID=$CategoryID");
		    exit;
		}
		
	}
	public function UpdateCategoryAction()
	{
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_GALLERY_CATEGORY);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CategoryID =$_POST['CategoryID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$CategoryObj->where="CategoryID ='".(int)$CategoryID."'";
				$CategoryObj->tableUpdate($DataArray);
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Gallery updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."");
			 exit;
		}
	}
	
	public function DeleteCategoryAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if($CategoryID > 0)
		{
			$Obj = $this->getDetail($CategoryID);
			$CategoryObj = new DataTable(TABLE_GALLERY_CATEGORY);
			$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
			$CategoryObj->tableDelete();								
			
				if(isset($Obj->Image) && $Obj->Image !="")
					$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
				
			
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='cms_gallery' ";
			$SeoObj->tableDelete();		
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Category deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&CategoryID=".$this->origin->CategoryID);
		 exit;
	}
	

	/* gallery images section start*/
	public function AddGalleryImageAction()
	{
		if(count($_POST)>0)
		{
			$GalleryImageObj = new DataTable(TABLE_GALLERY_IMAGES);
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;

			$DataArray = array();
			$DataArray['CategoryID'] = $CategoryID;
			$DataArray['ImageName'] = isset($_POST['ImageName'])?$_POST['ImageName']:"";
			$DataArray['ImageTitle'] = isset($_POST['ImageTitle'])?$_POST['ImageTitle']:"";
			$DataArray['ImageType'] = isset($_POST['ImageType'])?$_POST['ImageType']:"Image";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			/* gallery image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_gallery",'gallery',$DataArray['ImageName']);
			/* gallery image end*/
			
			$GalleryImageObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewGalleryImages&CategoryID=$CategoryID&tab=images");
			exit;
		}
	}
	public function EditGalleryImageAction()
	{
		if(count($_POST)>0)
		{
			$GalleryImageObj = new DataTable(TABLE_GALLERY_IMAGES);
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
			$ImageID = isset($_POST['ImageID'])?$_POST['ImageID']:0;


			$DataArray = array();
			
			$DataArray['ImageName'] = isset($_POST['ImageName'])?$_POST['ImageName']:"";
			$DataArray['ImageTitle'] = isset($_POST['ImageTitle'])?$_POST['ImageTitle']:"";
			$DataArray['ImageType'] = isset($_POST['ImageType'])?$_POST['ImageType']:"Image";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			/* product image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_gallery",'gallery');
			/* product image end*/
			
			$GalleryImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$GalleryImageObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewGalleryImages&CategoryID=$CategoryID&tab=images");
			exit;
		}
	}
	
	public function DeleteGalleryImageAction()
	{
		$ImageID = isset($_GET['DeleteImage'])?$_GET['DeleteImage']:0;
		if($ImageID > 0)
		{
			$GalleryImageObj = new DataTable(TABLE_GALLERY_IMAGES);
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
			
			$GalleryImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$Obj = (object)$GalleryImageObj->tableSelectOne();
			
			if(isset($Obj->Image) && $Obj->Image !="")
					$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);

			$GalleryImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$GalleryImageObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Image deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewGalleryImages&CategoryID=$CategoryID&tab=images");
			exit;
		}
	}
	
	public function getGalleryImages($CategoryID)
	{
		if($CategoryID > 0)
		{
			$Obj = new DataTable(TABLE_GALLERY_IMAGES);
			$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	/* gallery images section end*/
	
	public function getCategoryList()
	{
		$CategoryObj = new DataTable(TABLE_GALLERY_CATEGORY);
		$CategoryObj->where="1";
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	
	}
	
	public function GalleryImagesCount($CategoryID)
	{
		$Obj = new DataTable(TABLE_GALLERY_IMAGES);
		$Obj->where="CategoryID ='".(int)$CategoryID."'";
		$Obj->columnExpression=true;
		$Obj = $Obj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$CategoryObj = new DataTable(array('p'=>TABLE_GALLERY_CATEGORY));
			$CategoryObj->where[] = array('=',array('p.CategoryID' => $CategoryID));
				
			$CategoryObj->joinExpression = true;
			$CategoryObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.CategoryID AND s.MCode='cms_gallery')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$CategoryObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function imageCategoryURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."gallery/".$Image))
			return DIR_WS_SITE_UPLOADS."gallery/".$Image;
		
		return false;
	}
	
	
	public function pageTitle()
	{
		$Current = $this->getDetail($this->origin->CategoryID);
		return "Gallery <small>".($Current->CategoryName.""??"")."</small>";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditGallery">Add Gallery Category</a>
					</div>
              </div>		
			   ';
	}
	
	
}	