<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class EnquiryController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewEnquiry");
	}
	
	public function DeleteEnquiryAction()
	{
		$EnquiryID = isset($_GET['EnquiryID'])?$_GET['EnquiryID']:0;
		$obj = $this->getDetail($EnquiryID);
		if(isset($obj->EnquiryID))
		{
			$EnquiryObj = new DataTable(TABLE_EMAIL_ENQUIRIES);
			$EnquiryObj->where[] = array('=',array('EnquiryID' => $EnquiryID));
			$EnquiryObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Enquiry deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		exit;
	}
	public function DownloadEnquiryAction()
	{
		$EnquiryID = isset($_GET['EnquiryID'])?$_GET['EnquiryID']:0;
		$FileName = isset($_GET['FileName'])?$_GET['FileName']:0;
		$obj = $this->getDetail($EnquiryID);
		
		if($EnquiryID > 0)
		{
			$dir = FileHandle::CheckPrivateLogDirectory("contact_upload");
			FileHandle::DownloadFile($dir.$FileName);	
			exit;							
			
		}			
		
	}
	public function getList()
	{
		
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$where = new Where();
		
		
		$EnquiryObj = new DataTable(TABLE_EMAIL_ENQUIRIES);
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('FirstName','%'.$Value.'%')->OR
							->like('LastName','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('Phone','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$EnquiryObj->where = $where;
		
		$EnquiryObj->orderExpression = true;
		$EnquiryObj->AllowPaging =true;
		$EnquiryObj->PageSize=100;
		$EnquiryObj->PageTotalDisplay = 15; 
		$EnquiryObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $EnquiryObj;
		return $EnquiryObj->tableSelectAll(array("*"),"EnquiryID  DESC");
	
	}
	
	
	public function getDetail($EnquiryID)
	{
		if($EnquiryID > 0)
		{
			$EnquiryObj = new DataTable(array('m'=>TABLE_EMAIL_ENQUIRIES));
			$EnquiryObj->where[] = array('=',array('m.EnquiryID' => $EnquiryID));
			return (object)$EnquiryObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Enquiries";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-success" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'">View Enquiries</a>
					</div>
              </div>		
			   ';
	}
	
	
}	