<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class EmailTemplateController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("EmailTemplate");
	}
	
	public function EditTemplateAction()
	{
		if(count($_POST)>0)
		{
			$EmTmObj = new DataTable(TABLE_EMAIL_TEMPLATES);
			$TemplateID = isset($_GET['TemplateID'])?$_GET['TemplateID']:0;


			$DataArray = array();
			$DataArray['TemplateName'] = isset($_POST['TemplateName'])?$_POST['TemplateName']:"";
			$DataArray['FromName'] = isset($_POST['FromName'])?$_POST['FromName']:"";
			$DataArray['FromEmail'] = isset($_POST['FromEmail'])?$_POST['FromEmail']:"";
			$DataArray['Subject'] = isset($_POST['Subject'])?$_POST['Subject']:"";
			$DataArray['Notification'] = isset($_POST['Notification'])?$_POST['Notification']:"";
			$DataArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
			$DataArray['NotificationStatus'] = isset($_POST['NotificationStatus'])?$_POST['NotificationStatus']:0;
			$DataArray['EmailStatus'] = isset($_POST['EmailStatus'])?$_POST['EmailStatus']:0;
			
			if($TemplateID > 0)
			{
				$EmTmObj->where[] = array('=',array('TemplateID' => $TemplateID));
				$EmTmObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Content updated successfully."));
				
			}
			else 
			{
							
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$TemplateID = $EmTmObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Content added successfully."));
				
			}
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		    exit;
		}
	}
	public function getList()
	{
		$Obj = new DataTable(TABLE_EMAIL_TEMPLATES);
		$Obj->where[] = array('=',array('Editable' => '1'));
		return $Obj->tableSelectAll(array("*"),"TemplateID ASC");
	
	}
	
	public function getDetail($TemplateID)
	{
		if($TemplateID > 0)
		{
			$Obj = new DataTable(TABLE_EMAIL_TEMPLATES);
			$Obj->where[] = array('=',array('TemplateID' => $TemplateID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Email Template/Notifications";
	}
	
	
	
	
}	