<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class DocumentController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("DocumentManager");
	}
	
	
	public function AddEditCategoryAction()
	{
		if(count($_POST)>0)
		{
			$DocumentObj = new DataTable(TABLE_DOCUMENT_CATEGORY);
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;			
			$DataArray['CategoryName'] = isset($_POST['CategoryName'])?$_POST['CategoryName']:"";
			
			
			if($CategoryID > 0)
			{
				
				$DocumentObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$DocumentObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Document category updated successfully."));
				
			}
			else 
			{
				$Position = $DocumentObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;				
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$DocumentObj = new DataTable(TABLE_DOCUMENT_CATEGORY);
				$DocumentID = $DocumentObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Document category added successfully."));
				
			}
					
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=DocumentManager&CategoryID=$CategoryID");
			exit;
		}
	}
	public function AddEditDocumentAction()
	{
		if(count($_POST)>0)
		{
			$DocumentObj = new DataTable(TABLE_DOCUMENTS);
			$DocumentID = isset($_GET['DocumentID'])?$_GET['DocumentID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
			$UserID = isset($_REQUEST['UserID'])?$_REQUEST['UserID']:"";


			$DataArray = array();
			if($UserID != "")
				$DataArray['UserID'] = $UserID;
			
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['DocumentName'] = isset($_POST['DocumentName'])?$_POST['DocumentName']:"";
			$DataArray['DocumentTitle'] = isset($_POST['DocumentTitle'])?$_POST['DocumentTitle']:"";
			//$DataArray['DocumentType'] = isset($_POST['DocumentType'])?$_POST['DocumentType']:"Image";
			
			
			
			/* document image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Image","cms_document",'document',$DataArray['DocumentName']);
			/* document image end*/
			
			/* document upload added*/
			if(isset($_POST['DocumentUpload']) && $_POST['DocumentUpload'] !="" && file_exists(DIR_FS_SITE_UPLOADS."document/".$_POST['DocumentUpload']))
			{
				if(isset($_POST['DocumentUploadDelete']) && $_POST['DocumentUploadDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."document/".$_POST['DocumentUpload']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$UploadName = uniqid("Document_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."document/".$UploadName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Upload'] = $UploadName;
				$DataArray['DocumentTitle'] = basename($_FILES['Upload']['name']);
		
				if(isset($_POST['DocumentUpload']) && $_POST['DocumentUpload'] !="" && file_exists(DIR_FS_SITE_UPLOADS."document/".$_POST['DocumentUpload']))
					@unlink(DIR_FS_SITE_UPLOADS."document/".$_POST['DocumentUpload']);
			}
			/* document upload added end*/
			
			if($DocumentID > 0)
			{
				
				$DocumentObj->where[] = array('=',array('DocumentID' => $DocumentID));
				$DocumentObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Document updated successfully."));
				
			}
			else 
			{
				$DocumentObj->where ="CategoryID='".$CategoryID."'";
				$Position = $DocumentObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CategoryID'] = $CategoryID;
				
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$DocumentObj = new DataTable(TABLE_DOCUMENTS);
				$DocumentID = $DocumentObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Document added successfully."));
				
			}
			
			if(isset($_GET['iframe'])){
					$this->AllDone = "1";
				}
			else{
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewDocuments&CategoryID=$CategoryID&DocumentID=$DocumentID");
				exit;
			}
		}
		
	}
	
	public function UpdateCategoryAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$DocumentObj = new DataTable(TABLE_DOCUMENT_CATEGORY);
				$CategoryID =$_POST['CategoryID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$DocumentObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$DocumentObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Document updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=DocumentManager");
			 exit;
		}
	}
	public function UpdateDocumentAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:0;
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$DocumentObj = new DataTable(TABLE_DOCUMENTS);
				$DocumentID =$_POST['DocumentID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$DocumentObj->where[] = array('=',array('DocumentID' => $DocumentID));
				$DocumentObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Document updated successfully."));
			if(isset($_GET['rview']) && $_GET['rview']=="AddEditUser"){
				 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=Customer\MyAccount\Index&UserID=".$UserID."&view=AddEditUser&tab=documents&CategoryID=1");
				 exit;
			}
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewDocuments&CategoryID=$CategoryID");
			 exit;
		}
	}
	
	public function DeleteDocumentCategoryAction()
	{
		$DocumentID = isset($_GET['DocumentID'])?$_GET['DocumentID']:0;
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$DocumentObj = new DataTable(TABLE_DOCUMENT_CATEGORY);
		$DocumentObj->where[] = array('=',array('CategoryID' => $CategoryID));
		$DocumentObj->tableDelete();	
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=DocumentManager&CategoryID=$CategoryID");
		 exit;
		
	}
	public function DeleteDocumentAction()
	{
		$DocumentID = isset($_GET['DocumentID'])?$_GET['DocumentID']:0;
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$Obj = $this->getDocumentDetail($DocumentID);
		
		
		/*
		$Password = isset($_POST['Password'])?$_POST['Password']:"";			
		if(empty($Password))
		$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
		
		
		$check = $this->getClass('WebsiteControl\Login\Common')->CheckAdminPassword($Password);
		if($check != "1")
			$this->getSession()->setArrVar("alert",array("danger","ERROR: Password not correct or you do not have access for this action."));
		*/
		
		$arr = $this->getSession()->getVar("alert");
		if($arr==null)
			$arr =array();
	
		if(($arr==NULL || count($arr)==0) && $DocumentID > 0)
		{
			$DocumentObj = new DataTable(TABLE_DOCUMENTS);
			$DocumentObj->where[] = array('=',array('DocumentID' => $DocumentID));
			$DocumentObj->tableDelete();	
			
					if(isset($Obj->Image) && $Obj->Image !="")
					$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
			
			
				if(isset($Obj->Upload) && $Obj->Upload !="" && file_exists(DIR_FS_SITE_UPLOADS."document/".$Obj->Upload))
					@unlink(DIR_FS_SITE_UPLOADS."document/".$Obj->Upload);	
			
					
			$this->getSession()->setArrVar("alert",array("success","Document deleted successfully."));
			
			if(isset($_GET['iframe'])){
				$this->AllDone = "1";
			}
			else{
					
				if(isset($_GET['rview']) && $_GET['rview']=="AddEditUser"){
					 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=Customer\MyAccount\Index&UserID=".$Obj->UserID."&view=AddEditUser&tab=documents&CategoryID=".$Obj->CategoryID);
					 exit;
				}
				else{		
				 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewDocuments&CategoryID=$CategoryID");
				 exit;
				}
			}
		}
	}
	
	public function getDocumentDetail($DocumentID)
	{
		if($DocumentID > 0)
		{
			$Obj = new DataTable(TABLE_DOCUMENTS);
			$Obj->where[] = array('=',array('DocumentID' => $DocumentID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	public function DocumentCount($CategoryID)
	{
		$Obj = new DataTable(TABLE_DOCUMENTS);
		
		$Obj->columnExpression=true;
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj = $Obj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDocumentList($CategoryID)
	{
		$Obj = new DataTable(TABLE_DOCUMENTS);
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj->AllowPaging =true;
		$Obj->PageSize=50;
		$Obj->PageTotalDisplay = 15; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","DocumentID ASC"));
	}
	public function getList()
	{
		$Obj = new DataTable(TABLE_DOCUMENT_CATEGORY);
		$Obj->where="1";
		$where = new Where();
		$where->notEqualTo('CategoryID','1');
		$Obj->where = $where;
		
		return $Obj->tableSelectAll(array("*"),"CategoryID ASC");
	
	}
	
	public function getDocumentCategoryDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$Obj = new DataTable(TABLE_DOCUMENT_CATEGORY);
			$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function ImageDocumentURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."document/".$Image))
			return DIR_WS_SITE_UPLOADS."document/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Document Manager";
	}
	
	public function pageRight()
	{
		
		$return =  '<div class="title_right">
					<div class="pull-right">';

		$return .=  '<a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditDocumentCategory">Add Section</a>';
			if($this->origin->CategoryID > 0)
					$return .=  '<a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&CategoryID='.$this->origin->CategoryID.'&view=AddEditDocument">Add Document</a>';
	   $return .=  '</div>
              </div>		
			   ';
		
		return $return;
	}
	
	
	
	
}	