<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class CountryController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Countries");
	}
	
	public function UpdateCountriesAction()
	{
		if(count($_POST)>0)
		{
			$CountryObj = new DataTable(TABLE_COUNTRIES);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CountryID =$_POST['CountryID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$CountryObj->where="CountryID ='".(int)$CountryID."'";
				$CountryObj->tableUpdate($DataArray);
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Countries updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
			 exit;
		}
	}
	
	public function getList()
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="1";
		return $CountryObj->tableSelectAll(array("CountryID","CountryName","Active"),array("CountryName ASC"));
	
	}
	
	public function RegionCount($CountryID)
	{
		$CountryRegionObj = new DataTable(TABLE_COUNTRY_REGION);
		$CountryRegionObj->where="country_id ='".(int)$CountryID."'";
		$CountryRegionObj->columnExpression=true;
		$Obj = $CountryRegionObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	public function getDetail($CountryID)
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="CountryID ='".(int)$CountryID."'";
		return (object)$CountryObj->tableSelectOne();
	
	}
	
	public function getRegions($CountryID)
	{
		if($CountryID > 0)
		{
			$Obj = new DataTable(TABLE_COUNTRY_REGION);
			$Obj->where[] = array('=',array('country_id' => $CountryID));
			return $Obj->tableSelectAll(array("*"),array("region_name ASC","region_id ASC"));;
		}
		return ;
	
	}
	
	public function AddCountryRegionAction()
	{
		if(count($_POST)>0)
		{
			$CountryRegionObj = new DataTable(TABLE_COUNTRY_REGION);
			$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;

			$DataArray = array();
			$DataArray['country_id'] = $CountryID;
			$DataArray['region_name'] = isset($_POST['region_name'])?$_POST['region_name']:"";
			$DataArray['code'] = isset($_POST['code'])?$_POST['code']:"";
			$CountryRegionObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Region added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewRegions&CountryID=$CountryID");
			exit;
		}
	}
	public function EditCountryRegionAction()
	{
		if(count($_POST)>0)
		{
			$CountryRegionObj = new DataTable(TABLE_COUNTRY_REGION);
			$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
			$region_id = isset($_POST['region_id'])?$_POST['region_id']:0;


			$DataArray = array();
			
			$DataArray['region_name'] = isset($_POST['region_name'])?$_POST['region_name']:"";
			$DataArray['code'] = isset($_POST['code'])?$_POST['code']:"";
			$CountryRegionObj->where[] = array('=',array('region_id' => $region_id));
			$CountryRegionObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","REgion updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewRegions&CountryID=$CountryID");
			exit;
		}
	}
	
	public function DeleteCountryRegionAction()
	{
		$region_id = isset($_GET['DeleteRegion'])?$_GET['DeleteRegion']:0;
		if($region_id > 0)
		{
			$CountryRegionObj = new DataTable(TABLE_COUNTRY_REGION);
			$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
			$CountryRegionObj->where[] = array('=',array('region_id' => $region_id));
			$CountryRegionObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Region deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewRegions&CountryID=$CountryID");
			exit;
		}
	}
	
	
	public function pageTitle()
	{
		return "Countries";
	}
	
	
	
	
}	