<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class BannerController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("BannerManager");
	}
	
	
	public function AddEditBannerAction()
	{
		if(count($_POST)>0)
		{
			$BannerObj = new DataTable(TABLE_BANNERS);
			$BannerID = isset($_GET['BannerID'])?$_GET['BannerID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['BannerName'] = isset($_POST['BannerName'])?$_POST['BannerName']:"";
			$DataArray['BannerTitle'] = isset($_POST['BannerTitle'])?$_POST['BannerTitle']:"";
			$DataArray['BannerType'] = isset($_POST['BannerType'])?$_POST['BannerType']:"Image";
			
			$DataArray['Content'] = isset($_POST['Content'])?$_POST['Content']:"";
			$DataArray['EmbedCode'] = isset($_POST['EmbedCode'])?$_POST['EmbedCode']:"";
			$DataArray['LinkType'] = isset($_POST['LinkType'])?$_POST['LinkType']:"";
			$DataArray['Link'] = isset($_POST['Link'])?$_POST['Link']:"";
			
			$DataArray['StartDate'] = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			$DataArray['EndDate'] = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']:NULL;
			$DataArray['CounterDate'] = (isset($_POST['CounterDate']) && $_POST['CounterDate'] != "")?$_POST['CounterDate']:NULL;
			$DataArray['CounterStatus'] = isset($_POST['CounterStatus'])?(int)$_POST['CounterStatus']:"0";
			
			/* banner image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","cms_banner",'banner');
			/* banner image end*/
			
			
			if($BannerID > 0)
			{
				
				$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
				$BannerObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Banner updated successfully."));
				
			}
			else 
			{
				$BannerObj->where ="CategoryID='".$CategoryID."'";
				$Position = $BannerObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CategoryID'] = $CategoryID;
				
				$DataArray['Clicks'] = "0";
				$DataArray['Impressions'] = "0";
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$BannerObj = new DataTable(TABLE_BANNERS);
				$BannerID = $BannerObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Banner added successfully."));
				
			}
					
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID&BannerID=$BannerID");
			exit;
		}
		
	}
	
	public function UpdateBannerAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$BannerObj = new DataTable(TABLE_BANNERS);
				$BannerID =$_POST['BannerID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
				$BannerObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Banner updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID");
			 exit;
		}
	}
	
	public function DeleteBannerAction()
	{
		$BannerID = isset($_GET['BannerID'])?$_GET['BannerID']:0;
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$Obj = $this->getBannerDetail($BannerID);
		
		if($BannerID > 0)
		{
			$BannerObj = new DataTable(TABLE_BANNERS);
			$BannerObj->where[] = array('=',array('BannerID' => $BannerID));
			$BannerObj->tableDelete();		
			if(isset($Obj->Image) && $Obj->Image !="")
				$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
			
		}			
		$this->getSession()->setArrVar("alert",array("success","Banner deleted successfully."));
		
		 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewBanners&CategoryID=$CategoryID");
		 exit;
	}
	
	public function getBannerDetail($BannerID)
	{
		if($BannerID > 0)
		{
			$Obj = new DataTable(TABLE_BANNERS);
			$Obj->where[] = array('=',array('BannerID' => $BannerID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	public function BannerCount($CategoryID)
	{
		$Obj = new DataTable(TABLE_BANNERS);
		
		$Obj->columnExpression=true;
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj = $Obj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getBannerList($CategoryID)
	{
		$Obj = new DataTable(TABLE_BANNERS);
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj->AllowPaging =true;
		$Obj->PageSize=50;
		$Obj->PageTotalDisplay = 15; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","BannerID ASC"));
	}
	public function getList()
	{
		$Obj = new DataTable(TABLE_BANNER_CATEGORY);
		$Obj->where="1";
		return $Obj->tableSelectAll(array("*"),"CategoryID ASC");
	
	}
	
	public function getDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$Obj = new DataTable(TABLE_BANNER_CATEGORY);
			$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function ImageBannerURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."banner/".$Image))
			return DIR_WS_SITE_UPLOADS."banner/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Banner Manager";
	}
	
	public function pageRight()
	{
		if($this->origin->getView()=="ViewBanners"){
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&CategoryID='.$this->origin->CategoryID.'&view=AddEditBanner">Add Banner</a>
					</div>
              </div>		
			   ';
		}
	}
	
	
	
	
}	