<?php 
namespace Cms\Pages\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class AdController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("ViewAds");
		
		$this->CategoryID = "1";
	}
	
	
	public function AddEditAdAction()
	{
		if(count($_POST)>0)
		{
			$AdObj = new DataTable(TABLE_ADS);
			$AdID = isset($_GET['AdID'])?$_GET['AdID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['AdName'] = isset($_POST['AdName'])?$_POST['AdName']:"";
			$DataArray['DelayTime'] = isset($_POST['DelayTime'])?$_POST['DelayTime']:0;
			
			$DataArray['Content'] = isset($_POST['Content'])?$_POST['Content']:"";
			$DataArray['EmbedCode'] = isset($_POST['EmbedCode'])?$_POST['EmbedCode']:"";
			$DataArray['AdType'] = isset($_POST['AdType'])?$_POST['AdType']:"HTML";
			$DataArray['PageType'] = isset($_POST['PageType'])?$_POST['PageType']:"ALL";
			$DataArray['ProductIDs'] = isset($_POST['ProductIDs'])?implode(",",$_POST['ProductIDs']):"0";
			
			
			//$DataArray['StartDate'] = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			//$DataArray['EndDate'] = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']:NULL;
			
			
			/* ad image added/
			if(isset($_POST['AdImage']) && $_POST['AdImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."ad/".$_POST['AdImage']))
			{
				if(isset($_POST['AdImageDelete']) && $_POST['AdImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."ad/".$_POST['AdImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid("Ad_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."ad/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['AdImage']) && $_POST['AdImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."ad/".$_POST['AdImage']))
					@unlink(DIR_FS_SITE_UPLOADS."ad/".$_POST['AdImage']);
			}
			/* ad image added end*/
			
			if($AdID > 0)
			{
				
				$AdObj->where[] = array('=',array('AdID' => $AdID));
				$AdObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Ad updated successfully."));
				
			}
			else 
			{
				$AdObj->where ="CategoryID='".$CategoryID."'";
				$Position = $AdObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CategoryID'] = $CategoryID;
				
				$DataArray['Impressions'] = "0";
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$AdObj = new DataTable(TABLE_ADS);
				$AdID = $AdObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Ad added successfully."));
				
			}
					
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewAds&CategoryID=$CategoryID&AdID=$AdID");
			exit;
		}
		
	}
	
	public function UpdateAdAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$AdObj = new DataTable(TABLE_ADS);
				$AdID =$_POST['AdID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				//$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$AdObj->where[] = array('=',array('AdID' => $AdID));
				$AdObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Ad updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewAds&CategoryID=$CategoryID");
			 exit;
		}
	}
	
	public function DeleteAdAction()
	{
		$AdID = isset($_GET['AdID'])?$_GET['AdID']:0;
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		$Obj = $this->getAdDetail($AdID);
		
		if($AdID > 0)
		{
			$AdObj = new DataTable(TABLE_ADS);
			$AdObj->where[] = array('=',array('AdID' => $AdID));
			$AdObj->tableDelete();		
			if(isset($Obj->Image) && $Obj->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."ad/".$Obj->Image))
					@unlink(DIR_FS_SITE_UPLOADS."ad/".$Obj->Image);	
			
		}			
		$this->getSession()->setArrVar("alert",array("success","Ad deleted successfully."));
		
		 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewAds&CategoryID=$CategoryID");
		 exit;
	}
	
	public function getAdDetail($AdID)
	{
		if($AdID > 0)
		{
			$Obj = new DataTable(TABLE_ADS);
			$Obj->where[] = array('=',array('AdID' => $AdID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	public function AdCount($CategoryID)
	{
		$Obj = new DataTable(TABLE_ADS);
		
		$Obj->columnExpression=true;
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj = $Obj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getAdList($CategoryID)
	{
		$Obj = new DataTable(TABLE_ADS);
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj->AllowPaging =true;
		$Obj->PageSize=50;
		$Obj->PageTotalDisplay = 15; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","AdID ASC"));
	}
	public function getList()
	{
		$Obj = new DataTable(TABLE_AD_CATEGORY);
		$Obj->where="1";
		return $Obj->tableSelectAll(array("*"),"CategoryID ASC");
	
	}
	
	public function getDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$Obj = new DataTable(TABLE_AD_CATEGORY);
			$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function ImageAdURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."ad/".$Image))
			return DIR_WS_SITE_UPLOADS."ad/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Ad Manager";
	}
	
	public function pageRight()
	{
		if($this->origin->getView()=="ViewAds"){
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&CategoryID='.$this->origin->CategoryID.'&view=AddEditAd">Add Ad</a>
					</div>
              </div>		
			   ';
		}
	}
	
	
	
	
}	