<?php 
namespace Cms\Faqs;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;


class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	public function getFaqDetail($FaqID)
	{
		if($FaqID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PLUGIN_FAQS));
			$Obj->where[] = array('=',array('p.FaqID' => $FaqID));
				
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.FaqID AND s.MCode='faq_main')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	}
	
	
	
	public function getContentFaqs($Tag)
	{
		$uniqid = uniqid("f_");
		$returnString="";
		if(strtoupper($Tag) == "ALL"){
			$rows = $this->getFaqList(500);
			if(count($rows) > 0){
				$Sno = 1;
				$returnString  .= '
					<div class="accordion" id="'.$uniqid.'">
				';				
				foreach($rows as $CurrentRecord){
					$returnString  .= '
					<div class="accordion-item">
						<h2 class="accordion-header" id="'.$uniqid."_h".$CurrentRecord->FaqID.'">
						  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#'.$uniqid."_p".$CurrentRecord->FaqID.'" aria-expanded="false" aria-controls="'.$uniqid."_p".$CurrentRecord->FaqID.'">
							'.MyStripSlashes($CurrentRecord->Question).'
						  </button>
						</h2>
						<div id="'.$uniqid."_p".$CurrentRecord->FaqID.'" class="accordion-collapse collapse" aria-labelledby="'.$uniqid."_h".$CurrentRecord->FaqID.'">
						  <div class="accordion-body">
							'.MyStripSlashes($CurrentRecord->Answer).'
						  </div>
						</div>
					  </div>
					';	
				    $Sno++;					
				}
				$returnString  .= '
					</div>
				';
					
			}
					
		}
		return $returnString;
		
	}
	public function getFaqList($limit=12)
	{
		$Obj = new DataTable(TABLE_PLUGIN_FAQS);
		$where = new Where();
		$where->equalTo('Active','1');
		$Obj->where = $where;	
		$Obj->AllowPaging =true;
		$Obj->PageSize=$limit;
		$Obj->PageTotalDisplay = 12; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","FaqID ASC"));
	
	}
	
}	