<?php 
namespace Cms\Faqs\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		
	}
	
	
	public function AddEditFaqAction()
	{
		if(count($_POST)>0)
		{
			$FaqObj = new DataTable(TABLE_PLUGIN_FAQS);
			$FaqID = isset($_GET['FaqID'])?$_GET['FaqID']:0;
			

			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
			$DataArray['Answer'] = isset($_POST['Answer'])?$_POST['Answer']:"";
			
				
			
			
			
			if($FaqID > 0)
			{
				
				$FaqObj->where[] = array('=',array('FaqID' => $FaqID));
				$FaqObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Faq updated successfully."));
				
			}
			else 
			{
				$FaqObj->where ="1";
				$Position = $FaqObj->getMax("Position") + 1;
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$FaqObj = new DataTable(TABLE_PLUGIN_FAQS);
				$FaqID = $FaqObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Faq added successfully."));
				
			}
			
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Default&FaqID=$FaqID");
			exit;
		}
		
	}
	
	public function UpdateFaqAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$FaqObj = new DataTable(TABLE_PLUGIN_FAQS);
				$FaqID =$_POST['FaqID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$FaqObj->where[] = array('=',array('FaqID' => $FaqID));
				$FaqObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Faq updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Default");
			 exit;
		}
	}
	
	public function DeleteFaqAction()
	{
		$FaqID = isset($_GET['FaqID'])?$_GET['FaqID']:0;
		$Obj = $this->getClass("Cms\Faqs\Common")->getFaqDetail($FaqID);
		
		if($FaqID > 0)
		{
			$FaqObj = new DataTable(TABLE_PLUGIN_FAQS);
			$FaqObj->where[] = array('=',array('FaqID' => $FaqID));
			$FaqObj->tableDelete();		
			if(isset($Obj->Image) && $Obj->Image !="")
				$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
			
		}			
		$this->getSession()->setArrVar("alert",array("success","Faq deleted successfully."));
		
		 MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Default");
		 exit;
	}
	
		
	public function getFaqList()
	{
		$Obj = new DataTable(TABLE_PLUGIN_FAQS);
		$Obj->AllowPaging =true;
		$Obj->PageSize=50;
		$Obj->PageTotalDisplay = 15; 
		$Obj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $Obj;
		return $Obj->tableSelectAll(array("*"),array("Position ASC","FaqID ASC"));
	}
	
	
		
	public function pageTitle()
	{
		return "Faq Manager";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEdit">Add Faq</a>
					</div>
              </div>		
			   ';
		
	}
	
	
	
	
}	