<?php 
namespace Catalog\Report\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function EmailProductsAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Product Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Report created at ".date("Y-m-d h:i");
			
			$rows = $this->getAllReportList(false);
			$data = $this->PrepareAllReportList($rows,true);
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."product_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $ProductID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	public function PrintProductsAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $ProductID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	public function DownloadProductsAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."product_reports-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $ProductID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	public function PrepareAllReportList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['ProductID']=array("title"=>"Product ID","display"=>true);
		$ReturnData['header']['ModelNo']=array("title"=>"SKU","display"=>true);
		$ReturnData['header']['CreatedDate']=array("title"=>"Created Date","display"=>true);
		$ReturnData['header']['ProductName']=array("title"=>"Product Name","display"=>true);
		//$ReturnData['header']['Points']=array("title"=>"Loyalty Points","display"=>true);
		$ReturnData['header']['Status']=array("title"=>"Status","display"=>true);
		$ReturnData['header']['Price']=array("title"=>"Price","display"=>true);
		$ReturnData['header']['SalePrice']=array("title"=>"Sale Price","display"=>true);
		$ReturnData['header']['SaleActive']=array("title"=>"Sale Status","display"=>true);
		if(d("MANUFACTURER_ENABLED")=="1")
			$ReturnData['header']['MNName']=array("title"=>"Manufacturer Name","display"=>true);
		
		$ReturnData['header']['CategoryNames']=array("title"=>"Category Name","display"=>true);
		if($csv===false){
			$ReturnData['header']['Detail']=array("title"=>"Edit","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$CategoryNames = $this->getClass("Catalog\Product\Common")->getCategoryNames($CurrentRecord->ProductID);
				$ReturnData['data'][$CurrentRecord->ProductID]['ProductID'] = isset($CurrentRecord->ProductID)?$CurrentRecord->ProductID:"";
				$ReturnData['data'][$CurrentRecord->ProductID]['ModelNo'] = isset($CurrentRecord->ModelNo)?$CurrentRecord->ModelNo:"";
				$ReturnData['data'][$CurrentRecord->ProductID]['CreatedDate'] = isset($CurrentRecord->CreatedDate)?ConvertDateFromDb($CurrentRecord->CreatedDate):"";
				$ReturnData['data'][$CurrentRecord->ProductID]['ProductName'] = (isset($CurrentRecord->ProductName)?$CurrentRecord->ProductName:"");
				//$ReturnData['data'][$CurrentRecord->ProductID]['Points'] = (isset($CurrentRecord->ProductPoints)?$CurrentRecord->ProductPoints:"");
				$ReturnData['data'][$CurrentRecord->ProductID]['Status'] = ((isset($CurrentRecord->Active) && $CurrentRecord->Active=="1")?"YES":"NO");
				$ReturnData['data'][$CurrentRecord->ProductID]['Price'] = (isset($CurrentRecord->Price)?$CurrentRecord->Price:"");
				$ReturnData['data'][$CurrentRecord->ProductID]['SalePrice'] = (isset($CurrentRecord->SalePrice)?$CurrentRecord->SalePrice:"");
				$ReturnData['data'][$CurrentRecord->ProductID]['SaleActive'] = ((isset($CurrentRecord->SaleActive) && $CurrentRecord->SaleActive=="1")?"YES":"NO");
				$ReturnData['data'][$CurrentRecord->ProductID]['MNName'] = (isset($CurrentRecord->MNName)?$CurrentRecord->MNName:"");
				$ReturnData['data'][$CurrentRecord->ProductID]['CategoryNames'] = $CategoryNames;
				if($csv===false){
					$ReturnData['data'][$CurrentRecord->ProductID]['Detail'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Catalog\Product\Index&ProductID='.$CurrentRecord->ProductID.'&view=AddEditProduct" class="btn btn-xs btn-primary">Edit</a>';
				}
			}
		}
		return $ReturnData;
	}
	public function getAllReportList($paging=true)
	{
		$sb = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"00";
		$CArr = (isset($_REQUEST['CArr']) && $_REQUEST['CArr'] != "")?$_REQUEST['CArr']:"";
		$MNID = (isset($_REQUEST['MNID']) && $_REQUEST['MNID'] != "")?$_REQUEST['MNID']:"";
		$ac=isset($_REQUEST['ac'])?$_REQUEST['ac']:"";
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$SortByArray = $this->getSortByArray();
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		
		$where = new Where();
		$where->notEqualTo('p.ProductType','Child');
		
		
		
		if($MNID !="")
			$where->equalTo('p.MNID',$MNID);
		
		if($ac =="1")
			$where->equalTo('p.Active','1');
		
		if($StartDate != "")
			$where->greaterThanOrEqualTo('p.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('p.CreatedDate', $EndDate);
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('ProductName','%'.$Value.'%')->OR
							->like('ModelNo','%'.$Value.'%')->OR
							->like('ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		
		
		
		
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		if(d("MANUFACTURER_ENABLED")=="1"){							  
			$ProductObj->joinArray[] = array('name'=>array('m'=>TABLE_MANUFACTURERS),
										  'on'=>"(m.MNID=p.MNID)",
										  'columns'=>array("MNName"),
										  'type'=>'LEFT'
										  );
		}
									  
		if($CArr != ""){
			
			$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='catalog_category')",
									  //'columns'=>array("RelationID","SortOrder"),
									  'type'=>'LEFT'
									  );
									  
			$where->equalTo('ptc.RelationID',$CArr);
		}			
		
		$ProductObj->where = $where;
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =$paging;
		$ProductObj->PageSize=$PageSize;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		$ProductObj->orderExpression=true;
		//$ProductObj->groupBy = array("p.ProductID");
		return $ProductObj->tableSelectAll(array("*"),$OrderBy);
	
	}
	
	public function getSortByArray()
	{
		return  array(
					"00"=>array("display"=>"Default","column"=>"p.CreatedDate DESC"),
					"11"=>array("display"=>"Name (A - Z)","column"=>"p.ProductName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"p.ProductName DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"IF(pr.SaleActive='1',pr.SalePrice,pr.Price) ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"IF(pr.SaleActive='1',pr.SalePrice,pr.Price) DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"p.CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"p.CreatedDate ASC"),
					);
	}
	
	public function pageTitle()
	{
		return "Products Reports";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
				</div>		
			   ';
	}
	
	
}	