<?php 
namespace Catalog\Product\ProductType;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\Currency\CurrencyHandler as CurrencyHandler;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Simple extends AbstractModule 
{
	function __construct()
	{
		
	}
	function AddProductInTmpCart($ID,$Qty=1,$Attribute1 ="",$PostArray = array())
	{
		$AlertArray = array();
		$SessionID = $this->getSession()->getCurrentSID();
		$MasterID =	$ID;
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $MasterID));
		if(isset($GLOBALS['UserIDByAdmin']) && $GLOBALS['UserIDByAdmin'] != "")
		{
				//$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		else
		{
			$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																	"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																	"Stock","StockStatus","StockTotal","EndStock",
																	"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	
		
		
		
		
		if(!isset($CurrentProduct->ProductID))
			$AlertArray[] = array("danger","Something went wrong");
		
			if(isset($CurrentProduct->NotForSale) && $CurrentProduct->NotForSale == "1")
					$AlertArray[] = array("danger","Currently this product is not available for sale.");
				
				if(isset($CurrentProduct->EndStock) && $CurrentProduct->EndStock == "1" && $Qty > $CurrentProduct->Stock){
						$AlertArray[] = array("danger","Currently this product is out of stock.");
				}
					

				if(isset($CurrentProduct->SignedIn) && $CurrentProduct->SignedIn == "1")
				{
					if(d("FRONT_SIDE_INCLUDE")==true){
						$AlertArray[] = array("danger","Currently this product is available for registered customers.");
					}
				}
		
		 if($AlertArray==NULL || count($AlertArray)==0)	{
			/* add Simple product section start */
					$AlertArray = array();
				
						if(isset($CurrentProduct->ProductID) && $CurrentProduct->ProductID != "" && count($AlertArray)==0){
						 $ItemStatus ="Normal";
						 $ItemType ="Product";
						 $ItemName = isset($CurrentProduct->ProductName)?str_replace("'","",$CurrentProduct->ProductName):"";
						 $ItemNo = isset($CurrentProduct->ModelNo)?$CurrentProduct->ModelNo:"";
						 $ReferenceID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
						 
						 if($CurrentProduct->FreeShippingStatus =="1")
							$ItemStatus ="FreeShipping";
						if($CurrentProduct->VirtualProduct =="1")
							$ItemStatus ="Download";
						
						$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentProduct->ProductID,$Qty,$PostArray);
						$SubItemID = uniqid("Item_");
						$SubDataArray = array();
						$SubDataArray['ItemID'] = $SubItemID;
						$SubDataArray['ParentItemID'] = "";
						$SubDataArray['ItemType'] = $ItemType;
						$SubDataArray['ItemStatus'] = $ItemStatus;
						$SubDataArray['ReferenceID'] = $ReferenceID;
						$SubDataArray['ItemName'] =$ItemName;
						$SubDataArray['ItemNo'] = $ItemNo;	
						
						$SubDataArray['Attribute1'] = $CurrentProduct->ProductID;
						$SubDataArray['Attribute2'] = "";
						
						$SubDataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
						$SubDataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
						$SubDataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
						$SubDataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
						
						$SubDataArray['UnitPrice'] = isset($PriceSubArray['UnitPrice'])?$PriceSubArray['UnitPrice']:"";
						$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
						$SubDataArray['Price'] = isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"";
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['VoucherAmount'] = isset($PriceSubArray['Discount'])?$PriceSubArray['Discount']:"";
						$SubDataArray['VoucherText'] = "";
						$SubDataArray['VoucherCode'] = "";
						
						$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
						$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						
						if($SubDataArray['VoucherAmount'] > 0){
							$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
						}
						
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
						$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
						$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
										
				
						$SubDataArray['Comments'] = $Comments;		
						$SubDataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
						$SubDataArray['SessionID'] = $SessionID;
						
					
						$TmpCartObj = new DataTable(TABLE_TMPCART);
						$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
						$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
						$TmpCartObj->where[] = array('=',array('Attribute1' => $SubDataArray['Attribute1']));
						$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
						$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
						$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
						
						if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
							$TmpCartObj->tableUpdate($SubDataArray);
						}
						else{
							$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
							$TmpCartObj->tableInsert($SubDataArray);
						}
						
						
						
					}
					else{
						return $AlertArray;
					}
					
				$this->getClass('Sale\Cart\Common')->AddCartInCookie();			
			
			/* add Simple product section end */
			 return "1";
			 /* add product end*/
		 }
		 else{
			 return $AlertArray;
		 }	
		
	}
	
	

	
	
}	