<?php 
namespace Catalog\Product\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getHeaderCss()
	{
		//SkCssInclude(DIR_WS_SITE."templates/extras/starrating/css/star-rating.css");
		
	}
	
	public function getFooterJs()
	{
		//SkJsInclude(DIR_WS_SITE."templates/extras/starrating/js/star-rating.min.js");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		//var_dump($arr);exit;
		if($arr['ID'] && $arr['ID'] != "")
		{
			$MainObj = new DataTable(array('m'=>TABLE_PRODUCT));
			$MainObj->where[] = array('=',array('m.ProductID' => $arr['ID']));
			$MainObj->where[] = array('=',array('m.Active' => "1"));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = m.ProductID AND s.MCode='catalog_product')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->ProductID))
			{
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
					}	
											
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			
			
				$this->getMurphysMagicProductStatus($obj);
					
			}
			else{
				
				$MainObj = new DataTable(array('m'=>TABLE_PRODUCT));
				$MainObj->where[] = array('=',array('m.ProductID' => $arr['ID']));
				$MainObj->joinExpression = true;
				$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
											  'on'=>"(s.ReferenceID = m.ProductID AND s.MCode='catalog_product')",
											  'columns'=>array("*"),
											  'type'=>"left",
											  );
											  
				$obj = (object)$MainObj->tableSelectOne();
				if(isset($obj->ProductID)){
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
				}
			
				
			}
			
		}
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	public function NotifyMeAction()
	{
		$CurrentProduct = $this->getCurrentObj();
		if(isset($CurrentProduct->ProductID) && $CurrentProduct->ProductID != ""){
			$this->getClass('Customer\Login\Common')->CheckUserLogin(constant("DEFINE_CURRENT_PAGE_URL"));
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
			
			$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelatedObj->where[] = array('=',array('ProductID' => $CurrentProduct->ProductID));
			$ProductRelatedObj->where[] = array('=',array('RelationID' => $IsCurrentUser->UserID));
			$ProductRelatedObj->where[] = array('=',array('RelationType' => 'product_notify'));
			$Current = (object)$ProductRelatedObj->tableSelectOne();
			if(isset($Current->ProductID)){
					$DataArray = array();
					$DataArray['Custom'] = "0";
					$ProductRelatedObj->tableUpdate($DataArray);
			}
			else{
			
				$DataArray = array();
				$DataArray['ProductID'] = $CurrentProduct->ProductID;
				$DataArray['RelationID'] = $IsCurrentUser->UserID;
				$DataArray['RelationType'] = "product_notify";
				$DataArray['Custom'] = "0";
				$DataArray['SortOrder'] = $this->getClass("Catalog\Product\Common")->SKMaxGetRelatedSortOrder($IsCurrentUser->UserID,"product_notify") + 1;
				$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
				$ProductRelatedObj->tableInsert($DataArray);
			
			}
				
			
			$this->getSession()->setArrVar("alert",array("success","We will notify you once product will be back."));
			MyRedirect(SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID));
			 exit;
		}
		
		
	}
	public function AddReviewAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Rating']))
				$this->getSession()->setArrVar("alert",array("danger","Please select your rating"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr== NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
					$ProductID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
					$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$ProductReviewObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","Thank you for your feedback."));
					$this->AllDone = "1";
					
					$CurrentProduct = $this->getCurrentObj();
					$Mail_Subject = "A new review has been submitted at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new review has been submitted at site. ".chr(13).chr(13)."Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName.chr(13).SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID).chr(13).chr(13)."Thanks!";
			
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function GetAttributesAction()
	{
		$PassAttArr = isset($_GET['Att'])?$_GET['Att']:"";
		if(count($PassAttArr) > 0){
			
			$CurrentProduct = $this->getCurrentObj();
			if(isset($CurrentProduct->ProductType) && strtolower($CurrentProduct->ProductType) == "attribute"){
				
				$AttributeArr = $this->getClass('Catalog\Attribute\Common')->getAttributeArrayWithValues(explode(',',$CurrentProduct->ProductAttribute));
				$chidPrRows = $this->getClass('Catalog\Product\Common')->getProductChildren($CurrentProduct->ProductID);
				$ChidPrArr = array();
				foreach($chidPrRows as $CurrentChild){
					$ChidPrArr[] = $CurrentChild->ProductID;
				}
				$FilterChildProducts = array();
				foreach($PassAttArr as $PassAttributeID=>$PassAttributeValueID){
					$ChidPrArr = $this->getClass('Catalog\Product\Common')->getSpecificChildProductByAttributeValueID($ChidPrArr,$PassAttributeID,$PassAttributeValueID);
				}
				
				$SelectedAttributeArr = array();
				foreach($ChidPrArr as $ChildProductID){
					 foreach($AttributeArr as $AttributeID=>$Arr){
						 $CurrentAttRel = $this->getClass('Catalog\Product\Common')->getChildAttributeValueFromRel($ChildProductID, $AttributeID);
						 $SelectedAttributeArr[$AttributeID][$CurrentAttRel->AttributeValueID] = (isset($CurrentAttRel->AttributeValue)?MyStripSlashes($CurrentAttRel->AttributeValue):"");
						 
					 }
				}

				
			}
			$ReturnArray = array();
			$ReturnArray['Attribute'] = $SelectedAttributeArr;
			if(count($ChidPrArr)=="1"){
				$ChildProductID = $ChidPrArr[0];
				$ReturnArray['Child']['ProductID']  = $ChildProductID;
				$ReturnArray['Child']['Price'] = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($ChildProductID,1,true);
			}
			header('Content-Type: application/json');
			echo json_encode($ReturnArray);
			exit;
		}
		exit;
	}
	
	public function AddQuestionAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Question']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Question"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr== NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
					$ProductID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$ProductQuestionObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","We shall get in touch with you soon."));
					$this->AllDone = "1";
					
					$CurrentProduct = $this->getCurrentObj();
					$Mail_Subject = "A new question has been asked at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new question has been asked at site. ".chr(13).chr(13)."Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName.chr(13).SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID).chr(13).chr(13)."Thanks!";
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function AddShareFriendAction()
{
	if(count($_POST)>0)
	{
		
		$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
		if(isset($responseData->success) && $responseData->success===true)
		{
			
			$CurrentProduct = $this->getCurrentObj();
			$this->getSession()->setArrVar("alert",array("success","You have successfully sent email to your friend."));
			$this->AllDone = "1";
			
			$Mail_Subject = "Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
			$Mail_ToEmail = isset($_POST['FEmail'])?$_POST['FEmail']:"";
			
			$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
			$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
			$MessageBody =isset($_POST['MessageBody'])?$_POST['MessageBody']:"";
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
			
			
		}
		else
		{
			$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
		}
	}
}
	
	public function getProductImages($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_IMAGES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	
	public function getProductRelatedByType($ProductID,$Type="product_related")
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.RelationID=p.ProductID and ptc.RelationType='".$Type."')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			$Obj->where[] = array('=',array('p.Active' => '1'));
			return $Obj->tableSelectAll(array("ProductName","Image","ProductID"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	
	
	
	public function getProductReviews($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("ReviewID DESC"));;
		}
		return ;
	
	}
	
	public function getProductQuestions($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","QuestionID ASC"));;
		}
		return ;
	
	}
	
	public function getProductInfos($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_INFO);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","InfoID ASC"));;
		}
		return ;
	
	}
	
	function getMurphysMagicProductStatus($CurrentProduct)
	{
		
			
		
		
	
		
	}
	
	
	function pageTitle()
	{
		return isset($this->currentObj->ProductName)?MyStripSlashes($this->currentObj->ProductName):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function getBeforeMeta()
	{
		
	}
	function getAfterMeta()
	{
		if(is_object($this->currentObj)){
			$CurrentRecord = $this->currentObj;
			$return ='<link rel="canonical" href="'.SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID).'" />';
			$return .='<meta property="og:site_name" content="'.d("SITE_NAME").'"/>
						<meta property="og:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'" />
						<meta property="og:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'" />
						<meta property="og:type" content="website" />
						<meta property="og:url" content="'.SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID).'" />
						<meta property="og:image" content="'.SKSeoImage($CurrentRecord->Image,"500").'" />
						<meta property="og:locale" content="en_GB"/>
						<meta property="fb:app_id" content="'.d("FACEBOOK_APP_ID").'"/>
						<meta name="twitter:card" content="summary"/>
						<meta name="twitter:site" content="'.d("TWITTER_SITE_ID").'"/>
						<meta name="twitter:creator" content="'.d("TWITTER_SITE_CREATOR").'"/>
						<meta name="twitter:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'"/>
						<meta name="twitter:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'"/>
						<meta name="twitter:image" content="'.SKSeoImage($CurrentRecord->Image,"500").'"/>
			
			';
		}
		return $return;		 
	}
	
	function directFile()
	{
		if(in_array(strtolower($this->view),array("detail")))
			return true;
		else
			return false;
		
	}
	
	
}	