<?php 
namespace Catalog\Product\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getHeaderCss()
	{
		//SkCssInclude(DIR_WS_SITE."templates/extras/starrating/css/star-rating.css");
		
	}
	
	public function getFooterJs()
	{
		//SkJsInclude(DIR_WS_SITE."templates/extras/starrating/js/star-rating.min.js");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		//var_dump($arr);exit;
		if($arr['ID'] && $arr['ID'] != "")
		{
			$MainObj = new DataTable(array('m'=>TABLE_PRODUCT));
			$MainObj->where[] = array('=',array('m.ProductID' => $arr['ID']));
			$MainObj->where[] = array('=',array('m.Active' => "1"));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = m.ProductID AND s.MCode='catalog_product')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->ProductID))
			{
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
					}	
											
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			
			
				$this->getMurphysMagicProductStatus($obj);
					
			}
			else{
				
				$MainObj = new DataTable(array('m'=>TABLE_PRODUCT));
				$MainObj->where[] = array('=',array('m.ProductID' => $arr['ID']));
				$MainObj->joinExpression = true;
				$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
											  'on'=>"(s.ReferenceID = m.ProductID AND s.MCode='catalog_product')",
											  'columns'=>array("*"),
											  'type'=>"left",
											  );
											  
				$obj = (object)$MainObj->tableSelectOne();
				if(isset($obj->ProductID)){
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
				}
			
				
			}
			
		}
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	public function NotifyMeAction()
	{
		$CurrentProduct = $this->getCurrentObj();
		if(isset($CurrentProduct->ProductID) && $CurrentProduct->ProductID != ""){
			$this->getClass('Customer\Login\Common')->CheckUserLogin(constant("DEFINE_CURRENT_PAGE_URL"));
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
			
			$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelatedObj->where[] = array('=',array('ProductID' => $CurrentProduct->ProductID));
			$ProductRelatedObj->where[] = array('=',array('RelationID' => $IsCurrentUser->UserID));
			$ProductRelatedObj->where[] = array('=',array('RelationType' => 'product_notify'));
			$Current = (object)$ProductRelatedObj->tableSelectOne();
			if(isset($Current->ProductID)){
					$DataArray = array();
					$DataArray['Custom'] = "0";
					$ProductRelatedObj->tableUpdate($DataArray);
			}
			else{
			
				$DataArray = array();
				$DataArray['ProductID'] = $CurrentProduct->ProductID;
				$DataArray['RelationID'] = $IsCurrentUser->UserID;
				$DataArray['RelationType'] = "product_notify";
				$DataArray['Custom'] = "0";
				$DataArray['SortOrder'] = $this->getClass("Catalog\Product\Common")->SKMaxGetRelatedSortOrder($IsCurrentUser->UserID,"product_notify") + 1;
				$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
				$ProductRelatedObj->tableInsert($DataArray);
			
			}
				
			
			$this->getSession()->setArrVar("alert",array("success","We will notify you once product will be back."));
			MyRedirect(SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID));
			 exit;
		}
		
		
	}
	public function AddReviewAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Rating']))
				$this->getSession()->setArrVar("alert",array("danger","Please select your rating"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr== NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
					$ProductID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
					$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$ProductReviewObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","Thank you for your feedback."));
					$this->AllDone = "1";
					
					$CurrentProduct = $this->getCurrentObj();
					$Mail_Subject = "A new review has been submitted at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new review has been submitted at site. ".chr(13).chr(13)."Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName.chr(13).SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID).chr(13).chr(13)."Thanks!";
			
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function GetAttributeSizesAction()
	{
		$VID = isset($_GET['VID'])?(int)$_GET['VID']:"";
		$ReturnText=" Not available";
		if($VID > 0){
			$CurrentProduct = $this->getCurrentObj();
			$ColorAttribute = $this->getClass('Catalog\Attribute\Common')->getAttributeData($VID);
			$ColorAttributeData = "";
			$GridPrice = "";
			$GridPriceArr = array();
			
			$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
			$where = new Where();
			$where->equalTo('pd.UserTypeID',1);
			$where->greaterThanOrEqualTo('QtyMax',1);
			$where->lessThanOrEqualTo('QtyMin',1);
			$ProductDiscountObj->where = $where;								  
			$OnePercentObj = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("QtyMin ASC"));	
			
			
			$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
			$PercentObj = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("DiscountPercent DESC"));	
			
			if($ColorAttribute->Image != "" && file_exists(DIR_FS_SITE_UPLOADS."attribute/".$ColorAttribute->Image))
				$ColorAttributeData .= '<img src="'.DIR_WS_SITE_UPLOADS.'attribute/'.$ColorAttribute->Image.'" width="70" class="img-fluid">';
				
			$ProductCobj = $this->getClass('Catalog\Product\Common');
			if(isset($CurrentProduct->ProductType) && strtolower($CurrentProduct->ProductType) == "attribute"){
				$ChildIDs = $ProductCobj->getProductChildrenIDsActive($CurrentProduct->ProductID);
				$ChidPrArr = $ProductCobj->getSpecificChildProductByAttributeValueID($ChildIDs,"101",$VID);
				$ChildContent = "";
				$FirstPrice = -1;
				foreach($ChidPrArr as $CurrentChild){
					
					$ChildPriceArray = $ProductCobj->GetProductPriceNStock($CurrentChild,1,true);
					if($FirstPrice==-1 && isset($ChildPriceArray['JsPrice']) && $ChildPriceArray['JsPrice'] > 0){
						
						$FirstPrice = $ChildPriceArray['JsPrice'];
						if(isset($PercentObj->DiscountPercent) && $PercentObj->DiscountPercent > 0)
							$FirstPriceMin = $FirstPrice - ($PercentObj->DiscountPercent/100)*$FirstPrice;
				
					}
						
					
					$CurrentAttRel = $ProductCobj->getChildAttributeValueFromRel($CurrentChild, '102');
					if(isset($CurrentAttRel->AttributeValue)){
						if($ChildPriceArray['StockArray']['StockStatus']==true && $ChildPriceArray['StockArray']['EndStock']=="1" && $ChildPriceArray['StockArray']['Left']> 0){
							
							$ChildGridPrice = (isset($ChildPriceArray['GridPrice'])?$ChildPriceArray['GridPrice']:"");
							$GridPriceArr[$CurrentAttRel->AttributeValue] = "<b class='d-none'>Size: ".$CurrentAttRel->AttributeValue."</b>".$ChildGridPrice;
							
							$AvText = $ChildPriceArray['StockArray']['Left']." available";
							if($ChildPriceArray['StockArray']['Left'] > 500)
								$AvText = "500+ available";
								
							if(isset($OnePercentObj->DiscountPercent) && $OnePercentObj->DiscountPercent > 0)
								$DiffPrice = ($ChildPriceArray['JsPrice'] - ($OnePercentObj->DiscountPercent/100)*$ChildPriceArray['JsPrice']) - ($FirstPrice - ($OnePercentObj->DiscountPercent/100)*$FirstPrice);
							else
								$DiffPrice = $ChildPriceArray['JsPrice'] - $FirstPrice;
							
							$Priceone =$ChildPriceArray['Array']['Price'];
							if(isset($OnePercentObj->DiscountPercent) && $OnePercentObj->DiscountPercent > 0)
							$Priceone = $ChildPriceArray['Array']['Price'] - ($OnePercentObj->DiscountPercent/100)*$ChildPriceArray['Array']['Price'];
			
			
							$ChildContent .='<div class="col AttributeQtyDiv">
											  <div class="PriceHD fw-semi">'.(isset($CurrentAttRel->AttributeValue)?$CurrentAttRel->AttributeValue:"").'</div>
											  <input
													data-Attribute="Color:'.$ColorAttribute->AttributeValue.' Size:'.(isset($CurrentAttRel->AttributeValue)?$CurrentAttRel->AttributeValue:"").'"
													data-chid='.$CurrentChild.'
													data-SKU='.(isset($ChildPriceArray['Array']['ModelNo'])?$ChildPriceArray['Array']['ModelNo']:"").'
													data-MaxQty='.(isset($ChildPriceArray['StockArray']['Left'])?$ChildPriceArray['StockArray']['Left']:"100").'
													data-SalePrice='.(isset($ChildPriceArray['Array']['SalePrice'])?$ChildPriceArray['Array']['SalePrice']:"0").'
													data-SaleActive='.(isset($ChildPriceArray['Array']['SaleActive'])?$ChildPriceArray['Array']['SaleActive']:"0").'
													data-Price='.(isset($ChildPriceArray['Array']['Price'])?$ChildPriceArray['Array']['Price']:"0").'
													data-PriceOne='.$Priceone.'
													data-MainPriceWithTax='.(isset($ChildPriceArray['MainPriceWithTax'])?$ChildPriceArray['MainPriceWithTax']:"0").'
													data-MainPriceWithoutTax='.(isset($ChildPriceArray['MainPriceWithoutTax'])?$ChildPriceArray['MainPriceWithoutTax']:"0").'
													data-MainPrice='.(isset($ChildPriceArray['MainPrice'])?$ChildPriceArray['MainPrice']:"0").'
													data-TaxInPrice='.(isset($ChildPriceArray['TaxInPrice'])?$ChildPriceArray['TaxInPrice']:"0").'
													data-TaxPercent='.(isset($ChildPriceArray['TaxPercent'])?$ChildPriceArray['TaxPercent']:"0").'
													data-DefaultCurrencyFormat='.(isset($ChildPriceArray['DefaultCurrencyFormat'])?$ChildPriceArray['DefaultCurrencyFormat']:"0.00").'
													data-CurrentCurrencyFormat='.(isset($ChildPriceArray['CurrentCurrencyFormat'])?$ChildPriceArray['CurrentCurrencyFormat']:"0.00").'
													title="Price: '.$ChildPriceArray['JsPrice'].'"
													data-bs-html="true"
													data-bs-title="Price: '.$ChildPriceArray['JsPrice'].'"
													id="'.uniqid("u").'"
													class="AttributeQty PriceQty" style="max-width:90px;" type="number" name="ChQty['.$CurrentChild.']" id="ChQty" value="0" min="0" max="'.(isset($ChildPriceArray['StockArray']['Left'])?$ChildPriceArray['StockArray']['Left']:"0").'" />
											  <div class="fw-medium mt-2">'.$AvText.'</div>
											  <div class="Price'.(($DiffPrice > 0)?"":" d-none").'"><small>+'.(($DiffPrice > 0)?$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($DiffPrice):"").'</small></div>
											  <div class="ChildGridPrice d-none">'.(isset($ChildPriceArray['GridHoverPrice'])?$ChildPriceArray['GridHoverPrice']:"").'</div>
											</div>
											';
											//<div class="Price">'.$DiffPrice.(isset($ChildPriceArray['DisplayPrice'])?str_replace("From ","",$ChildPriceArray['DisplayPrice']):"").'</div>
										
						}
					}
				}
				
				$uid = uniqid("ta");
				$GridPrice ='<ul class="nav nav-pills mb-3 d-none" id="pills-tab'.$uid.'" role="tablist">';
				$Sno=1;
				foreach($GridPriceArr as $kk=>$vv){
					$GridPrice .='<li class="nav-item me-3" role="presentation"><button class="nav-link btn-secondary'.($Sno==1?' active':'').'" id="pills-'.strtolower($kk).'-tab'.$uid.'" data-bs-toggle="pill" data-bs-target="#pills-'.strtolower($kk).''.$uid.'" type="button" role="tab" aria-controls="pills-'.strtolower($kk).''.$uid.'" aria-selected="'.($Sno==1?'true':'false').'">'.$kk.'</button></li>';
				$Sno++;
				}
				$GridPrice .='</ul>';
				$GridPrice .='<div class="tab-content" id="pills-tabContent'.$uid.'">';
				$Sno=1;
				foreach($GridPriceArr as $kk=>$vv){
					$GridPrice .='<div class="tab-pane fade'.($Sno==1?' show active':'').'" id="pills-'.strtolower($kk).''.$uid.'" role="tabpanel" aria-labelledby="pills-'.strtolower($kk).'-tab'.$uid.'">'.$vv.'</div>';
				$Sno++;
				}
				$GridPrice .='</div>';
  				
				//@ob_clean();
				$ReturnText = '<div class="border-info border border-1 p-sm-4 p-3 MrBtm">
								<div class="colobox m-1">'.$ColorAttributeData.'</div>
								<div class="GridPrice m-1">'.$GridPrice.'</div>
							   </div>';
							   
				$ReturnText = '<div class="bg-light text-white fw-semi ls-100 px-4 py-2 text-uppercase d-none">Choose Sizes <span class="d-none">(Color '.$ColorAttribute->AttributeValue.')</span></div>
							  <div class="border-info border border-1 p-sm-4 p-3 MrBtm">
								<div class="colobox m-1">'.$ColorAttributeData.'</div>
								<div class="GridPrice m-1">'.$GridPrice.'</div >
								<div class="MinPrice d-none">From '.$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($FirstPriceMin)." ".$ChildPriceArray['PriceSuffix'].'</div>
								<div class="row gutter-sm row-cols-8 text-center SizeBox">'.$ChildContent.'</div>
							   </div>';
				
			}
			header('Content-Type: text/html');
			echo $ReturnText;
			exit;
		}
		//var_dump($VID);exit;
	}
	
	public function GetAttributeSizesMainAction()
	{
		$VID = isset($_GET['VID'])?(int)$_GET['VID']:"";
		$ReturnText=" Not available";
		if($VID > 0){
			$CurrentProduct = $this->getCurrentObj();
			$ColorAttribute = $this->getClass('Catalog\Attribute\Common')->getAttributeData($VID);
			$ColorAttributeData = "";
			$GridPrice = "";
			if($ColorAttribute->Image != "" && file_exists(DIR_FS_SITE_UPLOADS."attribute/".$ColorAttribute->Image))
				$ColorAttributeData .= '<img src="'.DIR_WS_SITE_UPLOADS.'attribute/'.$ColorAttribute->Image.'" width="70" class="img-fluid">';
				
			$ProductCobj = $this->getClass('Catalog\Product\Common');
			if(isset($CurrentProduct->ProductType) && strtolower($CurrentProduct->ProductType) == "attribute"){
				$ChildIDs = $ProductCobj->getProductChildrenIDsActive($CurrentProduct->ProductID);
				$ChidPrArr = $ProductCobj->getSpecificChildProductByAttributeValueID($ChildIDs,"101",$VID);
				$ChildContent = '<div class="col">
									<div class="PriceHD fw-semi">ModelNo</div>
									<div class="PriceHD fw-semi">Sizes</div>
									<div class="PriceHD fw-semi">Qty</div>
								 </div>';
				foreach($ChidPrArr as $CurrentChild){
					
					$ChildPriceArray = $ProductCobj->GetProductPriceNStock($CurrentChild,1,true);
					$CurrentAttRel = $ProductCobj->getChildAttributeValueFromRel($CurrentChild, '102');
					if(isset($CurrentAttRel->AttributeValue)){
						if($ChildPriceArray['StockArray']['StockStatus']==true && $ChildPriceArray['StockArray']['EndStock']=="1" && $ChildPriceArray['StockArray']['Left']> 0){
							$GridPrice = (isset($ChildPriceArray['GridPrice'])?$ChildPriceArray['GridPrice']:"");
							$ChildContent .='<div class="col">
											  <div class="PriceHD fw-semi">'.(isset($ChildPriceArray['Array']['ModelNo'])?$ChildPriceArray['Array']['ModelNo']:"").'</div>
											  <div class="PriceHD fw-semi">'.(isset($CurrentAttRel->AttributeValue)?$CurrentAttRel->AttributeValue:"").'</div>
											  <input
													data-Attribute="Color:'.$ColorAttribute->AttributeValue.' Size:'.(isset($CurrentAttRel->AttributeValue)?$CurrentAttRel->AttributeValue:"").'"
													data-chid='.$CurrentChild.'
													data-SKU='.(isset($ChildPriceArray['Array']['ModelNo'])?$ChildPriceArray['Array']['ModelNo']:"").'
													data-MaxQty='.(isset($ChildPriceArray['StockArray']['Left'])?$ChildPriceArray['StockArray']['Left']:"100").'
													data-SalePrice='.(isset($ChildPriceArray['Array']['SalePrice'])?$ChildPriceArray['Array']['SalePrice']:"0").'
													data-SaleActive='.(isset($ChildPriceArray['Array']['SaleActive'])?$ChildPriceArray['Array']['SaleActive']:"0").'
													data-Price='.(isset($ChildPriceArray['Array']['Price'])?$ChildPriceArray['Array']['Price']:"0").'
													data-MainPrice='.(isset($ChildPriceArray['MainPrice'])?$ChildPriceArray['MainPrice']:"0").'
													data-TaxInPrice='.(isset($ChildPriceArray['TaxInPrice'])?$ChildPriceArray['TaxInPrice']:"0").'
													data-TaxPercent='.(isset($ChildPriceArray['TaxPercent'])?$ChildPriceArray['TaxPercent']:"0").'
													data-DefaultCurrencyFormat='.(isset($ChildPriceArray['DefaultCurrencyFormat'])?$ChildPriceArray['DefaultCurrencyFormat']:"0.00").'
													data-CurrentCurrencyFormat='.(isset($ChildPriceArray['CurrentCurrencyFormat'])?$ChildPriceArray['CurrentCurrencyFormat']:"0.00").'
													class="AttributeQty PriceQty text-center" style="max-width:60px;" type="number" name="ChQty['.$CurrentChild.']" id="ChQty" value="0" min="0" max="'.(isset($ChildPriceArray['StockArray']['Left'])?$ChildPriceArray['StockArray']['Left']:"0").'" />
											  <div class="fw-medium mt-2">'.(isset($ChildPriceArray['StockArray']['Left'])?$ChildPriceArray['StockArray']['Left']:"0").' available</div>
											  <div class="Price d-none">'.(isset($ChildPriceArray['DisplayPrice'])?$ChildPriceArray['DisplayPrice']:"").'</div>
											</div>
											';
						}
					}
				}
				//@ob_clean();
				$ReturnText = '<div class="border-info border border-1 mb-1">
								<div class="row align-items-center px-2">
									<div class="col-1 text-center">'.$ColorAttributeData.'</div>
									<div class="col-11 p-1">
										<div class="GridPrice m-1 d-none">'.$GridPrice.'</div>
										<div class="row gutter-sm text-center SizeBox">'.$ChildContent.'</div>
									</div>	
							   </div>
							   </div>';
				
			}
			header('Content-Type: text/html');
			echo $ReturnText;
			exit;
		}
		//var_dump($VID);exit;
	}
	public function GetAttributesAction()
	{
		$ReturnArray = array();
		$PassAttArr = isset($_GET['Att'])?$_GET['Att']:"";
		if(count($PassAttArr) > 0){
			
			$CurrentProduct = $this->getCurrentObj();
			if(isset($CurrentProduct->ProductType) && strtolower($CurrentProduct->ProductType) == "attribute"){
				
				$AttributeArr = $this->getClass('Catalog\Attribute\Common')->getAttributeArrayWithValues(explode(',',$CurrentProduct->ProductAttribute));
				$chidPrRows = $this->getClass('Catalog\Product\Common')->getProductChildren($CurrentProduct->ProductID);
				$ChidPrArr = array();
				foreach($chidPrRows as $CurrentChild){
					$ChidPrArr[] = $CurrentChild->ProductID;
				}
				$FilterChildProducts = array();
				foreach($PassAttArr as $PassAttributeID=>$PassAttributeValueID){
					$ChidPrArr = $this->getClass('Catalog\Product\Common')->getSpecificChildProductByAttributeValueID($ChidPrArr,$PassAttributeID,$PassAttributeValueID);
				}
				
				$SelectedAttributeArr = array();
				foreach($ChidPrArr as $ChildProductID){
					 foreach($AttributeArr as $AttributeID=>$Arr){
						 $CurrentAttRel = $this->getClass('Catalog\Product\Common')->getChildAttributeValueFromRel($ChildProductID, $AttributeID);
						 $SelectedAttributeArr[$AttributeID][$CurrentAttRel->AttributeValueID] = (isset($CurrentAttRel->AttributeValue)?MyStripSlashes($CurrentAttRel->AttributeValue):"");
						 
					 }
				}

				
			}
			$ReturnArray['Attribute'] = $SelectedAttributeArr;
			if($ChidPrArr != NULL && count($ChidPrArr)==1){
				$ChildProductID = $ChidPrArr[0];
				$ReturnArray['Child']['ProductID']  = $ChildProductID;
				$ReturnArray['Child']['Price'] = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($ChildProductID,1,true);
			}
		}
		header('Content-Type: application/json');
		echo json_encode($ReturnArray);
		exit;
		
	}
	
	public function GetJsonPriceAction()
	{
		$UserTypeID =1;	
		$ReturnArray = array();
		$Var = isset($_GET['Var'])?$_GET['Var']:"";
		$Qty = isset($_GET['Qty'])?(int)$_GET['Qty']:"1";
		$TotalQty = isset($_GET['TotalQty'])?(int)$_GET['TotalQty']:$Qty;
		$chid = isset($_GET['chid'])?(int)$_GET['chid']:"0";
		$PriceArray = $this->getProductCommon()->GetProductPriceNStock($chid,$Qty,true);
		
		
		/* DiscountPercent check start */
			$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
			$where = new Where();
			$where->equalTo('pd.UserTypeID',$UserTypeID);
			$where->greaterThanOrEqualTo('QtyMax',$TotalQty);
			$where->lessThanOrEqualTo('QtyMin',$TotalQty);
			$ProductDiscountObj->where = $where;								  
			$CurrentProductPrice = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("QtyMin ASC"));	
			
		/* DiscountPercent check end*/
		
		$Return = array();
		$Return["discount"] = 0;
		$Return['Sess'] = $this->getSession()->getVar("SessPriceDisplay");
		if(isset($CurrentProductPrice->DiscountPercent) && $CurrentProductPrice->DiscountPercent  != 0)
			$Return["discount"] = $CurrentProductPrice->DiscountPercent;
					
		if($Var != ""){
			foreach(explode(",",$Var) as $key){
				if(isset($PriceArray[$key])){
					$Return[$key] = $PriceArray[$key];
				}
			}
			
		}
		header('Content-Type: application/json');
		echo json_encode($Return);
		exit;
		
		
	}
	
	public function AddQuestionAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Question']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Question"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr== NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
					$ProductID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$ProductQuestionObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","We shall get in touch with you soon."));
					$this->AllDone = "1";
					
					$CurrentProduct = $this->getCurrentObj();
					$Mail_Subject = "A new question has been asked at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new question has been asked at site. ".chr(13).chr(13)."Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName.chr(13).SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID).chr(13).chr(13)."Thanks!";
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function AddShareFriendAction()
{
	if(count($_POST)>0)
	{
		
		$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
		if(isset($responseData->success) && $responseData->success===true)
		{
			
			$CurrentProduct = $this->getCurrentObj();
			$this->getSession()->setArrVar("alert",array("success","You have successfully sent email to your friend."));
			$this->AllDone = "1";
			
			$Mail_Subject = "Please check this product at ".d('SITE_NAME').":".$CurrentProduct->ProductName;
			$Mail_ToEmail = isset($_POST['FEmail'])?$_POST['FEmail']:"";
			
			$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
			$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
			$MessageBody =isset($_POST['MessageBody'])?$_POST['MessageBody']:"";
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
			
			
		}
		else
		{
			$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
		}
	}
}
	
	public function getProductImages($ProductID)
	{
		/*
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_IMAGES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		*/
		return array();
	
	}
	public function getChildImages($MasterID)
	{
		if($MasterID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT);
			$Obj->where[] = array('=',array('MasterID' => $MasterID));
			$Obj->where[] = array('=',array('ProductType' => 'Child'));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("Image","ProductID","ProductAttribute"),array("ProductID ASC"));;
		}
		return ;
	
	}
	
	public function getProductReviews($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("ReviewID DESC"));;
		}
		return ;
	
	}
	
	public function getProductQuestions($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","QuestionID ASC"));;
		}
		return ;
	
	}
	
	public function getProductInfos($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_INFO);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","InfoID ASC"));;
		}
		return ;
	
	}
	
	function getMurphysMagicProductStatus($CurrentProduct)
	{
		
			
		
		
	
		
	}
	
	
	function pageTitle()
	{
		return isset($this->currentObj->ProductName)?MyStripSlashes($this->currentObj->ProductName):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function breadcrumb()
	{
			
			if(is_object($this->currentObj)){
				$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
				$Obj->joinExpression = true;
				$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
											  'on'=>"(ptc.RelationID=c.CategoryID and ptc.RelationType='catalog_category')",
											  'columns'=>array("id","RelationID","SortOrder"),
											  'type'=>''
											  );
											  
				$Obj->where[] = array('=',array('ptc.ProductID' => $this->currentObj->ProductID));
				$Obj->where[] = array('=',array('c.Active' => '1'));
				$CurrentRecord = (object)$Obj->tableSelectOne(array("CategoryName","CategoryID"),array("ParentID DESC","CategoryID DESC"));			
				if(isset($CurrentRecord->CategoryID)){
					$breadcrumb = $this->getClass("Catalog\Category\Common")->CategoryChain4Caption($CurrentRecord->CategoryID,"","SEOURL","breadcrumb-item",false,"",false,"");
					if($breadcrumb != "")
						return '<ul class="breadcrumb"><li class="breadcrumb-item"><a href="'.SKSEOURL('cms_pages','Detail',d('DEFAULT_PAGEID')).'">Home</a></li>'.$breadcrumb.'</ul>';
				}
			}
	}
	
	function getBeforeMeta()
	{
		
	}
	function getAfterMeta()
	{
		if(is_object($this->currentObj)){
			$CurrentRecord = $this->currentObj;
			$return ='<link rel="canonical" href="'.SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID).'" />';
			$return .='<meta property="og:site_name" content="'.d("SITE_NAME").'"/>
						<meta property="og:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'" />
						<meta property="og:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'" />
						<meta property="og:type" content="website" />
						<meta property="og:url" content="'.SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID).'" />
						<meta property="og:image" content="'.SKSeoImage($CurrentRecord->Image,"500").'" />
						<meta property="og:locale" content="en_GB"/>
						<meta property="fb:app_id" content="'.d("FACEBOOK_APP_ID").'"/>
						<meta name="twitter:card" content="summary"/>
						<meta name="twitter:site" content="'.d("TWITTER_SITE_ID").'"/>
						<meta name="twitter:creator" content="'.d("TWITTER_SITE_CREATOR").'"/>
						<meta name="twitter:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'"/>
						<meta name="twitter:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'"/>
						<meta name="twitter:image" content="'.SKSeoImage($CurrentRecord->Image,"500").'"/>
			
			';
		}
		return $return;		 
	}
	
	function bodyClass()
	{
		if(is_object($this->currentObj)){
			$CurrentRecord = $this->currentObj;
			$className = (isset($CurrentRecord->ProductType)?"type_".$CurrentRecord->ProductType:"");
			$className .= (isset($CurrentRecord->ProductID)?" product_".$CurrentRecord->ProductID:"");
			return $className;
		}
			return "";
	}
	function directFile()
	{
		if(in_array(strtolower($this->view),array("detail")))
			return true;
		else
			return false;
		
	}
	
	
}	