<?php 
namespace Catalog\Product;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class CronController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	
	public function CronProductFullIndexAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/product_index");
		$filename=$dir."indexing_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Index_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Index Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Action']="Processing";
				$Params['Offset']="0";				
			}
			
			//$this->getClass('Catalog\Product\Common')->BTCResetClearance();
			$where = new Where();
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where->notEqualTo('p.ProductType','Child');
			$ProductObj->where = $where;
			//$ProductObj->displayQuery =true;
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$ProductObj->offset = (int)$Params['Offset'];
			
			$SNo =$Params['Offset'];
			$rows = $ProductObj->tableSelectAll(array("ProductID"),"p.IdxMinPrice ASC");
			foreach( $rows as $CurrentRecord){
				if($CurrentRecord->ProductID > 0){
					$this->getClass('Catalog\Product\Common')->IndexProductSearch($CurrentRecord->ProductID);
					echo $CurrentRecord->ProductID." - indexed ".chr(13);
													
				}
				
				$SNo++;
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$Params['Offset'] = $SNo;
				$DataArray = array();
				$DataArray['CronStatus'] = "Processing";
				$DataArray['Params'] = base64_encode(serialize($Params));
				$CronObj->tableUpdate($DataArray);
				
				$sk_timeend = explode(' ', microtime() );
				$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
				if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
					return ;
			}
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
			
		}
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
		}
		
		fputs($fp2,"Index End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);
		
		
	}
	public function CronProductStockNotifyAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/product_notify");
		$filename=$dir."notify_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Notify_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Notify Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Action']="Processing";
				$Params['Offset']="0";				
			}
			
			$where = new Where();
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			
			$where->notEqualTo('p.ProductType','Child');
			$where->equalTo('p.Active',"1");
			$where->equalTo('ptc.RelationType','product_notify');
			$where->equalTo('ptc.Custom','0');
			$where->greaterThan('p.Stock','0');
			
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='product_notify')",
									  'columns'=>array("*"),
									  'type'=>''
									  );
									  
			
			$ProductObj->where = $where;
			
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$ProductObj->offset = (int)$Params['Offset'];
			
			//$ProductObj->displayQuery = true;
			$rows = $ProductObj->tableSelectAll(array("ProductID","ProductName"),array("ptc.id ASC"));
			$SNo =$Params['Offset'];
			/* for loope start here */
			foreach ($rows as $CurrentProduct){
				
				$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($CurrentProduct->RelationID);
				if(isset($CurrentUser->UserID)){
					$Arr = array();
					$Arr['Name'] = $CurrentUser->FirstName." ".$CurrentUser->LastName;
					$Arr['ProductID'] = $CurrentProduct->ProductID;
					$Arr['ProductName'] = $CurrentProduct->ProductName;
					fputs($fp2,"Notify Arr ".$UniqueID."=".print_r($Arr,true).chr(13));	
					
					$MessageBody = $this->getNotifyEmail($Arr);
					$Mail_Subject = $CurrentProduct->ProductName.": Your favorite product is back at ".d("SITE_NAME");
					$Mail_ToEmail = $CurrentUser->Email;
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody);
				}
				
				$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
				$ProductRelatedObj->where[] = array('=',array('ProductID' => $CurrentProduct->ProductID));
				$ProductRelatedObj->where[] = array('=',array('RelationID' => $CurrentProduct->RelationID));
				$ProductRelatedObj->where[] = array('=',array('RelationType' => 'product_notify'));
				$Current = (object)$ProductRelatedObj->tableSelectOne();
				if(isset($Current->ProductID)){
						$DataArray = array();
						$DataArray['Custom'] = "1";
						$ProductRelatedObj->tableUpdate($DataArray);
				}
				
				$SNo++;
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$Params['Offset'] = $SNo;
				$DataArray = array();
				$DataArray['CronStatus'] = "Processing";
				$DataArray['Params'] = base64_encode(serialize($Params));
				$CronObj->tableUpdate($DataArray);
				
				$sk_timeend = explode(' ', microtime() );
				$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
				if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
					return ;
				
			}
			/* for loope end here */
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
			
		}
		/* script end here*/
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
		}

		fputs($fp2,"Notify End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
		//http://192.168.0.77/sunil/custom_cms/ecommerce/newsite/index.php?m=Catalog\Product\Cron&v=Default&action=CronOrderNotify	
		
	}
	
	function getNotifyEmail($Arr)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/product_notify.php")){
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/product_notify.php");
			$MessageBody = ob_get_clean();
			return $MessageBody;
		}
		return false;
		
	}
	
	public function TestFunction($ScriptTimeLimit,$Obj)
	{
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		var_dump("TestFunction"); return; 
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$filename=$dir."process.txt";
		$fp2 = fopen($filename, "a+");
		while(1){
			fputs($fp2,"TestFunction=".date('Y-m-d H:i:s').chr(13));	
			$sk_timeend = explode(' ', microtime() );
			$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
			if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
				return ;
		}
		fclose($fp2);
	}
}	