<?php 
namespace Catalog\Product\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class JsonController extends AbstractModule
{
	function __construct()
	{
		header('Content-Type: application/json');
	}
	
	
	public function listAction()
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->in('p.ProductType',array('Simple','Attribute'));
		//$where->equalTo('p.Active','1');
		if($this->origin->q != "")
		{
			$where->NEST//start braket
						->like('ProductName','%'.$this->origin->q.'%')->OR
						->like('ModelNo','%'.$this->origin->q.'%')->OR
						->like('ProductLine','%'.$this->origin->q.'%')->OR
						->UNNEST;
	
		}
		$ProductObj->where = $where;
		//$ProductObj->displayQuery = true;
		$ProductObj->columnExpression = true;
		$ProductObj->rowType="array";
		$jsonArray = $ProductObj->tableSelectAll(array("ProductID as id","CONCAT(ProductName,' ',ModelNo) as text"),array("ProductName ASC"),100);
		echo json_encode($jsonArray);
		exit;
	}
	public function listAllAction()
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->in('p.ProductType',array('Simple','Attribute'));
		//$where->equalTo('p.Active','1');
		if($this->origin->q != "")
		{
			$where->NEST//start braket
						->like('ProductName','%'.$this->origin->q.'%')->OR
						->like('ModelNo','%'.$this->origin->q.'%')->OR
						->like('ProductLine','%'.$this->origin->q.'%')->OR
						->UNNEST;
	
		}
		$ProductObj->where = $where;
		$ProductObj->columnExpression = true;
		$ProductObj->rowType = 'array';
		$jsonArray = $ProductObj->tableSelectAll(array("ProductID as id","CONCAT(ProductName,' ',ModelNo) as text"),array("ProductName ASC"));
		echo json_encode($jsonArray);
		exit;
	}
	
	
}	