<?php 
namespace Catalog\Product\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $rpstdt,$rpeddt;
	function __construct()
	{
		$this->rpstdt=isset($_GET['rpstdt'])?MyStripSlashes($_GET['rpstdt']):date('Y-m-d',strtotime("-10 days"));
		$this->rpeddt=isset($_GET['rpeddt'])?MyStripSlashes($_GET['rpeddt']):date('Y-m-d');
		//echo "coming soon";exit;
		/*
		for($i=1;$i<=35;$i+=.5){
			echo $a =  $i." inches (".number_format(2.53998*$i,2)." cm)";
			$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
					$SubDataArray = array();
					$SubDataArray['AttributeValue'] =$a;
					$SubDataArray['Active'] = "1"; 
					$SubDataArray['Position'] = number_format(2.53998*$i,0);  
					$SubDataArray['AttributeID'] ='101';
					$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
					$AttributeValueObj->tableInsert($SubDataArray);
					
					
		}
		exit;
		*/
	}
	
	function getDateArray()
	{
		$StartDate = $this->rpstdt;
		$EndDate = $this->rpeddt;
		$DataArray = array();
		
		$date1 = new \DateTime($StartDate);
		$date2 = new \DateTime($EndDate);
		$interval = $date1->diff($date2);
		if($interval->days > 0){
			for($i=0;$i<=$interval->days;$i++)
				$DataArray[date('Y-m-d',strtotime($StartDate)+($i*24*60*60))] = ConvertDateFromDb(date('Y-m-d',strtotime($StartDate)+($i*24*60*60)));
		}
		return $DataArray;
	}
	
	public function getProductReportsGraph()
	{
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"Paid";
		$ProductID = (isset($_REQUEST['ProductID']) && $_REQUEST['ProductID'] != "")?$_REQUEST['ProductID']:"0";
		
		if($ProductID > 0){
			$StartDate = $this->rpstdt;
			$EndDate = $this->rpeddt." 23:59:59";
			
			$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
			$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
			
			$where = new Where();
			$ReportObj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
			
			$ReportObj->joinExpression = true;
			$ReportObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
										  'on'=>"(od.OrderID=o.OrderID)",
										  'columns'=>NULL,
										  'type'=>''
										  );
											  
			$ReportObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
										  'on'=>"(od.ReferenceID=p.ProductID and od.ItemType='Product')",
										  'columns'=>array("ProductID","ProductName","Stock"),
										  'type'=>''
										  );
			
			
			if($PaymentStatus !="")
				$where->equalTo('o.PaymentStatus',$PaymentStatus);
			if($StartDate != "")
				$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
			if($EndDate != "")
				$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
			
			if($ProductID !=""){
				$where->equalTo('p.ProductID',$ProductID);
			}
			
			 //$ReportObj->displayQuery = true;
			 $ReportObj->where = $where;
			 $ReportObj->columnExpression = true;
			 $ReportObj->groupBy = array("MyCurDate");
			 $rows  = $ReportObj->tableSelectAll(array("DATE_FORMAT(o.CreatedDate,'%Y-%m-%d') as MyCurDate",
													   "SUM(od.TotalWithTax) as TotalSale",
													   "SUM(od.Qty) as TotalQty",
													   "COUNT(*) as TotalCount"));
			
			//$DateDataArray = $this->getDateArray();
			//$DateDataArray = array_fill_keys(array_keys($DateDataArray), 0);
			//var_dump($DateDataArray);
			foreach($this->getDateArray() as $k=>$v){
				$DateDataArray[$k] = array("TotalSale"=>0,
										  "TotalQty"=>0	
										  );
			}
			
			foreach( $rows as $CurrentRecord){
				$DateDataArray[$CurrentRecord->MyCurDate] = array("TotalSale"=>(float)number_format($CurrentRecord->TotalSale,2,".",""),
																  "TotalQty"=>(float)number_format($CurrentRecord->TotalQty,0,".","")	
																  ); 	
			}
			return $DateDataArray;
			
		}
		
	
	}
	
	
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	public function getHeaderCss()
	{
		SkCssInclude(DIR_WS_SITE."templates/extras/starrating/css/star-rating.css");
		SkJsInclude(DIR_WS_SITE."templates/extras/starrating/js/star-rating.min.js");
		//<script src="http://192.168.0.77/sunil/custom_cms/ecommerce/attachment/extras/bootstrap-star-rating-master/bootstrap-star-rating-master/js/star-rating.js" type="text/javascript"></script>
	}
	
	public function getFooterJs()
	{
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Chart.js/dist/Chart.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/echarts/dist/echarts.min.js");
		
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/jquery.vmap.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/maps/jquery.vmap.world.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/examples/js/jquery.vmap.sampledata.js");
	
	}
	
	public function AddEditProductAction()
	{
		if(count($_POST)>0)
		{
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$SeoObj = new DataTable(TABLE_SEO);
			$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
			$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;

			
			$DataArray = array();
			
			$DataArray['ProductName'] = isset($_POST['ProductName'])?$_POST['ProductName']:"";
			$DataArray['ProductLine'] = isset($_POST['ProductLine'])?$_POST['ProductLine']:"";
			$DataArray['ModelNo'] = isset($_POST['ModelNo'])?$_POST['ModelNo']:"";
			$DataArray['Active'] = (isset($_POST['Active']) && $_POST['Active'] !="")?$_POST['Active']:"0";
			$DataArray['SizeScale'] = (isset($_POST['SizeScale']) && $_POST['SizeScale'] !="")?$_POST['SizeScale']:"0";
			
			$DataArray['BrandID'] = isset($_POST['BrandID'])?$_POST['BrandID']:"0";
			$DataArray['SmallDescription'] = isset($_POST['SmallDescription'])?$_POST['SmallDescription']:"";
			$DataArray['LargeDescription'] = isset($_POST['LargeDescription'])?$_POST['LargeDescription']:"";
			
			$DataArray['StockMessage'] = (isset($_POST['StockMessage']) && $_POST['StockMessage'] !="")?$_POST['StockMessage']:"";
			$DataArray['StockStatus'] = (isset($_POST['StockStatus']) && $_POST['StockStatus'] !="")?$_POST['StockStatus']:"0";
			$DataArray['EndStock'] = (isset($_POST['EndStock']) && $_POST['EndStock'] !="")?$_POST['EndStock']:"0";
			$DataArray['StockTotal'] = (isset($_POST['StockTotal']) && $_POST['StockTotal'] !="")?$_POST['StockTotal']:"0";
			$DataArray['Stock'] = (isset($_POST['Stock']) && $_POST['Stock'] !="")?$_POST['Stock']:"0";
			
			$DataArray['ShippingProductID'] = (isset($_POST['ShippingProductID']) && $_POST['ShippingProductID'] > 0)?$_POST['ShippingProductID']:"0";
			$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"0";
			
			$DataArray['Weight'] = (isset($_POST['Weight']) && $_POST['Weight'] !="")?$_POST['Weight']:"0";
			$DataArray['YoutubeVideo'] = (isset($_POST['YoutubeVideo']) && $_POST['YoutubeVideo'] !="")?$_POST['YoutubeVideo']:"";
			$DataArray['YouTubeVideo2'] = (isset($_POST['YouTubeVideo2']) && $_POST['YouTubeVideo2'] !="")?$_POST['YouTubeVideo2']:"";
			
			$DataArray['ProductPoints'] = (isset($_POST['ProductPoints']) && $_POST['ProductPoints'] !="")?$_POST['ProductPoints']:"0";
			
			$DataArray['NotForSale'] = isset($_POST['NotForSale'])?$_POST['NotForSale']:0;
			$DataArray['SignedIn'] = isset($_POST['SignedIn'])?$_POST['SignedIn']:0;
			
			$DataArray['DeliveryExempt'] = isset($_POST['DeliveryExempt'])?$_POST['DeliveryExempt']:0;
			$DataArray['Clearance'] = isset($_POST['Clearance'])?$_POST['Clearance']:0;
			$DataArray['VirtualProduct'] = isset($_POST['VirtualProduct'])?$_POST['VirtualProduct']:0;
			$DataArray['FreeShippingStatus'] = isset($_POST['FreeShippingStatus'])?$_POST['FreeShippingStatus']:0;
			$DataArray['PurchaseURL'] = isset($_POST['PurchaseURL'])?$_POST['PurchaseURL']:"";
			$DataArray['GiftVoucherStatus'] = isset($_POST['GiftVoucherStatus'])?$_POST['GiftVoucherStatus']:0;
			
			
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			
			if($ProductID > 0)
			{
				/* product image added*/
				$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
				$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_product",'product/p-'.$ProductID,$DataArray['ProductName']);
				/* product image end*/
			
				$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
				$ProductObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
				
			}
			else 
			{
				$AutoIncrementID = $ProductObj->AutoIncrementID();
				/* product image added*/
				$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$AutoIncrementID);
				$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_product",'product/p-'.$AutoIncrementID,$DataArray['ProductName']);
				/* product image end*/
				
				$DataArray['ProductType'] = (isset($_POST['ProductType']) && $_POST['ProductType'] !="")?$_POST['ProductType']:"Simple";
				if(isset($_POST['ProductAttribute']) && is_array($_POST['ProductAttribute']) && count($_POST['ProductAttribute']) > 0){
					$DataArray['ProductAttribute'] = implode(",",$_POST['ProductAttribute']);
					$DataArray['ProductType'] = "Attribute";
				
				}
						
				$ProductObj->where ="1";
				$Position = $ProductObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['UploadType'] ='';
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$ProductID = $ProductObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Product added successfully."));
				
				
			}
			
			
			/* SEO START*/
			$SeoObj->where = "ReferenceID = ".$ProductID." AND MCode ='catalog_product' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$URL = 	SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['ProductName']);
			$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_product','Detail',$ProductID);
			$DataArray['URLName'] = $URL;
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "catalog_product";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $ProductID;
				$SeoObj->tableInsert($DataArray);
			}
			/* SEO END*/
			
		/* ProductPrice entry start*/
		$UserTypeID ='1';
		$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
								   (QtyMin='0' OR QtyMin='1')";
		$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
		$DataArray = array();
		$DataArray['Price'] = (isset($_POST['PriceArr']['Price'][$UserTypeID]) && $_POST['PriceArr']['Price'][$UserTypeID] !="")?$_POST['PriceArr']['Price'][$UserTypeID]:"0";
		$DataArray['SalePrice'] = (isset($_POST['PriceArr']['SalePrice'][$UserTypeID]) && $_POST['PriceArr']['SalePrice'][$UserTypeID] !="")?$_POST['PriceArr']['SalePrice'][$UserTypeID]:"0";
		$DataArray['SaleActive'] = (isset($_POST['PriceArr']['SaleActive'][$UserTypeID]) && $_POST['PriceArr']['SaleActive'][$UserTypeID] !="")?$_POST['PriceArr']['SaleActive'][$UserTypeID]:"0";
		
		if(isset($_POST['ProductType']) && $_POST['ProductType']=="Simple"){
			$DataArray['Price'] = (isset($_POST['PriceSimple']['Price'][$UserTypeID]) && $_POST['PriceSimple']['Price'][$UserTypeID] !="")?$_POST['PriceSimple']['Price'][$UserTypeID]:"0";
			$DataArray['SalePrice'] = (isset($_POST['PriceSimple']['SalePrice'][$UserTypeID]) && $_POST['PriceSimple']['SalePrice'][$UserTypeID] !="")?$_POST['PriceSimple']['SalePrice'][$UserTypeID]:"0";
			$DataArray['SaleActive'] = (isset($_POST['PriceSimple']['SaleActive'][$UserTypeID]) && $_POST['PriceSimple']['SaleActive'][$UserTypeID] !="")?$_POST['PriceSimple']['SaleActive'][$UserTypeID]:"0";
		}
		
		if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
		{
			$ProductPriceObj->tableUpdate($DataArray);
		}
		else 
		{
			$DataArray['QtyMin'] = "0";
			$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
			$DataArray['PriceType'] = 'Unit';
			$DataArray['UserTypeID'] = $UserTypeID;
			$DataArray['ProductID'] = $ProductID;
			$ProductPriceObj->tableInsert($DataArray);
		}
		
		$UserTypeID ='2';
		$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
								   (QtyMin='0' OR QtyMin='1')";
		$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
		$DataArray = array();
		$DataArray['Price'] = (isset($_POST['PriceArr']['Price'][$UserTypeID]) && $_POST['PriceArr']['Price'][$UserTypeID] !="")?$_POST['PriceArr']['Price'][$UserTypeID]:"0";
		$DataArray['SalePrice'] = (isset($_POST['SalePrice']['Price'][$UserTypeID]) && $_POST['PriceArr']['SalePrice'][$UserTypeID] !="")?$_POST['PriceArr']['SalePrice'][$UserTypeID]:"0";
		$DataArray['SaleActive'] = (isset($_POST['PriceArr']['SaleActive'][$UserTypeID]) && $_POST['PriceArr']['SaleActive'][$UserTypeID] !="")?$_POST['PriceArr']['SaleActive'][$UserTypeID]:"0";
		
		if(isset($_POST['ProductType']) && $_POST['ProductType']=="Simple"){
			$DataArray['Price'] = (isset($_POST['PriceSimple']['Price'][$UserTypeID]) && $_POST['PriceSimple']['Price'][$UserTypeID] !="")?$_POST['PriceSimple']['Price'][$UserTypeID]:"0";
			$DataArray['SalePrice'] = (isset($_POST['PriceSimple']['SalePrice'][$UserTypeID]) && $_POST['PriceSimple']['SalePrice'][$UserTypeID] !="")?$_POST['PriceSimple']['SalePrice'][$UserTypeID]:"0";
			$DataArray['SaleActive'] = (isset($_POST['PriceSimple']['SaleActive'][$UserTypeID]) && $_POST['PriceSimple']['SaleActive'][$UserTypeID] !="")?$_POST['PriceSimple']['SaleActive'][$UserTypeID]:"0";
		}
		
		if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
		{
			$ProductPriceObj->tableUpdate($DataArray);
		}
		else 
		{
			$DataArray['QtyMin'] = "0";
			$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
			$DataArray['PriceType'] = 'Unit';
			$DataArray['UserTypeID'] = $UserTypeID;
			$DataArray['ProductID'] = $ProductID;
			$ProductPriceObj->tableInsert($DataArray);
		}
		
		/* ProductPriceObj entry end*/
		
		
		
		/* Favourite statua entry start*/
		foreach($this->getClass('Catalog\Product\Common')->getProductFavouriteArray() as $ff=>$arr){
			$fav = (isset($_POST[$ff]) && $_POST[$ff]==1)?1:0;
			$CurrentFav = $this->getClass('Catalog\Product\Common')->IsProductFavourite($ProductID,$ff);
			
			if($fav==1 && $CurrentFav==true){
				/* noting to do*/
			}
			elseif($fav==1 && $CurrentFav==false){
			
				$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
				$DataArray = array();
				$DataArray['ProductID'] = $ProductID;
				$DataArray['RelationID'] = 0;
				$DataArray['RelationType'] = $ff;
				$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetRelatedSortOrder($ProductID,$ff) + 1;
				$ProductRelatedObj->tableInsert($DataArray);
			}
			else{
					$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
					$ProductRelatedObj->where = "RelationType='".$ff."' and ProductID='".(int)$ProductID."'";
					$ProductRelatedObj->tableDelete();	
			}
			
		}
		/* Favourite statua entry end*/
		
		
		if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
		{			
			$ProductCategoryObj->where = "RelationType='catalog_category' and ProductID='".(int)$ProductID."'";
			if(implode(",", $_POST['CategoryArr']) != "")
				 $ProductCategoryObj->where .= "and RelationID NOT IN (".implode(",",$_POST['CategoryArr']).")";
			
			$ProductCategoryObj->tableDelete();	
			foreach ($_POST['CategoryArr'] as $ck=>$cv)
			{
				if($cv !="")
				{	
					if($ParentID == 0)
						$ParentID =$cv;
					
					$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
											  array('=',array('ProductID' => $ProductID)),
											  array('=',array('RelationID' => $cv))											  
											  );
					$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
					if(!isset($CObj->id)){
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['RelationID'] = $cv;
						$DataArray['RelationType'] = "catalog_category";
						$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
						$ProductCategoryObj->tableInsert($DataArray);
					}
				}
			}
		}
		
		if($ProductID > 0){
			$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
		}
		
			if(isset($_GET['iframe'])){
					$this->AllDone = "1";
				}
			else{	
				if(isset($_POST['Continue'])){	
					if($this->origin->rview)
						MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&rview=".$this->origin->rview);
					else
						MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID");
				}
				else{ 
					if($this->origin->rview)
						MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->rview."&ParentID=$ParentID&ProductID=$ProductID");
					else
						MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=Default&ParentID=$ParentID&ProductID=$ProductID");
				}
				exit;
			}
		}
		
	}
	public function AddEditChildProductAction()
	{
		if(count($_POST)>0)
		{
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
			$MasterID = (isset($_GET['MasterID']) && $_GET['MasterID'] > 0)?$_GET['MasterID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$DataArray = array();
			
			$DataArray['ModelNo'] = isset($_POST['ModelNo'])?$_POST['ModelNo']:"";
			$DataArray['LargeDescription'] = isset($_POST['LargeDescription'])?$_POST['LargeDescription']:"";
			$DataArray['StockMessage'] = (isset($_POST['StockMessage']) && $_POST['StockMessage'] !="")?$_POST['StockMessage']:"";
			$DataArray['StockStatus'] = (isset($_POST['StockStatus']) && $_POST['StockStatus'] !="")?$_POST['StockStatus']:"0";
			$DataArray['EndStock'] = (isset($_POST['EndStock']) && $_POST['EndStock'] !="")?$_POST['EndStock']:"0";
			$DataArray['StockTotal'] = (isset($_POST['StockTotal']) && $_POST['StockTotal'] !="")?$_POST['StockTotal']:"0";
			$DataArray['Stock'] = (isset($_POST['Stock']) && $_POST['Stock'] !="")?$_POST['Stock']:"0";
			$DataArray['Weight'] = (isset($_POST['Weight']) && $_POST['Weight'] !="")?$_POST['Weight']:"0";
			
			$DataArray['FeedBarcode'] = isset($_POST['FeedBarcode'])?$_POST['FeedBarcode']:"";
			$DataArray['FeedGtin'] = isset($_POST['FeedGtin'])?$_POST['FeedGtin']:"";
			$DataArray['Clearance'] = isset($_POST['Clearance'])?$_POST['Clearance']:0;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						
			
			/* product image added*/
			$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$MasterID);
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_product",'product/p-'.$MasterID,$DataArray['ProductName']);
			/* product image end*/
			
			if($ProductID > 0)
			{
				$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
				$ProductObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
				
			}
			
			
		/* ProductPrice entry start*/
		$UserTypeID ='1';
		$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
								   (QtyMin='0' OR QtyMin='1')";
		$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
		$DataArray = array();
		$DataArray['Price'] = (isset($_POST['PriceSimple']['Price'][$UserTypeID]) && $_POST['PriceSimple']['Price'][$UserTypeID] !="")?$_POST['PriceSimple']['Price'][$UserTypeID]:"0";
		$DataArray['SalePrice'] = (isset($_POST['PriceSimple']['SalePrice'][$UserTypeID]) && $_POST['PriceSimple']['SalePrice'][$UserTypeID] !="")?$_POST['PriceSimple']['SalePrice'][$UserTypeID]:"0";
		$DataArray['SaleActive'] = (isset($_POST['PriceSimple']['SaleActive'][$UserTypeID]) && $_POST['PriceSimple']['SaleActive'][$UserTypeID] !="")?$_POST['PriceSimple']['SaleActive'][$UserTypeID]:"0";
		
		
		if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
		{
			$ProductPriceObj->tableUpdate($DataArray);
		}
		else 
		{
			$DataArray['QtyMin'] = "0";
			$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
			$DataArray['PriceType'] = 'Unit';
			$DataArray['UserTypeID'] = $UserTypeID;
			$DataArray['ProductID'] = $ProductID;
			$ProductPriceObj->tableInsert($DataArray);
		}
		
		$UserTypeID ='2';
		$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
								   (QtyMin='0' OR QtyMin='1')";
		$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
		$DataArray = array();
		$DataArray['Price'] = (isset($_POST['PriceSimple']['Price'][$UserTypeID]) && $_POST['PriceSimple']['Price'][$UserTypeID] !="")?$_POST['PriceSimple']['Price'][$UserTypeID]:"0";
		$DataArray['SalePrice'] = (isset($_POST['PriceSimple']['SalePrice'][$UserTypeID]) && $_POST['PriceSimple']['SalePrice'][$UserTypeID] !="")?$_POST['PriceSimple']['SalePrice'][$UserTypeID]:"0";
		$DataArray['SaleActive'] = (isset($_POST['PriceSimple']['SaleActive'][$UserTypeID]) && $_POST['PriceSimple']['SaleActive'][$UserTypeID] !="")?$_POST['PriceSimple']['SaleActive'][$UserTypeID]:"0";
		
		if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
		{
			$ProductPriceObj->tableUpdate($DataArray);
		}
		else 
		{
			$DataArray['QtyMin'] = "0";
			$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
			$DataArray['PriceType'] = 'Unit';
			$DataArray['UserTypeID'] = $UserTypeID;
			$DataArray['ProductID'] = $ProductID;
			$ProductPriceObj->tableInsert($DataArray);
		}
		
		/* ProductPriceObj entry end*/
		
		if($MasterID > 0){
			$this->getClass('Catalog\Product\Common')->IndexProductSearch($MasterID);
		}
		
		if(isset($_GET['iframe']))
		{
			$this->AllDone = "1";
		}
		else{	
			if(isset($_POST['Continue'])){	
				if($this->origin->rview)
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&rview=".$this->origin->rview);
				else
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID");
			}
			else{ 
				if($this->origin->rview)
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->rview."&ParentID=$ParentID&ProductID=$ProductID");
				else
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=Default&ParentID=$ParentID&ProductID=$ProductID");
			}
			exit;
		}
		}
		
	}
	public function BulkProductsIndexesAction()
	{
		if(count($_POST)>0)
		{
			if(isset($_POST['SelctedProduct'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0){
						$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
					}
				}
					
			}
			if(isset($_POST['AllProduct'])){
				
				$where = new Where();
					$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
					$where->notEqualTo('p.ProductType','Child');
					$ProductObj->where = $where;
					//$ProductObj->displayQuery =true;
					$rows = $ProductObj->tableSelectAll(array("ProductID"),"p.ProductID ASC");
					foreach( $rows as $CurrentRecord){
						if($CurrentRecord->ProductID > 0){
							$this->getClass('Catalog\Product\Common')->IndexProductSearch($CurrentRecord->ProductID);
						}
					}
			}
			$this->getSession()->setArrVar("alert",array("success","Product indexes successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&ParentID=".$this->origin->ParentID."&PageNo=".$this->origin->PageNo);
			exit;
		}
	}
	public function UpdateProductAction()
	{
		if(count($_POST)>0)
		{
			
			/* BulkAllRemoveCategory start*/
			if(isset($_POST['BulkAllRemoveCategory'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				
				if($ParentID > 0)
					{
						$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
						$ProductCategoryObj->where = array(array('=',array('RelationType' => "catalog_category")),
														  array('=',array('RelationID' => $ParentID)));
						$ProductCategoryObj->tableDelete();								
					}	
				
				$this->getSession()->setArrVar("alert",array("success","All Products removed from the category list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkAllRemoveCategory end*/
			
			/* BulkRemoveCategory start*/
			if(isset($_POST['BulkRemoveCategory'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0 && $ParentID > 0)
					{
						$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
						$ProductCategoryObj->where = array(array('=',array('RelationType' => "catalog_category")),
														  array('=',array('RelationID' => $ParentID)),
														  array('=',array('ProductID' => $ProductID))											  
														  );
						$ProductCategoryObj->tableDelete();								
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the category list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkRemoveCategory end*/
			
			/* BulkRemovePermanent start*/
			if(isset($_POST['BulkRemovePermanent'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0){
						$this->getClass('Catalog\Product\Common')->DeleteProduct($ProductID);
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products deleted successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkRemovePermanent end*/
			
			/* BulkSubmit start*/
			if(isset($_POST['BulkSubmit'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0){
						
						$DataArray = array();		
						if(isset($_POST['NotForSale']) && $_POST['NotForSale'] != "")
							$DataArray['NotForSale'] = isset($_POST['NotForSale'])?$_POST['NotForSale']:0;
						if(isset($_POST['SignedIn']) && $_POST['SignedIn'] != "")
							$DataArray['SignedIn'] = isset($_POST['SignedIn'])?$_POST['SignedIn']:0;
						if(isset($_POST['Homepage']) && $_POST['Homepage'] != "")
							$DataArray['Homepage'] = isset($_POST['Homepage'])?$_POST['Homepage']:0;
						if(isset($_POST['Featured']) && $_POST['Featured'] != "")
							$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
						if(isset($_POST['VIPStatus']) && $_POST['VIPStatus'] != "")
							$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
						if(isset($_POST['WholeSaler']) && $_POST['WholeSaler'] != "")
							$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
						if(isset($_POST['GDiscountOff']) && $_POST['GDiscountOff'] != "")
							$DataArray['GDiscountOff'] = isset($_POST['GDiscountOff'])?$_POST['GDiscountOff']:0;
						if(isset($_POST['FreeShippingStatus']) && $_POST['FreeShippingStatus'] != "")
							$DataArray['FreeShippingStatus'] = isset($_POST['FreeShippingStatus'])?$_POST['FreeShippingStatus']:0;
						if(isset($_POST['Active']) && $_POST['Active'] != "")
							$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						if(count($DataArray) > 0){
							$ProductObj = new DataTable(TABLE_PRODUCT);
							$ProductObj->where="ProductID ='".(int)$ProductID."'";
							$ProductObj->tableUpdate($DataArray);
						}
						
						/* Favourite statua entry start*/
					foreach($this->getClass('Catalog\Product\Common')->getProductFavouriteArray() as $ff=>$arr){
						if(isset($_POST[$ff]) && $_POST[$ff]==1){
							$CurrentFav = $this->getClass('Catalog\Product\Common')->IsProductFavourite($ProductID,$ff);
							if($CurrentFav==false){
								$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
								$DataArray = array();
								$DataArray['ProductID'] = $ProductID;
								$DataArray['RelationID'] = 0;
								$DataArray['RelationType'] = $ff;
								$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetRelatedSortOrder($ProductID,$ff) + 1;
								$ProductRelatedObj->tableInsert($DataArray);
							}
						}
						
						if(isset($_POST[$ff]) && $_POST[$ff]=="-1"){
							$CurrentFav = $this->getClass('Catalog\Product\Common')->IsProductFavourite($ProductID,$ff);
							if($CurrentFav==true){
								$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
								$ProductRelatedObj->where = "RelationType='".$ff."' and ProductID='".(int)$ProductID."'";
								$ProductRelatedObj->tableDelete();	
							}
						
						}
						
					}
					/* Favourite statua entry end*/
						
						if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
						{			
							foreach ($_POST['CategoryArr'] as $ck=>$cv)
							{
								$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
								if($cv !="")
								{	
									$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
															  array('=',array('ProductID' => $ProductID)),
															  array('=',array('RelationID' => $cv))											  
															  );
									$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
									if(!isset($CObj->id)){
										$DataArray = array();
										$DataArray['ProductID'] = $ProductID;
										$DataArray['RelationID'] = $cv;
										$DataArray['RelationType'] = "catalog_category";
										$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
										$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
										$ProductCategoryObj->tableInsert($DataArray);
									}
								}
							}
						}
						
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkSubmit end*/
			
			/* UpdateList start*/
			if(isset($_POST['UpdateList'])){
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
				for ($i=1;$i <$_POST['Count'];$i++)
				{
					$ProductID =$_POST['ProductID_'.$i];
					$DataArray = array();
					//$DataArray['DifficultyRating'] = isset($_POST['DifficultyRating_'.$i])?$_POST['DifficultyRating_'.$i]:0;
					$DataArray['Stock'] = isset($_POST['Stock_'.$i])?$_POST['Stock_'.$i]:0;
					$DataArray['StockTotal'] = isset($_POST['StockTotal_'.$i])?$_POST['StockTotal_'.$i]:0;
					$DataArray['StockStatus'] = isset($_POST['StockStatus_'.$i])?$_POST['StockStatus_'.$i]:0;
					$DataArray['NotForSale'] = isset($_POST['NotForSale_'.$i])?$_POST['NotForSale_'.$i]:0;
					$DataArray['GDiscountOff'] = isset($_POST['GDiscountOff_'.$i])?$_POST['GDiscountOff_'.$i]:0;
					$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
					
					//$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
					$ProductObj->where="ProductID ='".(int)$ProductID."'";
					$ProductObj->tableUpdate($DataArray);
					
					$DataArray = array();
					$DataArray['SortOrder'] = (isset($_POST['SortOrder_'.$i]) && $_POST['SortOrder_'.$i] !="")?$_POST['SortOrder_'.$i]:0;			
					
					$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
												  array('=',array('RelationID' => $this->origin->ParentID)),
												  array('=',array('ProductID' => $ProductID))											  
												  );
												  
					$ProductCategoryObj->tableUpdate($DataArray);
					
				}
				$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID."&PageNo=".$this->origin->PageNo);
				 exit;
			}
		 /* UpdateList end*/
		
		}
	}
	
	public function BulkProductsStockAction()
	{
		if(count($_POST)>0)
		{
			
			/* BulkRemovePermanent start*/
			if(isset($_POST['BulkRemovePermanent'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0){
						$this->getClass('Catalog\Product\Common')->DeleteProduct($ProductID);				
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products deleted successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy."&k=".$this->origin->k);
			    exit;
			}
			/* BulkRemovePermanent end*/
			
			/* BulkSubmit start*/
			if(isset($_POST['BulkSubmit'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0){
						
						$DataArray = array();		
						if(isset($_POST['NotForSale']) && $_POST['NotForSale'] != "")
							$DataArray['NotForSale'] = isset($_POST['NotForSale'])?$_POST['NotForSale']:0;
						if(isset($_POST['SignedIn']) && $_POST['SignedIn'] != "")
							$DataArray['SignedIn'] = isset($_POST['SignedIn'])?$_POST['SignedIn']:0;
						if(isset($_POST['Homepage']) && $_POST['Homepage'] != "")
							$DataArray['Homepage'] = isset($_POST['Homepage'])?$_POST['Homepage']:0;
						if(isset($_POST['Featured']) && $_POST['Featured'] != "")
							$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
						if(isset($_POST['VIPStatus']) && $_POST['VIPStatus'] != "")
							$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
						if(isset($_POST['WholeSaler']) && $_POST['WholeSaler'] != "")
							$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
						if(isset($_POST['GDiscountOff']) && $_POST['GDiscountOff'] != "")
							$DataArray['GDiscountOff'] = isset($_POST['GDiscountOff'])?$_POST['GDiscountOff']:0;
						if(isset($_POST['FreeShippingStatus']) && $_POST['FreeShippingStatus'] != "")
							$DataArray['FreeShippingStatus'] = isset($_POST['FreeShippingStatus'])?$_POST['FreeShippingStatus']:0;
						if(isset($_POST['Active']) && $_POST['Active'] != "")
							$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						if(count($DataArray) > 0){
							$ProductObj = new DataTable(TABLE_PRODUCT);
							$ProductObj->where="ProductID ='".(int)$ProductID."'";
							$ProductObj->tableUpdate($DataArray);
						}
						
						if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
						{			
							foreach ($_POST['CategoryArr'] as $ck=>$cv)
							{
								$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
								if($cv !="")
								{	
									$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
															  array('=',array('ProductID' => $ProductID)),
															  array('=',array('RelationID' => $cv))											  
															  );
									$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
									if(!isset($CObj->id)){
										$DataArray = array();
										$DataArray['ProductID'] = $ProductID;
										$DataArray['RelationID'] = $cv;
										$DataArray['RelationType'] = "catalog_category";
										$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
										$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
										$ProductCategoryObj->tableInsert($DataArray);
									}
								}
							}
						}
						
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy."&k=".$this->origin->k);
			    exit;
			}
			/* BulkSubmit end*/
			
		}
	}
	
	public function BulkFeaturedProductAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$DataArray = array();
						$DataArray['Featured'] = "0";
						$ProductObj->where="ProductID ='".(int)$ProductID."'";
						$ProductObj->tableUpdate($DataArray);
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the featured list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/			
		}
	}
	
	public function BulkHomepageProductAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
						$ProductRelationObj->where = array(array('=',array('RelationType' => 'Homepage')),
																  array('=',array('ProductID' => $ProductID)),
																  array('=',array('RelationID' => '0'))											  
																  );
						$ProductRelationObj->tableDelete();
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the homepage list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/	
			/* UpdateList start*/
			if(isset($_POST['UpdateList'])){
				for ($i=1;$i <$_POST['Count'];$i++)
				{
					$ProductID =$_POST['ProductID_'.$i];
					$DataArray = array();
					$DataArray['SortOrder'] = (isset($_POST['SortOrder_'.$i]) && $_POST['SortOrder_'.$i] !="")?$_POST['SortOrder_'.$i]:0;			
					$DataArray['Custom'] = (isset($_POST['Custom_'.$i]) && $_POST['Custom_'.$i] !="")?$_POST['Custom_'.$i]:0;			
					$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
					$ProductCategoryObj->where = array(array('=',array('RelationType' => 'Homepage')),
												  array('=',array('RelationID' => '0')),
												  array('=',array('ProductID' => $ProductID))											  
												  );
					//echo "<pre>";var_dump($DataArray);							  
					$ProductCategoryObj->tableUpdate($DataArray);
					
				}
				$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
				 exit;
			}
		 /* UpdateList end*/
			
		}
	}
	
	
	public function UpdateFiltersAction()
	{
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
						
		if(count($_POST) > 0){
			
			$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION_FILTER);
			$ProductRelationObj->where = "ProductID='".(int)$ProductID."'";
			$ProductRelationObj->tableDelete();	
			
			foreach($_POST['ProductFilter'] as $FilterID=>$Arr){
				foreach($_POST['ProductFilter'][$FilterID] as $FilterValueID){
					$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION_FILTER);
					$AttDataArray = array();
					$AttDataArray['ProductID'] = $ProductID;
					$AttDataArray['FilterValueID'] = $FilterValueID;
					$AttDataArray['FilterID'] = $FilterID;
					$ProductRelationObj->tableInsert($AttDataArray);
				}
			}
			
			if($ProductID > 0){
				$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=filters");
		exit;
	}
	
	public function BulkPricesAction()
	{
		if(count($_POST)>0){
			
			/* BulkPrices start*/
			if(!isset($_POST['CategoryArr']))
				$this->getSession()->setArrVar("alert",array("danger","Please select categories."));
			if(isset($_POST['CategoryArr']) && count($_POST['CategoryArr'])==0)
				$this->getSession()->setArrVar("alert",array("danger","Please select categories."));
			
			$arr = $this->getSession()->getVar("alert");
			 if($arr==NULL || count($arr)==0)	{
				if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0){
					
					$where = new Where();
					$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
					$where->notEqualTo('p.ProductType','Child');
					$where->in('ptc.RelationID',$_POST['CategoryArr']);
					$ProductObj->where = $where;
				
					$ProductObj->joinExpression = true;
					$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
												  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='catalog_category')",
												  'columns'=>array("RelationID","SortOrder"),
												  'type'=>''
												  );
					//$ProductObj->displayQuery =true;
					$rows = $ProductObj->tableSelectAll(array("ProductID"),"p.ProductID ASC");
					foreach( $rows as $CurrentRecord){
						$ProductID = $CurrentRecord->ProductID;
						if(isset($_POST['Status'][1]) && $_POST['Status'][1]=="1"){
							$UserTypeID ='1';
							$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
							$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
													   (QtyMin='0' OR QtyMin='1')";
							$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID","Price"));
							if(isset($_POST['Price'][1]) && $_POST['Price'][1] > 0){
								$PercentageAmount=($_POST['Price'][1]/100) * $CurrentPrice->Price;
								$Price = $CurrentPrice->Price + $PercentageAmount;
								if(isset($_POST['PriceSet'][1]) && $_POST['PriceSet'][1]=="-")
									$Price = $CurrentPrice->Price - $PercentageAmount;
								$DataArray = array();
								$DataArray['Price'] = $Price;
								if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !=""){
									$ProductPriceObj->tableUpdate($DataArray);
								}
							}
							
						}
						
						if(isset($_POST['Status'][2]) && $_POST['Status'][2]=="1"){
							$UserTypeID ='2';
							$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
							$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
													   (QtyMin='0' OR QtyMin='1')";
							$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID","Price"));
							if(isset($_POST['Price'][2]) && $_POST['Price'][2] > 0){
								$PercentageAmount=($_POST['Price'][2]/100) * $CurrentPrice->Price;
								$Price = $CurrentPrice->Price + $PercentageAmount;
								if(isset($_POST['PriceSet'][2]) && $_POST['PriceSet'][2]=="-")
									$Price = $CurrentPrice->Price - $PercentageAmount;
								$DataArray = array();
								$DataArray['Price'] = $Price;
								if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !=""){
									$ProductPriceObj->tableUpdate($DataArray);
								}
							}
							
						}
					
						if($ProductID > 0){
							$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
						}		
					}
					
					
				}
				
				$this->getSession()->setArrVar("alert",array("success","All products prices updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."");
			    exit;
			 }
			
		
			/* BulkPrices end*/			
		}
	}
	
	public function BulkWholesaleProductsAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$DataArray = array();
						$DataArray['WholeSaler'] = "0";
						$ProductObj->where="ProductID ='".(int)$ProductID."'";
						$ProductObj->tableUpdate($DataArray);
					
					}
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the wholesaler list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/			
		}
	}
	
	
	public function BulkVIPStatusProductsAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$DataArray = array();
						$DataArray['VIPStatus'] = "0";
						$ProductObj->where="ProductID ='".(int)$ProductID."'";
						$ProductObj->tableUpdate($DataArray);
					
					}
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the VIP list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/			
		}
	}
	
	
	public function BulkFlashProductAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductPriceObj = new DataTable(TABLE_PRODUCT_PRICES);
						$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='10'";
						$ProductPriceObj->tableDelete();
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the flash sale."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy);
			    exit;
			}
			/* BulkSelectedRemove end*/
			/* BulkAllRemove start*/
			if(isset($_POST['BulkAllRemove'])){
					$ProductPriceObj = new DataTable(TABLE_PRODUCT_PRICES);
					$ProductPriceObj->where = "UserTypeID ='10'";
					$ProductPriceObj->tableDelete();
				$this->getSession()->setArrVar("alert",array("success","Products removed from the flash sale."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy);
			    exit;
			}
			/* BulkAllRemove end*/
		}
	}
	public function DeleteProductAction()
	{
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		if($ProductID > 0)
		{
			$this->getClass('Catalog\Product\Common')->DeleteProduct($ProductID);
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Product deleted successfully."));
		if($this->origin->rview)
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID."&view=".$this->origin->rview);
		else
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		exit;
	}
	
	public function DeleteAllAction()
	{
		$Agree = isset($_POST['Agree'])?$_POST['Agree']:0;
		if($Agree > 0)
		{
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			//$ProductObj->displayQuery =true;
			$rows = $ProductObj->tableSelectAll(array("ProductID"),"p.ProductID ASC");
			foreach( $rows as $CurrentRecord){
				$ProductID = $CurrentRecord->ProductID;
				if($ProductID > 0)
					$this->getClass('Catalog\Product\Common')->DeleteProduct($ProductID);
			}
		}			
		$this->getSession()->setArrVar("alert",array("success","Products deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
		exit;
	}
	
	public function DeleteCategoryProductAction()
	{
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		if($ProductID > 0 && $ParentID > 0)
		{
			$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductCategoryObj->where = array(array('=',array('RelationType' => "catalog_category")),
											  array('=',array('RelationID' => $ParentID)),
											  array('=',array('ProductID' => $ProductID))											  
											  );
			$ProductCategoryObj->tableDelete();								
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Product removed from the category list."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	
	/* UpdateChildren section start*/
	public function UpdateChildrenAction()
	{
		$MasterID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$CurrentRecord = $this->getDetail($MasterID);
		if($MasterID > 0 && count($_POST) > 0 && isset($CurrentRecord->ProductID)){
			$AttributeArr = $this->getClass('Catalog\Attribute\Common')->getAttributeArrayWithValues(explode(',',$CurrentRecord->ProductAttribute));
			$ChildIDArr = $this->getClass('Catalog\Product\Common')->getProductChildrenIDs($MasterID);
			$UpdatedChildIDArr = array();
			foreach ($_POST['Active'] as $k=>$v){
				$ChildProductID = $_POST['ChildProductID'][$k]?:0;
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
				$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
			
				if($ChildProductID > 0){
					$UpdatedChildIDArr[] = $ChildProductID;
				}
				else{
					/*insert */
					$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
					$Position = $ProductObj->getMax("Position") + 1;
					$BlankData = array();
					$BlankData['ProductType'] = 'Child';
					$BlankData['MasterID'] = $MasterID;
					$BlankData['Position'] = $Position;
					$SubDataArray['UploadType'] ='';
					$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
					$ChildProductID = $ProductObj->tableInsert($BlankData);		
					
				}
				
				$ProductRelationObj->where = "RelationType='attribute_child' and ProductID='".(int)$ChildProductID."'";
				$ProductRelationObj->tableDelete();	
			
			
				$SubDataArray = array();
				$ProductAttribute = "";
				$ProductAttributeString = $CurrentRecord->ProductName;
				$ModelNoString = $CurrentRecord->ModelNo;
				foreach($AttributeArr as $AttributeID=>$Arr){
					$ProductAttribute .= ($AttributeID."=".($_POST['AttributeValueID'][$AttributeID][$k]?? "")).", ";
					$ProductAttributeString .= " - ".($Arr['AttributeName'].": ".$Arr['Values'][$_POST['AttributeValueID'][$AttributeID][$k]]['AttributeValue']);
					$ModelNoString .= "___".($_POST['AttributeValueID'][$AttributeID][$k]?? "");
					
					$AttDataArray = array();
					$AttDataArray['ProductID'] = $ChildProductID;
					$AttDataArray['RelationID'] = ($_POST['AttributeValueID'][$AttributeID][$k]?? "");
					$AttDataArray['RelationType'] = "attribute_child";
					$AttDataArray['Custom'] = $AttributeID;
					$ProductRelationObj->tableInsert($AttDataArray);
					
				}
				$SubDataArray['ProductAttribute'] = substr($ProductAttribute,0,-2); 
				
				$SubDataArray['ProductName'] = $ProductAttributeString;
				$SubDataArray['SmallDescription'] = $ProductAttributeString;
				$SubDataArray['ProductLine'] = $ModelNoString;
				$SubDataArray['ModelNo'] = $_POST['ModelNo'][$k]?: ""; //$ModelNoString;
				
				
				$SubDataArray['StockMessage'] = $_POST['StockMessage'][$k]?: $CurrentRecord->StockMessage;
				$SubDataArray['StockStatus'] = $_POST['StockStatus'][$k]?: "0";
				$SubDataArray['EndStock'] = $_POST['EndStock'][$k]?: "0"; 
				$SubDataArray['StockTotal'] = $_POST['StockTotal'][$k]?: "0"; 
				$SubDataArray['Stock'] = $_POST['Stock'][$k]?: "0"; 
				$SubDataArray['Weight'] = $_POST['Weight'][$k]?: "0"; 
				$SubDataArray['ShippingProductID'] = $_POST['ShippingProductID'][$k]?: "0"; 
				$SubDataArray['Active'] = $_POST['Active'][$k]?: "0"; 
				$SubDataArray['Position'] = $_POST['Position'][$k]?: "0";  
				
				if($ChildProductID > 0){
					/*update */
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
					$ProductObj->tableUpdate($SubDataArray);
				}
				
				
				
				/* ProductPrice entry start*/
				$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".(int)(isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1")."' AND (QtyMin='0' OR QtyMin='1')";
				$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
				$DataArray = array();
				$DataArray['Price'] = $_POST['Price'][$k]?: "0"; 
				$DataArray['SalePrice'] = $_POST['SalePrice'][$k]?: "0"; 
				$DataArray['SaleActive'] = $_POST['SaleActive'][$k]?: "0"; 
				if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
				{
					$ProductPriceObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['QtyMin'] = "0";
					$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$DataArray['PriceType'] = 'Unit';
					$DataArray['UserTypeID'] = isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1";
					$DataArray['ProductID'] = $ChildProductID;
					$ProductPriceObj->tableInsert($DataArray);
				}
				/* ProductPriceObj entry end*/
				
			}

			/* Delete ChildIDs */
			$DeletedChildIDArr = array_diff($ChildIDArr,$UpdatedChildIDArr);
			if(is_array($DeletedChildIDArr) && count($DeletedChildIDArr) > 0){
				foreach($DeletedChildIDArr as $DeleteID){
					$this->getClass('Catalog\Product\Common')->DeleteProduct($DeleteID);
				}
			}
			/* Delete ChildIDs END*/
		
			if($MasterID > 0){
				$this->getClass('Catalog\Product\Common')->IndexProductSearch($MasterID);
			}
			
		}
		
		$this->getSession()->setArrVar("alert",array("success","Product(s) updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$MasterID&tab=attributes");
		exit;
	}
	
	public function UpdateChildrenBulkAction()
	{
		$MasterID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$CurrentRecord = $this->getDetail($MasterID);
		$ChildIDArr = $this->getClass('Catalog\Product\Common')->getProductChildrenIDs($MasterID);
		if(count($ChildIDArr) > 0 && $MasterID > 0 && count($_POST) > 0 && isset($CurrentRecord->ProductID)){
		
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
					
			
			$SubDataArray = array();
			if(isset($_POST['StockTotalChange']) && $_POST['StockTotalChange']=="1")
				$SubDataArray['StockStatus'] = $_POST['StockStatus']?: "0";
			
			if(isset($_POST['StockChange']) && $_POST['StockChange']=="1")
				$SubDataArray['Stock'] = $_POST['Stock']?: "0";
			
			if(isset($_POST['EndStockChange']) && $_POST['EndStockChange']=="1")
				$SubDataArray['EndStock'] = $_POST['EndStock']?: "0";
			
			if(isset($_POST['WeightChange']) && $_POST['WeightChange']=="1")
				$SubDataArray['Weight'] = $_POST['Weight']?: "0";
			
			if(isset($_POST['ShippingProductIDChange']) && $_POST['ShippingProductIDChange']=="1")
				$SubDataArray['ShippingProductID'] = $_POST['ShippingProductID']?: "0";
			
			if(isset($_POST['ActiveChange']) && $_POST['ActiveChange']=="1")
				$SubDataArray['Active'] = $_POST['Active']?: "0";

			if(count($SubDataArray) > 0){
				$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
				$ProductObj->tableUpdate($SubDataArray);
			}
			
			$PriceDataArray = array();
			if(isset($_POST['PriceChange']) && $_POST['PriceChange']=="1")
				$PriceDataArray['Price'] = $_POST['Price']?: "0";
			
			if(isset($_POST['SalePriceChange']) && $_POST['SalePriceChange']=="1")
				$PriceDataArray['SalePrice'] = $_POST['SalePrice']?: "0";
			
			if(isset($_POST['SaleActiveChange']) && $_POST['SaleActiveChange']=="1")
				$PriceDataArray['SaleActive'] = $_POST['SaleActive']?: "0";
			
			if(count($PriceDataArray) > 0){
			
				$ProductPriceObj->where = "ProductID IN (".implode(',',$ChildIDArr).") AND 
						UserTypeID ='".(int)(isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1")."' 
				AND QtyMin='0'";
				$ProductPriceObj->tableUpdate($PriceDataArray);
			}
			
			if($MasterID > 0){
				$this->getClass('Catalog\Product\Common')->IndexProductSearch($MasterID);
			}	
		}
		
		$this->getSession()->setArrVar("alert",array("success","Product(s) updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$MasterID&tab=attributes");
		exit;
	}
	
	public function ResetAttributesAllAction()
	{
		$MasterID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$CurrentRecord = $this->getDetail($MasterID);
		if(isset($_POST['ProductAttributeReset']) && is_array($_POST['ProductAttributeReset']) && count($_POST['ProductAttributeReset']) > 0){
				
				$ProductAttribute = explode(',',$CurrentRecord->ProductAttribute);
				if(array_diff($ProductAttribute , $_POST['ProductAttributeReset']) != array_diff($_POST['ProductAttributeReset'],$ProductAttribute)){
					
					$DataArray = array();
					$DataArray['ProductAttribute'] = implode(",",$_POST['ProductAttributeReset']);
					$DataArray['ProductType'] = "Attribute";
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where="ProductID ='".(int)$MasterID."'";
					$ProductObj->tableUpdate($DataArray);
					
					$DeletedChildIDArr = $this->getClass('Catalog\Product\Common')->getProductChildrenIDs($MasterID);
					if(is_array($DeletedChildIDArr) && count($DeletedChildIDArr) > 0){
						foreach($DeletedChildIDArr as $DeleteID){
							$this->getClass('Catalog\Product\Common')->DeleteProduct($DeleteID);
						}
					}
					
					$this->getSession()->setArrVar("alert",array("success","Product attribute(s) reset successfully."));
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$MasterID&tab=attributes");
					exit;
				}
				else{
					$this->getSession()->setArrVar("alert",array("danger","Nothing change in attribute(s)."));
				}
				
				
			
		}
		
		
	}
	
	public function getProductChildren($MasterID)
	{
		if($MasterID > 0)
		{
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductObj->where[] = array('=',array('p.MasterID' => $MasterID));
			$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
			$ProductObj->where[] = array('=',array('pr.UserTypeID' => '1'));
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID)",
										  'columns'=>array("Price","SalePrice","SaleActive"),
										  'type'=>"left",
										  );
			$ProductObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID = pr.UserTypeID AND IsDefault=1)",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			
			//$ProductObj->displayQuery = true;
			return $ProductObj->tableSelectAll(array("*"),array("ProductID ASC"));
		}
		
	
		return ;
	}

	public function getChildAttributeValueFromRel($ProductID,$AttributeID)
	{
		if($ProductID > 0 && $AttributeID > 0){
			$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelationObj->where = array(array('=',array('RelationType' => 'attribute_child')),
													  array('=',array('ProductID' => $ProductID)),
													  array('=',array('Custom' => $AttributeID))											  
													  );
			return (object)$ProductRelationObj->tableSelectOne(array("RelationID"));
		}
		return ;
							
	}

	
	/* UpdateChildren section end*/
	
	
/* product prices section start*/
	public function UpdatePricesAction()
	{
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		$ProductPriceObj = new DataTable(TABLE_PRODUCT_PRICES);
		
			/* ProductPrice entry start*/
		$DataArray = array();
		$DataArray['Price'] = (isset($_POST['Price']) && $_POST['Price'] !="")?$_POST['Price']:"0";
		$DataArray['SalePrice'] = (isset($_POST['SalePrice']) && $_POST['SalePrice'] !="")?$_POST['SalePrice']:"0";
		$DataArray['SaleActive'] = isset($_POST['SaleActive'])?$_POST['SaleActive']:0;
		
		/* ProductPriceObj entry end*/
		if(count($_POST)>0)
		{
			$UserTypeArray = $this->getProductCommon()->getUserTypeByProductPrices();
			foreach($UserTypeArray as $t=>$CurrentType)
			{
				$UserTypeID = $CurrentType['UserTypeID'];
				//if(in_array($UserTypeID,array(1,10)))
				if(in_array($UserTypeID,array(-1)))
				{
					$SubDataArray = array();
					if($UserTypeID == 1)
						$SubDataArray['Price'] = (isset($_POST['Price'][$UserTypeID][0]) && $_POST['Price'][$UserTypeID][0] !="")?$_POST['Price'][$UserTypeID][0]:"0";
					else
						$SubDataArray['Price'] = (isset($_POST['Price'][1][0]) && $_POST['Price'][1][0] !="")?$_POST['Price'][1][0]:"0";
				
					$SubDataArray['SaleStartDate'] = (isset($_POST['SaleStartDate'][$UserTypeID][0]) && $_POST['SaleStartDate'][$UserTypeID][0] !="")?$_POST['SaleStartDate'][$UserTypeID][0]:NULL;
					$SubDataArray['SaleEndDate'] = (isset($_POST['SaleEndDate'][$UserTypeID][0]) && $_POST['SaleEndDate'][$UserTypeID][0] !="")?$_POST['SaleEndDate'][$UserTypeID][0]." 23:59:59":NULL;
					
					$SubDataArray['SalePrice'] = (isset($_POST['SalePrice'][$UserTypeID][0]) && $_POST['SalePrice'][$UserTypeID][0] !="")?$_POST['SalePrice'][$UserTypeID][0]:"0";
					$SubDataArray['SaleActive'] = (isset($_POST['SaleActive'][$UserTypeID][0]) && $_POST['SaleActive'][$UserTypeID][0] !="")?$_POST['SaleActive'][$UserTypeID][0]:"0";
				
					$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".(int)$UserTypeID."' AND (QtyMin='0' OR QtyMin='1')";
					$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
					if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
					{
						$ProductPriceObj->tableUpdate($SubDataArray);
					}
					else 
					{
						$SubDataArray['QtyMin'] = "0";
						$SubDataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
						$SubDataArray['PriceType'] = 'Unit';
						$SubDataArray['UserTypeID'] = $UserTypeID;
						$SubDataArray['ProductID'] = $ProductID;
						$ProductPriceObj->tableInsert($SubDataArray);
					}
		
				}
				//if(in_array($UserTypeID,array(2,3)))
				if(in_array($UserTypeID,array(1)))
				{
					$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".(int)$UserTypeID."'";
					$ProductPriceObj->tableDelete();
					if(count($_POST['Price'][$UserTypeID]) > 0)
					{
						foreach($_POST['Price'][$UserTypeID] as $k=>$val)
						{
							$SubDataArray = array();
							$SubDataArray['ProductID'] = $ProductID;
							$SubDataArray['UserTypeID'] = $UserTypeID;
							$SubDataArray['QtyMin'] = (isset($_POST['QtyMin'][$UserTypeID][$k]) && $_POST['QtyMin'][$UserTypeID][$k] !="")?$_POST['QtyMin'][$UserTypeID][$k]:"0";
							$SubDataArray['QtyMax'] = (isset($_POST['QtyMax'][$UserTypeID][$k]) && $_POST['QtyMax'][$UserTypeID][$k] !="")?$_POST['QtyMax'][$UserTypeID][$k]:d("DEFINE_PRODUCT_QTY_MAX");
							$SubDataArray['PriceType'] = (isset($_POST['PriceType'][$UserTypeID][$k]) && $_POST['PriceType'][$UserTypeID][$k] !="")?$_POST['PriceType'][$UserTypeID][$k]:"Unit";
							$SubDataArray['Price'] = (isset($_POST['Price'][$UserTypeID][$k]) && $_POST['Price'][$UserTypeID][$k] !="")?$_POST['Price'][$UserTypeID][$k]:"0";
							$SubDataArray['SalePrice'] = (isset($_POST['SalePrice'][$UserTypeID][$k]) && $_POST['SalePrice'][$UserTypeID][$k] !="")?$_POST['SalePrice'][$UserTypeID][$k]:"0";
							$SubDataArray['SaleActive'] = (isset($_POST['SaleActive'][$UserTypeID][$k]) && $_POST['SaleActive'][$UserTypeID][$k] !="")?$_POST['SaleActive'][$UserTypeID][$k]:"0";
							$ProductPriceObj->tableInsert($SubDataArray);
						}
			
					}
					
					
				}
				
			}

			if($ProductID > 0){
				$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
			}
			$this->getSession()->setArrVar("alert",array("success","Prices updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=prices");
			exit;
		}
	}
	/* product prices section end*/
	
	/* UpdateDiscountPercent section start*/
	public function UpdateDiscountPercentAction()
	{
	
		if(count($_POST)>0)
		{
			$UserTypeArray = $this->getProductCommon()->getUserTypeByProductPrices();
			foreach($UserTypeArray as $t=>$CurrentType)
			{
				$UserTypeID = $CurrentType['UserTypeID'];
				//if(in_array($UserTypeID,array(2,3)))
				if(in_array($UserTypeID,array(1)))
				{
					$ProductDiscountObj = new DataTable(TABLE_PRODUCT_DISCOUNT);
					$ProductDiscountObj->where = "UserTypeID ='".(int)$UserTypeID."'";
					$ProductDiscountObj->tableDelete();
					if(count($_POST['DiscountPercent'][$UserTypeID]) > 0)
					{
						foreach($_POST['DiscountPercent'][$UserTypeID] as $k=>$val)
						{
							$SubDataArray = array();
							$SubDataArray['UserTypeID'] = $UserTypeID;
							$SubDataArray['QtyMin'] = (isset($_POST['QtyMin'][$UserTypeID][$k]) && $_POST['QtyMin'][$UserTypeID][$k] !="")?$_POST['QtyMin'][$UserTypeID][$k]:"0";
							$SubDataArray['QtyMax'] = (isset($_POST['QtyMax'][$UserTypeID][$k]) && $_POST['QtyMax'][$UserTypeID][$k] !="")?$_POST['QtyMax'][$UserTypeID][$k]:d("DEFINE_PRODUCT_QTY_MAX");
							$SubDataArray['DiscountPercent'] = (isset($_POST['DiscountPercent'][$UserTypeID][$k]) && $_POST['DiscountPercent'][$UserTypeID][$k] !="")?$_POST['DiscountPercent'][$UserTypeID][$k]:"0";
							$ProductDiscountObj->tableInsert($SubDataArray);
						}
			
					}
					
					
				}
				
			}
			$this->getSession()->setArrVar("alert",array("success","Discount prices updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ProductDiscount");
			exit;
		}
	}
	/* UpdateDiscountPercent section end*/
	
	/* product images section start*/
	public function AddProductImageAction()
	{
		if(count($_POST)>0)
		{
			$ProductImageObj = new DataTable(TABLE_PRODUCT_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;


			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			
			/* product image added*/
			$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_product",'product/p-'.$ProductID);
			/* product image end*/
			
			$ProductImageObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=images");
			exit;
		}
	}
	public function EditProductImageAction()
	{
		if(count($_POST)>0)
		{
			$ProductImageObj = new DataTable(TABLE_PRODUCT_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$ImageID = isset($_POST['ImageID'])?$_POST['ImageID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			
			/* product image added*/
			$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_product",'product/p-'.$ProductID);
			/* product image end*/
			
			$ProductImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$ProductImageObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=images");
			exit;
		}
	}
	
	public function DeleteProductImageAction()
	{
		$ImageID = isset($_GET['DeleteImage'])?$_GET['DeleteImage']:0;
		if($ImageID > 0)
		{
			$ProductImageObj = new DataTable(TABLE_PRODUCT_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$Obj = (object)$ProductImageObj->tableSelectOne();
			
			if(isset($Obj->Image) && $Obj->Image !="")
				$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);

			$ProductImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$ProductImageObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Image deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=images");
			exit;
		}
	}
	
	public function getProductImages($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_IMAGES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	/* product images section end*/
	
	/* product infos section start*/
	public function AddProductInfoAction()
	{
		if(count($_POST)>0)
		{
			$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['TabTitle'] = isset($_POST['TabTitle'])?$_POST['TabTitle']:"";
			$DataArray['InfoType'] = isset($_POST['InfoType'])?$_POST['InfoType']:"HTML";
			$DataArray['Description'] = isset($_POST['InfoAddDescription'])?$_POST['InfoAddDescription']:"";
			if($DataArray['InfoType']=="WMV")
			{
				$DataArray['Description'] = isset($_POST['DemoFile'])?$_POST['DemoFile']:"";
				/*Direct URL Start */
				if(isset($_POST['DirectURL']) && $_POST['DirectURL'] !="" && stristr($_POST['DirectURL'],"http"))
					$DataArray['Description'] = $_POST['DirectURL'];
				/*Direct URL End */
			}
		
			$ProductInfoObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Information added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=infos");
			exit;
		}
	}
	public function EditProductInfoAction()
	{
		if(count($_POST)>0)
		{
			$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$InfoID = isset($_POST['InfoID'])?$_POST['InfoID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['TabTitle'] = isset($_POST['TabTitle'])?$_POST['TabTitle']:"";
			$DataArray['InfoType'] = isset($_POST['InfoType'])?$_POST['InfoType']:"HTML";
			$DataArray['Description'] = isset($_POST['InfoEditDescription'])?$_POST['InfoEditDescription']:"";
			if($DataArray['InfoType']=="WMV")
			{
				$DataArray['Description'] = isset($_POST['DemoFile'])?$_POST['DemoFile']:"";
				/*Direct URL Start */
				if(isset($_POST['DirectURL']) && $_POST['DirectURL'] !="" && stristr($_POST['DirectURL'],"http"))
					$DataArray['Description'] = $_POST['DirectURL'];
				/*Direct URL End */
			}
			$ProductInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$ProductInfoObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Information updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=infos");
			exit;
		}
	}
	
	public function DeleteProductInfoAction()
	{
		$InfoID = isset($_GET['DeleteInfo'])?$_GET['DeleteInfo']:0;
		if($InfoID > 0)
		{
			$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$Obj = (object)$ProductInfoObj->tableSelectOne();
			
			$ProductInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$ProductInfoObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Information deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=infos");
			exit;
		}
	}
	
	public function getProductInfos($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_INFO);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","InfoID ASC"));;
		}
		return ;
	
	}
	/* product infos section end*/
	
	/* product downloads section start*/
	public function AddProductDownloadAction()
	{
		if(count($_POST)>0)
		{
			$ProductDownloadObj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['EmbedCodeStatus'] = isset($_POST['EmbedCodeStatus'])?$_POST['EmbedCodeStatus']:"0";
			$DataArray['EmbedCodeHTML'] = isset($_POST['EmbedCodeHTML'])?$_POST['EmbedCodeHTML']:"";
			$DataArray['DownloadFile'] = isset($_POST['DownloadFile'])?$_POST['DownloadFile']:"";
			$DataArray['AcademyOnline'] = isset($_POST['AcademyOnline'])?$_POST['AcademyOnline']:"0";
			$DataArray['AcademyAfterShow'] = isset($_POST['AcademyAfterShow'])?$_POST['AcademyAfterShow']:"0";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
		
		
			$ProductDownloadObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Download added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=downloads");
			exit;
		}
	}
	public function EditProductDownloadAction()
	{
		if(count($_POST)>0)
		{
			$ProductDownloadObj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$DownloadID = isset($_POST['DownloadID'])?$_POST['DownloadID']:0;


			$DataArray = array();
			$DataArray['EmbedCodeStatus'] = isset($_POST['EmbedCodeStatus'])?$_POST['EmbedCodeStatus']:"0";
			$DataArray['EmbedCodeHTML'] = isset($_POST['EmbedCodeHTML'])?$_POST['EmbedCodeHTML']:"";
			$DataArray['DownloadFile'] = isset($_POST['DownloadFile'])?$_POST['DownloadFile']:"";
			$DataArray['AcademyOnline'] = isset($_POST['AcademyOnline'])?$_POST['AcademyOnline']:"0";
			$DataArray['AcademyAfterShow'] = isset($_POST['AcademyAfterShow'])?$_POST['AcademyAfterShow']:"0";
		
		
			$ProductDownloadObj->where[] = array('=',array('DownloadID' => $DownloadID));
			$ProductDownloadObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Download updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=downloads");
			exit;
		}
	}
	
	public function DeleteProductDownloadAction()
	{
		$DownloadID = isset($_GET['DeleteDownload'])?$_GET['DeleteDownload']:0;
		if($DownloadID > 0)
		{
			$ProductDownloadObj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductDownloadObj->where[] = array('=',array('DownloadID' => $DownloadID));
			$ProductDownloadObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Download deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=downloads");
			exit;
		}
	}
	
	public function getProductDownloads($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("DownloadID ASC"));;
		}
		return ;
	
	}
	/* product downloads section end*/
	
	/* product questions section start*/
	public function AddProductQuestionAction()
	{
		if(count($_POST)>0)
		{
			$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
			$DataArray['Answer'] = isset($_POST['Answer'])?$_POST['Answer']:"";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			$ProductQuestionObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Question added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=questions");
			exit;
		}
	}
	public function EditProductQuestionAction()
	{
		if(count($_POST)>0)
		{
			$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$QuestionID = isset($_POST['QuestionID'])?$_POST['QuestionID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
			$DataArray['Answer'] = isset($_POST['Answer'])?$_POST['Answer']:"";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$ProductQuestionObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Question updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=questions");
			exit;
		}
	}
	
	public function DeleteProductQuestionAction()
	{
		$QuestionID = isset($_GET['DeleteQuestion'])?$_GET['DeleteQuestion']:0;
		if($QuestionID > 0)
		{
			$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$Obj = (object)$ProductQuestionObj->tableSelectOne();
			
			$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$ProductQuestionObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Question deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=questions");
			exit;
		}
	}
	
	public function getProductQuestions($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_QUESTIONS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","QuestionID ASC"));;
		}
		return ;
	
	}
	/* product questions section end*/
	/* product bundles section start*/
	
	public function DeleteProductBundleAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$BundleID = isset($_GET['BundleID'])?$_GET['BundleID']:0;
		if($BundleID > 0)
		{
			$BundleObj = new DataTable(TABLE_PRODUCT_BUNDLES);
			$BundleObj->where[] = array('=',array('BundleID' => $BundleID));
			$BundleObj->tableDelete();
		}
		$this->getSession()->setArrVar("alert",array("success","Bundle product deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=bundles");
		exit;
	}
	public function AddEditBundleProductAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$BundleID = isset($_GET['BundleID'])?$_GET['BundleID']:0;
			

			$DataArray = array();
			$DataArray['BundleName'] = isset($_POST['BundleName'])?$_POST['BundleName']:"";
			$DataArray['BundleDescription'] = isset($_POST['BundleDescription'])?$_POST['BundleDescription']:"";
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['MinProduct'] = (isset($_POST['MinProduct']) && $_POST['MinProduct'] > 0)?$_POST['MinProduct']:"0";
			$DataArray['MaxProduct'] = (isset($_POST['MaxProduct']) && $_POST['MaxProduct'] > 0)?$_POST['MaxProduct']:"0";
			$DataArray['RelatedProducts'] = isset($_POST['RelatedProducts'])?implode(",",$_POST['RelatedProducts']):"0";
			if($BundleID > 0)
			{
				$BundleObj = new DataTable(TABLE_PRODUCT_BUNDLES);
				$BundleObj->where[] = array('=',array('ProductID' => $ProductID));
				$BundleObj->where[] = array('=',array('BundleID' => $BundleID));
				$BundleObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Bundle product updated successfully."));
				
			}
			else 
			{
				
				$BundleObj = new DataTable(TABLE_PRODUCT_BUNDLES);
				$DataArray['ProductID'] =$ProductID;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$BundleID = $BundleObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Bundle product  added successfully."));
				
			}
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=bundles");
			exit;
		}
	}
	
	public function getProductBundlesByProduct($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_BUNDLES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","BundleID ASC"));;
		}
		return ;
	
	}
	public function getBundleProductDetails($BundleID)
	{
		if($BundleID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_BUNDLES);
			$Obj->where[] = array('=',array('BundleID' => $BundleID));
			return (object)$Obj->tableSelectOne(array("*"),array("Position ASC","BundleID ASC"));;
		}
		return ;
	
	}
	/* product bundles section end*/
	
	/* product registration code section start*/
	public function AddProductCodeAction()
	{
		if(count($_POST)>0)
		{
			$ProductCodeObj = new DataTable(TABLE_PRODUCT_CODES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['ProductCode'] = isset($_POST['ProductCode'])?$_POST['ProductCode']:"";
			$DataArray['CodeType'] = isset($_POST['CodeType'])?$_POST['CodeType']:"";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			
			$ProductCodeObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Code added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=registration");
			exit;
		}
	}
	public function EditProductCodeAction()
	{
		if(count($_POST)>0)
		{
			$ProductCodeObj = new DataTable(TABLE_PRODUCT_CODES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$CodeID = isset($_POST['CodeID'])?$_POST['CodeID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['ProductCode'] = isset($_POST['ProductCode'])?$_POST['ProductCode']:"";
			$DataArray['CodeType'] = isset($_POST['CodeType'])?$_POST['CodeType']:"";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			$ProductCodeObj->where[] = array('=',array('CodeID' => $CodeID));
			$ProductCodeObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Code updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=registration");
			exit;
		}
	}
	
	public function DeleteProductCodeAction()
	{
		$CodeID = isset($_GET['DeleteCode'])?$_GET['DeleteCode']:0;
		if($CodeID > 0)
		{
			$ProductCodeObj = new DataTable(TABLE_PRODUCT_CODES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductCodeObj->where[] = array('=',array('CodeID' => $CodeID));
			$Obj = (object)$ProductCodeObj->tableSelectOne();
			
			$ProductCodeObj->where[] = array('=',array('CodeID' => $CodeID));
			$ProductCodeObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Code deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=registration");
			exit;
		}
	}
	
	public function getProductCodes($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_CODES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("CodeID ASC"));;
		}
		return ;
	
	}
	/* product registration code section end*/
	public function getProductCouponCodes($ProductID)
	{
		if($ProductID > 0){
			
			$CouponObj = new DataTable(TABLE_COUPONS);
			$where = new Where();
			$where->equalTo('ProductSpecific','1');
			$where->expression('FIND_IN_SET((?),ProductIDs)',$ProductID);
			$CouponObj->where = $where;
			$CouponObj->orderExpression = true;
			//$CouponObj->displayQuery = true;
			return $CouponObj->tableSelectAll(array("*"),"Active=1 DESC,CouponID DESC");
		}
		return ;
	
	}
	/* product couponcode section end*/
	
	/* product additions section start*/
	
	public function UpdateAdditionalAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$AdditionID = isset($_POST['AdditionID'])?$_POST['AdditionID']:0;
			
			$ProductAdditionObj = new DataTable(TABLE_PRODUCT_ADDITIONS);
			$ProductAdditionObj->where[] = array('=',array('ProductID' => $ProductID));
			$ProductAdditionObj->tableDelete();
			
			if(isset($_POST['AttributeName']))
			{
				if(isset($_POST['AddSaveTemplateChk']) && isset($_POST['SaveTemplate']) && $_POST['SaveTemplate'] != ""){
					$BackupObj = new DataTable(TABLE_BACKUP);
					$BackArray = array();
					$BackArray['ReferenceID'] = "0";
					$BackArray['ReferenceTitle'] = $_POST['SaveTemplate']." - ".ConvertDateFromDb(date('Y-m-d H:i:s'));
					$BackArray['Page'] = "";
					$BackArray['ReferenceVar'] = "product_additions";
					$BackArray['Dumps'] = base64_encode(serialize($_POST['AttributeName']));
					$BackArray['CreatedDate'] = date('Y-m-d H:i:s');
					$BackupObj->tableInsert($BackArray);
								
				}
				foreach ($_POST['AttributeName'] as $k=>$v)
				{
					foreach ($_POST['AttributeValue'][$k] as $kkk=>$vvv)
					{
						if(isset($_POST['AttributeValue'][$k][$kkk]) && $_POST['AttributeValue'][$k][$kkk] !="")
						{
							$ProductAdditionObj = new DataTable(TABLE_PRODUCT_ADDITIONS);
							$DataArray = array();
							$DataArray['ProductID'] = $ProductID;
							$DataArray['AttributeName'] = isset($_POST['AttributeName'][$k])?$_POST['AttributeName'][$k]:"";
							$DataArray['AttributeType'] = isset($_POST['AttributeType'][$k])?$_POST['AttributeType'][$k]:"";
							$DataArray['Position'] = (isset($_POST['Position'][$k]) && $_POST['Position'][$k] > 0)?$_POST['Position'][$k]:"0";
							
							$DataArray['AttributeValueSort'] = (isset($_POST['AttributeValueSort'][$k][$kkk]) && $_POST['AttributeValueSort'][$k][$kkk] > 0)?$_POST['AttributeValueSort'][$k][$kkk]:0;
							$DataArray['AttributeValue'] = isset($_POST['AttributeValue'][$k][$kkk])?$_POST['AttributeValue'][$k][$kkk]:"";
							$DataArray['ModelNo'] = (isset($_POST['ModelNo'][$k][$kkk]) && $_POST['ModelNo'][$k][$kkk] !="")?$_POST['ModelNo'][$k][$kkk]:"";
							$DataArray['NormalPrice'] = (isset($_POST['NormalPrice'][$k][$kkk]) && $_POST['NormalPrice'][$k][$kkk] !="")?$_POST['NormalPrice'][$k][$kkk]:0;
							$DataArray['Price'] = (isset($_POST['Price'][$k][$kkk]) && $_POST['Price'][$k][$kkk] >0)?$_POST['Price'][$k][$kkk]:0;
							$DataArray['PriceSet'] = isset($_POST['PriceSet'][$k][$kkk])?$_POST['PriceSet'][$k][$kkk]:"+";
							
							$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
							$ProductAdditionObj->tableInsert($DataArray);
							
							
						}
					}
					//echo "<br>---------<br>";
				}
			}
			if($ProductID > 0){
				$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
			}
			$this->getSession()->setArrVar("alert",array("success","Attributes updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=additions");
			exit;
		}
	}
	
	
	
	public function getProductAdditions($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('pa'=>TABLE_PRODUCT_ADDITIONS));
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->columnExpression = true;
			//$Obj->displayQuery = true;
			return $Obj->tableSelectAll(array("DISTINCT(AttributeName) as AttributeName","AttributeType as AttributeType","Position as Position"),array("pa.Position ASC"));;
	
		}
		return ;
	
	}
	public function getProductAdditionValues($ProductID,$AttributeName)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_ADDITIONS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('AttributeName' => $AttributeName));
			return $Obj->tableSelectAll(array("*"),array("AttributeValueSort ASC","ProductAdditionID ASC"));;
	
		}
		return ;
	
	}
	/* product additions section end*/
	
	/* product reviews section start*/
	public function AddProductReviewAction()
	{
		if(count($_POST)>0)
		{
			$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$DataArray = array();
			$DataArray['ProductID'] = $ProductID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			$ProductReviewObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Review added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=reviews");
			exit;
		}
	}
	public function EditProductReviewAction()
	{
		if(count($_POST)>0)
		{
			$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$ReviewID = isset($_POST['ReviewID'])?$_POST['ReviewID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$ProductReviewObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Review updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=reviews");
			exit;
		}
	}
	
	public function DeleteProductReviewAction()
	{
		$ReviewID = isset($_GET['DeleteReview'])?$_GET['DeleteReview']:0;
		if($ReviewID > 0)
		{
			$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			
			$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$Obj = (object)$ProductReviewObj->tableSelectOne();
			
			$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$ProductReviewObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Review deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=reviews");
			exit;
		}
	}
	
	public function getProductReviews($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_REVIEWS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			return $Obj->tableSelectAll(array("*"),array("ReviewID ASC"));;
		}
		return ;
	
	}
	/* product reviews section end*/
	
	/* product related section start*/
	public function UpdateRelatedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
		$tab = isset($_GET['tab'])?$_GET['tab']:0;
		
		if(count($_POST)>0)
		{
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$id =$_POST['id_'.$i];
				$DataArray = array();
				$DataArray['SortOrder'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$ProductRelatedObj->where="id ='".(int)$id."'";
				$ProductRelatedObj->tableUpdate($DataArray);
			}
			$this->getSession()->setArrVar("alert",array("success","product(s)  updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=$tab");
			exit;
		}
	}
	public function AddProductRelatedAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
			$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
			$tab = isset($_GET['tab'])?$_GET['tab']:0;
		
			$productRelatedArray = $_POST["RelatedID"];
			if (count($productRelatedArray) >0)
			{
				foreach ($productRelatedArray as $value) {
					if(trim($value) != "")
					{
						$ProductRelatedObj = new DataTable(TABLE_PRODUCT_RELATION);
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['RelationID'] = $value;
						$DataArray['RelationType'] = $RelationType;
						$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetRelatedSortOrder($ProductID,$RelationType) + 1;
						$ProductRelatedObj->tableInsert($DataArray);
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Product(s) added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=$tab");
			exit;
		}
	}
	
	public function DeleteProductRelatedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$RelationID = isset($_GET['DeleteRelated'])?$_GET['DeleteRelated']:0;
		$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
		$tab = isset($_GET['tab'])?$_GET['tab']:0;
		
		if($RelationID > 0)
		{
			$ProductRelateObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelateObj->where[] = array('=',array('RelationID' => $RelationID));
			$ProductRelateObj->where[] = array('=',array('ProductID' => $ProductID));
			$ProductRelateObj->where[] = array('=',array('RelationType' => $RelationType));
			$ProductRelateObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Relate deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=$tab");
			exit;
		}
	}
	
	public function getProductRelated($ProductID,$RelationType)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.RelationID=p.ProductID and ptc.RelationType='".$RelationType."')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			
			return $Obj->tableSelectAll(array("ProductName"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	/* product related section end*/
	
	/* product discounted section start*/
	public function UpdateWithDiscountedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
		if(count($_POST)>0)
		{
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$ProductWithDiscountedObj = new DataTable(TABLE_PRODUCT_RELATION);
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$id =$_POST['id_'.$i];
				$DataArray = array();
				$DataArray['Custom'] = (isset($_POST['Custom_'.$i]) && $_POST['Custom_'.$i] > 0)?$_POST['Custom_'.$i]:0;
				$DataArray['SortOrder'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$ProductWithDiscountedObj->where="id ='".(int)$id."'";
				$ProductWithDiscountedObj->tableUpdate($DataArray);
			}
			$this->getSession()->setArrVar("alert",array("success","WithDiscounted product(s)  updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=discounted");
			exit;
		}
	}
	
	public function AddProductWithDiscountedAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		
			$productWithDiscountedArray = $_POST["WithDiscountedID"];
			if (count($productWithDiscountedArray) >0)
			{
				foreach ($productWithDiscountedArray as $value) {
					if(trim($value) != "")
					{
						$ProductWithDiscountedObj = new DataTable(TABLE_PRODUCT_RELATION);
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['Custom'] = "0";
						$DataArray['RelationID'] = $value;
						$DataArray['RelationType'] = "product_discounted";
						$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetWithDiscountedSortOrder($ProductID,"product_discounted") + 1;
						$ProductWithDiscountedObj->tableInsert($DataArray);
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Discounted product(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=discounted");
			exit;
		}
	}
	
	public function DeleteProductWithDiscountedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$ProductID = isset($_GET['ProductID'])?$_GET['ProductID']:0;
		$RelationID = isset($_GET['DeleteWithDiscounted'])?$_GET['DeleteWithDiscounted']:0;
		if($RelationID > 0)
		{
			$ProductRelateObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductRelateObj->where[] = array('=',array('RelationID' => $RelationID));
			$ProductRelateObj->where[] = array('=',array('ProductID' => $ProductID));
			$ProductRelateObj->where[] = array('=',array('RelationType' => 'product_discounted'));
			$ProductRelateObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Discounted deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditProduct&ParentID=$ParentID&ProductID=$ProductID&tab=discounted");
			exit;
		}
	}
	
	public function getProductWithDiscounted($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.RelationID=p.ProductID and ptc.RelationType='product_discounted')",
										  'columns'=>array("id","RelationID","Custom","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			
			return $Obj->tableSelectAll(array("ProductName"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	/* product discounted section end*/
	
	public function getList()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		
		if($ParentID > 0)
		{
			$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"SortOrder ASC";
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where->notEqualTo('p.ProductType','Child');
			$where->equalTo('ptc.RelationID',$ParentID);
			
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='catalog_category')",
										  'columns'=>array("RelationID","SortOrder"),
										  'type'=>''
										  );
		}
		else
		{
			$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"p.ProductID DESC";
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where->notEqualTo('p.ProductType','Child');
			$ProductObj->where = "p.ProductType != 'Child'  AND ProductID NOT IN (select ProductID from ".TABLE_PRODUCT_RELATION. " where RelationType='catalog_category')";
			
		}
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=50;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		
		return $ProductObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function getFeaturedList()
	{
		
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->where = "p.ProductType != 'Child'  AND Featured ='1'";
		//$ProductObj->displayQuery = true;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ProductStatus"=>"Active"),array("CreatedDate DESC"));
	
	}

	public function getFlashProductsList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pr.SalePrice DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('pr.SaleActive','1');
		
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID AND UserTypeID='10')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=25;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Stock","ProductPoints"),array($orderBy));
	
	}
	
	public function getWholesalerProductList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"ProductID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.WholeSaler',"1");
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('ProductID','%'.$Value.'%')->OR
							->like('ProductName','%'.$Value.'%')->OR
							->like('ModelNo','%'.$Value.'%')->OR
							->like('ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=25;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Stock","ProductPoints"),array($orderBy));
	
	}
	public function getVIPProductList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"ProductID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.VIPStatus',"1");
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('ProductID','%'.$Value.'%')->OR
							->like('ProductName','%'.$Value.'%')->OR
							->like('ModelNo','%'.$Value.'%')->OR
							->like('ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=25;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Stock","ProductPoints"),array($orderBy));
	
	}
	
	public function getMurphyMagicList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"ProductID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$UT = isset($_REQUEST['UT'])?$_REQUEST['UT']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		if($UT != "")
			$where->equalTo('p.UploadType',$UT);
			
		$where->NEST//start braket
				->equalTo('UploadType','MurphyScript')
				->OR
				->equalTo('UploadType','MurphyScriptStreaming')
				->UNNEST;
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('ProductID','%'.$Value.'%')->OR
							->like('ProductName','%'.$Value.'%')->OR
							->like('ModelNo','%'.$Value.'%')->OR
							->like('ProductLine','%'.$Value.'%')->OR
							->like('FeedID','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=25;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Stock","StockTotal","StockStatus","ProductPoints","Active","CreatedDate"),array($orderBy));
	
	}
	
	public function getProductAllBundles()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"ProductID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.ProductType',"Bundle");
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('ProductID','%'.$Value.'%')->OR
							->like('ProductName','%'.$Value.'%')->OR
							->like('ModelNo','%'.$Value.'%')->OR
							->like('ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=25;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Stock","StockTotal","StockStatus","ProductPoints","CreatedDate"),array($orderBy));
	
	}
	public function getProductAllList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"p.ProductID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		//$where->equalTo('p.VIPStatus',"1");
		
		if(isset($_REQUEST['CategoryArr']) && $_REQUEST['CategoryArr'] !=""){
					
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='catalog_category')",
										  'columns'=>array("RelationID","SortOrder"),
										  'type'=>''
										  );
		  $where->in('ptc.RelationID',array($_REQUEST['CategoryArr']));
										  
		}
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductObj->where = $where;
		
		//$ProductObj->displayQuery = true;
		$ProductObj->AllowPaging =true;
		$ProductObj->PageSize=20;
		$ProductObj->PageTotalDisplay = 15; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductObj;
		return $ProductObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	public function getProductCodesList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pc.CodeID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductCodeObj = new DataTable(array('pc'=>TABLE_PRODUCT_CODES));
		$where->notEqualTo('p.ProductType','Child');
		
		$ProductCodeObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(pc.ProductID=p.ProductID)",
									  'columns'=>array("ProductID","ProductName","ModelNo","Stock","StockTotal","StockStatus","ProductPoints"),
									  'type'=>''
									  );
									  
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->like('pc.ProductCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductCodeObj->where = $where;
		
		//$ProductCodeObj->displayQuery = true;
		$ProductCodeObj->AllowPaging =true;
		$ProductCodeObj->PageSize=25;
		$ProductCodeObj->PageTotalDisplay = 15; 
		$ProductCodeObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductCodeObj;
		return $ProductCodeObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function BulkReviewsAction()
	{
		if(count($_POST) > 0){
			/* EnableClick button start*/
			if(isset($_POST['EnableClick']) && $_POST['EnableClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					
					$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
					$DataArray = array();
					$DataArray['Active'] = "1";
					$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
					$ProductReviewObj->tableUpdate($DataArray);
				}
			}
			/* EnableClick button end*/
			/* DisableClick button start*/
			if(isset($_POST['DisableClick']) && $_POST['DisableClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					
					$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
					$DataArray = array();
					$DataArray['Active'] = "0";
					$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
					$ProductReviewObj->tableUpdate($DataArray);
				}
			}
			/* DisableClick button end*/
			
			/* DisableClick button start*/
			if(isset($_POST['DeleteClick']) && $_POST['DeleteClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					if($ReviewID > 0){
						$ProductReviewObj = new DataTable(TABLE_PRODUCT_REVIEWS);
						$ProductReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
						$ProductReviewObj->tableDelete();
					}
				}
			}
			/* DisableClick button end*/
		
		$this->getSession()->setArrVar("alert",array("success","Reviews(s)  updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&k=".$this->origin->k."&orderBy=".$this->origin->orderBy);
		exit;	
		}
		
		
	}
	public function getProductReviewsList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pr.ReviewID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductReviewObj = new DataTable(array('pr'=>TABLE_PRODUCT_REVIEWS));
		$where->notEqualTo('p.ProductType','Child');
		
		$ProductReviewObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(pr.ProductID=p.ProductID)",
									  'columns'=>array("ProductID","ProductName","ModelNo","Stock","StockTotal","StockStatus","ProductPoints"),
									  'type'=>''
									  );
									  
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->like('pr.CName','%'.$Value.'%')->OR
							->like('pr.CEmail','%'.$Value.'%')->OR
							->like('pr.Description','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductReviewObj->where = $where;
		
		//$ProductReviewObj->displayQuery = true;
		$ProductReviewObj->AllowPaging =true;
		$ProductReviewObj->PageSize=25;
		$ProductReviewObj->PageTotalDisplay = 15; 
		$ProductReviewObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductReviewObj;
		return $ProductReviewObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	
	public function BulkQuestionsAction()
	{
		if(count($_POST) > 0){
			/* EnableClick button start*/
			if(isset($_POST['EnableClick']) && $_POST['EnableClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					
					$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
					$DataArray = array();
					$DataArray['Active'] = "1";
					$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
					$ProductQuestionObj->tableUpdate($DataArray);
				}
			}
			/* EnableClick button end*/
			/* DisableClick button start*/
			if(isset($_POST['DisableClick']) && $_POST['DisableClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					
					$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
					$DataArray = array();
					$DataArray['Active'] = "0";
					$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
					$ProductQuestionObj->tableUpdate($DataArray);
				}
			}
			/* DisableClick button end*/
			
			/* DisableClick button start*/
			if(isset($_POST['DeleteClick']) && $_POST['DeleteClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					if($QuestionID > 0){
						$ProductQuestionObj = new DataTable(TABLE_PRODUCT_QUESTIONS);
						$ProductQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
						$ProductQuestionObj->tableDelete();
					}
				}
			}
			/* DisableClick button end*/
		
		$this->getSession()->setArrVar("alert",array("success","Questions(s)  updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&k=".$this->origin->k."&orderBy=".$this->origin->orderBy);
		exit;	
		}
		
		
	}
	
	public function getProductQuestionsList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pq.QuestionID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductQuestionObj = new DataTable(array('pq'=>TABLE_PRODUCT_QUESTIONS));
		$where->notEqualTo('p.ProductType','Child');
		
		$ProductQuestionObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(pq.ProductID=p.ProductID)",
									  'columns'=>array("ProductID","ProductName","ModelNo","Stock","StockTotal","StockStatus","ProductPoints"),
									  'type'=>''
									  );
									  
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->like('pq.CName','%'.$Value.'%')->OR
							->like('pq.CEmail','%'.$Value.'%')->OR
							->like('pq.Question','%'.$Value.'%')->OR
							->like('pq.Answer','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$ProductQuestionObj->where = $where;
		
		//$ProductQuestionObj->displayQuery = true;
		$ProductQuestionObj->AllowPaging =true;
		$ProductQuestionObj->PageSize=25;
		$ProductQuestionObj->PageTotalDisplay = 15; 
		$ProductQuestionObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ProductQuestionObj;
		return $ProductQuestionObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function getProducFavourite($RelationType)
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('ptc.RelationID','0');
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='".$RelationType."')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		//$ProductObj->displayQuery =true;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName"),array("SortOrder ASC, p.ProductID DESC"));
	}
	
	public function AddProductFavouriteAction()
	{
		$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
		if(count($_POST)>0)
		{
			
			$productArray = $_POST["FavouriteID"];
			if (count($productArray) >0)
			{
				foreach ($productArray as $ProductID) {
					if(trim($ProductID) != "")
					{
						
						$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
						$ProductRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
																  array('=',array('ProductID' => $ProductID)),
																  array('=',array('RelationID' => '0'))											  
																  );
						$CObj = (object)$ProductRelationObj->tableSelectOne(array("id"));
						if(!isset($CObj->id)){
							
							$DataArray = array();
							$DataArray['ProductID'] = $ProductID;
							$DataArray['RelationID'] = '0';
							$DataArray['RelationType'] = $RelationType;
							$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder('0',$RelationType) + 1;
							$ProductRelationObj->tableInsert($DataArray);
							
						}
						
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","product(s)  added successfully in the list."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Favourite&RelationType=$RelationType");
			exit;
		}
	}
	
	public function DeleteProductFavouriteDeleteAction()
	{
			$ProductID = (isset($_GET['FavouriteID']) && $_GET['FavouriteID'] > 0)?$_GET['FavouriteID']:0;
			$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
			if(trim($ProductID) != "")
			{
				$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
				$ProductRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
														  array('=',array('ProductID' => $ProductID)),
														  array('=',array('RelationID' => '0'))											  
														  );
				$ProductRelationObj->tableDelete();
			}
			$this->getSession()->setArrVar("alert",array("success","product(s)  removed successfully from the list."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Favourite&RelationType=$RelationType");
			exit;
		
	}
	
	public function BulkFavouriteProductAction()
	{
		$RelationType = isset($_GET['RelationType'])?$_GET['RelationType']:0;
			
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$ProductID){
					if($ProductID > 0)
					{
						$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
						$ProductRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
																  array('=',array('ProductID' => $ProductID)),
																  array('=',array('RelationID' => '0'))											  
																  );
						$ProductRelationObj->tableDelete();
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Products removed from the list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Favourite&RelationType=$RelationType");
				exit;
			}
			/* BulkSelectedRemove end*/	
			/* UpdateList start*/
			if(isset($_POST['UpdateList'])){
				for ($i=1;$i <$_POST['Count'];$i++)
				{
					$ProductID =$_POST['ProductID_'.$i];
					$DataArray = array();
					$DataArray['SortOrder'] = (isset($_POST['SortOrder_'.$i]) && $_POST['SortOrder_'.$i] !="")?$_POST['SortOrder_'.$i]:0;			
					$DataArray['Custom'] = (isset($_POST['Custom_'.$i]) && $_POST['Custom_'.$i] !="")?$_POST['Custom_'.$i]:0;			
					$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
					$ProductCategoryObj->where = array(array('=',array('RelationType' => $RelationType)),
												  array('=',array('RelationID' => '0')),
												  array('=',array('ProductID' => $ProductID))											  
												  );
					//echo "<pre>";var_dump($DataArray);							  
					$ProductCategoryObj->tableUpdate($DataArray);
					
				}
				$this->getSession()->setArrVar("alert",array("success","Product updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=Favourite&RelationType=$RelationType");
				exit;
			}
		 /* UpdateList end*/
			
		}
	}
	
	
	
	public function getDetail($ProductID)
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		if($ProductID > 0)
		{
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductCategoryObj2 = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductObj->where[] = array('=',array('p.ProductID' => $ProductID));
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.ProductID AND s.MCode='catalog_product')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID)",
										  'columns'=>array("Price","SalePrice","SaleActive"),
										  'type'=>"left",
										  );
			
			$ProductObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID = pr.UserTypeID AND IsDefault=1)",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			
			$ProductCategoryObj2->where ="RelationType ='catalog_category' AND ProductID='".(int)$ProductID."'";
			$categoryRows = $ProductCategoryObj2->tableSelectAll();
			$ProductCatgoryArr = array();
			foreach($categoryRows as $CategoryTmp)
			{
				$ProductCatgoryArr[] = $CategoryTmp->RelationID;
				if($ParentID ==0)
				 $ParentID = $CategoryTmp->RelationID;
			}
			$this->ProductCatgoryArr = $ProductCatgoryArr;
			return (object)$ProductObj->tableSelectOne();
		}
		else{
			$ProductCatgoryArr = array();
			$ProductCatgoryArr[] = $ParentID;
			$this->ProductCatgoryArr = $ProductCatgoryArr;
		}
	
		return ;
	
	}
	
	public function imageProduct($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."product/".$Image))
			return DIR_FS_SITE_UPLOADS."product/".$Image;
		
		return false;
	}
	
	public function imageProductURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."product/".$Image))
			return DIR_WS_SITE_UPLOADS."product/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		$Title = "Product";
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		if(isset($_GET['ProductID']) && $_GET['ProductID'] > 0)	{					
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductObj->where[] = array('=',array('p.ProductID' => $_GET['ProductID']));
			$TmpObj = (object)$ProductObj->tableSelectOne(array("ProductName"));
			$Title .=  (isset($TmpObj->ProductName)?" - (".$TmpObj->ProductName.")":"");
		}
		 if($ParentID > 0){
			$CategoryObj = new DataTable(array('p'=>TABLE_CATEGORY));
			$CategoryObj->where[] = array('=',array('p.CategoryID' => $ParentID));
			$TmpObj = (object)$CategoryObj->tableSelectOne(array("CategoryName"));
			$Title .= (isset($TmpObj->CategoryName)?" - <small>category:".$TmpObj->CategoryName."</small>":"");
		}
		
		
		
			
			
		 
		 
		 return $Title;
	}
	
	public function pageRight()
	{
		$Html = '<div class="title_right">
					<div class="pull-right">';
		if(isset($_GET['ProductID']) && $_GET['ProductID'] > 0)	{					
			$Html .= '  <a class="btn btn-success" href="'.SKSEOURL('catalog_product','Detail',$this->origin->ProductID).'" target="_blank">Preview Product</a>';
			$Html .= '  <a class="btn btn-danger" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&ProductID='.$this->origin->ProductID.'&rview='.$this->origin->rview.'&action=DeleteProduct" onclick="return confirm(\'Are you sure want to delete the Product?\')">Delete Product</a>';
		}

		$Html .= '    <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&view=AddEditProduct">Add Product</a>
					</div>
              </div>		
			   ';
			   
		return $Html;	   
	}
	
	
}	