<?php 
namespace Catalog\Option;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function getOptionValueWithOption($OptionValueID)
	{
		$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
		$OptionValueObj->where[] = array('=',array('OptionValueID' => $OptionValueID));
		$rows = $OptionValueObj->tableSelectAll(array("OptionValueID","OptionValue"),array("Position ASC","OptionValue ASC"));
		

			$MainObj = new DataTable(array('fv'=>TABLE_OPTION_VALUE));
			$MainObj->where[] = array('=',array('fv.OptionValueID' => $OptionValueID));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('f'=>TABLE_OPTION),
										  'on'=>"(f.OptionID = fv.OptionID)",
										  'columns'=>array("OptionID","OptionName"),
										  'type'=>"left",
										  );
										  
			return (object)$MainObj->tableSelectOne(array("*"));		
			
					
	}
	
	function getOptionPriceByEngravingCost($EngravingCost)
	{
		$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
		$OptionValueObj->where[] = array('=',array('OptionID' => '2'));
		$OptionValueObj->where[] = array('=',array('OptionValue' => trim($EngravingCost)));
		return (object)$OptionValueObj->tableSelectOne(array("*"),array("Position ASC","OptionValue ASC"));
					
	}
	
	
	function getOptionValuesByID($OptionID,$OnlyActive=true)
	{
		$Obj = new DataTable(TABLE_OPTION_VALUE);
		$Obj->where[] = array('=',array('OptionID' => $OptionID));
		if($OnlyActive==true)
			$Obj->where[] = array('=',array('Active' => '1'));
		
		$Obj->rowType="array";
		$rows = $Obj->tableSelectAll(array("*"),array("Position ASC"));
		return $rows;
		
	}
	
	function getOptionArrayWithValues($OnlyActive=true,$IDs="")
	{
		$where = new Where();
		$ReturnArr = array(); 
		$OptionObj = new DataTable(array('p'=>TABLE_OPTION));
		if($OnlyActive==true)
			$where->equalTo('p.Active',"1");
		
		if(is_array($IDs))
			$IDArray = $IDs;
		else if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where->in('p.OptionID',$IDArray);
		}
		
		$OptionObj->where = $where;
		$option_rows =  $OptionObj->tableSelectAll(array("OptionID","OptionName"),array("Position ASC","OptionID ASC"));
			
		foreach($option_rows as $CurrentOption){
			if(isset($CurrentOption->OptionID)){
					
					$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
					$OptionValueObj->where[] = array('=',array('OptionID' => $CurrentOption->OptionID));
					if($OnlyActive==true)
						$OptionValueObj->where[] = array('=',array('Active' => '1'));
			
					$rows = $OptionValueObj->tableSelectAll(array("OptionValueID","OptionValue","OptionValPrice"),array("Position ASC","OptionValue ASC"));
					
					$ReturnArr[$CurrentOption->OptionID] = array('OptionID'=>MyStripslashes($CurrentOption->OptionID),
																 'OptionName'=>MyStripslashes($CurrentOption->OptionName),
													);
					foreach($rows as $CurrentAttVal){
						
							$ReturnArr[$CurrentOption->OptionID]['Values'][$CurrentAttVal->OptionValueID] = array('OptionID'=>$CurrentAttVal->OptionValueID,
																									 'OptionValue'=>MyStripslashes($CurrentAttVal->OptionValue),
																									 'OptionValPrice'=>MyStripslashes($CurrentAttVal->OptionValPrice),
																									);
				
					}
					
			}
		
		}
		
		return $ReturnArr;
	}
	
	function getAllOptions($OnlyActive=true)
	{
		$ReturnArr = array(); 
		$OptionObj = new DataTable(array('p'=>TABLE_OPTION));
		if($OnlyActive==true)
			$OptionObj->where[] = array('=',array('p.Active' => '1'));
		
		$option_rows =  $OptionObj->tableSelectAll(array("OptionID","OptionName"),array("Position ASC","OptionID ASC"));
		foreach($option_rows as $CurrentOption){
			if(isset($CurrentOption->OptionID)){
					$ReturnArr[$CurrentOption->OptionID] = MyStripslashes($CurrentOption->OptionName);
			}
		
		}
		return $ReturnArr;
	}

	function SKOptionValLinkURL($OptionURL,$FID, $FValID,$Param=array("option"=>"1"),$ExcludeParam= array("PageNo"))
	{
			$url = parse_url($OptionURL);
			$path = $url['path'];
			$query = isset($url['query'])?$url['query']:"";
			
			$OptionArray = array();
			if($query !="")
			{
				parse_str($query,$OptionArray);
			}
			
			$FTVar = isset($OptionArray['FT'][$FID])?$OptionArray['FT'][$FID]:"";
			if($FID > -1){
				if(isset($FTVar) && $FTVar !="")
				{
					if(!in_array($FValID,explode(",",$FTVar)))
						$OptionArray['FT'][$FID] = $FTVar.",".$FValID;
				}
				else 
				{
					$OptionArray['FT'][$FID] = $FValID;
				}
				
				foreach ($OptionArray as $k=>$v)
				{
					if(in_array($k,$ExcludeParam))
						unset($OptionArray[$k]);
					
				}
			}
			
			$OptionArray = array_merge($OptionArray,$Param);
			
			return  $path."?".urldecode(http_build_query($OptionArray));
	}

	function SKOptionValLinkRemoveURL($OptionURL,$FID,$FValID)
	{
			$url = parse_url($OptionURL);
			$path = $url['path'];
			$query = isset($url['query'])?$url['query']:"";
			
			$OptionArray = array();
			if($query !="")
			{
				parse_str($query,$OptionArray);
			}
			
			
			$FTVar = isset($OptionArray['FT'][$FID])?$OptionArray['FT'][$FID]:"";
			
			if(isset($FTVar) && $FTVar !="")
			{
				$FTVarArr = explode(",",$FTVar);
				if(count($FTVarArr) >1)
				{
					foreach ($FTVarArr as $k=>$v)
					{
						if($FValID==$v)
							unset($FTVarArr[$k]);
					}
				 $OptionArray['FT'][$FID] = implode(",",$FTVarArr);
				}
				elseif (count($FTVarArr) == 1)
				{
					unset($OptionArray['FT'][$FID]);
				}
			}
		
		return  $path."?".urldecode(http_build_query($OptionArray));
	}
		
	
}	