<?php 
namespace Catalog\Option\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditOptionAction()
	{
		if(count($_POST)>0)
		{
			$OptionObj = new DataTable(TABLE_OPTION);
			$SeoObj = new DataTable(TABLE_SEO);
			$OptionID = isset($_GET['OptionID'])?$_GET['OptionID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['OptionName'] = isset($_POST['OptionName'])?$_POST['OptionName']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			
			/* Option image added*/
			if(isset($_POST['OptionImage']) && $_POST['OptionImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."option/".$_POST['OptionImage']))
			{
				if(isset($_POST['OptionImageDelete']) && $_POST['OptionImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."option/".$_POST['OptionImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid(substr($DataArray['OptionName'],0,5)."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."option/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['OptionImage']) && $_POST['OptionImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."option/".$_POST['OptionImage']))
					@unlink(DIR_FS_SITE_UPLOADS."option/".$_POST['OptionImage']);
			}
			/* Option image added end*/	
			
			if($OptionID > 0)
			{
				
				$OptionObj->where[] = array('=',array('OptionID' => $OptionID));
				$OptionObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Option updated successfully."));
				
			}
			else 
			{
							
				$OptionObj->where ="1";
				$Position = $OptionObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$OptionID = $OptionObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Option added successfully."));
				
			}
			
			if(isset($_POST['OptionValue'])){
				$OptionValueIDArr = $this->getAllOptionValuesIDs($OptionID);
				$UpdatedOptionValueIDArr = array();
				
				foreach ($_POST['OptionValue'] as $k=>$v){
					$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
					$SubDataArray = array();
					$OptionValueID = $_POST['OptionValueID'][$k]?:0;
					$SubDataArray['OptionValue'] =$_POST['OptionValue'][$k]?? "";
					$SubDataArray['OptionValPrice'] =(isset($_POST['OptionValPrice'][$k]) && $_POST['OptionValPrice'][$k] > 0)?(float)$_POST['OptionValPrice'][$k]:0;
					$SubDataArray['Active'] = (isset($_POST['Active'][$k]) && $_POST['Active'][$k] > 0)?1:0;; 
					$SubDataArray['Position'] = (isset($_POST['Position'][$k]) && $_POST['Position'][$k] > 0)?(int)$_POST['OptionValPrice'][$k]:0;; 
					if($SubDataArray['OptionValue'] != ""){
						if($OptionValueID > 0){
							$UpdatedOptionValueIDArr[] = $OptionValueID;
							$OptionValueObj->where[] = array('=',array('OptionID' => $OptionID));
							$OptionValueObj->where[] = array('=',array('OptionValueID' => $OptionValueID));
							$OptionValueObj->tableUpdate($SubDataArray);
							
						}
						else{
							$SubDataArray['OptionID'] =$OptionID;
							$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
							$OptionValueObj->tableInsert($SubDataArray);
						}
					}
					//var_dump($OptionValueID,$SubDataArray,"<hr>");
					
				}
				
				/* Delete OptionValueIds*/
				$DeletedOptionValueIDArr = array_diff($OptionValueIDArr,$UpdatedOptionValueIDArr);
				if(is_array($DeletedOptionValueIDArr) && count($DeletedOptionValueIDArr) > 0){
					foreach($DeletedOptionValueIDArr as $DeleteID){
						$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
						$OptionValueObj->where[] = array('=',array('OptionValueID' => $DeleteID));
						$OptionValueObj->tableDelete();
					}
				}
				/* Delete OptionValueIds END*/
				
			}
		
			if(isset($_POST['Continue'])){	
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditOption&OptionID=$OptionID");
				exit;
		    }
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&OptionID=$OptionID");
		    exit;
		}
		
	}
	public function UpdateOptionAction()
	{
		if(count($_POST)>0)
		{
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$OptionObj = new DataTable(TABLE_OPTION);
				$OptionID =$_POST['OptionID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$OptionObj->where[] = array('=',array('OptionID' => $OptionID));
				$OptionObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Option updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&PageNo=".$this->origin->PageNo);
			 exit;
		}
	}
	
	public function DeleteOptionAction()
	{
		$OptionID = isset($_GET['OptionID'])?$_GET['OptionID']:0;
		if($OptionID > 0)
		{
			$OptionObj = new DataTable(TABLE_OPTION);
			$OptionObj->where[] = array('=',array('OptionID' => $OptionID));
			$OptionObj->tableDelete();								
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$OptionID." AND MCode ='catalog_Option' ";
			$SeoObj->tableDelete();		
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Option deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$OptionObj = new DataTable(TABLE_OPTION);
		$OptionObj->where="1";
		
		$OptionObj->AllowPaging =true;
		$OptionObj->PageSize=100;
		$OptionObj->PageTotalDisplay = 15; 
		$OptionObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $OptionObj;
		return $OptionObj->tableSelectAll(array("*"),array("Position ASC","OptionName ASC"));
	
	}
	public function getAllOptionValues($OptionID)
	{
		$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
		$OptionValueObj->where[] = array('=',array('OptionID' => $OptionID));
		
		return $OptionValueObj->tableSelectAll(array("*"),array("Position ASC","OptionValue ASC"));
	
	}
	public function getAllOptionValuesIDs($OptionID)
	{
		$OptionValueObj = new DataTable(TABLE_OPTION_VALUE);
		$OptionValueObj->where[] = array('=',array('OptionID' => $OptionID));		
		$OptionValueObj->columnExpression = true;
		$Obj  = (object)$OptionValueObj->tableSelectOne(array("GROUP_CONCAT(OptionValueID) as OptionValueIDs"));
		return explode(",",$Obj->OptionValueIDs);
	
	}
	
	public function productCount($OptionID)
	{
		$ProductOptionObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductOptionObj->where="Relationtype='Option' AND RelationID ='".(int)$OptionID."'";
		$ProductOptionObj->columnExpression=true;
		$Obj = $ProductOptionObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($OptionID)
	{
		if($OptionID > 0)
		{
			$OptionObj = new DataTable(array('p'=>TABLE_OPTION));
			$OptionObj->where[] = array('=',array('p.OptionID' => $OptionID));
			return (object)$OptionObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function imageOption($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."option/".$Image))
			return DIR_FS_SITE_UPLOADS."option/".$Image;
		
		return false;
	}
	
	public function imageOptionURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."option/".$Image))
			return DIR_WS_SITE_UPLOADS."option/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Options";
	}
	
	public function pageRight()
	{
		return '';
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditOption">Add Option</a>
					</div>
              </div>		
			   ';
	}
	
	
}	