<?php 
namespace Catalog\Filter;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function getFilterValueWithFilter($FilterValueID)
	{
		$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
		$FilterValueObj->where[] = array('=',array('FilterValueID' => $FilterValueID));
		$rows = $FilterValueObj->tableSelectAll(array("FilterValueID","FilterValue"),array("Position ASC","FilterValue ASC"));
		

			$MainObj = new DataTable(array('fv'=>TABLE_FILTER_VALUE));
			$MainObj->where[] = array('=',array('fv.FilterValueID' => $FilterValueID));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('f'=>TABLE_FILTER),
										  'on'=>"(f.FilterID = fv.FilterID)",
										  'columns'=>array("FilterID","FilterName"),
										  'type'=>"left",
										  );
										  
			return (object)$MainObj->tableSelectOne(array("FilterValueID","FilterValue"));		
			
					
	}
	
	function getFiltersByCategory($CategoryID)
	{
			$CategoryRelationObj = new DataTable(TABLE_CATEGORY_RELATION);
			$CategoryRelationObj->where ="RelationType ='catalog_filter' AND CategoryID='".(int)$CategoryID."'";
			$filterRows = $CategoryRelationObj->tableSelectAll();
			$CatgoryFilterArr = array();
			foreach($filterRows as $Tmp)
			{
				$CatgoryFilterArr[] = $Tmp->RelationID;
			}
			return $CatgoryFilterArr;
			
	}
	function getFilterArrayWithValues($OnlyActive=true,$IDs="")
	{
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache/filter");
		$filename=$dir.md5("fi_".serialize(array($OnlyActive,$IDs))).".txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArr = unserialize(file_get_contents($filename));
			return $ReturnArr;
		}
		else{
			
		$where = new Where();
		$ReturnArr = array(); 
		$FilterObj = new DataTable(array('p'=>TABLE_FILTER));
		if($OnlyActive==true)
			$where->equalTo('p.Active',"1");
		
		if(is_array($IDs))
			$IDArray = $IDs;
		else if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where->in('p.FilterID',$IDArray);
		}
		
		$FilterObj->where = $where;
		$filter_rows =  $FilterObj->tableSelectAll(array("FilterID","FilterName"),array("Position ASC","FilterID ASC"));
			
		foreach($filter_rows as $CurrentFilter){
			if(isset($CurrentFilter->FilterID)){
					
					$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
					$FilterValueObj->where[] = array('=',array('FilterID' => $CurrentFilter->FilterID));
					if($OnlyActive==true)
						$FilterValueObj->where[] = array('=',array('Active' => '1'));
			
					$rows = $FilterValueObj->tableSelectAll(array("FilterValueID","FilterValue","FilterLine"),array("Position ASC","FilterValue ASC"));
					
					$ReturnArr[$CurrentFilter->FilterID] = array('FilterID'=>MyStripslashes($CurrentFilter->FilterID),
																 'FilterName'=>MyStripslashes($CurrentFilter->FilterName),
													);
					foreach($rows as $CurrentAttVal){
						
							$ReturnArr[$CurrentFilter->FilterID]['Values'][$CurrentAttVal->FilterValueID] = array('FilterID'=>$CurrentAttVal->FilterValueID,
																									 'FilterValue'=>MyStripslashes($CurrentAttVal->FilterValue),
																									 'FilterLine'=>MyStripslashes($CurrentAttVal->FilterLine),
																									);
				
					}
					
			}
		
		}
		
		$fp2 = fopen($filename, "w");
		fputs($fp2,serialize($ReturnArr));	
		fclose($fp2);
		return $ReturnArr;
		
			
		}
		
		
	}
	
	function getAllFilters($OnlyActive=true)
	{
		$ReturnArr = array(); 
		$FilterObj = new DataTable(array('p'=>TABLE_FILTER));
		if($OnlyActive==true)
			$FilterObj->where[] = array('=',array('p.Active' => '1'));
		
		$filter_rows =  $FilterObj->tableSelectAll(array("FilterID","FilterName"),array("Position ASC","FilterID ASC"));
		foreach($filter_rows as $CurrentFilter){
			if(isset($CurrentFilter->FilterID)){
					$ReturnArr[$CurrentFilter->FilterID] = MyStripslashes($CurrentFilter->FilterName);
			}
		
		}
		return $ReturnArr;
	}

	function SKFilterValLinkURL($FilterURL,$FID, $FValID,$Param=array("filter"=>"1"),$ExcludeParam= array("PageNo"))
	{
			$url = parse_url($FilterURL);
			$path = $url['path'];
			$query = isset($url['query'])?$url['query']:"";
			
			$FiterArray = array();
			if($query !="")
			{
				parse_str($query,$FiterArray);
			}
			
			$FTVar = isset($FiterArray['FT'][$FID])?$FiterArray['FT'][$FID]:"";
			if($FID > -1){
				if(isset($FTVar) && $FTVar !="")
				{
					if(!in_array($FValID,explode(",",$FTVar)))
						$FiterArray['FT'][$FID] = $FTVar.",".$FValID;
				}
				else 
				{
					$FiterArray['FT'][$FID] = $FValID;
				}
				
			}
			foreach ($FiterArray as $k=>$v)
			{
				if(in_array($k,$ExcludeParam))
					unset($FiterArray[$k]);
				
			}
			$FiterArray = array_merge($FiterArray,$Param);
			
			
			return  $path."?".urldecode(http_build_query($FiterArray));
	}

	function SKFilterValLinkRemoveURL($FilterURL,$FID,$FValID)
	{
			$url = parse_url($FilterURL);
			$path = $url['path'];
			$query = isset($url['query'])?$url['query']:"";
			
			$FiterArray = array();
			if($query !="")
			{
				parse_str($query,$FiterArray);
			}
			
			
			$FTVar = isset($FiterArray['FT'][$FID])?$FiterArray['FT'][$FID]:"";
			
			if(isset($FTVar) && $FTVar !="")
			{
				$FTVarArr = explode(",",$FTVar);
				if(count($FTVarArr) >1)
				{
					foreach ($FTVarArr as $k=>$v)
					{
						if($FValID==$v)
							unset($FTVarArr[$k]);
					}
				 $FiterArray['FT'][$FID] = implode(",",$FTVarArr);
				}
				elseif (count($FTVarArr) == 1)
				{
					unset($FiterArray['FT'][$FID]);
				}
			}
		
		return  $path."?".urldecode(http_build_query($FiterArray));
	}
	
	function addEditFilterValue($FilterID,$FilterValue)
	{
		$DBObj = new DataTable(TABLE_FILTER_VALUE);
		$where = new Where();
		$where->equalTo('FilterID',$FilterID);
		$where->equalTo('FilterValue',$FilterValue);
		$DBObj->where = $where;
		$Singleobj = (object)$DBObj->tableSelectOne(array("FilterValueID"),"FilterValueID ASC");
		if(isset($Singleobj->FilterValueID)){
			return $Singleobj->FilterValueID;
		}
		else{
			$DataArray = array();
			$DataArray['FilterID'] = $FilterID;
			$DataArray['FilterValue'] = $FilterValue;
			$DataArray['Active'] = "1";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			return $DBObj->tableInsert($DataArray);
		}
	}
		
	
}	