<?php 
namespace Catalog\Category\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as Common;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	public function getCommon()
	{
		$obj = new Common();
		return $obj;
	}
	
	public function AddEditCategoryAction()
	{
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_CATEGORY);
			$SeoObj = new DataTable(TABLE_SEO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['ParentID'] =$ParentID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
			$DataArray['TopMenu'] = isset($_POST['TopMenu'])?$_POST['TopMenu']:0;
			$DataArray['MegaMenu'] = isset($_POST['MegaMenu'])?$_POST['MegaMenu']:0;
			$DataArray['MegaMenuCols'] = (isset($_POST['MegaMenuCols']) && $_POST['MegaMenuCols'] > 0)?$_POST['MegaMenuCols']:0;
			
			
			$DataArray['CategoryName'] = isset($_POST['CategoryName'])?$_POST['CategoryName']:"";
			$DataArray['CategoryTitle'] = isset($_POST['CategoryTitle'])?$_POST['CategoryTitle']:"";
			$DataArray['CategoryCode'] = isset($_POST['CategoryCode'])?$_POST['CategoryCode']:"";
			$DataArray['CategoryPassword'] = isset($_POST['CategoryPassword'])?$_POST['CategoryPassword']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['FullDescription'] = isset($_POST['FullDescription'])?$_POST['FullDescription']:"";
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			 
			$DataArray['MegaMenuDescription'] = isset($_POST['MegaMenuDescription'])?$_POST['MegaMenuDescription']:"";
			$DataArray['MegaMenuProductTitle'] = isset($_POST['MegaMenuProductTitle'])?$_POST['MegaMenuProductTitle']:"";
			$DataArray['ProductSpecific'] = isset($_POST['ProductSpecific'])?$_POST['ProductSpecific']:"0";
			$DataArray['ProductIDs'] = isset($_POST['ProductIDs'])?implode(",",$_POST['ProductIDs']):"0";
			$DataArray['FeaturedProductIDs'] = isset($_POST['FeaturedProductIDs'])?implode(",",$_POST['FeaturedProductIDs']):"0";
						 
			
			/* category image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_category",'category',$DataArray['CategoryName']);
			/* category image end*/
			
			
			
			if($CategoryID > 0)
			{
				
				$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$CategoryObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Category updated successfully."));
				
			}
			else 
			{
							
				$CategoryObj->where ="ParentID='".$ParentID."'";
				$Position = $CategoryObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$CategoryID = $CategoryObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Category added successfully."));
				
			}
			
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$URL = 	SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['CategoryName']);
			$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
			$DataArray['URLName'] = $URL;
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "catalog_category";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $CategoryID;
				$SeoObj->tableInsert($DataArray);
			}
					
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			
			if(isset($_POST['Continue']))
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditCategory&ParentID=$ParentID&CategoryID=$CategoryID");
			else
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
		    exit;
		}
		
	}
	public function UpdateCategoryAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_CATEGORY);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CategoryID =$_POST['CategoryID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
				$DataArray['TopMenu'] = isset($_POST['TopMenu_'.$i])?$_POST['TopMenu_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$DataArray['CategoryPassword'] = isset($_POST['CategoryPassword_'.$i])?$_POST['CategoryPassword_'.$i]:"";
				$CategoryObj->where="CategoryID ='".(int)$CategoryID."'";
				$CategoryObj->tableUpdate($DataArray);
				
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Category updated successfully."));
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
			 exit;
		}
	}
	
	public function DeleteCategoryAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if($CategoryID > 0)
		{
			$Obj = $this->getDetail($CategoryID);
			$CategoryObj = new DataTable(TABLE_CATEGORY);
			$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
			$CategoryObj->tableDelete();	

			if(isset($Obj->Image) && $Obj->Image !="")
					$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
				
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' ";
			$SeoObj->tableDelete();	

			$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductCategoryObj->where="Relationtype='catalog_category' AND RelationID ='".(int)$CategoryID."'";
			$ProductCategoryObj->tableDelete();
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Category deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where="ParentID ='".(int)$ParentID."'";
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	
	}
	
	public function subCategoryCount($CategoryID)
	{
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where="ParentID ='".(int)$CategoryID."'";
		$CategoryObj->columnExpression=true;
		$Obj = $CategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function productCount($CategoryID)
	{
		$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductCategoryObj->where="Relationtype='catalog_category' AND RelationID ='".(int)$CategoryID."'";
		$ProductCategoryObj->columnExpression=true;
		$Obj = $ProductCategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$CategoryObj = new DataTable(array('p'=>TABLE_CATEGORY));
			$CategoryObj->where[] = array('=',array('p.CategoryID' => $CategoryID));
				
			$CategoryObj->joinExpression = true;
			$CategoryObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.CategoryID AND s.MCode='catalog_category')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$CategoryObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Category";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&view=AddEditCategory">Add Category</a>
					</div>
              </div>		
			   ';
	}
	
	
}	