<?php 
namespace Catalog\Category\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class ImportController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Import");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	public function getHeaderCss()
	{
	}
	
	public function getFooterJs()
	{
	}
	
	
	public function UploadCSVFileAction()
	{
		/* attachment Start*/
		if(isset($_FILES['UploadCSV']) && $_FILES['UploadCSV']['name'] !="")
		{
			$ArrayType = explode(".",$_FILES['UploadCSV']['name']);
			$Type=$ArrayType[count($ArrayType)-1];
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
			$FileName=uniqid("i-csv-".date('Y-m-d')."-").".".$Type;
			copy($_FILES['UploadCSV']['tmp_name'],$dir.$FileName);
		}
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&File=".$FileName);
		exit;
		/* attachment End*/
	}
	public function DownloadCSVFileAction()
	{
		
		$CategoryArray[0] = $this->getCsvHeaderInArray();
		$CategoryArray = $this->CategoryData($CategoryArray,0);
		//var_dump($CategoryArray);
		//exit;
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
		$filename=$dir."d-category-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		foreach($CategoryArray as $CategoryID=>$DArr){
			fputcsv($csv_resource, array_values($DArr));
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
		
	}
	
	/*  Categories recursive data start */
	function CategoryData($CategoryArray,$ParentID,$ActiveOnly=false) 
	{
		$CategoryObj = new DataTable(array('m'=>TABLE_CATEGORY));
		$CategoryObj->joinExpression = true;
		$CategoryObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
									  'on'=>"(s.ReferenceID = m.CategoryID AND s.MCode='catalog_category')",
									  'columns'=>array("*"),
									  'type'=>"left",
									  );
									  
		
		$CategoryObj->where[] = array('=',array('m.ParentID' => $ParentID));
		if($ActiveOnly)
			$CategoryObj->where[] = array('=',array('m.Active' => '1'));
				
		$rows = $CategoryObj->tableSelectAll(array("*"),array("m.ParentID ASC","m.Position ASC"));
		if(count($rows) > 0){
			foreach( $rows as $CurrentCategory)
			{
				//var_dump("<hr>",$CurrentCategory->CategoryName);
				foreach($CategoryArray[0] as $arrKey=>$arrCol){
						$CategoryArray[$CurrentCategory->CategoryID][$arrKey] = isset($CurrentCategory->{$arrKey})?MyStripSlashes($CurrentCategory->{$arrKey}):""; 	
				}				
				$CategoryArray = $this->CategoryData($CategoryArray,$CurrentCategory->CategoryID,$ActiveOnly);
			}
		}
		
		return $CategoryArray;
	}
	
	public function ProcessCSVFileAction()
	{
		set_time_limit(0);
		if(count($_POST) > 0){
			$File = isset($_GET['File'])?$_GET['File']:"";
			
			$csvdata = $this->getDataFromCSV($File);
			foreach($csvdata as $csv_k=>$data){
				
				
				foreach($this->getCsvHeaderInArray() as $key=>$val):
					$index = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($val)));
					if(defined($index)){
						${$key} = isset($data[constant($index)])?trim($data[constant($index)]):"";
					}
				endforeach;
				
					var_dump($this->getCsvHeaderInArray());
				
					if(isset($CategoryID) && $CategoryID > 0){
						$CategoryID = $this->checkCategoryExist($CategoryID);
						if($CategoryID > 0){
							
							$DataArray = array();
							if(isset($ParentID) && $ParentID > 0)
								$DataArray['ParentID'] =$ParentID;
							if(isset($Active))
								$DataArray['Active'] = ($Active == "1")?1:0;
							if(isset($Featured))
								$DataArray['Featured'] = ($Featured == "1")?1:0;
							if(isset($TopMenu))
								$DataArray['TopMenu'] = ($TopMenu == "1")?1:0;
							
							if(isset($CategoryName))
									$DataArray['CategoryName'] =$CategoryName;
							if(isset($CategoryTitle))
									$DataArray['CategoryTitle'] =$CategoryTitle;
							if(isset($CategoryLine))
									$DataArray['CategoryLine'] =$CategoryLine;
							if(isset($CategoryPassword))
									$DataArray['CategoryPassword'] =$CategoryPassword;
						
							
							if(isset($Description))
									$DataArray['Description'] =$Description;
							if(isset($FullDescription))
									$DataArray['FullDescription'] =$FullDescription;
						
							$CategoryObj = new DataTable(TABLE_CATEGORY);
							$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
							$CategoryObj->tableUpdate($DataArray);
				 
							$SeoObj = new DataTable(TABLE_SEO);
							$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
							$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
							
							
							$DataArray = array();
							if(isset($MetaTitle))
								$DataArray['MetaTitle'] =$MetaTitle;
							if(isset($MetaKeyword))
								$DataArray['MetaKeyword'] =$MetaKeyword;
							if(isset($MetaDescription))
								$DataArray['MetaDescription'] =$MetaDescription;
						
							if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
								if(isset($URLName) && $URLName != ""){
									$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URLName,'catalog_category','Detail',$CategoryID);
									$DataArray['URLName'] = $URL;
								}
								$SeoObj->tableUpdate($DataArray);
							}
							else{
								
								$URL = 	SkURLCreate((isset($URLName) && $URLName !="")?$URLName:$CategoryName);
								$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
								$DataArray['URLName'] = $URL;			
								$DataArray['MCode'] = "catalog_category";
								$DataArray['MView'] = "Detail";
								$DataArray['ReferenceID'] = $CategoryID;
								$SeoObj->tableInsert($DataArray);
							}
						}
						
					}
					else{
						/* New Record entry start*/
						$DataArray = array();
							if(isset($ParentID) && $ParentID > 0)
								$DataArray['ParentID'] =$ParentID;
							else 
								$DataArray['ParentID'] =0;	
							
							$DataArray['Active'] = (isset($Active) && $Active =="1")?"1":"0";
							$DataArray['Featured'] = (isset($Featured) && $Featured =="1")?"1":"0";
							$DataArray['Profiles'] = (isset($Profiles) && $Profiles =="1")?"1":"0";
							$DataArray['Searched'] = (isset($Searched) && $Searched =="1")?"1":"0";
							$DataArray['Others'] = (isset($Others) && $Others =="1")?"1":"0";
							$DataArray['TopMenu'] = (isset($TopMenu) && $TopMenu =="1")?"1":"0";
							$DataArray['MegaMenu'] = (isset($MegaMenu) && $MegaMenu =="1")?"1":"0";
							$DataArray['MegaMenuCols'] = (isset($MegaMenuCols) && $MegaMenuCols > 0)?$MegaMenuCols:"0";
							
			
							if(isset($CategoryName))
									$DataArray['CategoryName'] =$CategoryName;
							if(isset($CategoryTitle))
									$DataArray['CategoryTitle'] =$CategoryTitle;
							if(isset($CategoryLine))
									$DataArray['CategoryLine'] =$CategoryLine;
							if(isset($CategoryPassword))
									$DataArray['CategoryPassword'] =$CategoryPassword;
							if(isset($Description))
									$DataArray['Description'] =$Description;
							if(isset($FullDescription))
									$DataArray['FullDescription'] =$FullDescription;	
								
							$CategoryObj = new DataTable(TABLE_CATEGORY);
							$CategoryObj->where ="ParentID='".$ParentID."'";
							$Position = $CategoryObj->getMax("Position") + 1;
							$DataArray['Position'] = $Position;
							$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
							$CategoryID = $CategoryObj->tableInsert($DataArray);	
							
							$SeoObj = new DataTable(TABLE_SEO);
							$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
							$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
							
							
							$DataArray = array();
							if(isset($MetaTitle))
								$DataArray['MetaTitle'] =$MetaTitle;
							if(isset($MetaKeyword))
								$DataArray['MetaKeyword'] =$MetaKeyword;
							if(isset($MetaDescription))
								$DataArray['MetaDescription'] =$MetaDescription;
						
							if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
								if(isset($URLName) && $URLName != ""){
									$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URLName,'catalog_category','Detail',$CategoryID);
									$DataArray['URLName'] = $URL;
								}
								$SeoObj->tableUpdate($DataArray);
							}
							else{
								
								$URL = 	SkURLCreate((isset($URLName) && $URLName !="")?$URLName:$CategoryName);
								$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
								$DataArray['URLName'] = $URL;			
								$DataArray['MCode'] = "catalog_category";
								$DataArray['MView'] = "Detail";
								$DataArray['ReferenceID'] = $CategoryID;
								$SeoObj->tableInsert($DataArray);
							}
						/* New Record entry end*/
					}
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Records updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view);
		exit;
		
	}
	
	
	public function getDataFromCSV($CSVFile)
	{
		$row =1;
		$csvdata = array();
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
		if(isset($CSVFile) && $CSVFile !="" && file_exists($dir.$CSVFile)){
			if (($handle = fopen($dir.$CSVFile, "r")) !== FALSE) {
				    while (($data = fgetcsv($handle)) !== FALSE) {
						if($row ==1){
							$this->CSVHeaderData($data);
						}
						else{
							$csvdata[] = $data;
						}
						$row++; 
					}
			}
		}
		return $csvdata;
	}
	
	function getCsvHeaderInArray()
	{
		$CsvHeader = array("CategoryID"=>"CategoryID",
						   "ParentID"=>"ParentID",
						   "URLName"=>"URL",
						   "CategoryName"=>"CategoryName",
						   "CategoryTitle"=>"CategoryTitle",
						   //"CategoryLine"=>"CategoryLine",
						   "Active"=>"Status",
						   //"Featured"=>"IsFeatured",
						   //"TopMenu"=>"IsTopMenu",
						   "MetaTitle"=>"MetaTitle",
						   "MetaKeyword"=>"MetaKeyword",
						   "MetaDescription"=>"MetaDescription",
						   "Description"=>"Description",
						   "FullDescription"=>"MoreDescription",
						   //"Image"=>"Image",
						   );
					   
		return 	$CsvHeader;		   
	}
	function CSVHeaderData($arr)
	{
			foreach ($arr as $key => $value)
			{
				$prop = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($value)));
				if(!defined($prop))	
					define($prop,$key);
			}
			
	}
	
	function checkCategoryExist($CategoryID)
	{
		$Obj = new DataTable(TABLE_CATEGORY);
		$Obj->where[] = array('=',array('CategoryID' => $CategoryID));
		$Obj =  (object)$Obj->tableSelectOne(array("CategoryID"));
		if(isset($Obj->CategoryID))
			return $Obj->CategoryID;
		
			return "";
		
	}
	
	
	
	public function pageTitle()
	{
		return "Import";
	}
	
	public function pageRight()
	{
		$Html = '';
		return $Html;	   
	}
	
	
}	