<?php 
namespace Catalog\Brand\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Brand\Common as BrandCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Expression;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	var $onlyProduct = false; 
	var $passwordProtected = false; 
	var $MinPrice = 0; 
	var $MaxPrice = 200; 
	function __construct()
	{
		
	}
	
	public function getBrandCommon()
	{
		$obj = new BrandCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['ID'] && $arr['ID'] != "")
		{
			$MainObj = new DataTable(array('m'=>TABLE_BRANDS));
			$MainObj->where[] = array('=',array('m.BrandID' => $arr['ID']));
			$MainObj->where[] = array('=',array('m.Active' => "1"));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = m.BrandID AND s.MCode='catalog_brand')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->BrandID))
			{
					/*
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
						$this->onlyFile = true;
					}
					*/					
											
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
					
			}
			
		}
	}
	
	
	public function getProductlist($BrandID)
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"12";
		$sb = isset($_GET['sb'])?$_GET['sb']:"21";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderBy = "p.CreatedDate DESC";
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		
		/* Min Max Start*/
		/*
		$ProductMinMaxObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$minMaxwhere = new Where();
		$minMaxwhere->notEqualTo('p.ProductType','Child');
		$minMaxwhere->equalTo('p.BrandID',$BrandID);
		$minMaxwhere->equalTo('p.Active',"1");
		$ProductMinMaxObj->where = $minMaxwhere;
		
		$ProductMinMaxObj->columnExpression = $ProductMinMaxObj->joinExpression = true;
		//$ProductMinMaxObj->displayQuery =true;
		$Obj = (object)$ProductMinMaxObj->tableSelectOne(array("MinPrice"=>"MIN(p.IdxMinPrice)",
												"MaxPrice"=>"MAX(p.IdxMaxPrice)"
											   ));
		$this->MinPrice = $Obj->MinPrice;
		$this->MaxPrice = $Obj->MaxPrice;
		*/
		/* Min Max End*/
		
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where = new Where();
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.BrandID',$BrandID);
		$where->equalTo('p.Active',"1");
		
		
		
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != ""){
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
				}
			}
		}
		
		if(isset($_GET['FromPrice']) && $_GET['FromPrice'] > 0 && isset($_GET['ToPrice']) && $_GET['ToPrice'] > 0){
			$where->NEST
					->expression('(? BETWEEN IdxMinPrice AND IdxMaxPrice)',(float)$_GET['FromPrice'])
					->OR
					->expression('(? BETWEEN IdxMinPrice AND IdxMaxPrice)',(float)$_GET['ToPrice'])
				->UNNEST;
		}
		elseif(isset($_GET['FromPrice']) && $_GET['FromPrice'] > 0){
			$where->expression('p.IdxMinPrice >= '.(float)$_GET['FromPrice']);
			
		}elseif(isset($_GET['ToPrice']) && $_GET['ToPrice'] > 0){
			$where->expression('p.IdxMaxPrice <= '.(float)$_GET['ToPrice']);
		}
		
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		
		
		if(isset($_GET['FT']) && is_array($_GET['FT'])){
			foreach($_GET['FT'] as $FilterID=>$FilterVal){
			$FilterValArr = array_filter(explode(",",preg_replace("/[^0-9,]/", "",$FilterVal)));
			if(is_array($FilterValArr) && count($FilterValArr) > 0){
				$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
										  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID IN (".implode(",",$FilterValArr).")
												  )",
										  'columns'=>NULL,
										  'type'=>''
										  );
				}
			}
			
		}
		
			
		//$ProductObj->displayQuery =true;
		$ProductObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$ProductObj->AllowPaging =false;
			
		$ProductObj->PageSize=$ps;
		$ProductObj->PagingPrefix="";
		$ProductObj->PageTotalDisplay = 10; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $ProductObj;
		$ProductObj->orderExpression=true;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	public function ResetFilters($FilterArr)
	{
		//return $FilterArr;
		$ResetFilter = array();
		$BrandID = $this->currentObj->BrandID;
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache/brand_filter");
		$filename=$dir.md5("brand_".$BrandID).".txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$FilterArr = unserialize(file_get_contents($filename));
			return $FilterArr;
		}
		else{
			
			foreach($FilterArr as $FilterID => $Arr){
				foreach($Arr['Values'] as $FilterValueID=>$ArVaArr){	
					$where = new Where();
					
					$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
					$where->notEqualTo('p.ProductType','Child');
					$where->equalTo('p.BrandID',$BrandID);
					$where->equalTo('p.Active',"1");
												  
					$ProductObj->joinExpression = true;
					$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
										  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID = '".(int)$FilterValueID."'
												  )",
										  'columns'=>NULL,
										  'type'=>''
										  );
					//$ProductObj->displayQuery = true;
					$ProductObj->where = $where;
					//$Obj = (object)$ProductObj->tableSelectOne(array('ProductID'));		
					$ProductObj->columnExpression=true;
					$Obj = (object)$ProductObj->tableSelectOne(array('Total'=>'Count(*)'));	
					if($Obj->Total == 0){
						unset($FilterArr[$FilterID]['Values'][$FilterValueID]);
					}
					//if(!isset($Obj->ProductID)){
						//unset($FilterArr[$FilterID]['Values'][$FilterValueID]);
					//}					
					
				}		
			}
			
			$fp2 = fopen($filename, "w");
			fputs($fp2,serialize($FilterArr));	
			fclose($fp2);
			return $FilterArr;
		}
			 
	}
	
	public function FilterCount($FilterID,$FilterValueID)
	{
		$BrandID = $this->currentObj->BrandID;
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.BrandID',$BrandID);
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if(trim($Value) != ""){
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
				}
			}
		}
		
		$ProductObj->where = $where;
		
		$ProductObj->joinExpression = true;
									  
		if($FilterID > 0 && $FilterValueID > 0){
			$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
									  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID = '".(int)$FilterValueID."'
											  )",
									  'columns'=>NULL,
									  'type'=>''
									  );
		}
		
		//$ProductObj->displayQuery =true;
		$ProductObj->columnExpression=true;
		$Obj = (object)$ProductObj->tableSelectOne(array('Total'=>'Count(*)'));	
			
		return $Obj->Total;
		
			 
	}
	
	public function getSortByArray()
	{
		return  array(
					//"00"=>array("display"=>"Default","column"=>"p.Position ASC","p.CreatedDate DESC"),
					//"00"=>array("display"=>"Default","column"=>"ptc.SortOrder ASC,p.CreatedDate DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"p.IdxMinPrice ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"p.IdxMaxPrice DESC"),
					"00"=>array("display"=>"Sort by Part No.","column"=>"p.ModelNo ASC,p.CreatedDate DESC"),
					"11"=>array("display"=>"Name (A - Z)","column"=>"p.ProductName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"p.ProductName DESC"),
					//"31"=>array("display"=>"Date (Latest)","column"=>"p.CreatedDate DESC"),
					//"32"=>array("display"=>"Date (Oldest)","column"=>"p.CreatedDate ASC"),
					);
	}
	public function subBrandCount($BrandID)
	{
		$BrandObj = new DataTable(TABLE_BRANDS);
		$BrandObj->where[] = array('=',array('ParentID' => $BrandID));
		$BrandObj->where[] = array('=',array('Active' => "1"));
		$BrandObj->columnExpression=true;
		$Obj = $BrandObj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	function getBeforeMeta()
	{
		
	}
	function getAfterMeta()
	{
		if(is_object($this->currentObj)){
			$CurrentRecord = $this->currentObj;
			$return ='<link rel="canonical" href="'.SKSEOURL('catalog_brand','Detail',$CurrentRecord->BrandID).'" />';
			$return .='<meta property="og:site_name" content="'.d("SITE_NAME").'"/>
						<meta property="og:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'" />
						<meta property="og:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'" />
						<meta property="og:type" content="website" />
						<meta property="og:url" content="'.SKSEOURL('catalog_brand','Detail',$CurrentRecord->BrandID).'" />
						<meta property="og:image" content="'.SKSeoImage($CurrentRecord->Image,"500",false).'" />
						<meta property="og:locale" content="en_GB"/>
						<meta property="fb:app_id" content="'.d("FACEBOOK_APP_ID").'"/>
						<meta name="twitter:card" content="summary"/>
						<meta name="twitter:site" content="'.d("TWITTER_SITE_ID").'"/>
						<meta name="twitter:creator" content="'.d("TWITTER_SITE_CREATOR").'"/>
						<meta name="twitter:title" content="'.MyStripSlashes($CurrentRecord->MetaTitle??"").'"/>
						<meta name="twitter:description" content="'.MyStripSlashes($CurrentRecord->MetaDescription??"").'"/>
						<meta name="twitter:image" content="'.SKSeoImage($CurrentRecord->Image,"500",false).'"/>
			
			';
		}
		return $return;		 
	}
	function breadcrumb()
	{
			if(is_object($this->currentObj)){
				$CurrentRecord = $this->currentObj;
				$breadcrumb = $this->getClass("Catalog\Brand\Common")->BrandChain4Caption($CurrentRecord->BrandID,"","SEOURL","breadcrumb-item",false,"",false,"");
				if($breadcrumb != "")
					return '<ul class="breadcrumb"><li class="breadcrumb-item"><a href="'.SKSEOURL('cms_pages','Detail',d('DEFAULT_PAGEID')).'">Home</a></li>'.$breadcrumb.'</ul>';
			}
	}
	function pageTitle()
	{
		return isset($this->currentObj->BrandTitle)?MyStripSlashes($this->currentObj->BrandTitle):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function directFile()
	{
		if(in_array(strtolower($this->view),array("detail")))
			return true;
		else
			return false;
		
	}
	
	
}	