<?php 
namespace Catalog\Brand;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function getBrandDetailByBrandID($BrandID) 
	{
		$ObjObj = new DataTable(TABLE_BRANDS);
		$ObjObj->where ="BrandID='".$BrandID."' AND Active ='1'";
		return (object)$ObjObj->tableSelectOne(array("*"));
			
	}
	
	function getBrandImage($BrandID,$Size="150x150",$Class="img-fluid w-100") 
	{
		$ObjObj = new DataTable(TABLE_BRANDS);
		$ObjObj->where ="BrandID='".$BrandID."'";
		$Obj = (object)$ObjObj->tableSelectOne(array("BrandName","Image"));
		if(isset($Obj->Image) && $Obj->Image != "")
			return SKSeoImage($Obj->Image,$Size,array("class"=>$Class));
		
		return "";
			
	}
	function getBrandDecription($BrandID) 
	{
		$ObjObj = new DataTable(TABLE_BRANDS);
		$ObjObj->where ="BrandID='".$BrandID."'";
		$Obj = (object)$ObjObj->tableSelectOne(array("Description"));
		if(isset($Obj->Description) && $Obj->Description != "")
			return MyStripSlashes($Obj->Description);
		
		return "";
			
	}
	function GetFeaturedBrand($limit=12) 
	{
		$ObjObj = new DataTable(TABLE_BRANDS);
		$ObjObj->where =" Active ='1' and Featured ='1'";
		return $ObjObj->tableSelectAll(array("BrandID","BrandName","Image"),"Position ASC",$limit);
			
	}
	
	function getAllBrands($OrderBy="Position ASC") 
	{
		$ObjObj = new DataTable(TABLE_BRANDS);
		$ObjObj->where =" Active ='1'";
		return $ObjObj->tableSelectAll(array("BrandID","BrandName","Image"),$OrderBy);
			
	}
	
	function getBrandByIDs($IDs="",$OnlyActive=true,$limit=100)
	{
		$where = new Where();
		$ReturnArr = array(); 
		$MainObj = new DataTable(array('m'=>TABLE_BRANDS));
		if($OnlyActive==true)
			$where->equalTo('m.Active',"1");
		
		if(is_array($IDs))
			$IDArray = $IDs;
		else if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where->in('m.BrandID',$IDArray);
		}
		
		$MainObj->where = $where;
		return $MainObj->tableSelectAll(array("BrandID","BrandName","Image"),"Position ASC",$limit);
		
		
	}
	
	
	public function GenerateHTMLSitemapBrandList($ClassName="sitemap-link")
	{
		$Text="";
		$TmpObj = new DataTable(TABLE_BRANDS);
		$TmpObj->where="Active='1'";
		$rows = $TmpObj->tableSelectAll(array("BrandID","BrandName"),"Position ASC");
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<div class="'.$ClassName.'">
							<a href="'.SKSEOURL('catalog_brand','Detail',$CurrentRecord->BrandID).'">'.MyStripSlashes($CurrentRecord->BrandName).'</a>
						</div>';		
			
		 }
		 return (string)$Text;
	
	}
	
	function getBrandTemplates()
	{
		$rows = array();
		$rows["default.php"] = "Default";
		$rows["brands.php"] = "All Brands View";
		return $rows;
	}
	
}	