<?php 
namespace Catalog\Attribute\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Expression;
use Laminas\Db\Sql\Where;
class JsonController extends AbstractModule
{
	function __construct()
	{
		header('Content-Type: application/json');
	}
	
	
	public function listAction()
	{
		$AttributeObj = new DataTable(TABLE_ATTRIBUTE);
		$AttributeObj->where="1";
		$AttributeObj->rowType="array";
		
		if($this->origin->q != "")
		{
			$where_array =  array();
			$where_array[] = array('like',"AttributeName", "%".$this->origin->q.'%');
			$AttributeObj->where =  $where_array;
	
		}
		$rows = $AttributeObj->tableSelectAll(array("AttributeID as id","AttributeName as text"),array("AttributeName ASC"));
		
		$jsonArray = $rows;
		echo json_encode($jsonArray);
		exit;
	}
	
	public function listAttributeValueAction()
	{
		$AttributeID = isset($_REQUEST['AttributeID'])?$_REQUEST['AttributeID']:"0";
		$Obj = new DataTable(TABLE_ATTRIBUTE_VALUE);
		$Obj->rowType="array";
		$where = new Where();
		$where->equalTo('AttributeID',$AttributeID);
			
		if($this->origin->q != "")
		{
			$where->NEST//start braket
						->like('AttributeValue','%'.$this->origin->q.'%')->OR
						->like('AttributeLine','%'.$this->origin->q.'%')->OR
						->UNNEST;
				
		
		}
		//$Obj->displayQuery = true;
		$Obj->where = $where;
		$rows = $Obj->tableSelectAll(array("AttributeValueID as id","AttributeValue as text"),array("AttributeValue ASC"));
		$jsonArray = $rows;
		echo json_encode($jsonArray);
		exit;
	}
	
	
}	